<?php



/**

 * Description of equipment

 *

 * @author Ashraf

 */

class Equipment extends Admin_Controller

{



    public function __construct()

    {

        parent::__construct();

        $this->load->model('equipment_model');

    }



    public function index($id = null)

    {

        $data['type']  = $_GET['type'];

        $data['title'] = lang('all') . ' ' . lang('Equipment');

        //get all equipment information

        $data['all_equipment_info'] = $this->equipment_model->get_permission('tbl_equipment');



        $data['subview'] = $this->load->view('admin/equipment/equipment', $data, TRUE);

        $this->load->view('admin/_layout_main', $data);

    }



    public function new_equipment($id = null)

    {

        $data['title'] = lang('new') . ' ' . lang('equipment');

        if (!empty($id)) {

            $can_edit = $this->equipment_model->can_action('tbl_equipment', 'edit', array('id' => $id));



            $edited = can_action('165', 'edited');

            if (!empty($can_edit) || !empty($edited)) {

                $data['equipment_info'] = $this->equipment_model->get_all_equipment_info($id);

            }

        }

        $data['assign_user'] = $this->equipment_model->allowed_user('165');

        // get all employee info

        $data['subview'] = $this->load->view('admin/equipment/new_equipment', $data, FALSE);

        $this->load->view('admin/_layout_modal_lg', $data); //page load

    }



    public function equipmentList($type = "")

    {



        if ($this->input->is_ajax_request()) {

            $this->load->model('datatables');

            $this->datatables->table = 'tbl_equipment';

        

            $custom_field = custom_form_table_search(15);

            $action_array = array('id');

            $main_column = array('sdi_no', 'unit', 'Chassis no', 'description', 'make_for', 'model_no', 'serial_no', 'year');

            $result = array_merge($main_column, $custom_field, $action_array);

            $this->datatables->column_order = $result;

            $this->datatables->column_search = $result;



            $this->datatables->order = array('id' => 'desc');

            $where = "";

            if($type) $where  = array("type" , $type);

            $fetch_data = $this->datatables->get_datatable_permission('',$where);



            $edited = can_action('165', 'edited');

            $deleted = can_action('165', 'deleted');

            $data = array();

            foreach ($fetch_data as $_key => $v_equipment) {

                $profile_info = $this->db->where('user_id', $v_equipment->user_id)->get('tbl_account_details')->row();

                $can_edit = $this->equipment_model->can_action('tbl_equipment', 'edit', array('id' => $v_equipment->id));

                $can_delete = $this->equipment_model->can_action('tbl_equipment', 'delete', array('id' => $v_equipment->id));

                if (!empty($profile_info->fullname)) {

                    $name = $profile_info->fullname . (!empty($profile_info->employment_id) ? ' (' . $profile_info->employment_id . ')' : ' ');

                } else {

                    $name = '-';

                }



                $action = null;

                $sub_array = array();

                $sub_array[] = $_key + 1;

                $sub_array[] = $v_equipment->type;

                $sub_array[] = $v_equipment->sdi_no;

                $sub_array[] = $v_equipment->unit;

                $sub_array[] = $v_equipment->chassis_no;

                $sub_array[] = $v_equipment->description;

                $sub_array[] = $v_equipment->make_for;

                $sub_array[] = $v_equipment->model_no;

                $sub_array[] = $v_equipment->serial_no;

                $sub_array[] = $v_equipment->year;

                

             



                if (!empty($can_edit) || !empty($edited)) {

                    $action .= '<a href="' . base_url() . 'admin/equipment/new_equipment/' . $v_equipment->id . '"

                               class="btn btn-primary btn-xs" title="' . lang('edit') . '" data-toggle="modal"

                               data-target="#myModal_large"><span class="fa fa-pencil-square-o"></span></a>  ';

                }

                if (!empty($can_delete) || !empty($deleted)) {

                    $action .= ajax_anchor(base_url('admin/equipment/delete_equipment/' . $v_equipment->id), "<i class='btn btn-xs btn-danger fa fa-trash-o'></i>", array("class" => "", "title" => lang('delete'), "data-fade-out-on-success" => "#table_" . $_key)) . ' ';

                }

                $action .= btn_view_modal('admin/equipment/equipment_details/' . $v_equipment->id) . ' ';



                $sub_array[] = $action;

                $data[] = $sub_array;

            }



            render_table($data);

        } else {

            redirect('admin/dashboard');

        }

    }



    public function save_equipment($id = NULL)

    {

        $created = can_action('165', 'created');

        $edited = can_action('165', 'edited');

        if (!empty($created) || !empty($edited) && !empty($id)) {

            $data = $this->equipment_model->array_from_post(array(

                'sdi_no',

                'type',

                'unit',

                'chassis_no',

                'description',

                'make_for',

                'model_no',

                'serial_no',

                'year'));

            $data['created_at'] = date("Y-m-d H:i:s");

            if (empty($id)) {

                $data['assigned_by'] = $this->session->userdata('user_id');

            }

            

            //save data into table.

            $this->equipment_model->_table_name = "tbl_equipment"; // table name

            $this->equipment_model->_primary_key = "id"; // $id

            $return_id = $this->equipment_model->save($data, $id);

          

            save_custom_field(15, $return_id);

        

            // save into activities

            $activities = array(

                'user' => $this->session->userdata('user_id'),

                'module' => 'equipment',

                'module_field_id' => $return_id,

                'activity' => $activity,

                'icon' => 'fa-suitcase',

                'link' => 'admin/equipment/view_equipment_details/' . $return_id,

                'value1' => $data['sdi_no'],

            );



            // Update into tbl_project

            $this->equipment_model->_table_name = "tbl_activities"; //table name

            $this->equipment_model->_primary_key = "activities_id";

            $this->equipment_model->save($activities);





            $type = "success";

            $message = $msg;

            set_message($type, $message);

        }

        redirect('admin/equipment');

    }



    public function view_equipment_details($id = NULL)

    {

        $data['title'] = lang('equipment_details');

        //get all equipment information

        $data['equipment_info'] = $this->equipment_model->get_all_equipment_info($id);



        $data['subview'] = $this->load->view('admin/equipment/equipment_detail', $data, TRUE);

        $this->load->view('admin/_layout_main', $data);

    }



    public function equipment_details($id = NULL)

    {

        $data['title'] = lang('equipment_details');

        //get all equipment information

        $data['equipment_info'] = $this->equipment_model->get_all_equipment_info($id);



        $data['subview'] = $this->load->view('admin/equipment/equipment_detail', $data, FALSE);

        $this->load->view('admin/_layout_modal_lg', $data);

    }



    public function delete_equipment($id = NULL)

    {

        $deleted = can_action('165', 'deleted');

        $can_delete = $this->equipment_model->can_action('tbl_equipment', 'delete', array('id' => $id));

        if (!empty($can_delete) || !empty($deleted)) {



            $equipment_info = $equipment_info = $this->db->where('id', $id)->get('tbl_equipment')->row();

            // save into activities

            $activities = array(

                'user' => $this->session->userdata('user_id'),

                'module' => 'equipment',

                'module_field_id' => $id,

                'activity' => 'activity_delete_equipment',

                'icon' => 'fa-suitcase',

                'value1' => $equipment_info->equipment_name,

            );



            // Update into tbl_project

            $this->equipment_model->_table_name = "tbl_activities"; //table name

            $this->equipment_model->_primary_key = "activities_id";

            $this->equipment_model->save($activities);





            $this->equipment_model->_table_name = "tbl_equipment"; // table name

            $this->equipment_model->_primary_key = "id"; // $id

            $this->equipment_model->delete($id); // delete



            // messages for user

            $type = "success";

            $message = lang('equipment_information_delete');

        } else {

            $type = "error";

            $message = 'Operation Field!';

        }

        set_message($type, $message);

        redirect('admin/equipment');

    }



    public function equipment_pdf($id)

    {

        $data['equipment_info'] = $this->equipment_model->get_all_equipment_info($id);



        $this->load->helper('dompdf');

        $view_file = $this->load->view('admin/equipment/equipment_pdf', $data, true);

        pdf_create($view_file, slug_it(lang('equipment_details') . '- ' . $data['equipment_info']->fullname));

    }



    public function download_file($id)

    {

        $this->load->helper('download');

        $file = $this->uri->segment(5);



        if ($id) {

            $down_data = file_get_contents('uploads/' . $file); // Read the file's contents

            force_download($file, $down_data);

        } else {

            $type = "error";

            $message = 'Operation Fieled !';

            set_message($type, $message);

            if (empty($_SERVER['HTTP_REFERER'])) {

                redirect('admin/equipment');

            } else {

                redirect($_SERVER['HTTP_REFERER']);

            }

        }

    }



}

