<?php

/**
 * Description of equipment_type
 *
 * @author Ashraf
 */
class Equipment_type extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('equipment_type_model');
    }

    public function index($id = NULL)
    {
        $data['type'] = $_GET['type'];
        $data['title'] = lang('all') . ' ' . lang('Equipment_type');
        //get all equipment_type information
        $data['all_equipment_type_info'] = $this->equipment_type_model->get_permission('tbl_equipment_type');
        $data['subview'] = $this->load->view('admin/equipment_type/equipment_type', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function new_equipment_type($id = null)
    {
        $data['type'] = $_GET['type'];
        $data['title'] = lang('new') . ' ' . lang('equipment_type');
        if (!empty($id)) {
            $can_edit = $this->equipment_type_model->can_action('tbl_equipment_type', 'edit', array('id' => $id));

            $edited = can_action('101', 'edited');
            if (!empty($can_edit) && !empty($edited)) {
                $data['equipment_type_info'] = $this->equipment_type_model->get_all_equipment_type_info($id);
            }
        }
        $data['assign_user'] = $this->equipment_type_model->allowed_user('101');
        // get all employee info
        $data['subview'] = $this->load->view('admin/equipment_type/new_equipment_type', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data); //page load
    }

    public function equipment_typeList($type ="")
    {
        if ($this->input->is_ajax_request()) {
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_equipment_type';
        
            $custom_field = custom_form_table_search(15);
            $action_array = array('id');
            $main_column = array('sdi_no', 'unit', 'description', 'make_for', 'model_no', 'serial_no', 'year');
            $result = array_merge($main_column, $custom_field, $action_array);
            $this->datatables->column_order = $result;
            $this->datatables->column_search = $result;

            $this->datatables->order = array('id' => 'desc');
            $where = "";
            if($type) $where  = array("equi_type" , $type);
            $fetch_data = $this->datatables->get_datatable_permission('',$where);

            $edited = can_action('101', 'edited');
            $deleted = can_action('101', 'deleted');
            $data = array();
            foreach ($fetch_data as $_key => $v_equipment_type) {
                $profile_info = $this->db->where('user_id', $v_equipment_type->user_id)->get('tbl_account_details')->row();
                $can_edit = $this->equipment_type_model->can_action('tbl_equipment_type', 'edit', array('id' => $v_equipment_type->id));
                $can_delete = $this->equipment_type_model->can_action('tbl_equipment_type', 'delete', array('id' => $v_equipment_type->id));
                if (!empty($profile_info->fullname)) {
                    $name = $profile_info->fullname . (!empty($profile_info->employment_id) ? ' (' . $profile_info->employment_id . ')' : ' ');
                } else {
                    $name = '-';
                }

                $action = null;
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_equipment_type->equi_type;
                $sub_array[] = $v_equipment_type->make;
                $sub_array[] = $v_equipment_type->model;
                $sub_array[] = $v_equipment_type->serial_no;
                $sub_array[] = $v_equipment_type->local_no;
                $sub_array[] = $v_equipment_type->year;
                
             

                if (!empty($can_edit) && !empty($edited)) {
                    $action .= '<a href="' . base_url() . 'admin/equipment_type/new_equipment_type/' . $v_equipment_type->id . ''.'/?type='.$type.'"
                               class="btn btn-primary btn-xs" title="' . lang('edit') . '" data-toggle="modal"
                               data-target="#myModal_large"><span class="fa fa-pencil-square-o"></span></a>  ';
                }
                if (!empty($can_delete) && !empty($deleted)) {
                    $action .= ajax_anchor(base_url('admin/equipment_type/delete_equipment_type/' . $v_equipment_type->id), "<i class='btn btn-xs btn-danger fa fa-trash-o'></i>", array("class" => "", "title" => lang('delete'), "data-fade-out-on-success" => "#table_" . $_key)) . ' ';
                }
                $action .= btn_view_modal('admin/equipment_type/equipment_type_details/' . $v_equipment_type->id . '/?type='.$type) . ' ';

                $sub_array[] = $action;
                $data[] = $sub_array;
            }

            render_table($data);
        } else {
            redirect('admin/dashboard');
        }
    }

    public function save_equipment_type($id = NULL)
    {
        $created = can_action('101', 'created');
        $edited = can_action('101', 'edited');
        if (!empty($created) || !empty($edited) && !empty($id)) {
            $data = $this->equipment_type_model->array_from_post(array(
                'equi_type',
                'make',
                'model',
                'serial_no',
                'transmission',
                'ntn',
                'local_no',
                'year',
                'weight',
                'eng_make',
                'eng_model',
                'tire_size',
                'dimension',));
            $data['created_at'] = date("Y-m-d H:i:s");
            if (empty($id)) {
                $data['assigned_by'] = $this->session->userdata('user_id');
            }
            

            //save data into table.
            $this->equipment_type_model->_table_name = "tbl_equipment_type"; // table name
            $this->equipment_type_model->_primary_key = "id"; // $id
            $return_id = $this->equipment_type_model->save($data, $id);
          
            save_custom_field(15, $return_id);
        
            // save into activities
            $activities = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'equipment_type',
                'module_field_id' => $return_id,
                'activity' => $activity,
                'icon' => 'fa-suitcase',
                'link' => 'admin/equipment_type/view_equipment_type_details/' . $return_id,
                'value1' => $data['sdi_no'],
            );

            // Update into tbl_project
            $this->equipment_type_model->_table_name = "tbl_activities"; //table name
            $this->equipment_type_model->_primary_key = "activities_id";
            $this->equipment_type_model->save($activities);
            
            $type_val = $this->input->post('type_val');
            
            print_r($type_val); die;
            $type = "success";
            $message = $msg;
            set_message($type, $message);
        }
        redirect('admin/equipment_type/?type='.$type_val);
    }

    public function view_equipment_type_details($id = NULL)
    {
        $data['title'] = lang('equipment_type_details');
        //get all equipment_type information
        $data['equipment_type_info'] = $this->equipment_type_model->get_all_equipment_type_info($id);

        $data['subview'] = $this->load->view('admin/equipment_type/equipment_type_detail', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function equipment_type_details($id = NULL)
    {
        $data['type']  = $_GET['type'];
        $data['title'] = lang('equipment_type_details');
        //get all equipment_type information
        $data['equipment_type_info'] = $this->equipment_type_model->get_all_equipment_type_info($id);

        $data['subview'] = $this->load->view('admin/equipment_type/equipment_type_detail', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data);
    }

    public function delete_equipment_type($id = NULL)
    {
        $deleted = can_action('101', 'deleted');
        $can_delete = $this->equipment_type_model->can_action('tbl_equipment_type', 'delete', array('id' => $id));
        if (!empty($can_delete) && !empty($deleted)) {

            $equipment_type_info = $equipment_type_info = $this->db->where('id', $id)->get('tbl_equipment_type')->row();
            // save into activities
            $activities = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'equipment_type',
                'module_field_id' => $id,
                'activity' => 'activity_delete_equipment_type',
                'icon' => 'fa-suitcase',
                'value1' => $equipment_type_info->equipment_type_name,
            );

            // Update into tbl_project
            $this->equipment_type_model->_table_name = "tbl_activities"; //table name
            $this->equipment_type_model->_primary_key = "activities_id";
            $this->equipment_type_model->save($activities);


            $this->equipment_type_model->_table_name = "tbl_equipment_type"; // table name
            $this->equipment_type_model->_primary_key = "id"; // $id
            $this->equipment_type_model->delete($id); // delete

            // messages for user
            $type = "success";
            $message = lang('equipment_type_information_delete');
        } else {
            $type = "error";
            $message = 'Operation Field!';
        }
        set_message($type, $message);
        redirect('admin/equipment_type');
    }

    public function equipment_type_pdf($id)
    {
        $data['equipment_type_info'] = $this->equipment_type_model->get_all_equipment_type_info($id);

        $this->load->helper('dompdf');
        $view_file = $this->load->view('admin/equipment_type/equipment_type_pdf', $data, true);
        pdf_create($view_file, slug_it(lang('equipment_type_details') . '- ' . $data['equipment_type_info']->fullname));
    }

    public function download_file($id)
    {
        $this->load->helper('download');
        $file = $this->uri->segment(5);

        if ($id) {
            $down_data = file_get_contents('uploads/' . $file); // Read the file's contents
            force_download($file, $down_data);
        } else {
            $type = "error";
            $message = 'Operation Fieled !';
            set_message($type, $message);
            if (empty($_SERVER['HTTP_REFERER'])) {
                redirect('admin/equipment_type');
            } else {
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
    }

}
