<?php

/**
 * Description of gpu
 *
 * @author Ashraf
 */
class Gpu extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('gpu_model');
    }

    public function index($id = NULL)
    {

        $data['title'] = lang('all') . ' ' . lang('Gpu');
        //get all gpu information
        $data['all_gpu_info'] = $this->gpu_model->get_permission('tbl_gpu');

        $data['subview'] = $this->load->view('admin/gpu/gpu', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function new_gpu($id = null)
    {
        $data['title'] = lang('new') . ' ' . lang('gpu');
        if (!empty($id)) {
            $can_edit = $this->gpu_model->can_action('tbl_gpu', 'edit', array('id' => $id));

            $edited = can_action('101', 'edited');
            if (!empty($can_edit) && !empty($edited)) {
                $data['gpu_info'] = $this->gpu_model->get_all_gpu_info($id);
            }
        }
        $data['assign_user'] = $this->gpu_model->allowed_user('101');
        // get all employee info
        $data['subview'] = $this->load->view('admin/gpu/new_gpu', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data); //page load
    }

    public function gpuList()
    {
        if ($this->input->is_ajax_request()) {
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_gpu';
        
            $custom_field = custom_form_table_search(15);
            $action_array = array('id');
            $main_column = array('sdi_no', 'unit', 'description', 'make_for', 'model_no', 'serial_no', 'year');
            $result = array_merge($main_column, $custom_field, $action_array);
            $this->datatables->column_order = $result;
            $this->datatables->column_search = $result;

            $this->datatables->order = array('id' => 'desc');
            $fetch_data = $this->datatables->get_datatable_permission();

            $edited = can_action('101', 'edited');
            $deleted = can_action('101', 'deleted');
            $data = array();
            foreach ($fetch_data as $_key => $v_gpu) {
                $profile_info = $this->db->where('user_id', $v_gpu->user_id)->get('tbl_account_details')->row();
                $can_edit = $this->gpu_model->can_action('tbl_gpu', 'edit', array('id' => $v_gpu->id));
                $can_delete = $this->gpu_model->can_action('tbl_gpu', 'delete', array('id' => $v_gpu->id));
                if (!empty($profile_info->fullname)) {
                    $name = $profile_info->fullname . (!empty($profile_info->employment_id) ? ' (' . $profile_info->employment_id . ')' : ' ');
                } else {
                    $name = '-';
                }

                $action = null;
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_gpu->type;
                $sub_array[] = $v_gpu->make;
                $sub_array[] = $v_gpu->model;
                $sub_array[] = $v_gpu->serial_no;
                $sub_array[] = $v_gpu->local_no;
                $sub_array[] = $v_gpu->year;

                if (!empty($can_edit) && !empty($edited)) {
                    $action .= '<a href="' . base_url() . 'admin/gpu/new_gpu/' . $v_gpu->id . '"
                               class="btn btn-primary btn-xs" title="' . lang('edit') . '" data-toggle="modal"
                               data-target="#myModal_large"><span class="fa fa-pencil-square-o"></span></a>  ';
                }
                if (!empty($can_delete) && !empty($deleted)) {
                    $action .= ajax_anchor(base_url('admin/gpu/delete_gpu/' . $v_gpu->id), "<i class='btn btn-xs btn-danger fa fa-trash-o'></i>", array("class" => "", "title" => lang('delete'), "data-fade-out-on-success" => "#table_" . $_key)) . ' ';
                }
                $action .= btn_view_modal('admin/gpu/gpu_details/' . $v_gpu->id) . ' ';

                $sub_array[] = $action;
                $data[] = $sub_array;
            }

            render_table($data);
        } else {
            redirect('admin/dashboard');
        }
    }

    public function save_gpu($id = NULL)
    {
        $created = can_action('101', 'created');
        $edited = can_action('101', 'edited');
        if (!empty($created) || !empty($edited) && !empty($id)) {
            $data = $this->gpu_model->array_from_post(array(
                'type',
                'make',
                'model',
                'serial_no',
                'ntn',
                'local_no',
                'year',
                'weight',
                'eng_make',
                'eng_model',
                'tire_size',
                'dimension',
                ));
            $data['created_at'] = date("Y-m-d H:i:s");
            if (empty($id)) {
                $data['assigned_by'] = $this->session->userdata('user_id');
            }

            
            //save data into table.
            $this->gpu_model->_table_name = "tbl_gpu"; // table name
            $this->gpu_model->_primary_key = "id"; // $id
            $return_id = $this->gpu_model->save($data, $id);
          
            save_custom_field(15, $return_id);
        
            // save into activities
            $activities = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'gpu',
                'module_field_id' => $return_id,
                'activity' => $activity,
                'icon' => 'fa-suitcase',
                'link' => 'admin/gpu/view_gpu_details/' . $return_id,
                'value1' => $data['sdi_no'],
            );

            // Update into tbl_project
            $this->gpu_model->_table_name = "tbl_activities"; //table name
            $this->gpu_model->_primary_key = "activities_id";
            $this->gpu_model->save($activities);


            $type = "success";
            $message = $msg;
            set_message($type, $message);
        }
        redirect('admin/gpu');
    }

    public function view_gpu_details($id = NULL)
    {
        $data['title'] = lang('gpu_details');
        //get all gpu information
        $data['gpu_info'] = $this->gpu_model->get_all_gpu_info($id);

        $data['subview'] = $this->load->view('admin/gpu/gpu_detail', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function gpu_details($id = NULL)
    {
        $data['title'] = lang('gpu_details');
        //get all gpu information
        $data['gpu_info'] = $this->gpu_model->get_all_gpu_info($id);

        $data['subview'] = $this->load->view('admin/gpu/gpu_detail', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data);
    }

    public function delete_gpu($id = NULL)
    {
        $deleted = can_action('101', 'deleted');
        $can_delete = $this->gpu_model->can_action('tbl_gpu', 'delete', array('id' => $id));
        if (!empty($can_delete) && !empty($deleted)) {

            $gpu_info = $gpu_info = $this->db->where('id', $id)->get('tbl_gpu')->row();
            // save into activities
            $activities = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'gpu',
                'module_field_id' => $id,
                'activity' => 'activity_delete_gpu',
                'icon' => 'fa-suitcase',
                'value1' => $gpu_info->gpu_name,
            );

            // Update into tbl_project
            $this->gpu_model->_table_name = "tbl_activities"; //table name
            $this->gpu_model->_primary_key = "activities_id";
            $this->gpu_model->save($activities);


            $this->gpu_model->_table_name = "tbl_gpu"; // table name
            $this->gpu_model->_primary_key = "id"; // $id
            $this->gpu_model->delete($id); // delete

            // messages for user
            $type = "success";
            $message = lang('gpu_information_delete');
        } else {
            $type = "error";
            $message = 'Operation Field!';
        }
        set_message($type, $message);
        redirect('admin/gpu');
    }

    public function gpu_pdf($id)
    {
        $data['gpu_info'] = $this->gpu_model->get_all_gpu_info($id);

        $this->load->helper('dompdf');
        $view_file = $this->load->view('admin/gpu/gpu_pdf', $data, true);
        pdf_create($view_file, slug_it(lang('gpu_details') . '- ' . $data['gpu_info']->fullname));
    }

    public function download_file($id)
    {
        $this->load->helper('download');
        $file = $this->uri->segment(5);

        if ($id) {
            $down_data = file_get_contents('uploads/' . $file); // Read the file's contents
            force_download($file, $down_data);
        } else {
            $type = "error";
            $message = 'Operation Fieled !';
            set_message($type, $message);
            if (empty($_SERVER['HTTP_REFERER'])) {
                redirect('admin/gpu');
            } else {
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
    }

}
