<?php
/**
 * Description of jobs
 *
 * @author Ashraf
 */
class Jobs extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('items_model');
        $this->load->model('jobs_model');
        $this->load->model('Equipment_model');
    }
    public function jobtickets($id = NULL)
    {
        $data['title'] = lang('all') . ' Job Tickets';
        //get all jobs information
        $data['all_jobs_info'] = $this->jobs_model->get_permission('tbl_job_tickets');
        // print_r($data['all_jobs_info']);
        // exit;
        $data['subview'] = $this->load->view('admin/jobs/jobtickets', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    public function index($id = NULL)
    {
        $data['title'] = lang('all') . ' ' . lang('Jobs');
        //get all jobs information
        // $data['all_jobs_info'] = $this->jobs_model->get_permission('tbl_jobs');

        
        // For Custom Pagindation 
            $this->load->library('pagination');
            
            // print_r(base_url('admin/jobs'));
            // exit();
        	
        	$config=[
        	        'base_url'=>base_url('admin/jobs/index'),
        	        'per_page'=>10,
        	        'total_rows'=>$this->jobs_model->rows_pagination(),
        	        ];
        	        
                    $config['full_tag_open'] = "<ul class='pagination'>";
                    $config['full_tag_close'] = '</ul>';
                    $config['num_tag_open'] = '<li>';
                    $config['num_tag_close'] = '</li>';
                    $config['cur_tag_open'] = '<li class="active"><a href="#">';
                    $config['cur_tag_close'] = '</a></li>';
                    $config['prev_tag_open'] = '<li>';
                    $config['prev_tag_close'] = '</li>';
                    $config['first_tag_open'] = '<li>';
                    $config['first_tag_close'] = '</li>';
                    $config['last_tag_open'] = '<li>';
                    $config['last_tag_close'] = '</li>';
                    
                    
                    
                    $config['prev_link'] = 'Previous Page';
                    $config['prev_tag_open'] = '<li>';
                    $config['prev_tag_close'] = '</li>';
                    
                    
                    $config['next_link'] = 'Next Page';
                    $config['next_tag_open'] = '<li>';
                    $config['next_tag_close'] = '</li>';
    
        	        $this->pagination->initialize($config);
        	        
        $data['all_jobs_info']=$this->jobs_model->heypagination($config['per_page'],$this->uri->segment(4));
        
        
        //         print_r(sizeof($data['all_jobs_info']));
        // exit;
        
        
        
        $data['subview'] = $this->load->view('admin/jobs/jobs', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    //this fatches all the jobs
    public function jobsList($filterBy = null, $search_by = null)
    {
        if ($this->input->is_ajax_request()) {
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_jobs';
            $custom_field = custom_form_table_search(15);
            $action_array = array('id');
            $main_column = array('sdi_no', 'workorderid','unit', 'description', 'make_for', 'model_no', 'serial_no', 'year', 'status');
            $result = array_merge($main_column, $custom_field, $action_array);
            $this->datatables->column_order = $result;
            $this->datatables->column_search = $result;
            $this->datatables->order = array('id' => 'desc');
            
            
            // the where conditions
            $where = array();
            // if the filter is empty
            if (empty($filterBy)) {
                $where = array('status !=' => 'completed');
            }
            // if the search by is not empty
            if (!empty($search_by)) {
                if ($search_by == 'by_client') {
                    $where = array('tbl_jobs.client_id' => $filterBy, 'status !=' => 'completed');
                }
                if ($search_by == 'by_category') {
                    $where = array('tbl_jobs.category_id' => $filterBy, 'status !=' => 'completed');
                }
                if ($search_by == 'by_staff') {
                    if ($filterBy == 'everyone') {
                        $where = array('tbl_jobs.permission' => 'all');
                    } else {
                        $where = $filterBy;
                    }
                }
                // hi
            } else {
                if ($filterBy == 'overdue') {
                    $where = array('UNIX_TIMESTAMP(end_date) <' => strtotime(date('Y-m-d')), 'project_status !=' => 'completed');
                } elseif (!empty($filterBy)) {
                    $where = array('tbl_jobs.status' => $filterBy);
                }
            }
            // fetch data
            $fetch_data = $this->datatables->get_datatable_permission($where);
            $edited = can_action('166', 'edited');
            $deleted = can_action('166', 'deleted');
            $data = array();
            $equipment_data = $this->jobs_model->get_all_equpment();
            foreach ($fetch_data as $_key => $v_jobs) {
                $profile_info = $this->db->where('user_id', $v_jobs->user_id)->get('tbl_account_details')->row();
                $can_edit = $this->jobs_model->can_action('tbl_jobs', 'edit', array('id' => $v_jobs->id));
                $can_delete = $this->jobs_model->can_action('tbl_jobs', 'delete', array('id' => $v_jobs->id));
                if (!empty($profile_info->fullname)) {
                    $name = $profile_info->fullname . (!empty($profile_info->employment_id) ? ' (' . $profile_info->employment_id . ')' : ' ');
                } else {
                    $name = '-';
                }

                $unitNumberData = $this->Equipment_model->get_all_equipment_info($v_jobs->unit_no);
                $equipment_datas = '';
                if(!empty($unitNumberData)){
                    $equipment_datas = $unitNumberData->unit;
                }
              // print_r($sub_array);
                $action = null;
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_jobs->workorderid;
                $sub_array[] = $equipment_datas;
                $sub_array[] = $v_jobs->job_type;
                $sub_array[] = $v_jobs->created_at;
                $sub_array[] = $v_jobs->model;
                $sub_array[] = $v_jobs->prn_no;

                $status = null;

                    if (!empty($v_jobs->status)) {

                        if ($v_jobs->status == 'completed') {

                            $status = "<span class='label label-success'>" . lang($v_jobs->status) . "</span>";

                        } elseif ($v_jobs->status == 'in_progress') {

                            $status = "<span class='label label-primary'>" . lang($v_jobs->status) . "</span>";

                        } elseif ($v_jobs->status == 'cancel') {

                            $status = "<span class='label label-danger'>" . lang($v_jobs->status) . "</span>";

                        } else {

                            $status = "<span class='label label-warning'>" . lang($v_jobs->status) . "</span>";

                        }

                    }

                    $change_status = null;

                    // if (!empty($can_edit) && !empty($edited)) {

                        $ch_url = base_url() . 'admin/Jobs/change_status/';

                        $change_status = '<div class="btn-group">

                        <button class="btn btn-xs btn-default dropdown-toggle"

                                data-toggle="dropdown">

                            <span class="caret"></span></button>

                        <ul class="dropdown-menu animated zoomIn">

                            <li>

                                <a href="' . $ch_url . $v_jobs->id . '/started' . '">' . lang('started') . '</a>

                                </li>

                            <li>

                                <a href="' . $ch_url . $v_jobs->id . '/in_progress' . '">' . lang('in_progress') . '</a>

                                </li>

                            <li>

                                <a href="' . $ch_url . $v_jobs->id . '/cancel' . '">' . lang('cancel') . '</a>

                                </li>

                            <li>

                                <a href="' . $ch_url . $v_jobs->id . '/on_hold' . '">' . lang('on_hold') . '</a>

                                </li>

                            <li>

                                <a href="' . $ch_url . $v_jobs->id . '/completed' . '">' . lang('completed') . '</a>

                            </li>

                        </ul>

                    </div>';

                    // }

                    $sub_array[] = $status . ' ' . $change_status;


                // $sub_array[] = $v_jobs->status;
                if (!empty($can_edit) || !empty($edited)) {
                    $action .= '<a onClick="showDropWithSearch()" href="' . base_url() . 'admin/jobs/new_jobs/' . $v_jobs->id . '"
                               class="btn btn-primary btn-xs " title="' . lang('edit') . '" data-toggle="modal"
                               data-target="#myModal_large"><span class="fa fa-pencil-square-o"></span></a>  ';
                }
                if (!empty($can_delete) || !empty($deleted)) {
                    $action .= ajax_anchor(base_url('admin/jobs/delete_jobs/' . $v_jobs->id), "<i class='btn btn-xs btn-danger fa fa-trash-o'></i>", array("class" => "", "title" => lang('delete'), "data-fade-out-on-success" => "#table_" . $_key)) . ' ';
                    
                }

                $action .= btn_view_modal('admin/jobs/jobs_details/' . $v_jobs->id) . ' ';
                $action .= '<a href="' . base_url() . 'admin/jobs/job_ticket_pdf/' . $v_jobs->id . '"
                               class="btn btn-primary btn-xs"  target="_blank"><span class="fa fa-file"></span></a> ' . ' '; 

                // $action .= '<a href="' . base_url() . 'admin/jobs/job_ticket_pdf_new/' . $v_jobs->id . '"
                //               class="btn btn-primary btn-xs" title="Job Ticket Pdf" target="_blank"><span class="fa fa-file" ></span></a> ' . ' ';
                //$action .= btn_view_modal('admin/jobs/jobs_upload/' . $v_jobs->id) . ' ';
                $sub_array[] = $action;
                
                $data[] = $sub_array;
            }
            render_table($data);
        } else {
            redirect('admin/dashboard');
        }
    }
    public function new_jobticket($id = null)
    {
        $data['title'] = lang('new') . ' Job Ticket';
        if (!empty($id)) {
            $can_edit = $this->jobs_model->can_action('tbl_jobs', 'edit', array('id' => $id));
            $edited = can_action('166', 'edited');
            if (!empty($can_edit) || !empty($edited)) {
                $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
              //  echo $this->db->last_query();exit;
                // echo $this->db->last_query();exit;
                $data['equipment_info'] = $this->jobs_model->get_all_equpment();
                $data['client_info'] = $this->jobs_model->get_all_client();
                $data['problems_info'] = $this->jobs_model->get_all_problems();
                //$data['work_ordersnew'] = $this->db->select('*')->from('tbl_job_tickets')->where('id',$id)->result();
                $data['jobs_info']=$this->db->get_where('tbl_job_tickets', array('id' => $id))->row();
                // $data['workorder']=$this->db->get_where('tbl_job_tickets_workorders', array('jobticketid' => $id))->row();
                 $data['workorder'] = $this->db->query('SELECT * FROM `tbl_job_tickets_workorders` WHERE jobticketid = "' . $id . '"')->result_array();
                 $data['tickets_services'] = $this->db->query('SELECT * FROM `tbl_job_tickets_services` WHERE jobticketid = "' . $id . '"')->result_array();
                 $data['parts_new'] = $this->db->query('SELECT * FROM `tbl_job_tickets_parts` WHERE jobticketid = "' . $id . '"')->result_array();
                 //$data['parts_new']=$this->db->get_where('', array('jobticketid' => $id))->row();
                // print_r($data);exit;
              //   echo $this->db->last_query();exit;
                //$data['jobs_info'] = $this->db->query('SELECT * FROM `tbl_job_tickets` WHERE id = "' . $id . '"')->result_array();
              //  $data['workorders'] = $this->db->query('SELECT * FROM `tbl_job_tickets_workorders` WHERE jobticketid = "' . $id . '"')->result_array();
              //  print_r($data);exit;
                
       // echo $this->db->last_query();exit;
            }
        }
        
        $data['assign_user'] = $this->jobs_model->allowed_user('166');
        // get all employee info
      //  echo "<pre>";
    //    print_r($data); exit;//die;
        $data['equipment_info'] = $this->jobs_model->get_all_equpment();
        $data['work_orders'] = $this->db->select('tbl_jobs.workorderid as workorderid, tbl_equipment.sdi_no as sdi_no')->join('tbl_equipment','tbl_jobs.unit_no = tbl_equipment.id')->group_by('workorderid')->order_by('tbl_jobs.id','desc')->get('tbl_jobs')->result();

        $data['parts'] = $this->db->get('tbl_parts')->result();
        $data['parts_all'] = $this->db->get('tbl_parts')->result();
        $data['client_info'] = $this->jobs_model->get_all_client();
        
        //  echo "<pre>";
       // print_r($data); die;        
        $data['problems_info'] = $this->jobs_model->get_all_problems();
        $data['work_type'] = "New Job Ticket";

         //print_r($data['problems_info']); die;
        $data['subview'] = $this->load->view('admin/jobs/new_jobticket', $data, FALSE);
       //   echo "<pre>";
       // print_r($data); die;
        $this->load->view('admin/_layout_modal_lg', $data); //page load
    }
    
    public function save_jobtickets()
    {
     
        $id=$this->uri->segment(4);
       // echo $id;exit;
        if (!empty($id)) {
          //  echo 'hai';exit;
        $ticketmain['date'] = $this->input->post('date');
        $ticketmain['jobticketno'] = $this->input->post('jobticketno');
        $ticketmain['customer_id'] = $this->input->post('company_name');
        $ticketmain['acft_first'] = $this->input->post('acft_first');
        $ticketmain['acft_second'] = $this->input->post('acft_second');
        $ticketmain['acft_third'] = $this->input->post('acft_third');
      //  $ticketmain['sign'] = $this->input->post('jobticketno');
        $ticketmain['employee_id'] = $this->input->post('name');
        $ticketmain['designation'] = $this->input->post('designation');
        $this->db->where('id',$id);
        $this->db->update('tbl_job_tickets',$ticketmain);
      //  echo $this->db->last_query();exit;
   //     $this->db->insert('tbl_job_tickets',$ticketmain);
        //$jtid = $this->db->insert_id();
        $servicename = $this->input->post('servicename');
        $serviceremark = $this->input->post('serviceremark');
        $servicehours_used = $this->input->post('servicehours_used');
        $servicehours_usedid = $this->input->post('servicehours_usedid');
        $serviceid = 0;
        foreach($servicename as $service)
        {
            $servicearray['jobticketid'] = $id;
          
            $servicearray['name'] = $service;
            $servicearray['remark'] = $serviceremark[$serviceid];
            $servicearray['hours_used'] = $servicehours_used[$serviceid];
            //print_r($servicearray);exit;
            //$this->db->insert('tbl_job_tickets_services',$servicearray);
            //$this->db->where('id',$workorderid);
            //$this->db->where('jobticketid',$id);
            //$this->db->update('tbl_job_tickets_services',$servicearray);
            
            $this->db->where('id',$servicehours_usedid[$serviceid])->delete('tbl_job_tickets_services');
         // echo  $this->db->last_query();exit;
            $this->db->insert('tbl_job_tickets_services',$servicearray);
           //  echo  $this->db->last_query();exit;
            $serviceid++;
        }
        
        $workorders = $this->input->post('workorder_id');
     //   print_r($workorders);exit;
       // $rate_per_hours = $this->input->post('rate_per_hours');
        $wohours_used = $this->input->post('hours_used');
        // print_r($wohours_used);exit;
        $cost_center = $this->input->post('cost_center');
        $workid=$this->input->post('workorderid');
        $woid = 0;
        foreach($workorders as $workorder)
        {
            if(!empty($workorder)){
            $workorderarray['jobticketid'] = $id;
            $workorderarray['wordorderid'] = $workorder;
          //  $workorderarray['rate_per_hours'] = $rate_per_hours[$woid];
            $workorderarray['hours_used'] = $wohours_used[$woid];
            $workorderarray['cost_center'] = $cost_center[$woid];
            
            // hi
            //$this->db->where('id',$workid[$woid]);
           // $this->db->where('jobticketid',$id);
         //   $this->db->update('tbl_job_tickets_workorders',$workorderarray);
             $this->db->where('id',$workid[$woid])->delete('tbl_job_tickets_workorders');
            $this->db->insert('tbl_job_tickets_workorders',$workorderarray);
            }
            // echo $this->db->last_query();exit;
            $woid++;
        }
        
        $part_names = $this->input->post('part_name');
        $part_description = $this->input->post('part_description');
        $part_quantity = $this->input->post('part_quantity');
        $part_unit = $this->input->post('part_unit');
        $parts_newid = $this->input->post('parts_newid');
        $ptid = 0;
        
        $this->db->where('jobticketid',$id)->delete('tbl_job_tickets_parts');
            
        foreach($part_names as $part_name)
        {
            if(!empty($part_description[$ptid])){
            $part_namearray['jobticketid'] = $id;
            $part_namearray['partid'] = $part_name;
            $part_namearray['description'] = $part_description[$ptid];
            $part_namearray['quantity'] = $part_quantity[$ptid];
            $part_namearray['unit'] = $part_unit[$ptid];
            $part_namearray['unitprice'] = '0';
          //  print_r($part_namearray);exit;
            //$this->db->where('id',$parts_newid[$ptid])->delete('tbl_job_tickets_parts');
            //echo $this->db->last_query();exit;
            $this->db->insert('tbl_job_tickets_parts',$part_namearray);

            }

            
            //$this->db->where('id',$this->input->post('parts_newid'));
            //$this->db->where('jobticketid',$id);
            //$this->db->update('tbl_job_tickets_parts',$part_namearray);
            //$this->db->insert('tbl_job_tickets_parts',$part_namearray);
            $ptid++;
        }
        }else{
            
              // echo 'hai122';exit;
              $ticketmain['date'] = $this->input->post('date');
        $ticketmain['jobticketno'] = $this->input->post('jobticketno');
        $ticketmain['customer_id'] = $this->input->post('company_name');
        $ticketmain['acft_first'] = $this->input->post('acft_first');
        $ticketmain['acft_second'] = $this->input->post('acft_second');
        $ticketmain['acft_third'] = $this->input->post('acft_third');
      //  $ticketmain['sign'] = $this->input->post('jobticketno');
        $ticketmain['employee_id'] = $this->input->post('name');
        $ticketmain['designation'] = $this->input->post('designation');
        
        $this->db->insert('tbl_job_tickets',$ticketmain);
        $jtid = $this->db->insert_id();
        $servicename = $this->input->post('servicename');
        $serviceremark = $this->input->post('serviceremark');
        $servicehours_used = $this->input->post('servicehours_used');
        $serviceid = 0;
        foreach($servicename as $service)
        {
            $servicearray['jobticketid'] = $jtid;
            $servicearray['name'] = $service;
            $servicearray['remark'] = $serviceremark[$serviceid];
            $servicearray['hours_used'] = $servicehours_used[$serviceid];
           // print_r($servicearray);exit;
            $this->db->insert('tbl_job_tickets_services',$servicearray);
            $serviceid++;
        }
        
        $workorders = $this->input->post('workorder_id');
        
       // $rate_per_hours = $this->input->post('rate_per_hours');
        $wohours_used = $this->input->post('hours_used');
        
        $cost_center = $this->input->post('cost_center');
     //   print_r($cost_center);
      //  print_r($wohours_used);exit;
        $woid = 0;
        foreach($workorders as $workorder)
        {
            $workorderarray['jobticketid'] = $jtid;
            $workorderarray['wordorderid'] = $workorder;
          //  $workorderarray['rate_per_hours'] = $rate_per_hours[$woid];
            $workorderarray['hours_used'] = $wohours_used[$woid];
            $workorderarray['cost_center'] = $cost_center[$woid];
            
            
            $this->db->insert('tbl_job_tickets_workorders',$workorderarray);
            $woid++;
        }
        
        $part_names = $this->input->post('part_name');
        $part_description = $this->input->post('part_description');
        $part_quantity = $this->input->post('part_quantity');
        $part_unit = $this->input->post('part_unit');
        $ptid = 0;
        foreach($part_names as $part_name)
        {
            $part_namearray['jobticketid'] = $jtid;
            $part_namearray['partid'] = $part_name;
            $part_namearray['description'] = $part_description[$ptid];
            $part_namearray['quantity'] = $part_quantity[$ptid];
            $part_namearray['unit'] = $part_unit[$ptid];
            $part_namearray['unitprice'] = '0';
            
            
            $this->db->insert('tbl_job_tickets_parts',$part_namearray);
            $ptid++;
        }
        }
        
      
       // print_r($this->input->post());
      //  exit;
        
         redirect('admin/jobs/jobtickets');
    }
    
    public function delete_jobtickets($id = NULL)
    {
        $deleted = can_action('166', 'deleted');
       // $can_delete = $this->jobs_model->can_action('tbl_jobs', 'delete', array('id' => $id));
        if (!empty($deleted)) {
            
            $this->db->where('id',$id)->delete('tbl_job_tickets');
            $this->db->where('jobticketid',$id)->delete('tbl_job_tickets_services');
            $this->db->where('jobticketid',$id)->delete('tbl_job_tickets_workorders');
            $this->db->where('jobticketid',$id)->delete('tbl_job_tickets_parts');
            
            // messages for user
            $type = "success";
            $message = lang('jobs_information_delete');
             redirect('admin/jobs/jobtickets');
        } else {
            $type = "error";
            $message = 'Operation Field!';
        }
        set_message($type, $message);
       
    }
    
    
    
    public function new_jobs($id = null)
    {
        $data['title'] = lang('new') . ' ' . lang('jobs');
        if (!empty($id)) {
            $can_edit = $this->jobs_model->can_action('tbl_jobs', 'edit', array('id' => $id));
            $edited = can_action('166', 'edited');
            if (!empty($can_edit) || !empty($edited)) {
                $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
                $data['equipment_info'] = $this->jobs_model->get_all_equpment();
                $data['client_info'] = $this->jobs_model->get_all_client();
                $data['problems_info'] = $this->jobs_model->get_all_problems();
            }
        }
        $data['assign_user'] = $this->jobs_model->allowed_user('166');
        // get all employee info
        //print_r($data); die;
        $data['equipment_info'] = $this->jobs_model->get_all_equpment();
        $data['client_info'] = $this->jobs_model->get_all_client();
        $data['problems_info'] = $this->jobs_model->get_all_problems();
        $data['work_type'] = "New Work Order";

         //print_r($data['problems_info']); die;
        $data['subview'] = $this->load->view('admin/jobs/new_jobs', $data, FALSE);
        //print_r($data); die;
        $this->load->view('admin/_layout_modal_lg', $data); //page load
    }

   public function print_job($id = null)
   {
     $data['title'] = lang('new') . ' ' . lang('jobs');
        if (!empty($id)) {
            $can_edit = $this->jobs_model->can_action('tbl_jobs', 'edit', array('id' => $id));
            $edited = can_action('166', 'edited');
            if (!empty($can_edit) || !empty($edited)) {
                $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
                $data['equipment_info'] = $this->jobs_model->get_all_equpment();
                $data['client_info'] = $this->jobs_model->get_all_client();
                $data['problems_info'] = $this->jobs_model->get_all_problems();
            }
        }
        $data['assign_user'] = $this->jobs_model->allowed_user('166');
        // get all employee info
        //print_r($data); die;
        $data['equipment_info'] = $this->jobs_model->get_all_equpment();
        $data['client_info'] = $this->jobs_model->get_all_client();
        $data['problems_info'] = $this->jobs_model->get_all_problems();
        $data['work_type'] = "New Work Order";
        $data['subview'] = $this->load->view('admin/jobs/print_job', $data, FALSE);

   }
   
   public function print_jobticket($id)
   {
        $data['title'] = lang('new') . 'Job Ticket';
     
        $data['client_info'] = $this->jobs_model->get_all_client();
        $data['job_ticket'] = $this->db->where('id',$id)->get('tbl_job_tickets')->row();
        $data['work_type'] = "Print Job Tikcet";
        $data['subview'] = $this->load->view('admin/jobs/print_job_ticket', $data, FALSE);
   }
   
   
   
   public function print_job_ticket($id = null)
   {
     $data['title'] = lang('new') . ' ' . lang('jobs');
        if (!empty($id)) {
            $can_edit = $this->jobs_model->can_action('tbl_jobs', 'edit', array('id' => $id));
            $edited = can_action('166', 'edited');
            if (!empty($can_edit) || !empty($edited)) {
                $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
                $data['equipment_info'] = $this->jobs_model->get_all_equpment();
                $data['client_info'] = $this->jobs_model->get_all_client();
                $data['problems_info'] = $this->jobs_model->get_all_problems();
            }
        }
        $data['assign_user'] = $this->jobs_model->allowed_user('166');
        // get all employee info
        //print_r($data); die;
        $data['equipment_info'] = $this->jobs_model->get_all_equpment();
        $data['client_info'] = $this->jobs_model->get_all_client();
        $data['problems_info'] = $this->jobs_model->get_all_problems();
        $data['work_type'] = "New Work Order";
        $data['subview'] = $this->load->view('admin/jobs/print_job_ticket', $data, FALSE);

   }

   public function sign($id = null)
   {
 
     $this->load->view('admin/jobs/sign');
   
   }



    public function update_signature(){
      
        $job_id = $this->input->post('job_id');
        $base64Value = $this->input->post('base64Value');
        $ImageName = '';
         $PROFILE_DIRECTORY = $_SERVER['DOCUMENT_ROOT'].'/assets/sign/';
       $getSign = $this->saveProfilesImage2($base64Value,$PROFILE_DIRECTORY, $ImageName);
      
         $status = array();
         $status['file'] = $getSign;
        // print_r($status);
       //  exit;
        $this->db->where('id',$job_id);
        
        $res = $this->db->update('tbl_jobs',$status);

         if($res > 0){
          echo json_encode('1');
         } else {
           echo json_encode('0');
         }

    }

   function saveProfilesImage2($base64,$PROFILE_DIRECTORY, $ImageName = '')
   {
    $img = imagecreatefromstring(base64_decode($base64)); 
  //echo $img;
    if($img != false) 
    { 
      //echo 'true';
        $imageName  = ($ImageName !='') ? $ImageName.'.png' : $this->generate_unique_code1().time().'.png';      
        $path = $PROFILE_DIRECTORY.$imageName;
        if(imagepng($img, $path)) 
            return $imageName;                       
        else
            return '';
    } 
  }

function generate_unique_code1(){
    return substr(str_shuffle("1234567890"),'0','5');    
}


    public function c_new_jobs($id = null)
    {
        $data['title'] = lang('new') . ' ' . lang('jobs');
        if (!empty($id)) {
            $can_edit = $this->jobs_model->can_action('tbl_jobs', 'edit', array('id' => $id));
            $edited = can_action('166', 'edited');
            if (!empty($can_edit) || !empty($edited)) {
                $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
                $data['equipment_info'] = $this->jobs_model->get_all_equpment();
                $data['client_info'] = $this->jobs_model->get_all_client();
                $data['problems_info'] = $this->jobs_model->get_all_problems();
            }
        }
        $data['assign_user'] = $this->jobs_model->allowed_user('166');
        $data['equipment_info'] = $this->jobs_model->get_all_equpment();
        $data['client_info'] = $this->jobs_model->get_all_client();
        $data['problems_info'] = $this->jobs_model->get_all_problems();
        $data['work_type'] = "Client Work Order";

         //print_r($data['problems_info']); die;
        $data['subview'] = $this->load->view('admin/jobs/client_new_jobs', $data, FALSE);
        //print_r($data['equipment_info']); die;
        $this->load->view('admin/_layout_modal_lg', $data); //page load
    }

    public function c_new_jobs_old($id = null)
    {
        $data['title'] = lang('new') . ' ' . lang('jobs');
        if (!empty($id)) {
            $can_edit = $this->jobs_model->can_action('tbl_jobs', 'edit', array('id' => $id));
            $edited = can_action('166', 'edited');
            if (!empty($can_edit) || !empty($edited)) {
                $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
                $data['equipment_info'] = $this->jobs_model->get_all_equpment();
                $data['client_info'] = $this->jobs_model->get_all_client();
                $data['problems_info'] = $this->jobs_model->get_all_problems();
            }
        }
        $data['assign_user'] = $this->jobs_model->allowed_user('166');
        // get all employee info
        //print_r($data); die;
        $data['equipment_info'] = $this->jobs_model->get_all_equpment();
        $data['client_info'] = $this->jobs_model->get_all_client();
        $data['problems_info'] = $this->jobs_model->get_all_problems();

         //print_r($data['problems_info']); die;
        $data['subview'] = $this->load->view('admin/jobs/c_new_jobs', $data, FALSE);
        //print_r($data['equipment_info']); die;
        $this->load->view('admin/_layout_modal_lg', $data); //page load
    }
    public function get_last_vist_PM($id){
        $this->db->select('tbl_jobs.*');
        $this->db->from('tbl_jobs');
        $this->db->where('tbl_jobs.unit_no',$id);
        $this->db->order_by("tbl_jobs.id", "desc");
        $query_result = $this->db->limit(1)->get();
        $result = $query_result->row(); 
        echo json_encode($result);
        exit();
    }
    public function get_ajax_equipment($id)
    {
        $this->db->select('tbl_equipment.*', FALSE);
        $this->db->from('tbl_equipment');
        $this->db->where('tbl_equipment.id',$id);
        $query_result = $this->db->get();
        $result = $query_result->row(); 
        echo json_encode($result);
        exit();
    }
    public function get_ajax_company($id)
    {
        $result = $this->jobs_model->get_all_client($id);
        echo json_encode($result);
        exit();
    }
    
    // fetch tickets for jobs
    public function jobticketsList($filterBy = null, $search_by = null)
    {
        if ($this->input->is_ajax_request()) {
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_job_tickets';
            $custom_field = custom_form_table_search(15);
            $action_array = array('id');
            $main_column = array('tbl_job_tickets.jobticketno','tbl_job_tickets.date','tbl_job_tickets.status');
            $result = array_merge($main_column, $custom_field, $action_array);
            $this->datatables->column_order = $result;
            $this->datatables->column_search = $result;
            $this->datatables->order = array('id' => 'desc');
            
            $fetch_data = $this->datatables->get_datatable_permission();
            
            $where = array();
            if (empty($filterBy)) {
                $where = array('status !=' => 'completed');
            }
            if (!empty($search_by)) {
                if ($search_by == 'by_client') {
                    $where = array('tbl_job_tickets.client_id' => $filterBy, 'status !=' => 'completed');
                }
                if ($search_by == 'by_category') {
                    $where = array('tbl_job_tickets.category_id' => $filterBy, 'status !=' => 'completed');
                }
                if ($search_by == 'by_staff') {
                    if ($filterBy == 'everyone') {
                        $where = array('tbl_job_tickets.permission' => 'all');
                    } else {
                        $where = $filterBy;
                    }
                }
            } else {
                if ($filterBy == 'overdue') {
                    $where = array('UNIX_TIMESTAMP(end_date) <' => strtotime(date('Y-m-d')), 'status !=' => 'completed');
                } elseif (!empty($filterBy)) {
                    $where = array('tbl_job_tickets.status' => $filterBy);
                }
            }
            $fetch_data = $this->datatables->get_datatable_permission($where);

              $data = array();
            $edited = can_action('166', 'edited');
            $deleted = can_action('166', 'deleted');
          
            // get all data from tbl_equipment
            $equipment_data = $this->jobs_model->get_all_equpment();
            
            // loopthrough data
            foreach ($fetch_data as $_key => $v_jobs) {
                // get persons profile info
                $profile_info = $this->db->where('user_id', $v_jobs->user_id)->get('tbl_account_details')->row();
                // check if they can edit
                $can_edit = $this->jobs_model->can_action('tbl_jobs', 'edit', array('id' => $v_jobs->id));
                // check if they can delete
                $can_delete = $this->jobs_model->can_action('tbl_jobs', 'delete', array('id' => $v_jobs->id));
                // if we have the profile name
                if (!empty($profile_info->fullname)) {
                    $name = $profile_info->fullname . (!empty($profile_info->employment_id) ? ' (' . $profile_info->employment_id . ')' : ' ');
                } else {
                    $name = '-';
                }

                // check unit
                $unitNumberData = $this->Equipment_model->get_all_equipment_info($v_jobs->unit_no);
                $equipment_datas = '';
                if(!empty($unitNumberData)){
                    $equipment_datas = $unitNumberData->unit;
                }
               
                $action = null;
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_jobs->jobticketno;
                $sub_array[] = $v_jobs->date;
                $status = null;
                // check tickets status
                    if (!empty($v_jobs->status)) {
                        if ($v_jobs->status == 'completed') {
                            $status = "<span class='label label-success'>" . lang($v_jobs->status) . "</span>";
                        } elseif ($v_jobs->status == 'in_progress') {
                            $status = "<span class='label label-primary'>" . lang($v_jobs->status) . "</span>";
                        } elseif ($v_jobs->status == 'cancel') {
                            $status = "<span class='label label-danger'>" . lang($v_jobs->status) . "</span>";
                        } else {
                            $status = "<span class='label label-warning'>" . lang($v_jobs->status) . "</span>";
                        }
                    }
                    // initialize change status to null
                    $change_status = null;

                    // if (!empty($can_edit) && !empty($edited)) {

                        $ch_url = base_url() . 'admin/Jobs/jobtickets_change_status/';

                        $change_status = '<div class="btn-group">

                        <button class="btn btn-xs btn-default dropdown-toggle"

                                data-toggle="dropdown">

                            <span class="caret"></span></button>

                        <ul class="dropdown-menu animated zoomIn">

                            <li>

                                <a href="' . $ch_url . $v_jobs->id . '/started' . '">' . lang('started') . '</a>

                                </li>

                            <li>

                                <a href="' . $ch_url . $v_jobs->id . '/in_progress' . '">' . lang('in_progress') . '</a>

                                </li>

                            <li>

                                <a href="' . $ch_url . $v_jobs->id . '/cancel' . '">' . lang('cancel') . '</a>

                                </li>

                            <li>

                                <a href="' . $ch_url . $v_jobs->id . '/on_hold' . '">' . lang('on_hold') . '</a>

                                </li>

                            <li>

                                <a href="' . $ch_url . $v_jobs->id . '/completed' . '">' . lang('completed') . '</a>

                            </li>

                        </ul>

                    </div>';

                    // }

                    $sub_array[] = $status . ' ' . $change_status;

                if (!empty($can_edit) || !empty($edited)) {
                    $action .= '<a onClick="showDropWithSearch()" href="' . base_url() . 'admin/jobs/new_jobticket/' . $v_jobs->id . '"
                               class="btn btn-primary btn-xs" title="' . lang('edit') . '" data-toggle="modal"
                               data-target="#myModal_large"><span class="fa fa-pencil-square-o"></span></a>  ';
                }
                if (!empty($can_delete) || !empty($deleted)) {
                    $action .= ajax_anchor(base_url('admin/jobs/delete_jobtickets/' . $v_jobs->id), "<i class='btn btn-xs btn-danger fa fa-trash-o'></i>", array("class" => "", "title" => lang('delete'), "data-fade-out-on-success" => "#table_" . $_key)) . ' ';
                }

                $action .= btn_view_modal('admin/jobs/jobs_ticket_details/' . $v_jobs->id) . ' ';
                $action .= '<a target="_blank" href="' . base_url() . 'admin/jobs/print_jobticket/' . $v_jobs->id . '"
                               class="btn btn-primary btn-xs" ><span class="fa fa-file"></span></a> ' . ' '; 

              /*  $action .= '<a href="' . base_url() . 'admin/jobs/job_ticket_pdf_new/' . $v_jobs->id . '"
                               class="btn btn-primary btn-xs" title="Job Ticket Pdf" target="_blank"><span class="fa fa-file" ></span></a> ' . ' ';*/
                //$action .= btn_view_modal('admin/jobs/jobs_upload/' . $v_jobs->id) . ' ';
                $sub_array[] = $action;
                
                $data[] = $sub_array;
            }
            // the filtration basically happens here, this is probably a view rendering function inside
            render_table($data,$where);
        } else {
            redirect('admin/dashboard');
        }
    }
    //JOB TICKEt list function end 
    
    
    
    
    
    //JOB TICKEt change function start
    public function jobtickets_change_status($id,$status)
    
     {

        $edited = can_action('166', 'edited');

        $can_edit = $this->jobs_model->can_action('tbl_job_tickets', 'edit', array('id' => $id));

        // if (!empty($can_edit) && !empty($edited)) {

            $jobs_info = $this->jobs_model->check_by(array('id' => $id), 'tbl_job_tickets');

            $notifiedUsers = array();

            if (!empty($jobs_info->permission) && $jobs_info->permission != 'all') {

                $permissionUsers = json_decode($jobs_info->permission);

                foreach ($permissionUsers as $user => $v_permission) {

                    array_push($notifiedUsers, $user);

                }

            } else {

                $notifiedUsers = $this->jobs_model->allowed_user_id('166');

            }

            if (!empty($notifiedUsers)) {

                foreach ($notifiedUsers as $users) {

                    if ($users != $this->session->userdata('user_id')) {

                        add_notification(array(

                            'to_user_id' => $users,

                            'from_user_id' => true,

                            'description' => 'not_changed_status',

                            'link' => 'admin/projects/project_details/' . $id,

                            'value' => lang('status') . ' : ' . lang($jobs_info->status) . ' to ' . lang($status),

                        ));

                    }

                }

            }

            show_notification($notifiedUsers);





            $client_info = $this->jobs_model->check_by(array('client_id' => $jobs_info->client_id), 'tbl_client');

            if (!empty($client_info->primary_contact)) {

                $notifyUser = array($client_info->primary_contact);

            } else {

                $user_info = $this->jobs_model->check_by(array('company' => $jobs_info->client_id), 'tbl_account_details');

                if (!empty($user_info)) {

                    $notifyUser = array($user_info->user_id);

                }

            }

            if (!empty($notifyUser)) {

                foreach ($notifyUser as $v_user) {

                    if ($v_user != $this->session->userdata('user_id')) {

                        add_notification(array(

                            'to_user_id' => $v_user,

                            'from_user_id' => true,

                            'description' => 'not_changed_status',

                            'link' => 'client/projects/project_details/' . $id,

                            'value' => lang('status') . ' : ' . lang($jobs_info->status) . ' to ' . lang($status),

                        ));

                    }

                }

                show_notification($notifyUser);

            }



            $data['status'] = $status;

            // if ($data['status'] == 'completed') {

            //     $data['progress'] = 100;

            //     $this->tasks_timer('off', $id, true);

            // }

            // if (!empty($data['progress']) && $data['progress'] == 100) {

            //     $data['status'] = 'completed';

            // }

            $this->jobs_model->_table_name = 'tbl_job_tickets';

            $this->jobs_model->_primary_key = 'id';

            $this->jobs_model->save($data, $id);

            // messages for user

            $type = "success";

            $message = lang('change_status');

            set_message($type, $message);

        //}

        if (empty($_SERVER['HTTP_REFERER'])) {

            redirect('admin/jobs/jobtickets');

        } else {

            redirect($_SERVER['HTTP_REFERER']);

        }

    }
    
    //END FUNCTION 
    
    public function save_jobs($id = NULL)
    {
	
        $created = can_action('166', 'created');
        $edited = can_action('166', 'edited');
        if (!empty($created) || !empty($edited) && !empty($id)) {
            
            $data = $this->jobs_model->array_from_post(array(
                'job_type',
                'unit_no',
                'workorderid',
                'checkindatetime',
                'checkoutdatetime',
                'date_open',
                'previous_hr_meter',
                'equipment',
                'plat_no',
                'present_hr_meter',
                'model',
                'serial_no',
                'last_pm_date',
                'chassis_no',
                'year',
                'last_visit_to_shop',
                'company_name',
                'prn_no',
                'representative_name',
                'open_name',
                'open_prn',
                'open_date',
                'close_name',
                'close_prn',
                'close_date',
            ));
            if(in_array(-1,$this->input->post('problem')))
            {
               $data['other_problem'] = $this->input->post('other_problem');
            }
            else{
                $data['other_problem'] = Null;
            }
            $data['problem']   = implode(',',$this->input->post('problem'));
            
          //  print_r($data);
            $datetimein = $data['checkindatetime']; 
            $datetimeout = $data['checkoutdatetime']; 
            $datetime1 = new DateTime($datetimein);
            $datetime2 = new DateTime($datetimeout);
            $interval = $datetime1->diff($datetime2);
           // $elapsed = $interval->format('%y Y %m M %a D %h H %i M %s S');
           $totalyears = $interval->format('%y');
           $totalmonth = $interval->format('%m');
           $totaldays = $interval->format('%a');
           $totalhous = $interval->format('%h');
           $totalmins = $interval->format('%i');
           $totalsecs = $interval->format('%s');
         
           $totalhousnew = ($totalyears*365*30 * 24); 
           $totalhousnew += ($totalmonth *30 * 24); 
           $totalhousnew += ($totaldays * 24); 
           $totalhousnew += $totalhous;
            $elapsed = $totalhousnew.":".$totalmins;


          //  $elapsed = $interval->format('%h:%i');
            $to_time = strtotime($datetimeout);
            $from_time = strtotime($datetimein);
            $taotaltimenew =  round(abs(($to_time - $from_time) / 60)/60,2);
            $parts = explode('.', (string) $taotaltimenew);
            
          $decimal = ".".$parts[1]*60;
            $taotaltime = $parts[0].":".$decimal;
          
            $data['totalchecktime']  = $elapsed;

            $data['created_at'] = date("Y-m-d H:i:s");
            if (empty($id)) {
                $data['assigned_by'] = $this->session->userdata('user_id');
            }
            //print_r($data); die;
            //save data into table.
            $this->jobs_model->_table_name = "tbl_jobs"; // table name
            $this->jobs_model->_primary_key = "id"; // $id
            $return_id = $this->jobs_model->save($data, $id);
            
            //save daat is session
            $this->session->set_userdata('job_id', $return_id);

            save_custom_field(15, $return_id);
            // save into activities
            $activities = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'jobs',
                'module_field_id' => $return_id,
                'activity' => $activity,
                'icon' => 'fa-suitcase',
                'link' => 'admin/jobs/view_jobs_details/' . $return_id,
                'value1' => $data['sdi_no'],
            );
            // Update into tbl_project
            $this->jobs_model->_table_name = "tbl_activities"; //table name
            $this->jobs_model->_primary_key = "activities_id";
            $this->jobs_model->save($activities);
            $type = "success";
            $message = $msg;
            set_message($type, $message);
        }
		
        if($this->input->post('save')==="save"){
            redirect('admin/jobs');
        }elseif($this->input->post('save')==="next"){
            redirect('admin/jobs/view_next_step1');
        }
        
    }
    public function jobinv(){
        $data['title'] = lang('jobs_invoice');
        $data['subview'] = $this->load->view('admin/jobs/job_invoice', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    public function view_next_step1(){
        $jobId = $this->session->userdata('job_id');
        $usedTools = $this->jobs_model->get_user_job_tools();
        $data['usedTools'] = $usedTools;
        $all_accounts = $this->jobs_model->get_all_accounts();
        $data['all_accounts'] = $all_accounts;
       
        $all_completed_jobs = $this->jobs_model->get_all_completed_job($jobId);
        $data['all_completed_jobs'] = $all_completed_jobs;
        $data['job_id'] = $jobId;
        $data['title'] = lang('jobs_details');
        // echo '<pre>';print_r($data);die;
        $data['subview'] = $this->load->view('admin/jobs/next_step1', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    public function save_step1(){
        //update previous added jobs
        //get Date diff as intervals
       /* $d1 = new DateTime("01:00:00");
        $d2 = new DateTime("05:35:45");
        $interval = $d1->diff($d2);
        $diffInSeconds = $interval->s; //45
        $diffInMinutes = $interval->i; //23
        $diffInHours   = $interval->h; //8
        $diffInDays    = $interval->d; //21
        $diffInMonths  = $interval->m; //4
        $diffInYears   = $interval->y; //1
        echo ($interval->h .' '. $diffInMinutes . ' ' . $diffInSeconds);
        print_r($_POST);
        exit();*/
        // echo '<pre>';print_r($_POST);die;
        $jobId = $this->session->userdata('job_id');
        $this->db->delete('tbl_jobs_done', array('job_id' => $jobId));

        foreach($_POST['code'] as $key => $val){

            $newTimeDuration = '00:00:00';
            //get Date diff as interval
            if($_POST['startTime'][$key] && $_POST['endTime'][$key]){
                $d1 = new DateTime($_POST['startTime'][$key]);
                $d2 = new DateTime($_POST['endTime'][$key]);
                $interval = $d1->diff($d2);
                $newTimeDuration = ($interval->h.':'.$interval->i.':'.$interval->s);
            }
        
            $insert['code']=$val;
            $insert['date']=$_POST['date'][$key];
            $insert['hrs']=$newTimeDuration;
            $insert['job_id']=$_POST['job_id'];
            $insert['job']=$_POST['job'][$key];
            $insert['start_time']=$_POST['startTime'][$key];
            $insert['end_time']=$_POST['endTime'][$key];
            $insert['tool_used']=json_encode($_POST['toolUsed'][$key]);
            $this->db->insert('tbl_jobs_done',$insert);

        }
        if($this->input->post('save')==="save"){
            redirect('admin/jobs');
        }elseif($this->input->post('save')==="next"){
            redirect('admin/jobs/view_next_step2');
        }
    }
    public function get_getequipment_disc(){
        $resut = $this->db->get_where('tbl_parts',array('partno'=>$_POST['productName']))->row();
        echo json_encode($resut);
    }
    public function get_getequipment_partno(){
        $resut = $this->db->get_where('tbl_parts',array('disc'=>$_POST['productName']))->row();
        echo json_encode($resut);
    }
    public function view_next_step2(){
        $jobId = $this->session->userdata('job_id');
        $get_invoice = $this->jobs_model->get_all_parts_invoice($jobId);
        $get_parts = $this->jobs_model->get_all_parts();
        $all_invoice_list = $this->jobs_model->get_all_parts_details_list_invoice($jobId);
        $data['all_invoice_list'] = $all_invoice_list;
        $data['get_invoice'] = $get_invoice;
        $data['get_parts'] = $get_parts;
        $data['all_accounts'] = $this->jobs_model->get_all_accounts();
        $data['title'] = lang('jobs_details');
        $data['jobId'] = $jobId;
        $data['subview'] = $this->load->view('admin/jobs/next_step2', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    public function save_step2(){
        // echo '<pre>';
        // print_r($_POST);die;
        $jobId = $this->session->userdata('job_id');
        $get_invoice = $this->jobs_model->get_all_parts_invoice($jobId);
        
        if(!empty($get_invoice)){
            //update previous added invoice data
            $invoiceId = $get_invoice->id;
            $this->db->delete('tbl_job_part_indetail', array('invoice' => $invoiceId));
            //update invoice
            $this->db->delete('tbl_job_part_invoice', array('job_id' => $jobId));
        }

        $this->db->select('*');
        $this->db->from('tbl_job_part_invoice');
        $count = $this->db->get()->num_rows();
        $invoice = $count + 1;
            $array['job_id'] = $jobId;
            $array['invoice'] = $invoice;
            $array['subtotal'] = $_POST['subtotal'];
            $array['handfee'] = $_POST['handfee'];
            $array['laborcost'] = $_POST['laborcost'];
            $array['vat'] = $_POST['vat'];
            $array['amtdue'] = $_POST['amtdue'];
            $this->db->insert('tbl_job_part_invoice',$array);
            $insert_invoice = $this->db->insert_id();
                foreach($_POST['partno'] as $key => $val){
                    $insert_data['invoice'] = $insert_invoice;
                    $insert_data['invoice'] = $insert_invoice;
                    $insert_data['partno']=$val;
                    $insert_data['disc']=$_POST['disc'][$key];
                    $insert_data['emp_code']=$_POST['emp_code'][$key];
                    $insert_data['qty']=$_POST['qty'][$key];
                    $insert_data['unit']=$_POST['unit'][$key];
                    $insert_data['unitprice']=$_POST['unitprice'][$key];
                    $insert_data['totalprice']=$_POST['totalprice'][$key];
                    $resss = $this->db->insert('tbl_job_part_indetail',$insert_data);
                    
                    //my code
                    if($resss && empty($get_invoice)){
                        $partData = $this->jobs_model->GetSingleByPartNO($_POST['part_id'][$key]); 
                        if(!empty($partData)){
                            $partData['instock'] -= $_POST['qty'][$key];
                            $new_instock = $partData['instock'] ;
                            $update = $this->jobs_model->UpdatePartsStocks($partData['id'],$new_instock) ;
                            if($update){
                              if($partData['min_stock'] > $new_instock){    
                                    $req['serial_id'] = $partData['id'];
                                    $req['serial_no'] = $partData['partno'];
                                    $req['request_type'] = 'Part';
                                    $req['min_stock'] = $partData['min_stock'];
                                    $req['instock'] = $new_instock;
                                    $req['title'] = $partData['disc'];
                                    $req_insert = $this->db->insert('tbl_request',$req);
                                    if($req_insert){
                                        // $notifiedUsers = $this->items_model->allowed_user_id('57');
                                        $email_template = email_templates(array('email_group' => 'new_part_request'));
                                        $subject = $email_template->subject;
                                        $message = $email_template->template_body;
                                        
                                        $projectName = str_replace("{PART_NAME}", $partData['partno'], $message);
                                        $Link = str_replace("{PROJECT_URL}", base_url() . 'admin/projects/',$projectName);
                                        $message = str_replace("{SITE_NAME}", config_item('company_name'), $Link);
                                        
                                        $params['subject'] = $subject;
                                        $params['message'] = $message;
                                        $notifiedUsers = $this->items_model->allowed_user_id('57');
                                     
                                        
                                        if (!empty($notifiedUsers)) {
                                            foreach ($notifiedUsers as $users) {
                                                 echo '<pre>';
                                                $login_info = $this->items_model->check_by(array('user_id' => $users), 'tbl_users');
                                                $params['recipient'] = $login_info->email;
                                                $send_mail = $this->items_model->send_email($params);
                                                if ($users != $this->session->userdata('user_id')) {
                                                    add_notification(array(
                                                        'to_user_id' => $users,
                                                        'from_user_id' => true,
                                                        'description' => 'not_changed_status',
                                                        'link' => 'admin/projects',
                                                        'value' => lang('request') . ' : ' . $partData['partno'] . ' instock quantity less then' . $partData['min_stock'],
                                                    ));
                                                }
                                            }
                                        }
                                       
                                       show_notification($notifiedUsers);
                                    }
                              }
                            }
                        }   
                    }
                    // end my code
                }
        redirect('admin/jobs');
    }
    
    public function mail_test(){
         $email_template = email_templates(array('email_group' => 'new_part_request'));
            $subject = $email_template->subject;
            $message = $email_template->template_body;
            
            
            $params['subject'] = $subject;
            $params['message'] = $message;
            // $notifiedUsers = $this->items_model->allowed_user_id('57');
            $notifiedUsers = array("69");
            
            if (!empty($notifiedUsers)) {
                foreach ($notifiedUsers as $users) {
                     echo '<pre>';
                    $login_info = $this->items_model->check_by(array('user_id' => $users), 'tbl_users');
                    $params['recipient'] = $login_info->email;
                    // print_r($params);die;
                     echo $send_mail = $this->items_model->send_email($params);
                }
            }
    }

    public function delete_invoice_part_by_id(){
        //get invoide details
        $invoice_partId = $_POST["id"];
        
        //update previous added invoice data
        $invoiceId = $get_invoice->id;
        $this->db->delete('tbl_job_part_indetail', array('id' => $invoice_partId));

        //update pricing
        $jobId = $this->session->userdata('job_id');
        $get_invoice = $this->jobs_model->get_all_parts_invoice($jobId);
        $all_invoice_list = $this->jobs_model->get_all_parts_details_list_invoice($jobId);

        if(!empty($all_invoice_list)){

            $totalCost = 0;
            foreach($all_invoice_list as $key => $value){
                $totalCost = $totalCost + ($value->qty * $value->unitprice);
            }

            if(!empty($get_invoice)){
                $invoiceId = $get_invoice->id;
                $handfee = $get_invoice->handfee;
                $laborcost = $get_invoice->laborcost;
                $vat = $get_invoice->vat;
            }else{
                $invoiceId = 0;
                $handfee = 0;
                $laborcost = 0;
                $vat = 0;
            }

            $totalCost = $totalCost + intval($handfee) + intval($laborcost);
            if($vat != 0){
                $amtdueDeduct = ( $totalCost / 100 ) * $vat;
                $amtdue = $totalCost - $amtdueDeduct;    
            }else{
                $amtdue = $totalCost;  
            }

            $this->db->set('subtotal', $totalCost);
            $this->db->set('amtdue', $amtdue);
            $this->db->where('id', $invoiceId);   
            $this->db->update('tbl_job_part_invoice');

        }


    }

    public function view_jobs_details($id = NULL)
    {
        $data['title'] = lang('jobs_details');
        //get all jobs information
        $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
        $data['subview'] = $this->load->view('admin/jobs/jobs_detail', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    public function jobs_details_original($id = NULL)
    {
        $data['title'] = lang('jobs_details');
        //get all jobs information
        $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
        $data['problems_info'] = $this->jobs_model->get_all_problems();

        //print_r($data['jobs_info']); die;
        $data['subview'] = $this->load->view('admin/jobs/jobs_detail', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data);
    }
    public function jobs_details($id = NULL)
    {
        $data['title'] = lang('jobs_details');
        
        //get all jobs information
        $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
        $data['problems_info'] = $this->jobs_model->get_all_problems();

        //mcode
        $mcodeData = $this->jobs_model->get_all_completed_job($id);
        $data['mcodeData'] = $mcodeData;

        //invoice data
        $get_invoice = $this->jobs_model->get_all_parts_invoice($id);
        $all_invoice_list = $this->jobs_model->get_all_parts_details_list_invoice($id);
        $data['all_invoice_list'] = $all_invoice_list;
        $data['get_invoice'] = $get_invoice;   
        
        //print_r($data['jobs_info']); die;
        $data['subview'] = $this->load->view('admin/jobs/jobs_detail', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data);
    }
    
    public function jobs_ticket_details($id = NULL)
    {
        $data['title'] = 'jobs_ticket_details';
       
        $data['job_ticket'] = $this->db->where('id',$id)->get('tbl_job_tickets')->row();
        //get all jobs information
        $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
        $data['problems_info'] = $this->jobs_model->get_all_problems();

        //mcode
        $mcodeData = $this->jobs_model->get_all_completed_job($id);
        $data['mcodeData'] = $mcodeData;

        //invoice data
        $get_invoice = $this->jobs_model->get_all_parts_invoice($id);
        $all_invoice_list = $this->jobs_model->get_all_parts_details_list_invoice($id);
        $data['all_invoice_list'] = $all_invoice_list;
        $data['get_invoice'] = $get_invoice;   
        
        //print_r($data['jobs_info']); die;
        $data['subview'] = $this->load->view('admin/jobs/jobs_ticket_details', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data);
    }
    
    
    
    public function delete_jobs($id = NULL)
    {
        $deleted = can_action('166', 'deleted');
        $can_delete = $this->jobs_model->can_action('tbl_jobs', 'delete', array('id' => $id));
        if (!empty($can_delete) || !empty($deleted)) {
            $jobs_info = $jobs_info = $this->db->where('id', $id)->get('tbl_jobs')->row();
            // save into activities
            $activities = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'jobs',
                'module_field_id' => $id,
                'activity' => 'activity_delete_jobs',
                'icon' => 'fa-suitcase',
                'value1' => $jobs_info->jobs_name,
            );
            // Update into tbl_project
            $this->jobs_model->_table_name = "tbl_activities"; //table name
            $this->jobs_model->_primary_key = "activities_id";
            $this->jobs_model->save($activities);
            $this->jobs_model->_table_name = "tbl_jobs"; // table name
            $this->jobs_model->_primary_key = "id"; // $id
            $this->jobs_model->delete($id); // delete
            // messages for user
            $type = "success";
            $message = lang('jobs_information_delete');
        } else {
            $type = "error";
            $message = 'Operation Field!';
        }
        set_message($type, $message);
        redirect('admin/jobs');
    }
    public function jobs_upload($id)
    {
        $data['title'] = lang('jobs_file_upload');
        $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);

        //print_r($data['jobs_info']); die;
        $data['subview'] = $this->load->view('admin/jobs/jobs_file_upload', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data);
    }
    public function jobs_file_upload($id){
        $job_id = $id;
            if(!empty($_FILES['avatar']['name'])){
                $config['upload_path'] = 'uploads/work/';
                $config['allowed_types'] = 'jpg|jpeg|png|gif';
                $config['file_name'] = $_FILES['avatar']['name'];
                
                $this->load->library('upload',$config);
                $this->upload->initialize($config);
                
                if($this->upload->do_upload('avatar')){
                    $uploadData = $this->upload->data();
                    $file = $uploadData['file_name'];
                }else{
                    $file = '';
                }
            }else{
                $file= '';
            }

        $this->db->set('file', $file); 
        $this->db->where('id', $job_id);   
        $this->db->update('tbl_jobs');

        redirect('admin/jobs');
    }
    public function jobs_pdf($id)
    {
        $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
        $data['equipment'] = $this->jobs_model->get_all_equpment(); 
        $data['problems_info'] = $this->jobs_model->get_all_problems();    
        $this->load->helper('dompdf');
        
        $view_file = $this->load->view('admin/jobs/jobs_pdf', $data, true);
        // echo $view_file; die;
        pdf_create($view_file, slug_it(lang('jobs_pdf') . '- ' . $data['jobs_info']->fullname));
    }
    public function mcode_pdf($id)
    {
        $jobs_info = $this->jobs_model->get_all_completed_job($id);
        $data['jobs_info'] = $jobs_info;
        //$this->load->helper('dompdf');
         $data['jobs_info'] = $this->load->view('admin/jobs/mcode_pdf', $data, false);
        // $view_file = $this->load->view('admin/jobs/mcode_pdf', $data, true);
        // // echo $view_file; die;
        // pdf_create($view_file, slug_it(lang('mcode_pdf') . '- ' . $data['jobs_info']->fullname));
    }

    public function mcode_pdf_individual()
    {

        $usedTools = $this->jobs_model->get_user_job_tools();
        $all_accounts = $this->jobs_model->get_all_accounts();

        $empCodes = '';
        if(@count($all_accounts)){
            foreach ($all_accounts as $row){
                if(@$_GET["e"] == $row->account_details_id){
                    $empCodes = $row->employment_id;
                    break;
                }
            }
        }

        $toolCodes = '';
        if(@count($usedTools)){
            foreach ($usedTools as $row){
                if(@$_GET["t"] == $row->id){
                    $toolCodes = $row->name;
                    break;
                }
            }
        }


        $empCode = $_GET["e"];
        $date = $_GET["d"];
        $hrs = $_GET["h"];
        $job_dob = $_GET["j"];
        $data['j'] = $job_dob;
        $data['h'] = $hrs;
        $data['d'] = $date;
        $data['e'] = $empCodes;
        $data['t'] = $toolCodes;
        //$this->load->helper('dompdf');
        //$view_file = $this->load->view('admin/jobs/mcode_pdf_individual', $data, true);
         $data['jobs_info'] = $this->load->view('admin/jobs/mcode_pdf_individual', $data, false);
        // echo $view_file; die;
        //pdf_create($view_file, slug_it(lang('mcode_pdf') . '- ' . $data['jobs_info']->fullname));
    }


    public function all_detail_data($id)
    {
       
        //get all jobs information
        $data['jobs_info'] = $this->jobs_model->get_all_jobs_info($id);
        $data['problems_info'] = $this->jobs_model->get_all_problems();

        //mcode
        $mcodeData = $this->jobs_model->get_all_completed_job($id);
        $data['mcodeData'] = $mcodeData;

        //invoice data
        $get_invoice = $this->jobs_model->get_all_parts_invoice($id);
        $all_invoice_list = $this->jobs_model->get_all_parts_details_list_invoice($id);
        $data['all_invoice_list'] = $all_invoice_list;
        $data['get_invoice'] = $get_invoice;   
        
        $this->load->helper('dompdf');
        $view_file = $this->load->view('admin/jobs/all_detail_data', $data, true);
        // echo $view_file; die;
        pdf_create($view_file, slug_it(lang('mcode_pdf') . '- ' . $data['jobs_info']->fullname));
    }

    public function job_ticket_pdf($id)
    {
        $get_invoice = $this->jobs_model->get_all_parts_invoice($id);
        $all_invoice_list = $this->jobs_model->get_all_parts_details_list_invoice($id);
       // echo $this->db->last_query();exit;
        $jobs_info = $this->jobs_model->get_all_jobs_info($id);
        
        $data['all_invoice_list'] = $all_invoice_list;
        $data['get_invoice'] = $get_invoice;   
        $data['jobs_info'] = $jobs_info;
        $data['mcodeData'] = $this->db->query('SELECT * FROM `tbl_jobs_done` WHERE job_id = "' . $id . '"')->result_array();
        //print_r($data);exit;
        $this->load->helper('dompdf');
        //$view_file = $this->load->view('admin/jobs/job_ticket_pdf', $data, true);
        $data['jobs_info'] = $this->load->view('admin/jobs/job_ticket_pdf', $data, false);
        // echo $view_file; die;
        // pdf_create($view_file, slug_it(lang('job_ticket_pdf') . '- ' . $data['jobs_info']->fullname));
      
    }
    public function download_file($id)
    {
        $this->load->helper('download');
        $file = $this->uri->segment(5);
        if ($id) {
            $down_data = file_get_contents('uploads/' . $file); // Read the file's contents
            force_download($file, $down_data);
        } else {
            $type = "error";
            $message = 'Operation Fieled !';
            set_message($type, $message);
            if (empty($_SERVER['HTTP_REFERER'])) {
                redirect('admin/jobs');
            } else {
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
    }
    public function view_order_data(){
        $jobId = $this->session->userdata('job_id');
        $all_completed_jobs = $this->jobs_model->get_all_completed_job($jobId);
        $data['all_completed_jobs'] = $all_completed_jobs;
        $data['job_id'] = $jobId;
        $data['title'] = lang('jobs_details');
        $data['subview'] = $this->load->view('admin/jobs/view_order_data_list', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function get_ajax_sign()
    {

        $job_id=$this->input->post('sign_id');
        $result = $this->jobs_model->get_sign($job_id);
        echo json_encode($result);

    }
    public function get_ajax_sign_ticket()
    {

        $job_id=$this->input->post('sign_id');
        $result = $this->jobs_model->get_sign_ticket($job_id);
        echo json_encode($result);

    }

     public function job_ticket_pdf_new($id)
    {
        $get_invoice = $this->jobs_model->get_all_parts_invoice($id);
        $all_invoice_list = $this->jobs_model->get_all_parts_details_list_invoice($id);
        $jobs_info = $this->jobs_model->get_all_jobs_info($id);
        $data['all_invoice_list'] = $all_invoice_list;
        $data['get_invoice'] = $get_invoice;   
        $data['jobs_info'] = $jobs_info;
        $this->load->helper('dompdf');
        //$view_file = $this->load->view('admin/jobs/job_ticket_pdf', $data, true);
        $data['jobs_info'] = $this->load->view('admin/jobs/job_ticket_pdf_new', $data, false);
        // echo $view_file; die;
        //pdf_create($view_file, slug_it(lang('job_ticket_pdf') . '- ' . $data['jobs_info']->fullname));
      
    }

    public function change_status($id, $status)

    {

        $edited = can_action('166', 'edited');

        $can_edit = $this->jobs_model->can_action('tbl_jobs', 'edit', array('id' => $id));

        // if (!empty($can_edit) && !empty($edited)) {

            $jobs_info = $this->jobs_model->check_by(array('id' => $id), 'tbl_jobs');

            $notifiedUsers = array();

            if (!empty($jobs_info->permission) && $jobs_info->permission != 'all') {

                $permissionUsers = json_decode($jobs_info->permission);

                foreach ($permissionUsers as $user => $v_permission) {

                    array_push($notifiedUsers, $user);

                }

            } else {

                $notifiedUsers = $this->jobs_model->allowed_user_id('166');

            }

            if (!empty($notifiedUsers)) {

                foreach ($notifiedUsers as $users) {

                    if ($users != $this->session->userdata('user_id')) {

                        add_notification(array(

                            'to_user_id' => $users,

                            'from_user_id' => true,

                            'description' => 'not_changed_status',

                            'link' => 'admin/projects/project_details/' . $id,

                            'value' => lang('status') . ' : ' . lang($jobs_info->status) . ' to ' . lang($status),

                        ));

                    }

                }

            }

            show_notification($notifiedUsers);





            $client_info = $this->jobs_model->check_by(array('client_id' => $jobs_info->client_id), 'tbl_client');

            if (!empty($client_info->primary_contact)) {

                $notifyUser = array($client_info->primary_contact);

            } else {

                $user_info = $this->jobs_model->check_by(array('company' => $jobs_info->client_id), 'tbl_account_details');

                if (!empty($user_info)) {

                    $notifyUser = array($user_info->user_id);

                }

            }

            if (!empty($notifyUser)) {

                foreach ($notifyUser as $v_user) {

                    if ($v_user != $this->session->userdata('user_id')) {

                        add_notification(array(

                            'to_user_id' => $v_user,

                            'from_user_id' => true,

                            'description' => 'not_changed_status',

                            'link' => 'client/projects/project_details/' . $id,

                            'value' => lang('status') . ' : ' . lang($jobs_info->status) . ' to ' . lang($status),

                        ));

                    }

                }

                show_notification($notifyUser);

            }



            $data['status'] = $status;

            // if ($data['status'] == 'completed') {

            //     $data['progress'] = 100;

            //     $this->tasks_timer('off', $id, true);

            // }

            // if (!empty($data['progress']) && $data['progress'] == 100) {

            //     $data['status'] = 'completed';

            // }

            $this->jobs_model->_table_name = 'tbl_jobs';

            $this->jobs_model->_primary_key = 'id';

            $this->jobs_model->save($data, $id);

            // messages for user

            $type = "success";

            $message = lang('change_status');

            set_message($type, $message);

        //}

        if (empty($_SERVER['HTTP_REFERER'])) {

            redirect('admin/jobs');

        } else {

            redirect($_SERVER['HTTP_REFERER']);

        }

    }



}
