<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Ledger extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('items_model');
        $this->load->model('invoice_model');
        $this->load->model('credit_note_model');
    }
    
    public function index(){
        $data['title'] = lang('Ledger');
        $data['active'] = 1;
        $data['subview'] = $this->load->view('admin/ledger/ledger', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    
    
    public function ledgerlist($filterBy = null, $search_by = null){

        if ($this->input->is_ajax_request()) {
            $currency = $this->invoice_model->check_by(array('code' => config_item('default_currency')), 'tbl_currencies');
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_ledger';
            $this->datatables->join_table = array('tbl_client','tbl_ledger_type');
            $this->datatables->join_where = array('tbl_ledger.client_id=tbl_client.client_id','tbl_ledger.type=tbl_ledger_type.ledger_type_id');
            $this->datatables->select = 'tbl_ledger.*,tbl_client.name as client,tbl_ledger_type.name as ledger_type';
            $this->datatables->order = array('tbl_ledger.ledger_id' => 'desc');
            $where  = array("tbl_ledger.status" , 1);
            $fetch_data = $this->datatables->get_datatable_permission('',$where);
            // $edited = can_action('173', 'edited');
            // $deleted = can_action('173', 'deleted');
            $data = array();
            foreach ($fetch_data as $_key => $v_ledger) {
                // print_r($v_ledger);
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_ledger->date;
                $sub_array[] = $v_ledger->ledger_number;
                $sub_array[] = $v_ledger->client;
                $sub_array[] = '<p class="fw-700 fs-16">'.$v_ledger->ledger_type.'</p>';
                $sub_array[] = $v_ledger->discription;
                $sub_array[] = $v_ledger->debit.' '.$currency->symbol;
                $sub_array[] = $v_ledger->credit.' '.$currency->symbol;
                $data[] = $sub_array;
            }
            render_table($data);
        } else {
            redirect('admin/dashboard');
        }
    }
    
    
    public function save_ledger(){
        $all_data = array();

        for ($x = 0; $x < count($_POST['client_id']); $x++){
            $ledger_data['ledger_number'] = 'NPCO_LDG_'.(sprintf('%04d', get_last_ledger_num()+($x+1)));
            $ledger_data['date'] = $this->input->post('date');
            $ledger_data['client_id'] = trim($_POST['client_id'][$x]);
            $ledger_data['type'] = trim($_POST['type'][$x]);
            $ledger_data['debit'] = trim($_POST['debit'][$x]);
            $ledger_data['credit'] = trim($_POST['credit'][$x]);
            $ledger_data['discription'] = trim($_POST['discription'][$x]);
            $all_data[] = $ledger_data;
        }
        
        if (!empty($all_data)) {
            $in = $this->db->insert_batch('tbl_ledger', $all_data);
            if($in){
                set_message('success', 'Ledger Add successFully!!');
            }
        }
        redirect('admin/ledger');
    }
    
    public function cash($id = null){
        $data['title'] = lang('Cash Ledger');
        $data['active'] = ($id == null)?1:2;
        if(!empty($id) && ($id != null)){
            $data['cash_orders'] = $this->invoice_model->check_by(['cash_orders_id' => $id], 'tbl_ledger_cash_orders');
            $data['cash_orders_deatils'] = $this->db->where(['cash_order_id' => $id,'status' => 1])->get('tbl_ledger_cash_orders_deatils')->result();
        }
        $data['subview'] = $this->load->view('admin/ledger/cash', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    
    public function cash_order_deatils($id=null){
        if(!empty($id)){
            $data['title'] = lang('Cash Ledger');
            $data['active'] = 1;
            $data['cashorder'] = $this->cashOrdrData($id);
            $this->db->select('tbl_ledger_cash_orders_deatils.*');
            $this->db->where(['tbl_ledger_cash_orders_deatils.cash_order_id'=>$id,'tbl_ledger_cash_orders_deatils.status' =>1]);
            $data['allOrders'] = $this->db->get('tbl_ledger_cash_orders_deatils')->result();
            $data['cashSum'] = $this->db->select('SUM(accrual_amount) as totalCash')->where(['cash_order_id'=>$id,'status' => 1])->get('tbl_ledger_cash_orders_deatils')->row()->totalCash;
            $data['subview'] = $this->load->view('admin/ledger/cash_orders', $data, TRUE);
            $this->load->view('admin/_layout_main', $data);
        }else{
            redirect('admin/ledger/cash');
        }
    }
    
    public function cashOrdrData($id){
        return $this->db->where('cash_orders_id',$id)->get('tbl_ledger_cash_orders')->row();
    }
    public function pdf_cash_order($id){
        $data['title'] = lang('Cash Ledger');
        $data['cashorder'] = $this->cashOrdrData($id);
        $this->db->select('tbl_ledger_cash_orders_deatils.*');
        $this->db->where(['tbl_ledger_cash_orders_deatils.cash_order_id'=>$id,'tbl_ledger_cash_orders_deatils.status' =>1]);
        $data['allOrders'] = $this->db->get('tbl_ledger_cash_orders_deatils')->result();
        $data['cashSum'] = $this->db->select('SUM(accrual_amount) as totalCash')->where(['cash_order_id'=>$id,'status' => 1])->get('tbl_ledger_cash_orders_deatils')->row()->totalCash;
        $data['title'] = $data['cashorder']->order_no; //Page title
        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/ledger/pdf_cash_order', $data, TRUE);
        // echo ($viewfile);
        pdf_create($viewfile, slug_it('Cash Order'),TRUE,'a4');
    }
    
    public function save_cashorder(){
        $all_data = array();
        // tbl_ledger_cash_orders
        $cashToOrder = array(
            'order_date'    => trim($this->input->post('order_date')),
            'order_no'      => trim($this->input->post('order_no')),
            'order_cashto'  => trim($this->input->post('order_cashto')),
            'order_note'    => trim($this->input->post('order_note')),
        );
        $this->items_model->_table_name = "tbl_ledger_cash_orders";
        $orderID = $this->items_model->save($cashToOrder);

        for ($x = 0; $x < count($_POST['accrual_amount']); $x++){
            $order_data['cash_order_id'] = $orderID;
            $order_data['accrual_amount'] = trim($_POST['accrual_amount'][$x]);
            $order_data['reasons'] = trim($_POST['reasons'][$x]);
            $all_data[] = $order_data;
        }
        if (!empty($all_data)) {
            $in = $this->db->insert_batch('tbl_ledger_cash_orders_deatils', $all_data);
            if($in){
                set_message('success', 'Cash Order Added successFully!!');
            }
        }
        redirect('admin/ledger/cash');
    }
    
     public function edit_cashorder($id){
        $all_data = array();
        $orderID = $id;
        // tbl_ledger_cash_orders
        $cashToOrder = array(
            'order_date'    => trim($this->input->post('order_date')),
            'order_no'      => trim($this->input->post('order_no')),
            'order_cashto'  => trim($this->input->post('order_cashto')),
            'order_note'    => trim($this->input->post('order_note')),
        );
       
        $update = $this->db->set($cashToOrder)->where('cash_orders_id', $id)->update("tbl_ledger_cash_orders");
        if($update){
            if($this->db->set(['status'=>0])->where(['cash_order_id'=> $orderID])->update('tbl_ledger_cash_orders_deatils')){
                $msg = 'Cash Order Updated successFully!!';
                for ($x = 0; $x < count($_POST['accrual_amount']); $x++){
                    $order_data['cash_order_id'] = $orderID;
                    $order_data['accrual_amount'] = trim($_POST['accrual_amount'][$x]);
                    $order_data['reasons'] = trim($_POST['reasons'][$x]);
                    $all_data[] = $order_data;
                }
                
                if (!empty($all_data)) {
                    $in = $this->db->insert_batch('tbl_ledger_cash_orders_deatils', $all_data);
                    if($in){
                        set_message('success', 'Cash Order Updated successFully!!');
                    }
                }
            }
        }
        redirect('admin/ledger/cash');
    }
    
    public function saveCashOrderDeatils($order_data,$orderID){
        
    }
    public function cashOrderlist(){
        
        if ($this->input->is_ajax_request()) {
            $currency = $this->invoice_model->check_by(array('code' => config_item('default_currency')), 'tbl_currencies');
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_ledger_cash_orders';
            $this->datatables->select = '*';
            $this->datatables->order = array('tbl_ledger_cash_orders.cash_orders_id ' => 'desc');
            $fetch_data = $this->datatables->get_datatable_permission('');
            $data = array();
            foreach ($fetch_data as $_key => $v_ledger) {
                // print_r($v_ledger);
                $totalCash = $this->db->select('SUM(accrual_amount) as totalCash')->where(['cash_order_id'=>$v_ledger->cash_orders_id,'status' => 1])->get('tbl_ledger_cash_orders_deatils')->row()->totalCash;
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = '<a href="' . base_url() . 'admin/ledger/cash_order_deatils/'.$v_ledger->cash_orders_id .'">'.$v_ledger->order_no.'</a>';
                $sub_array[] = $v_ledger->order_date;
                $sub_array[] = $v_ledger->order_cashto;
                $sub_array[] = number_format(floatval($totalCash), 2, '.', '');
                $sub_array[] = $v_ledger->order_note;
                $sub_array[] = $v_ledger->create_at	;
                $sub_array[] = '<a href="'.base_url('admin/ledger/cash/'.$v_ledger->cash_orders_id).'" class="btn btn-primary btn-xs"><i class="fa fa-pencil-square-o"></i></a>';
                $data[] = $sub_array;
            }
            render_table($data);
        } else {
            redirect('admin/dashboard');
        }
    }
    
    public function receipt($id = null){
        $data['title'] = lang('Receipt');
        $data['active'] = ($id == null)?1:2;
        if(!empty($id) && ($id != null)){
            $data['receipt'] = $this->invoice_model->check_by(['receipt_id ' => $id], 'tbl_receipt');
        }
        $data['subview'] = $this->load->view('admin/ledger/receipt', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    
    public function save_receipt($id = null){
        $receipt = array(
            'received_name' => trim($this->input->post('received_name')),
            'receipt_voucher_no' => trim($this->input->post('receipt_voucher_no')),
            'sr' => trim($this->input->post('sr')),
            'sr_h' => trim($this->input->post('sr_h')),
            'receipt_sum' => trim($this->input->post('receipt_sum')),   
            'receipt_for' => trim($this->input->post('receipt_for')),
            'paymentType' => trim($this->input->post('paymentType')),
            'payment_data' => trim($this->input->post('payment_data')),
        );
        if($id === null){
            $this->items_model->_table_name = "tbl_receipt";
            $receiptID = $this->items_model->save($receipt);
        }else{
            $this->db->set($receipt);
            $this->db->where('receipt_id', $id);
            $this->db->update("tbl_receipt");
        }
        if(!empty($receiptID)){
             set_message('success', 'Receipt Added successFully!!');
        }else{
             set_message('success', 'Receipt Updated successFully!!');
        }
        redirect('admin/ledger/receipt');
    }
    
    public function receiptlist(){
        if ($this->input->is_ajax_request()) {
            $currency = $this->invoice_model->check_by(array('code' => config_item('default_currency')), 'tbl_currencies');
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_receipt';
            $this->datatables->select = '*';
            $this->datatables->order = array('tbl_receipt.receipt_id ' => 'desc');
            $fetch_data = $this->datatables->get_datatable_permission('');
            $data = array();
            foreach ($fetch_data as $_key => $v_receipt) {
                // print_r($v_ledger);
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_receipt->received_name;
                $sub_array[] = $v_receipt->receipt_voucher_no;
                $sub_array[] = $v_receipt->sr.'.'.$v_receipt->sr_h.' '.$currency->symbol;
                $sub_array[] = $v_receipt->receipt_sum;
                $sub_array[] = $v_receipt->receipt_for;
                $sub_array[] = $v_receipt->paymentType;
                $sub_array[] = $v_receipt->payment_data;
                $sub_array[] = $v_receipt->created_at;
                $action = '';
                $action .= '<a href="'.base_url('admin/ledger/receipt/'.$v_receipt->receipt_id).'" class="btn btn-primary btn-xs"><i class="fa fa-pencil-square-o"></i></a>';
                $action .= '<a href="'.base_url('admin/ledger/receipt_details/'.$v_receipt->receipt_id).'" class="btn btn-primary btn-xs "  style="margin:0px 5px"><span class="fa fa-eye"></span></a>';
                $sub_array[] = $action;
                $data[] = $sub_array;
            }
            render_table($data);
        }else{
            redirect('admin/dashboard');
        }
    }
    
    public function pdf_receipt($id){
        $data['voucher'] = $this->invoice_model->check_by(['receipt_id' => $id], 'tbl_receipt');
        $data['title'] = 'Receipt Voucher';
        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/ledger/receipt_details', $data, TRUE);
        pdf_create($viewfile, slug_it($data['title']));
    }
    
    public function receipt_details($id){
        $data['voucher'] = $this->invoice_model->check_by(['receipt_id' => $id], 'tbl_receipt');
        $data['title'] = 'Receipt Voucher';
        // dd($data['voucher']);
        $data['subview'] = $this->load->view('admin/ledger/receipt_details', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    
    public function payment($id = null){
        $data['title'] = lang('Payment');
        $data['active'] = ($id == null)?1:2;
        if(!empty($id) && ($id != null)){
            $data['payment'] = $this->invoice_model->check_by(['voucher_id' => $id], 'tbl_payment_voucher');
        }
        $data['subview'] = $this->load->view('admin/ledger/payment', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    
    public function save_payment($id = null){
        $payment_voucher = array(
            'received_name' => trim($this->input->post('received_name')),
            'payment_voucher_no' => trim($this->input->post('payment_voucher_no')),
            'sr' => trim($this->input->post('sr')),
            'sr_h' => trim($this->input->post('sr_h')),
            'payment_voucher_sum' => trim($this->input->post('payment_voucher_sum')),   
            'payment_voucher_for' => trim($this->input->post('payment_voucher_for')),
            'paymentType' => trim($this->input->post('paymentType')),
            'payment_data' => trim($this->input->post('payment_data'))
        );
        $this->items_model->_table_name = "tbl_payment_voucher";
        
        if($id === null){
            $voucherID = $this->items_model->save($payment_voucher);
        }else{
            $this->db->set($payment_voucher);
            $this->db->where('voucher_id', $id);
            $this->db->update("tbl_payment_voucher");
        }
        
        if(!empty($voucherID)){
             set_message('success', 'Payment Added successFully!!');
        }else{
             set_message('success', 'Payment updated successFully!!');
        }
        redirect('admin/ledger/payment');
    }
    
    public function paymentlist(){
        if ($this->input->is_ajax_request()) {
            $currency = $this->invoice_model->check_by(array('code' => config_item('default_currency')), 'tbl_currencies');
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_payment_voucher';
            $this->datatables->select = '*';
            $this->datatables->order = array('tbl_payment_voucher.voucher_id ' => 'desc');
            $fetch_data = $this->datatables->get_datatable_permission('');
            $data = array();
            foreach ($fetch_data as $_key => $v_receipt) {
                // print_r($v_ledger);
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_receipt->received_name;
                $sub_array[] = $v_receipt->payment_voucher_no;
                $sub_array[] = $v_receipt->sr.'.'.$v_receipt->sr_h.' '.$currency->symbol;
                $sub_array[] = $v_receipt->payment_voucher_sum;
                $sub_array[] = $v_receipt->payment_voucher_for;
                $sub_array[] = $v_receipt->paymentType;
                $sub_array[] = $v_receipt->payment_data;
                $sub_array[] = $v_receipt->created_at;
                $action = '';
                $action .= '<a href="'.base_url('admin/ledger/payment/'.$v_receipt->voucher_id).'" class="btn btn-primary btn-xs"><i class="fa fa-pencil-square-o"></i></a>';
                $action .= '<a href="'.base_url('admin/ledger/payment_detail/'.$v_receipt->voucher_id).'" style="margin:0px 5px" class="btn btn-primary btn-xs" ><span class="fa fa-eye"></span></a>';
                $sub_array[] = $action;
                $data[] = $sub_array;
            }
            render_table($data);
        }else{
            redirect('admin/dashboard');
        }
    }
    public function pdf_payment($id){
        $data['voucher'] = $this->invoice_model->check_by(['voucher_id' => $id], 'tbl_payment_voucher');
        $data['title'] = 'Payment Voucher';
        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/ledger/pdf_payment', $data, TRUE);
        pdf_create($viewfile, slug_it($data['title']));
    }
    
    public function payment_detail($id){
        $data['voucher'] = $this->invoice_model->check_by(['voucher_id' => $id], 'tbl_payment_voucher');
        $data['title'] = 'Payment Voucher';
        $data['subview'] = $this->load->view('admin/ledger/payment_detail', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    
    public function settlement(){
        $data['title'] = lang('Settlement');
        $data['active'] = 1;
        $data['subview'] = $this->load->view('admin/ledger/settlement', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    
    public function save_settlement(){
        $settlementData = array(
            'settlement_no' => trim($this->input->post('settlement_no')),
            'date' => trim($this->input->post('date')),
            'emp_name' => trim($this->input->post('emp_name')),
            'emp_id' => trim($this->input->post('emp_id')),
            'emp_period' => trim($this->input->post('emp_period')),
            'supv_name' => trim($this->input->post('supv_name')),
            'suv_emp_id' => trim($this->input->post('suv_emp_id')),
            'vaucher_no' => trim($this->input->post('vaucher_no'))
        );

        $this->items_model->_table_name = "tbl_settlement";
        $settlementID = $this->items_model->save($settlementData);
        if(!empty($settlementID)){
            for ($x = 0; $x < count($_POST['settlement_client']); $x++  ){
                $settlement_Data['settlement_identity'] = $settlementID;
                $settlement_Data['settlement_date'] = $_POST['settlement_date'][$x];
                $settlement_Data['settlement_client'] = $_POST['settlement_client'][$x];
                $settlement_Data['settlement_discription'] = $_POST['settlement_discription'][$x];
                $settlement_Data['settlement_receipt_no'] = $_POST['settlement_receipt_no'][$x];
                $settlement_Data['settlement_unit_price'] = $_POST['settlement_unit_price'][$x];
                $settlement_Data['settlement_total'] = $_POST['settlement_total'][$x];
                $settlement_Data['settlement_note	'] = $_POST['settlement_note'][$x];
                $all_data[] = $settlement_Data;
            }
            if (!empty($all_data)) {
                $in = $this->db->insert_batch('tbl_settlement_details', $all_data);
                if($in){
                    set_message('success', 'Settlement Order Added successFully!!');
                }
            }
        }else{
            set_message('danger', 'We have a technical Issue !!');
        }
        redirect('admin/ledger/settlement');
    }
    
    
    public function settlementlist(){
         if ($this->input->is_ajax_request()) {
            $currency = $this->invoice_model->check_by(array('code' => config_item('default_currency')), 'tbl_currencies');
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_settlement';
            $this->datatables->select = '*';
            $this->datatables->order = array('tbl_settlement.settlement_id  ' => 'desc');
            $fetch_data = $this->datatables->get_datatable_permission('');
            $data = array();
            foreach ($fetch_data as $_key => $v_settlement) {
                // print_r($v_ledger);
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_settlement->settlement_no;
                $sub_array[] = $v_settlement->date;
                $sub_array[] = $v_settlement->emp_name;
                $sub_array[] = $v_settlement->emp_id;
                $sub_array[] = $v_settlement->emp_period;
                $sub_array[] = $v_settlement->supv_name;
                $sub_array[] = $v_settlement->suv_emp_id;
                $sub_array[] = $v_settlement->vaucher_no;
                $sub_array[] = '<a href="'.base_url('admin/ledger/pdf_settlement/'.$v_settlement->settlement_id).'" class="btn btn-primary btn-xs" target="_blank"><span class="fa fa-file"></span></a>';
                $data[] = $sub_array;
            }
            render_table($data);
        }else{
            redirect('admin/dashboard');
        }
    }
    
    public function pdf_settlement($id=null){
        $data['settlement'] = $this->invoice_model->check_by(['settlement_id' => $id], 'tbl_settlement');
        $data['settlement_data'] = $this->getSettlement($id);
        $data['title'] = 'Settlement Voucher';
        $this->load->helper('dompdf');
        
        $viewfile = $this->load->view('admin/ledger/pdf_settlement', $data, TRUE);
        // echo $viewfile;
        pdf_create($viewfile, slug_it($data['title'].''.$data['settlement']->settlement_no),TRUE,'a4');
    }
    
    public function getSettlement($id){
        $this->db->select('tbl_settlement_details.*,tbl_client.name as client_name');
        $this->db->from('tbl_settlement_details');
        $this->db->join('tbl_client','tbl_settlement_details.settlement_client=tbl_client.client_id','left');
        $this->db->where(['tbl_settlement_details.settlement_identity'=>$id]);
        $this->db->order_by('tbl_settlement_details.settlement_details_id','ASC');
        return  $this->db->get()->result();
    }
    
}