<?php

/**
 * Description of equipment
 *
 * @author Ashraf
 */
class on_demand extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('ondemand_model');
        $this->load->model('equipment_model');
        $this->load->model('items_model');
        // $this->load->model('tool_model');
    }

    public function index($id = null){
        //get all part
        $data['title'] = 'On Demand Parts || Tools';
        $data['all_parts'] = $this->ondemand_model->get_all_ondemand();
        
        // $data['project']  = $this->part_model->getProject();
        $data['subview'] = $this->load->view('admin/on_demand/on_demand', $data, TRUE);
        
        $this->load->view('admin/_layout_main', $data);
    }

    public function on_demand_List($type = "")
    {

        // if ($this->input->is_ajax_request()) {
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_on_demand';
        
            $custom_field = custom_form_table_search(15);
            $action_array = array('id');
            $main_column = array('id', 'partno', 'status');
            $result = array_merge($main_column, $custom_field, $action_array);
            $this->datatables->column_order = $result;
            $this->datatables->column_search = $result;
            $this->datatables->order = array('id' => 'desc');
            
            $where  = array("status" , 0);
            $fetch_data = $this->datatables->get_datatable_permission('',$where);
           
            $edited = can_action('173', 'edited');
            $deleted = can_action('173', 'deleted');
            $data = array();
            foreach ($fetch_data as $_key => $v_part) {
                
                $profile_info = $this->db->where('user_id', $v_part->user_id)->get('tbl_account_details')->row();
                $can_edit = $this->equipment_model->can_action('tbl_equipment', 'edit', array('id' => $v_part->id));
                $can_delete = $this->equipment_model->can_action('tbl_equipment', 'delete', array('id' => $v_part->id));
                if (!empty($profile_info->fullname)) {
                    $name = $profile_info->fullname . (!empty($profile_info->employment_id) ? ' (' . $profile_info->employment_id . ')' : ' ');
                } else {
                    $name = '-';
                }

                $action = null;
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_part->partno;
                $sub_array[] = date( "jS M Y h:i A", strtotime($v_part->created_at));
                $sub_array[] = $v_part->disc;
                // My code
                $sub_array[] = $v_part->size;
                $sub_array[] = $v_part->category;
                $sub_array[] = $v_part->stock_location;
                $sub_array[] = $v_part->process_qty;
                $sub_array[] = $v_part->conn;
                $sub_array[] = $v_part->req_type;
                $sub_array[] = $v_part->req_priorty;
               
                
                if($v_part->request_status == '1'){
                    $request_status = '<span style=" color:#fff;padding: 1px 2px; background-color: #27c24c;" >Accepted</span> ';
                }elseif($v_part->request_status == '2'){
                    $request_status = '<span  style=" color:#fff;padding: 1px 2px; background-color: #5d9cec;" >On Hold</span> ';
                }elseif($v_part->request_status == '00'){
                    $request_status = '<span  style=" color: #fff;padding: 1px 2px; background-color: red;" >Reject</span> ';
                }elseif($v_part->request_status == '11'){
                    $request_status = '<span  style=" color: #fff;padding: 1px 2px; background-color: #23b7e5;">Completed</span> ';
                }
                else{
                    $request_status = '';
                }
                
                $sub_array[] = $request_status;
                $sub_array[] = $v_part->edd;
                if($v_part->project_status == '1' && $v_part->request_status == '1'){
                    $mms = '<a onClick="DeliveryPopUpModel('."'$v_part->id'".','."'$v_part->project_no'".')" class = "DRMss" data-toggle="modal" data-target="#DRMms" >
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus" viewBox="0 0 16 16"> <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z"/> 
                                </svg>
                            </a>';
                     $sub_array[] = $mms;
                }
                else{
                    $sub_array[] = $v_part->rec_mss;
                }
               
                
                //my code end 
                if (!empty($can_edit) || !empty($edited)) {
                    // $action .= '<a onClick="editPopUpModel('."'$v_part->partno'".', '."'$v_part->disc'".','."'$v_part->id'".','."'$v_part->size'".','."'$v_part->category'".','."'$v_part->instock'".','."'$v_part->stock_location'".','."'$v_part->min_stock'".','."'$v_part->fixed_qty'".','."'$v_part->conn'".','."'$v_part->req_type'".','."'$v_part->req_priorty'".','."'$v_part->rec_mss'".');"
                    //     href="' . base_url() . 'admin/tool/new_tool/' . $v_tool->id . '"
                    //     class="btn btn-primary btn-xs" title="' . lang('edit') . '" data-toggle="modal"
                    //     data-target="#myEditModal_large">
                    //     <span class="fa fa-pencil-square-o"></span>
                    //     </a>';
                    $action .= '<a onclick="()" href="https://npcosystem.com/admin/on_demand/edit_ondemand/'.$v_part->id.'" class="btn btn-primary btn-xs " title="Edit" data-toggle="modal" data-target="#myModal"><span class="fa fa-pencil-square-o"></span></a>';
                }
                if (!empty($can_delete) || !empty($deleted)) {
                    // $action .= ajax_anchor(base_url('admin/on_demand/delete_on_demand?did='.$v_part->id), '<i class="btn btn-xs btn-danger fa fa-trash-o"></i>', array("class" => "", "title" => lang('delete'), "data-fade-out-on-success" => "#table_" . $_key)) . ' ';

                    $action .= '<a onclick="return confirm('."'Are you sure you want to delete $v_part->partno ?'".');" class="btn btn-danger btn-xs"  href = "'.base_url('admin/on_demand/delete_on_demand?did='.$v_part->id).'" style="padding: 0;margin: 2px;"><i class="btn btn-xs btn-danger fa fa-trash-o"></i></a>';
                }
                // $action .= btn_view_modal('admin/part/part_details/' . $v_part->id) . ' ';

                
               
                
                $sub_array[] = $action;
                $data[] = $sub_array;
            }
            render_table($data);
        // } else {
        //     redirect('admin/dashboard');
        // }
    }
    
    public function edit_ondemand($id = null){
        // if(!empty($id)){
        //     echo "$id";
        // }else{
        //     echo "NULLL";
        // }
        // exit();
        $data['item'] = $this->items_model->check_by(array('id' => $id), 'tbl_on_demand');
        $data['subview'] = $this->load->view('admin/on_demand/edit_ondemand', $data, FALSE);
        $this->load->view('admin/_layout_modal', $data); //page load
    }
    
    public function save_ondemand()
    {
        if(!empty($_POST["partno"])){
            
            // save into parts
            $ondemandData = array(
                'partno' => trim($_POST["partno"]),
                'disc' => trim($_POST["disc"]),
                'size' => trim($_POST["size"]),
                'category' => trim($_POST["category"]),
                'stock_location' => trim($_POST["stock_location"]),
                'process_qty' => trim($_POST["process_qty"]),
                'conn' => trim($_POST["condition"]),
                'req_type' => trim($_POST["req_type"]),
                'req_priorty' => trim($_POST["req_priorty"]),
                'rec_mss' => trim($_POST["rec_mss"])
            );
            // // Save into part
            $this->ondemand_model->_table_name = "tbl_on_demand";
            $str = $this->ondemand_model->save($ondemandData);
            $LastInsertId = $this->db->insert_id();
             
            if(!empty($LastInsertId)){
                
                $req['serial_id'] = $LastInsertId;
                $req['serial_no'] = $_POST["partno"];
                $req['request_type'] = 'On-Demand';
                $req['title'] =  $_POST["disc"];
                $req_insert = $this->db->insert('tbl_request',$req);
                
                if($req_insert){
                    $email_template = email_templates(array('email_group' => 'new_part_request'));
                    $subject = $email_template->subject;
                    $message = $email_template->template_body;
                    
                    $projectName = str_replace("{PART_NAME}", $_POST["partno"], $message);
                    $Link = str_replace("{PROJECT_URL}", base_url() . 'admin/projects/',$projectName);
                    $message = str_replace("{SITE_NAME}", config_item('company_name'), $Link);
                    
                    $params['subject'] = $subject;
                    $params['message'] = $message;
                    $notifiedUsers = $this->items_model->allowed_user_id('57');
                    // $notifiedUsers = array("60");
                    
                    if (!empty($notifiedUsers)) {
                        foreach ($notifiedUsers as $users):
                            $login_info = $this->items_model->check_by(array('user_id' => $users), 'tbl_users');
                            $params['recipient'] = $login_info->email;
                            $send_mail = $this->items_model->send_email($params);
    
                            if ($users != $this->session->userdata('user_id')) {
                                add_notification(array(
                                    'to_user_id' => $users,
                                    'from_user_id' => true,
                                    'description' => 'not_changed_status',
                                    'link' => 'admin/projects',
                                    'value' => lang('request') . ' : New Part ' .  $_POST["partno"] . ' instock quantity is 0',
                                ));
                            }
                        endforeach;
                    }
                   
                  show_notification($notifiedUsers);
                }
            }

            $type = "success";
            $message = $_POST['partno']." Created Successfully!!";
            set_message($type, $message);
        }
        redirect('admin/on_demand');
    }
    
    public function update_ondemand($id = null)
    {        
        echo'<pre>';
        echo $id;
        echo '<br/>';
        if (!empty($id)) {
            $data = array( 
                'partno'   =>    trim($_POST['epartno']),
                'disc'    =>    trim($_POST['disc']),
                'size'   =>    trim($_POST['size']),
                'category'   =>    trim($_POST['category']),
                'stock_location'   =>    trim($_POST['stock_location']),
                'process_qty'  =>    trim($_POST['fixed_qty']),
                'conn' =>    trim($_POST['condition']),
                'req_type'  =>    trim($_POST['req_type']),
                'req_priorty'   =>   trim( $_POST['req_priorty']),
            );
            // print_r($data);die;
            $this->db->set($data);
            $this->db->where('id', $id);
            $up = $this->db->update('tbl_on_demand');
            if($up){
                $type = "success";
                $message = "Itme Updated successfully!!";
                set_message($type, $message);
            }else{
                $type = "danger";
                $message = "We have A technicale issue!!";
                set_message($type, $message);
            }

        }
        redirect('admin/On_demand');
    }
    
    public function delete_on_demand()
    {
        if (!empty($_GET["did"])) {
            $this->db->set('status', 1);
            $this->db->where('id', $_GET["did"]);
            $result = $this->db->update('tbl_on_demand');
            
            if($result){
                $type = "success";
                $message = "On Demand Item deleted successfully";
            }else{
                $type = "error";
                $message = "Sorry we have a technicale issue";
            }
        }else{
            $type = "error";
            $message = "Sorry we have a technicale issue";
        }
        set_message($type, $message);

        redirect('admin/on_demand');
    }

   
    
}
