<?php

/**
 * Description of problems
 *
 * @author Ashraf
 */
class Problems extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('problems_model');
    }

    public function index($id = NULL)
    { 
       // die;

        $data['title'] = lang('all') . ' ' . lang('Problems');
        //get all problems information
        $data['all_problems_info'] = $this->problems_model->get_permission('tbl_problems');

        $data['subview'] = $this->load->view('admin/problems/problems', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function new_problems($id = null)
    {
        $data['title'] = lang('new') . ' ' . lang('problems');
        if (!empty($id)) {
            $can_edit = $this->problems_model->can_action('tbl_problems', 'edit', array('id' => $id));

            $edited = can_action('172', 'edited');
            if (!empty($can_edit) || !empty($edited)) {
                $data['problems_info'] = $this->problems_model->get_all_problems_info($id);
            }
        }
        $data['assign_user'] = $this->problems_model->allowed_user('172');
        // get all employee info
        $data['subview'] = $this->load->view('admin/problems/new_problems', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data); //page load
    }

    public function problemsList()
    {
        if ($this->input->is_ajax_request()) {
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_problems';
        
            $custom_field = custom_form_table_search(15);
            $action_array = array('id');
            $main_column = array('sdi_no', 'unit', 'description', 'make_for', 'model_no', 'serial_no', 'year');
            $result = array_merge($main_column, $custom_field, $action_array);
            $this->datatables->column_order = $result;
            $this->datatables->column_search = $result;

            $this->datatables->order = array('id' => 'desc');
            $fetch_data = $this->datatables->get_datatable_permission();

            $edited = can_action('172', 'edited');
            $deleted = can_action('172', 'deleted');
            $data = array();
            foreach ($fetch_data as $_key => $v_problems) {
                $profile_info = $this->db->where('user_id', $v_problems->user_id)->get('tbl_account_details')->row();
                $can_edit = $this->problems_model->can_action('tbl_problems', 'edit', array('id' => $v_problems->id));
                $can_delete = $this->problems_model->can_action('tbl_problems', 'delete', array('id' => $v_problems->id));
                if (!empty($profile_info->fullname)) {
                    $name = $profile_info->fullname . (!empty($profile_info->employment_id) ? ' (' . $profile_info->employment_id . ')' : ' ');
                } else {
                    $name = '-';
                }

                $action = null;
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_problems->problem_name;
            
                if (!empty($can_edit) || !empty($edited)) {
                    $action .= '<a href="' . base_url() . 'admin/problems/new_problems/' . $v_problems->id . '"
                               class="btn btn-primary btn-xs" title="' . lang('edit') . '" data-toggle="modal"
                               data-target="#myModal_large"><span class="fa fa-pencil-square-o"></span></a>  ';
                }
                if (!empty($can_delete) || !empty($deleted)) {
                    $action .= ajax_anchor(base_url('admin/problems/delete_problems/' . $v_problems->id), "<i class='btn btn-xs btn-danger fasr fa fa-trash-o'></i>", array("class" => "", "title" => lang('delete'), "data-fade-out-on-success" => "#table_" . $v_problems->id)) . ' ';
                }
                $action .= btn_view_modal('admin/problems/problems_details/' . $v_problems->id) . ' ';

                $sub_array[] = $action;
                $data[] = $sub_array;
            }

            render_table($data);
        } else {
            redirect('admin/dashboard');
        }
    }

    public function save_problems($id = NULL)
    {
        $created = can_action('172', 'created');
        $edited = can_action('172', 'edited');
        if (!empty($created) || !empty($edited) && !empty($id)) {
            $data = $this->problems_model->array_from_post(array(
                'problem_name'
                ));
            $data['created_at'] = date("Y-m-d H:i:s");
            if (empty($id)) {
                $data['assigned_by'] = $this->session->userdata('user_id');
            }
            
           // print_r($data); die;
            //save data into table.
            $this->problems_model->_table_name = "tbl_problems"; // table name
            $this->problems_model->_primary_key = "id"; // $id
            $return_id = $this->problems_model->save($data, $id);
          
            save_custom_field(15, $return_id);
        
            // save into activities
            $activities = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'problems',
                'module_field_id' => $return_id,
                'activity' => $activity,
                'icon' => 'fa-suitcase',
                'link' => 'admin/problems/view_problems_details/' . $return_id,
                'value1' => $data['sdi_no'],
            );

            // Update into tbl_project
            $this->problems_model->_table_name = "tbl_activities"; //table name
            $this->problems_model->_primary_key = "activities_id";
            $this->problems_model->save($activities);


            $type = "success";
            $message = $msg;
            set_message($type, $message);
        }
        redirect('admin/problems');
    }

    public function view_problems_details($id = NULL)
    {
        $data['title'] = lang('problems_details');
        //get all problems information
        $data['problems_info'] = $this->problems_model->get_all_problems_info($id);

        $data['subview'] = $this->load->view('admin/problems/problems_detail', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function problems_details($id = NULL)
    {
        $data['title'] = lang('problems_details');
        //get all problems information
        $data['problems_info'] = $this->problems_model->get_all_problems_info($id);

        $data['subview'] = $this->load->view('admin/problems/problems_detail', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data);
    }

    public function delete_problems($id = NULL)
    {
        $deleted = can_action('172', 'deleted');
        $can_delete = $this->problems_model->can_action('tbl_problems', 'delete', array('id' => $id));
        if (!empty($can_delete) || !empty($deleted)) {

            $problems_info = $problems_info = $this->db->where('id', $id)->get('tbl_problems')->row();
            // save into activities
            $activities = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'problems',
                'module_field_id' => $id,
                'activity' => 'activity_delete_problems',
                'icon' => 'fa-suitcase',
                'value1' => $problems_info->problems_name,
            );

            // Update into tbl_project
            $this->problems_model->_table_name = "tbl_activities"; //table name
            $this->problems_model->_primary_key = "activities_id";
            $this->problems_model->save($activities);


            $this->problems_model->_table_name = "tbl_problems"; // table name
            $this->problems_model->_primary_key = "id"; // $id
            $this->problems_model->delete($id); // delete

            // messages for user
            $type = "success";
            $message = lang('problems_information_delete');
        } else {
            $type = "error";
            $message = 'Operation Field!';
        }
        set_message($type, $message);
       // redirect('admin/problems');
    }

    public function problems_pdf($id)
    {
        $data['problems_info'] = $this->problems_model->get_all_problems_info($id);

        $this->load->helper('dompdf');
        $view_file = $this->load->view('admin/problems/problems_pdf', $data, true);
        pdf_create($view_file, slug_it(lang('problems_details') . '- ' . $data['problems_info']->fullname));
    }

    public function download_file($id)
    {
        $this->load->helper('download');
        $file = $this->uri->segment(5);

        if ($id) {
            $down_data = file_get_contents('uploads/' . $file); // Read the file's contents
            force_download($file, $down_data);
        } else {
            $type = "error";
            $message = 'Operation Fieled !';
            set_message($type, $message);
            if (empty($_SERVER['HTTP_REFERER'])) {
                redirect('admin/problems');
            } else {
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
    }

}
