<?php

/**
 * Description of service
 *
 * @author Ashraf
 */
class Service extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('service_model');
    }

    public function index($id = NULL)
    {

        $data['title'] = lang('all') . ' ' . lang('Service');
        //get all service information
        $data['all_service_info'] = $this->service_model->get_permission('tbl_service');

        $data['subview'] = $this->load->view('admin/service/service', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function new_service($id = null)
    {
        $data['title'] = lang('new') . ' ' . lang('service');
        if (!empty($id)) {
            $can_edit = $this->service_model->can_action('tbl_service', 'edit', array('id' => $id));

            $edited = can_action('167', 'edited');
            if (!empty($can_edit) || !empty($edited)) {
                $data['service_info'] = $this->service_model->get_all_service_info($id);
            }
        }
        $data['assign_user'] = $this->service_model->allowed_user('167');
        // get all employee info
        $data['subview'] = $this->load->view('admin/service/new_service', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data); //page load
    }

    public function serviceList()
    {
        if ($this->input->is_ajax_request()) {
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_service';
        
            $custom_field = custom_form_table_search(15);
            $action_array = array('id');
            $main_column = array('sdi_no', 'unit', 'description', 'make_for', 'model_no', 'serial_no', 'year');
            $result = array_merge($main_column, $custom_field, $action_array);
            $this->datatables->column_order = $result;
            $this->datatables->column_search = $result;

            $this->datatables->order = array('id' => 'desc');
            $fetch_data = $this->datatables->get_datatable_permission();

            $edited = can_action('167', 'edited');
            $deleted = can_action('167', 'deleted');
            $data = array();
            foreach ($fetch_data as $_key => $v_service) {
                $profile_info = $this->db->where('user_id', $v_service->user_id)->get('tbl_account_details')->row();
                $can_edit = $this->service_model->can_action('tbl_service', 'edit', array('id' => $v_service->id));
                $can_delete = $this->service_model->can_action('tbl_service', 'delete', array('id' => $v_service->id));
                if (!empty($profile_info->fullname)) {
                    $name = $profile_info->fullname . (!empty($profile_info->employment_id) ? ' (' . $profile_info->employment_id . ')' : ' ');
                } else {
                    $name = '-';
                }

                $action = null;
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_service->unit_no;
                $sub_array[] = $v_service->sdi_no;
                $sub_array[] = $v_service->eqpt_model;
                $sub_array[] = $v_service->description;
                $sub_array[] = $v_service->manufacturing;
                $sub_array[] = $v_service->drawbar;
                $sub_array[] = $v_service->unit_s_n;
                $sub_array[] = $v_service->s_n;
                
             

                if (!empty($can_edit) || !empty($edited)) {
                    $action .= '<a href="' . base_url() . 'admin/service/new_service/' . $v_service->id . '"
                               class="btn btn-primary btn-xs" title="' . lang('edit') . '" data-toggle="modal"
                               data-target="#myModal_large"><span class="fa fa-pencil-square-o"></span></a>  ';
                }
                if (!empty($can_delete) || !empty($deleted)) {
                    $action .= ajax_anchor(base_url('admin/service/delete_service/' . $v_service->id), "<i class='btn btn-xs btn-danger fa fa-trash-o'></i>", array("class" => "", "title" => lang('delete'), "data-fade-out-on-success" => "#table_" . $_key)) . ' ';
                }
                $action .= btn_view_modal('admin/service/service_details/' . $v_service->id) . ' ';

                $sub_array[] = $action;
                $data[] = $sub_array;
            }

            render_table($data);
        } else {
            redirect('admin/dashboard');
        }
    }

    public function save_service($id = NULL)
    {
        $created = can_action('167', 'created');
        $edited = can_action('167', 'edited');
        if (!empty($created) || !empty($edited) && !empty($id)) {
            $data = $this->service_model->array_from_post(array(
                'unit_no',
                'sdi_no',
                'description',
                'manufacturing',
                'eqpt_model',
                'drawbar',
                'unit_s_n',
                'engine_model',
                's_n',
                'no_of_cylinder',
                'rpm',
                'hp',
                'trans_make_type',
                'trans_s_n',
                'transfer_case',
                'final_drive',
                'axel_and_wheel',
                'tyres',
                'brake_system',
                'steering_system',
                'ground_clearance',
                'hydraulic_system',
                'implements',
                'power_kva',
                'motor_type',
                'portability',
                'frequency',
                'application',
                'cooling_system',
                'battery_vol',
                'gvw',
                'dimenssion'
                ));
            $data['created_at'] = date("Y-m-d H:i:s");
            if (empty($id)) {
                $data['assigned_by'] = $this->session->userdata('user_id');
            }
            
           // print_r($data); die;
            //save data into table.
            $this->service_model->_table_name = "tbl_service"; // table name
            $this->service_model->_primary_key = "id"; // $id
            $return_id = $this->service_model->save($data, $id);
          
            save_custom_field(15, $return_id);
        
            // save into activities
            $activities = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'service',
                'module_field_id' => $return_id,
                'activity' => $activity,
                'icon' => 'fa-suitcase',
                'link' => 'admin/service/view_service_details/' . $return_id,
                'value1' => $data['sdi_no'],
            );

            // Update into tbl_project
            $this->service_model->_table_name = "tbl_activities"; //table name
            $this->service_model->_primary_key = "activities_id";
            $this->service_model->save($activities);


            $type = "success";
            $message = $msg;
            set_message($type, $message);
        }
        redirect('admin/service');
    }

    public function view_service_details($id = NULL)
    {
        $data['title'] = lang('service_details');
        //get all service information
        $data['service_info'] = $this->service_model->get_all_service_info($id);

        $data['subview'] = $this->load->view('admin/service/service_detail', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function service_details($id = NULL)
    {
        $data['title'] = lang('service_details');
        //get all service information
        $data['service_info'] = $this->service_model->get_all_service_info($id);

        $data['subview'] = $this->load->view('admin/service/service_detail', $data, FALSE);
        $this->load->view('admin/_layout_modal_lg', $data);
    }

    public function delete_service($id = NULL)
    {
        $deleted = can_action('167', 'deleted');
        $can_delete = $this->service_model->can_action('tbl_service', 'delete', array('id' => $id));
        if (!empty($can_delete) || !empty($deleted)) {

            $service_info = $service_info = $this->db->where('id', $id)->get('tbl_service')->row();
            // save into activities
            $activities = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'service',
                'module_field_id' => $id,
                'activity' => 'activity_delete_service',
                'icon' => 'fa-suitcase',
                'value1' => $service_info->service_name,
            );

            // Update into tbl_project
            $this->service_model->_table_name = "tbl_activities"; //table name
            $this->service_model->_primary_key = "activities_id";
            $this->service_model->save($activities);


            $this->service_model->_table_name = "tbl_service"; // table name
            $this->service_model->_primary_key = "id"; // $id
            $this->service_model->delete($id); // delete

            // messages for user
            $type = "success";
            $message = lang('service_information_delete');
        } else {
            $type = "error";
            $message = 'Operation Field!';
        }
        set_message($type, $message);
        redirect('admin/service');
    }

    public function service_pdf($id)
    {
        $data['service_info'] = $this->service_model->get_all_service_info($id);

        $this->load->helper('dompdf');
        $view_file = $this->load->view('admin/service/service_pdf', $data, true);
        pdf_create($view_file, slug_it(lang('service_details') . '- ' . $data['service_info']->fullname));
    }

    public function download_file($id)
    {
        $this->load->helper('download');
        $file = $this->uri->segment(5);

        if ($id) {
            $down_data = file_get_contents('uploads/' . $file); // Read the file's contents
            force_download($file, $down_data);
        } else {
            $type = "error";
            $message = 'Operation Fieled !';
            set_message($type, $message);
            if (empty($_SERVER['HTTP_REFERER'])) {
                redirect('admin/service');
            } else {
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
    }

}
