<?php

/**
 * Description of equipment
 *
 * @author Ashraf
 */
class Tool extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('tool_model');
        $this->load->model('equipment_model');
    }

    public function index($id = null)
    {
        //get all tool
        $data['all_tools'] = $this->tool_model->get_all_tools();
        $data['subview'] = $this->load->view('admin/tool/tool', $data, TRUE);
        
        $this->load->view('admin/_layout_main', $data);
    }

    public function toolList($type = "")
    {

        if ($this->input->is_ajax_request()) {
            $this->load->model('datatables');
            $this->datatables->table = 'tbl_used_tools';
        
            $custom_field = custom_form_table_search(15);
            $action_array = array('id');
            $main_column = array('id', 'name', 'status');
            $result = array_merge($main_column, $custom_field, $action_array);
            $this->datatables->column_order = $result;
            $this->datatables->column_search = $result;
            $this->datatables->order = array('id' => 'desc');
            
            $where  = array("status" , 0);
            $fetch_data = $this->datatables->get_datatable_permission('',$where);

            $edited = can_action('173', 'edited');
            $deleted = can_action('173', 'deleted');
            $data = array();
            foreach ($fetch_data as $_key => $v_tool) {
                $profile_info = $this->db->where('user_id', $v_tool->user_id)->get('tbl_account_details')->row();
                $can_edit = $this->equipment_model->can_action('tbl_equipment', 'edit', array('id' => $v_tool->id));
                $can_delete = $this->equipment_model->can_action('tbl_equipment', 'delete', array('id' => $v_tool->id));
                if (!empty($profile_info->fullname)) {
                    $name = $profile_info->fullname . (!empty($profile_info->employment_id) ? ' (' . $profile_info->employment_id . ')' : ' ');
                } else {
                    $name = '-';
                }

                $action = null;
                $sub_array = array();
                $sub_array[] = $_key + 1;
                $sub_array[] = $v_tool->part_no;
                $sub_array[] = $timeStamp = date( "jS M Y h:i A", strtotime($v_tool->created_at));
                $sub_array[] = $v_tool->name;
                
                ///my code 
                $sub_array[] = $v_tool->sizes;
                $sub_array[] = $v_tool->category;
                $sub_array[] = $v_tool->instock;
                $sub_array[] = $v_tool->stock_location;
                // $sub_array[] = $v_tool->min_stock;
                $sub_array[] = $v_tool->conn;
                $sub_array[] = $v_tool->req_type;
                $sub_array[] = $v_tool->req_priorty;
                if($v_tool->request_status == '1'){
                    $request_status = '<span style=" color:#fff;padding: 1px 2px; background-color: green;" >Accept</span> ';
                }elseif($v_tool->request_status == '2'){
                    $request_status = '<span  style=" color:#fff;padding: 1px 2px; background-color: #5d9cec;" >On Hold</span> ';
                }elseif($v_tool->request_status == '00'){
                    $request_status = '<span  style=" color: #fff;padding: 1px 2px; background-color: red;" >Reject</span> ';
                }elseif($v_tool->request_status == '11'){
                    $request_status = '<span  style=" color: #fff;padding: 1px 2px; background-color: #23b7e5;">Completed</span> ';
                }else{
                        $request_status = '';
                }
                $sub_array[] = $request_status;
                $sub_array[] = $v_tool->edd;
                if($v_part->project_status == '1' && $v_tool->request_status == '1'){
                    $mms = '<a onClick="DeliveryPopUpModel('."'$v_tool->id'".','."'$v_tool->project_no'".')" class = "DRMss" data-toggle="modal" data-target="#DRMms" >
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus" viewBox="0 0 16 16"> <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z"/> 
                                </svg>
                            </a>';
                     $sub_array[] = $mms;
                }
                else{
                    $sub_array[] = $v_tool->rec_mss;
                }
                
                //end my code
                
                if (!empty($can_edit) || !empty($edited)) {
                    $action .= '<a onClick="editPopUpModel('."'$v_tool->part_no'".', '."'$v_tool->name'".','."'$v_tool->id'".','."'$v_tool->sizes'".','."'$v_tool->category'".','."'$v_tool->instock'".','."'$v_tool->stock_location'".','."'$v_tool->conn'".','."'$v_tool->req_type'".','."'$v_tool->req_priorty'".','."'$v_tool->rec_mss'".');" href="' . base_url() . 'admin/tool/new_tool/' . $v_tool->id . '"
                                                        class="btn btn-primary btn-xs" title="' . lang('edit') . '" data-toggle="modal"
                                                        data-target="#myEditModal_large">
                                                        <span class="fa fa-pencil-square-o"></span>
                                                        </a>  ';
                }
                if (!empty($can_delete) || !empty($deleted)) {
                    // $action .= ajax_anchor(base_url('admin/tool/delete_tool?did='.$v_tool->id), '<i class="btn btn-xs btn-danger fa fa-trash-o"></i>', array("class" => "", "title" => lang('delete'), "data-fade-out-on-success" => "#table_" . $_key)) . ' ';
                    $action .= '<a onclick="return confirm('."'Are you sure you want to delete $v_tool->part_no ?'".');" class="btn btn-danger btn-xs"  href = "'.base_url('admin/tool/delete_tool?did='.$v_tool->id).'" style="padding: 0;"><i class="btn btn-xs btn-danger fa fa-trash-o"></i></a>';
                    
                }
                $action .= btn_view_modal('admin/tool/tool_details/' . $v_tool->id) . ' ';

                $sub_array[] = $action;
                $data[] = $sub_array;
            }
            render_table($data);
        } else {
            redirect('admin/dashboard');
        }
    }

    public function save_tools()
    { 
        if (!empty($_POST["name"])) {
            
            
         
            // save into tools
            $tools = array(
                'part_no' => $_POST["partno"],
                'name' => $_POST["name"],
                'sizes' => $_POST["size"],
                'category' => $_POST["category"],
                'instock' => $_POST["instock"],
                'stock_location' => $_POST["stock_location"],
                'conn' => $_POST["condition"],
                'req_type' => $_POST["req_type"],
                'req_priorty' => $_POST["req_priorty"],
                'rec_mss' => $_POST["rec_mss"]
            );
            // Save into tool
            $this->tool_model->_table_name = "tbl_used_tools";
            $var = $this->tool_model->save($tools);
            $LastInsertId = $this->db->insert_id();
             
            if(trim($_POST["instock"]) == 0){
                $req['serial_id'] = $LastInsertId;
                $req['serial_no'] = $_POST["partno"];
                $req['request_type'] = 'Tool';
                $req['min_stock'] = '';
                $req['instock'] = trim($_POST["instock"]);
                $req['title'] =  $_POST["name"];
                $req_insert = $this->db->insert('tbl_request',$req);
                
                 if($req_insert){
                    $email_template = email_templates(array('email_group' => 'new_part_request'));
                    $subject = $email_template->subject;
                    $message = $email_template->template_body;
                    
                    $projectName = str_replace("{PART_NAME}", $_POST["partno"], $message);
                    $tool = str_replace("Part", 'Tool', $projectName);
                    $Link = str_replace("{PROJECT_URL}", base_url() . 'admin/projects/',$tool);
                    $message = str_replace("{SITE_NAME}", config_item('company_name'), $Link);
                    
                    $params['subject'] = $subject;
                    $params['message'] = $message;
                    $notifiedUsers = $this->items_model->allowed_user_id('57');
                    // $notifiedUsers = array("60");
                    
                    if (!empty($notifiedUsers)) {
                        foreach ($notifiedUsers as $users):
                            $login_info = $this->items_model->check_by(array('user_id' => $users), 'tbl_users');
                            $params['recipient'] = $login_info->email;
                            $send_mail = $this->items_model->send_email($params);
    
                            if ($users != $this->session->userdata('user_id')) {
                                add_notification(array(
                                    'to_user_id' => $users,
                                    'from_user_id' => true,
                                    'description' => 'not_changed_status',
                                    'link' => 'admin/projects',
                                    'value' => lang('request') . ' : New Tool ' .  $_POST["partno"] . ' instock quantity is 0',
                                ));
                            }
                        endforeach;
                    }
                   
                   show_notification($notifiedUsers);
                }
            }
            
            

            $type = "success";
            $message = $msg;
            set_message($type, $message);
            
           
        }
       
        redirect('admin/tool');
    }

    public function update_tools()
    {
        
        if (!empty($_POST["toolId"]) && !empty($_POST["ename"])) {
            
            // Update into tool
             $tool_data = array(
                
                'part_no'   =>    $_POST['tool_no'] ,
                'name'    =>    $_POST['ename'] ,
                'sizes'   =>    $_POST['size'],
                'category'   =>    $_POST['category'] ,
                'instock' =>    $_POST['instock'],
                'stock_location'   =>    $_POST['stock_location'] ,
                'min_stock'  =>    $_POST['min_stock'] ,
                'conn' =>    $_POST['condition'] ,
                'req_type'  =>    $_POST['req_type'] ,
                'req_priorty'   =>    $_POST['req_priorty'] ,
                'rec_mss' =>    $_POST['rec_mss'] 
            );     
            $this->db->set($tool_data);
            $this->db->where('id', $_POST["toolId"]);
            $this->db->update('tbl_used_tools');

            $type = "success";
            $message = $msg;
            set_message($type, $message);
        }
        redirect('admin/tool');
    }

    public function delete_tool()
    {
        if (!empty($_GET["did"])) {
            
            // delete into tool
            $this->db->set('status', 1);
            $this->db->where('id', $_GET["did"]);
            $result = $this->db->update('tbl_used_tools');
            
            // $data = [
            //     $type => "success",
            //     $message => $msg
            // ];
            // echo json_encode($data);
            if($result){
                $type = "success";
                $message = 'Tool Deleted Successfully!!';
            }else{
                $type = "error";
                $message = "Sorry we have a technicale issue";
            }
        }else{
            $type = "error";
            $message = "Sorry we have a technicale issue";
        }
        set_message($type, $message);

        // if (empty($_SERVER['HTTP_REFERER'])) {
        //     redirect('forms/leads/' . $key);
        // } else {
        //     redirect($_SERVER['HTTP_REFERER']);
        // }
        redirect('admin/tool');
    }

}
