<?php

class Jobs_model extends MY_Model {

    public $_table_name;
    public $_order_by;
    public $_primary_key;

    public function get_all_jobs_info($id = NULL) {
        
        $this->db->from('tbl_jobs');
        $this->db->select('tbl_jobs.*,tbl_equipment.unit,tbl_client.name', FALSE);
        $this->db->join('tbl_client','tbl_jobs.company_name = tbl_client.client_id');
        $this->db->join('tbl_equipment','tbl_jobs.unit_no = tbl_equipment.id');
        if (!empty($id)) {
            $this->db->where('tbl_jobs.id', $id);
            $query_result = $this->db->get();
            $result = $query_result->row();
        } else {
              
            $query_result = $this->db->get();
            $result = $query_result->result();
        }
         
        return $result;
    }
    
    function rows_pagination()
    {
         $e=$this->db->select()
        ->from('tbl_jobs')
        ->get();
        return $e->num_rows();   
    }
    
    function heypagination($limit,$offset)
    {
    $e=$this->db->select()
    ->from('tbl_jobs')
    ->limit($limit,$offset)
    ->get();
    return $e->result_array();
    }

    public function get_all_equpment() {

        $this->db->select('tbl_equipment.*', FALSE);
        $this->db->from('tbl_equipment');
        $query_result = $this->db->get();
        $result = $query_result->result();   
        return $result;
    }

    public function get_all_client($id="") {

        $this->db->select('tbl_client.*', FALSE);
        $this->db->from('tbl_client');

        if (!empty($id)) {
            $this->db->where('tbl_client.client_id',$id);
            $query_result = $this->db->get();
            $result = $query_result->row();
        } else {
              
            $query_result = $this->db->get();
            $result = $query_result->result();
        }

        return $result;
    }

    public function get_all_problems($id="") {

        $this->db->select('tbl_problems.*', FALSE);
        $this->db->from('tbl_problems');

        if (!empty($id)) {
            $this->db->where('tbl_problems.id',$id);
            $query_result = $this->db->get();
            $result = $query_result->row();
        } else {
              
            $query_result = $this->db->get();
            $result = $query_result->result();
        }

        return $result;
    }

    public function get_all_completed_job($jobId="") {

        $this->db->select('tbl_jobs_done.*,tbl_account_details.employment_id', FALSE);
        $this->db->join('tbl_account_details','tbl_jobs_done.code = tbl_account_details.account_details_id');
        $this->db->from('tbl_jobs_done');

        if (!empty($jobId)) {
            $this->db->where('tbl_jobs_done.job_id',$jobId);
            $this->db->order_by("tbl_jobs_done.id", "asc");
            $query_result = $this->db->get();
            $result = $query_result->result();
        } else {
              
            $query_result = $this->db->get();
            $result = $query_result->result();
        }
        return $result;
    }

    public function get_job_details($jobId="") {

        $this->db->select('tbl_jobs.*', FALSE);
        $this->db->from('tbl_jobs');

        if (!empty($jobId)) {
            $this->db->where('tbl_jobs.id',$jobId);
            $this->db->order_by("tbl_jobs.id", "asc");
            $query_result = $this->db->get();
            $result = $query_result->row();
        } else {
              
            $query_result = $this->db->get();
            $result = $query_result->row();
        }
        return $result;
    }

    public function get_user_job_tools($jobId="") {

        $this->db->select('tbl_used_tools.id,tbl_used_tools.name', FALSE);
        $this->db->from('tbl_used_tools');
        $this->db->where('status',0);

        if (!empty($jobId)) {
            $this->db->order_by("tbl_used_tools.id", "asc");
            $query_result = $this->db->get();
            $result = $query_result->result();
        } else {
              
            $query_result = $this->db->get();
            $result = $query_result->result();
        }
        return $result;
    }

    public function get_all_accounts($jobId="") {

        $this->db->select('tbl_account_details.*', FALSE);
        $this->db->from('tbl_account_details');

        if (!empty($jobId)) {
            $this->db->order_by("tbl_account_details.id", "asc");
            $query_result = $this->db->get();
            $result = $query_result->result();
        } else {
              
            $query_result = $this->db->get();
            $result = $query_result->result();
        }
        return $result;
    }

    public function get_all_parts_invoice($jobId="") {

        $this->db->select('tbl_job_part_invoice.*', FALSE);
        $this->db->from('tbl_job_part_invoice');

        if (!empty($jobId)) {
            $this->db->where('tbl_job_part_invoice.job_id',$jobId);
            $query_result = $this->db->get();
            $result = $query_result->row();
        } else {
            $query_result = $this->db->get();
            $result = $query_result->result();
        }
        $result->data = $this->db->last_query();
        return $result;
    }

    public function get_all_parts_details_list_invoice($jobId="") {

        $this->db->from('tbl_job_part_invoice');
        $this->db->select('tbl_job_part_indetail.*', FALSE);
        $this->db->join('tbl_job_part_indetail','tbl_job_part_invoice.id = tbl_job_part_indetail.invoice');
        $this->db->where('tbl_job_part_invoice.job_id', $jobId);
        $this->db->order_by("tbl_job_part_indetail.id", "asc");
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;

    }
  public function get_all_parts() {

        $this->db->select('tbl_parts.*', FALSE);
        $this->db->from('tbl_parts');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;

    }

    public function get_sign($job_id="") {

        if (!empty($job_id)) {

             $this->db->where('id',$job_id);
             return  $this->db->update('tbl_jobs',array('file'=> ''));
           
        }

    

    }

    public function get_sign_ticket($job_id="") {

        if (!empty($job_id)) {

             $this->db->where('id',$job_id);
             return  $this->db->update('tbl_job_tickets',array('sign'=> ''));
           
        }

    

    }
    
    public function GetSingleByPartNO($partid){

        $this->db->select('id,partno,disc,instock,min_stock');
        $this->db->where('id',$partid);
        $this->db->limit(1);
        return $this->db->get('tbl_parts')->row_array();
    }
    
    public function UpdatePartsStocks($id,$instock){
        $this->db->set('instock', $instock);
        return $this->db->where('id',$id)->update('tbl_parts');   
    }

}
