<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?=$title;?></title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600;700&display=swap');

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            list-style: none;
            text-decoration: none;
            /*font-family: 'Poppins', sans-serif;*/
        }

        html {
            font-size: 75%;
        }

      
    </style>
</head>

<body style="font-family: 'Poppins', sans-serif;">
  <?php
    $paid_amount = $this->invoice_model->calculate_to('paid_amount', $invoice_info->invoices_id);
    $client_info = $this->invoice_model->check_by(array('client_id' => $invoice_info->client_id), 'tbl_client');
    if (!empty($client_info)) {
        $currency = $this->invoice_model->client_currency_symbol($invoice_info->client_id);
        $client_lang = $client_info->language;
    } else {
        $client_lang = 'english';
        $currency = $this->invoice_model->check_by(array('code' => config_item('default_currency')), 'tbl_currencies');
    }

    unset($this->lang->is_loaded[5]);
    $language_info = $this->lang->load('sales_lang', $client_lang, TRUE, FALSE, '', TRUE);
    $payment_status = $this->invoice_model->get_payment_status($invoice_info->invoices_id);

    $uri = $this->uri->segment(3);
    if ($uri == 'invoice_email') {
        $img = base_url() . config_item('invoice_logo');
    } else {
        $img = ROOTPATH . '/' . config_item('invoice_logo');
        $a = file_exists($img);
        if (empty($a)) {
            $img = base_url() . config_item('invoice_logo');
        }
        if (!file_exists($img)) {
            $img = ROOTPATH . '/' . 'uploads/default_logo.png';
        }
    }
    ?>
   <table style="width:100%;">
		<tr>
			<td style="width: 50%;">
			    <div style="width: 250px;">
			        
                    <img style="width: 100%;margin: 0px 50px;" src="https://npcosystem.com/uploads/logo/sss-logo.jpg">
			    </div>
            </td>
		</tr>
	</table>
   <table style="width: 100%;">
		<tr>
			<td >
			    <h2 style="background: #042b64;color: #fff;text-align: right;font-size: 30px;font-weight: 500;border-radius: 50px 0px 0 0;padding: 0px 18px;margin-right: 1px;">Tax Invoice</h2>	
			</td>
			<td >
			    <h2 style="background: #042b64;color: #fff;text-align: left;font-size: 30px;font-weight: 500;border-radius: 0px 50px 0 0;padding: 0px 18px;margin-left: 1px;">فاتورة ��يبية</h2>	
			</td>
		</tr>
	</table>

    <table style="width: 100%;">
        <tbody>
            <tr>
                <td>
                    <h2
                        style="background: #042b64;color: #fff; font-size: 18px;font-weight: 500;border-radius: 50px 50px 0 0; padding-left: 14px; padding-block: 20px; margin-block: 6px;">

                    </h2>
                </td>
            </tr>
        </tbody>
    </table>

    <table style="width: 100%;">
        <tbody>
            <tr>
                <td style="width: 50%;">
                    <table border="1" style="width: 100%;">
                        <thead>
                            <tr>
                                <th style="width: 20%; background-color: #042b64; color:white;">Invoice Number</th>
                                <th style="width: 60%;text-align:center;"><?= $invoice_info->reference_no ?></th>
                                <th style="width: 20%; background-color: #042b64; color:white;">رقم الفاتورة</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="width: 20%; background-color: #042b64; color:white;">Invoice issue Date</td>
                                <td style="width: 60%;text-align:center;"><?= strftime(config_item('date_format'), strtotime($invoice_info->invoice_date)); ?></td>
                                <td style="width: 20%; background-color: #042b64; color:white;">رقم الفاتورة</td>
                            </tr>
                            <tr>
                                <td style="width: 20%; background-color: #042b64; color:white;">Date and Supply</td>
                                <td style="width: 60%;text-align:center;"></td>
                                <td style="width: 20%; background-color: #042b64; color:white;">رقم الفاتورة</td>
                            </tr>
                            <tr>
                                <td style="width: 20%; background-color: #042b64; color:white;">Branch</td>
                                <td style="width: 60%;text-align:center;"></td>
                                <td style="width: 20%; background-color: #042b64; color:white;">رقم الفاتورة</td>
                            </tr>
                            <tr>
                                <td style="width: 20%; background-color: #042b64; color:white;">Due Date</td>
                                <td style="width: 60%;text-align:center;"><?= strftime(config_item('date_format'), strtotime($invoice_info->due_date)); ?></td>
                                <td style="width: 20%; background-color: #042b64; color:white;">تاريخ ا��ستحقاق </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
                <td style="width: 50%;">

                <td>
                    <div style="height: 100px; width: 100px; border: 4px solid #042b64;"></div>
                </td>

                </td>
            </tr>
        </tbody>
    </table>

    <table style="width: 100%;">
        <tbody>
            <tr>
                <td style="width: 50%;">
                    <table border="1" style="width: 100%;">
                        <thead>
                            <tr>
                                <th style="width: 20%; background-color: #042b64; color:white;">Supplier</th>
                                <th style="width: 60%;"></th>
                                <th style="width: 20%; background-color: #042b64; color:white;">رقم الفاتورة</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="width: 20%;">Name : </td>
                                <td style="width: 60%;"><?= (config_item('company_legal_name_' . $client_lang) ? config_item('company_legal_name_' . $client_lang) : config_item('company_legal_name')) ?></td>
                                <td style="width: 20%; ">رقم الفاتورة</td>
                            </tr>
                            <tr>
                                <td style="width: 20%; ">Bulding No :</td>
                                <td style="width: 60%;"><?= (config_item('company_address_' . $client_lang) ? config_item('company_address_' . $client_lang) : config_item('company_address')) ?></td>
                                <td style="width: 20%; color:white;">رقم الفاتورة</td>
                            </tr>
                            <tr>
                                <td style="width: 20%; ">City :</td>
                                <td style="width: 60%;"><?= (config_item('company_city_' . $client_lang) ? config_item('company_city_' . $client_lang) : config_item('company_city')) ?></td>
                                <td style="width: 20%; ">رقم الفاتورة</td>
                            </tr>
                            <tr>
                                <td style="width: 20%;">Country :</td>
                                <td style="width: 60%;"><?= (config_item('company_country_' . $client_lang) ? config_item('company_country_' . $client_lang) : config_item('company_country')) ?></td>
                                <td style="width: 20%;">تاريخ ا��ستحقاق </td>
                            </tr>
                            <tr>
                                <td style="width: 20%;">
                                    Postal Code :</td>
                                <td style="width: 60%;"><?= config_item('company_zip_code') ?></td>
                                <td style="width: 20%;">تاريخ ا��ستحقاق </td>
                            </tr>
                            <tr>
                                <td style="width: 20%;">Additional No :</td>
                                <td style="width: 60%;"></td>
                                <td style="width: 20%;">تاريخ ا��ستحقاق </td>
                            </tr>
                            <tr>
                                <td style="width: 20%;">VAT Number :</td>
                                <td style="width: 60%;"></td>
                                <td style="width: 20%;">تاريخ ا��ستحقاق </td>
                            </tr>
                            <tr>
                                <td style="width: 20%;">Other Buyer ID</td>
                                <td style="width: 60%;"></td>
                                <td style="width: 20%;">تاريخ ا��ستحقاق </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
        
                <td style="width: 50%;">
                    <table border="1" style="width: 100%;">
                         <?php
                            if (!empty($client_info)) {
                                $client_name = $client_info->name;
                                $address = $client_info->address;
                                $city = $client_info->city;
                                $zipcode = $client_info->zipcode;
                                $country = $client_info->country;
                                $phone = $client_info->phone;
                                $email = $client_info->email;
                            } else {
                                $client_name = '-';
                                $address = '-';
                                $city = '-';
                                $zipcode = '-';
                                $country = '-';
                                $phone = '-';
                                $email = '-';
                            }
                            ?>
                        <thead>
                            <tr>
                                <th style="width: 20%; background-color: #042b64; color:white;">Customer</th>
                                <th style="width: 60%;"></th>
                                <th style="width: 20%; background-color: #042b64; color:white;">رقم الفاتورة</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="width: 20%;">Name : </td>
                                <td style="width: 60%;"><?= $client_name ?></td>
                                <td style="width: 20%; ">رقم الفاتورة</td>
                            </tr>
                            <tr>
                                <td style="width: 20%; ">Bulding No :</td>
                                <td style="width: 60%;"><?= $address ?></td>
                                <td style="width: 20%; color:white;">رقم الفاتورة</td>
                            </tr>
                            <tr>
                                <td style="width: 20%; ">City :</td>
                                <td style="width: 60%;"><?= (!empty($city))?$city:'-'?></td>
                                <td style="width: 20%; ">رقم الفاتورة</td>
                            </tr>
                            <tr>
                                <td style="width: 20%;">Country :</td>
                                <td style="width: 60%;"><?= (!empty($country))?$country:'-' ?></td>
                                <td style="width: 20%;">تاريخ ا��ستحقاق </td>
                            </tr>
                            <tr>
                                <td style="width: 20%;">
                                    Postal Code :</td>
                                <td style="width: 60%;"><?= (!empty($zipcode))?$zipcode:'-' ?></td>
                                <td style="width: 20%;">تاريخ ا��ستحقاق </td>
                            </tr>
                            <tr>
                                <td style="width: 20%;">Additional No :</td>
                                <td style="width: 60%;"></td>
                                <td style="width: 20%;">تاريخ ا��ستحقاق </td>
                            </tr>
                            <tr>
                                <td style="width: 20%;">VAT Number :</td>
                                <td style="width: 60%;"></td>
                                <td style="width: 20%;">تاريخ ا��ستحقاق </td>
                            </tr>
                            <tr>
                                <td style="width: 20%;">Other Buyer ID</td>
                                <td style="width: 60%;"></td>
                                <td style="width: 20%;">تاريخ ا��ستحقاق </td>
                            </tr>
                        </tbody>
                    </table>
                </td>


            </tr>
        </tbody>
    </table>
    <?php if (!empty($invoice_jobs)) { ?>
     <table style="width: 100%; margin-top: 2rem;" border="1">
        <tbody style="">
            <tr>
                <td colspan ="3" style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:30%"></td>
                <td style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:10%">Price</td>
                <td style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:10%">Hours</td>
                <td style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:45%">(شامل��يبة القيمة المضافة) <br>Description</td>
                <td style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:5%">م<br>No</td>
            </tr>
        </tbody>
        <tbody>
            <?php $i = 1; foreach ($invoice_jobs as $job_key => $invoice_job) : ?>
                <tr>
                    <td colspan ="3" style="text-align: center; padding-block: 1.5rem;border: none;width:30%"></td>
                    <td style="text-align: center; padding-block: 1.5rem;width:10%"><?= $invoice_job->price; ?></td>
                    <td style="text-align: center; padding-block: 1.5rem;width:10%"><?= $invoice_job->hour; ?></td>
                    <td style="text-align: center; padding-block: 1.5rem;width:45%"><?= $invoice_job->jobticketno; ?></td>
                    <td style="text-align: center; padding-block: 1.5rem;width:50%"><?= $i++; ?></td>
                </tr>
            <?php endforeach; ?>


        </tbody>
    </table>
    <?php } ?>
    <table style="width: 100%; margin-top: 2rem;" border="1">
        <tbody style="">
            
            <tr>
                <td style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:10%">
                    المجموع<br>(شامل ��يبة القيمة المضافة) <br>Item Subtotal Incude VAT</td>
                <td style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:10%">
                    المجموع<br>(شامل ��يبة القيمة المضافة) <br>Tax Rate</td>

                <td style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:10%">
                    المجموع<br>(شامل ��يبة القيمة المضافة) <br>Discount</td>
                <td style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:10%">
                    المجموع<br>(شامل ��يبة القيمة المضافة) <br>Unite Price</td>
                <td style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:10%">
                    الكمية<br>Quantity</td>
                <td style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:45%">(شامل
                    ��يبة القيمة المضافة) <br>Description</td>
                <td style="background-color: #042b64; color: white; text-align: center; padding-block: 1rem;width:5%">م<br>No</td>
            </tr>
        </tbody>
        <tbody>
             <?php
            $invoice_items = $this->invoice_model->ordered_items_by_id($invoice_info->invoices_id);
            if (!empty($invoice_items)) :
                $i = 1;
                foreach ($invoice_items as $key => $v_item) :
                    
                    $item_name = $v_item->item_name ? $v_item->item_name : $v_item->item_desc;
                    $item_tax_name = json_decode($v_item->item_tax_name);
            ?>
            <tr>
                <td style="text-align: center; padding-block: 1.5rem;"><?= display_money($v_item->total_cost) ?></td>
                <td style="text-align: center; padding-block: 1.5rem;">
                    <?php
                        if (!empty($item_tax_name)) {
                            foreach ($item_tax_name as $v_tax_name) {
                                $i_tax_name = explode('|', $v_tax_name);
                                $tax_amount += $v_item->total_cost / 100 * $i_tax_name[1];
                                echo '<small class="pr-sm">' . $i_tax_name[0] . ' (' . $i_tax_name[1] . ' %)' . '</small>' . display_money($v_item->total_cost / 100 * $i_tax_name[1]) . ' <br>';
                            }
                        }
                        $total_cost += $v_item->total_cost;
                        $total_tax += $tax_amount;
                    ?>
                </td>
                <td style="text-align: center; padding-block: 1.5rem;"></td>
                <td style="text-align: center; padding-block: 1.5rem;"><?= display_money($v_item->unit_cost) ?></td>
                <td style="text-align: center; padding-block: 1.5rem;"><?= $v_item->quantity . '   ' . $v_item->unit ?></td>
                <td style="text-align: center; padding-block: 1.5rem;">
                    <h3 style="font-weight: 500;"><?= $item_name ?></h3>
                    <small><?= nl2br($v_item->item_desc) ?></small>
                </td>
                <td style="text-align: center; padding-block: 1.5rem;"><?= $i++; ?></td>
            </tr>
            <?php endforeach;
            endif; ?>
        </tbody>
    </table>


    <table style="width: 100%; margin-top: 2rem;" border="1 ">
        <tbody>
            <tr>
                <td style="width: 20%; background-color: #042b64; color: white; padding-block: 1rem;">Note</td>
                <td style="width: 60%;  padding-block: 1rem;"><?=($invoice_info->notes)?></td>
                <td style="width: 20%; background-color: #042b64; color: white; padding-block: 1rem;">م��حظات</td>
            </tr>
            <?php 
            $tax_info = json_decode($invoice_info->total_tax);
            $tax_total = 0;
            if (!empty($tax_info)) {
                $tax_name = $tax_info->tax_name;
                $total_tax = $tax_info->total_tax;
                if (!empty($tax_name)) {
                    foreach ($tax_name as $t_key => $v_tax_info) {
                        $tax = explode('|', $v_tax_info);
                        $tax_total += $total_tax[$t_key];
                }
                }
            } ?>
            <tr>
                <td style="width: 20%; background-color: #042b64; color: white; padding-block: 1rem;">Total (Excluding VAT)</td>
                <td style="width: 60%;  padding-block: 1rem;"></td>
                <td style="width: 20%; background-color: #042b64; color: white; padding-block: 1rem;">م��حظات</td>
            </tr>
            <tr>
                <td style="width: 20%; background-color: #042b64; color: white; padding-block: 1rem;">Total Taxable
                    Amount <br>
                    (excluding VAT )</td>
                <td style="width: 60%;  padding-block: 1rem;"><?= display_money($this->invoice_model->calculate_to('invoice_cost', $invoice_info->invoices_id)) ?></td>
                <td style="width: 20%; background-color: #042b64; color: white; padding-block: 1rem;">م��حظات</td>
            </tr>
            <tr>
                <td style="width: 20%; background-color: #042b64; color: white; padding-block: 1rem;">Value Added Tax (15%)</td>
                <td style="width: 60%;  padding-block: 1rem;"><?= display_money($tax_total); ?></td>
                <td style="width: 20%; background-color: #042b64; color: white; padding-block: 1rem;">م��حظات</td>
            </tr>
            <tr>
                <td style="width: 20%; background-color: #042b64; color: white; padding-block: 1rem;">Total Amount Due</td>
                <td style="width: 60%;  padding-block: 1rem;"><?= display_money($this->invoice_model->calculate_to('total', $invoice_info->invoices_id), $currency->symbol); ?></td>
                <td style="width: 20%; background-color: #042b64; color: white; padding-block: 1rem;">م��حظات</td>
            </tr>
        </tbody>
    </table>


    <table style="width: 100%; margin-top: 2rem;">
        <tbody>
            <td style="width: 50%;">
                <table style="width: 100%;">
                    <tr>
                        <p style="background-color: #042b64; color: white; font-size: 15px;text-align: center;padding: 2px;">
                           Bank Account Details
                        </p>
                    </tr>
                    <tr>
                        <td style="text-align: center;">Bank Name:</td>
                        <td style="text-align: center;">RIYAD BANK1</td>
                        <td style="text-align: center;">اسم البنك: </td>
                    </tr>
                    <tr>
                        <td style="text-align: center; background-color: rgba(189, 189, 189, 0.24);">Bank Account:</td>
                        <td style="text-align: center;  background-color: rgba(189, 189, 189, 0.24);">1010717609940</td>
                        <td style="text-align: center;  background-color: rgba(189, 189, 189, 0.24);">حساب البنك:
                        </td>
                    </tr>
                    <tr>
                        <td style="text-align: center;">IBAN SAR:</td>
                        <td style="text-align: center;">SA37 2000 0001 0107 1760 9940</td>
                        <td style="text-align: center;">رقم ا��يبان ر.س :
                        </td>
                    </tr>
                    <tr>
                        <td
                            style="text-align: center;  background-color: rgba(189, 189, 189, 0.24);  background-color: rgba(189, 189, 189, 0.24);">
                            IBAN USD:</td>
                        <td style="text-align: center;  background-color: rgba(189, 189, 189, 0.24);">
                            SA7120000002094743000440</td>
                        <td style="text-align: center;  background-color: rgba(189, 189, 189, 0.24);">رقم ا��يبان دو��ر
                            امريكي :
                        </td>
                    </tr>
                    <tr>
                        <td style="text-align: center;">Swift Code:</td>
                        <td style="text-align: center;">RIBLSARI</td>
                        <td style="text-align: center;">رمز ال��عة:</td>
                    </tr>
                    <tr>
                        <td style="text-align: center;  background-color: rgba(189, 189, 189, 0.24);">Bank Address:</td>
                        <td style="text-align: center;  background-color: rgba(189, 189, 189, 0.24);">Bank Al Riyad Al
                            Ageeg Branch # 246
                        </td>
                        <td style="text-align: center;  background-color: rgba(189, 189, 189, 0.24);">عنوان البنك:</td>
                    </tr>
                </table>
            </td>
            <td style="width: 50%;">


                <table style="width: 100%">
                    <tbody>
                        <tr>
                            <td style="padding-block: 1rem ; color: black; text-align: right; font-size: 12px;">
                                <div>Reciver:...............عنوان الب</div>
                            </td>
                          
                        </tr>
                        <tr>
                            <td style="padding-block: 1rem ; color: black; text-align: right; font-size: 12px;">
                                <div>Signature:...............عنوان الب</div>
                            </td>
                          
                        </tr>
                    </tbody>
                </table>
        </tbody>
    </table>

</body>

</html>