<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="keywords" content="marksheet, html, css">
		<meta name="description" content="A marksheet using HTML and CSS.">
		<meta name="author" content="Harsh Kapadia">

		<!-- CSS -->
		<style>
            @font-face {
    font-family: "Typewriter";
    src: url("../fonts/typewriter.woff2") format("woff2");
}

@font-face {
    font-family: "Old English";
    src: url("../fonts/oldEnglishFive.woff2") format("woff2");
}

*
{
	padding: 0;
	margin: 0;
	box-sizing: border-box;
}

body
{
	
	color: black;
	font-family: Typewriter, "Times New Roman", Times, serif;
	font-size: 17px;
}

/* #svg-background
{
	position: fixed;
	width: 100vw;
	height: 100vh;
	z-index: -1;
	background: url(../img/mu-text-watermark.svg);
} */

main
{
	display: flex;
	flex-direction: column;
}

#mu-logo
{
	height: 50px;
    width: 200px;
	position: absolute;
	left: 2%;
	top: 1%;
}

#mu-logo-watermark-wrapper
{
	display: grid;
	place-content: center;
	position: fixed;
	top: 0;
	left: 0;
	width: 100vw;
	height: 100vh;
}

#mu-logo-watermark
{
	opacity: 0.1;
	height: 40vh;
}

h1
{
	font-family: "Old English", "Times New Roman", Times, serif;
	font-weight: 100;
	font-size: 25px;
	padding: 0.5%;
}

h2
{
	font-family: "Times New Roman", Times, serif;
}

h1, h2
{
	color: black;
	display: flex;
	flex-direction: column;
	align-items: center;
}

.student-data
{
	padding-top: 2%;
	display: grid;
	width: 90%;
	margin: auto;
	grid-template-columns: max-content 1fr;
	column-gap: 1.5rem;
}

label
{
	color: black;
	font-family: "Times New Roman", Times, serif;
	font-size: 20px;
	padding: 0.5% 0;
}

.student-data > label
{
	position: relative;
}

.student-data > label::after
{
	content: ":";
	position: absolute;
	right: -15px;
}

.student-data > div
{
	line-height: 1.5em;
}

section
{
	padding-top: 2%;
}

table
{
	border-collapse: collapse;
	width: 100%;
}

th
{
	font-family: "Times New Roman", Times, serif;
}

td, th
{
	border: solid black 2px;
}

td, th
{
	padding: 0.5% 0.5%;
}

th
{
	color: black;
}

.no-bottom-top-border
{
	border-bottom: none;
	border-top: none;
}

.no-right-border
{
	border-right: none;
}

.no-left-border
{
	border-left: none;
}

#total-row
{
	text-align: right;
	color: black;
	font-size: 20px;
	font-weight: bold;
}

.serif-fonts
{
	font-family: "Times New Roman", Times, serif;
}

.end-section
{
	display: flex;
	flex-direction: column;
}

.end-section-data
{
	display: flex;
}

.end-data-set
{
	display: flex;
	align-items: baseline;
	padding: 0.3% 0.5%;
	flex: 0.33;
}

.salutation-outer
{
	padding: 2% 1%;
	display: flex;
	justify-content: flex-end;
}

.salutation-inner
{
	color: black;
	font-family: "Times New Roman", Times, serif;
	font-style: italic;
	font-size: 20px;
	font-weight: bold;
	text-align: center;
}

/* =========================== GITHUB CORNER STYLES ========================== */

.github-corner:hover .octo-arm {
	animation: octocat-wave 560ms ease-in-out
}

@keyframes octocat-wave {

	0%,
	100% {
		transform: rotate(0)
	}

	20%,
	60% {
		transform: rotate(-25deg)
	}

	40%,
	80% {
		transform: rotate(10deg)
	}
}

@media (max-width:500px) {
	.github-corner:hover .octo-arm {
		animation: none
	}

	.github-corner .octo-arm {
		animation: octocat-wave 560ms ease-in-out
	}
}
        </style>

		<!-- Favicon -->
		<link rel="shortcut icon" href="./static/img/favicon.ico" type="image/x-icon">

		<title>Harsh Kapadia's Marksheet</title>
	</head>

	<body>
		
		<img id="mu-logo" src="logo.png" alt="MU">
		<div id="svg-background">
			<div id="mu-logo-watermark-wrapper">
				<img id="mu-logo-watermark" src="logo.png" alt="">
			</div>
		</div>
		
		<main>
			<h1></h1>
			<div class="student-data">
			</div>
		</main>
		<section style="margin-top: 30px;">
			<table>
				<tr>
					<td rowspan="3" width="30%" style="text-align: left;">Date:</td>
					<td rowspan="3"  width="40%" style="border-top: unset;">Job Ticket</td>
					<td rowspan="3" width="30%" style="text-align: left;">Invoice no:</td>
				</tr>
			</table>
            <table >
				<tr >
					<td rowspan="3" width="100%" style="text-align: left;border-top: unset;">Charges Payable:</td>
				</tr>
			</table>
            <table >
				<tr >
					<td rowspan="3" width="100%" style="text-align: left;border-top: unset;">Local Agent:</td>
				</tr>
			</table>
            <table >
				<tr >
					<td rowspan="3" width="100%" style="text-align: left;border-top: unset;">Address</td>
				</tr>
			</table>
            <table>
				<tr>
					<td rowspan="3" width="30%" style="text-align: left;border-top: unset;">ACFT REG:</td>
					<td rowspan="3"  width="40%" style="border-top: unset;"></td>
					<td rowspan="3" width="30%" style="text-align: left;border-top: unset;"></td>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="30%" height="60px" style="text-align: left;border-top: unset;">
                        Owner/Auth.Rep.Signature:
                    </td>
					<td rowspan="3"  width="40%" height="60px" style="border-top: unset;">
                        Name:
                    </td>
					<td rowspan="3" width="30%" height="60px" style="text-align: left;border-top: unset;">
                        Title:
                    </td>
				</tr>
			</table>
            <table>
				<tr>
					<th rowspan="3" width="75%" style="text-align: left;border-top: unset;">Type Of Service Provided:</th>
					<th rowspan="3"  width="25%" style="border-top: unset;"></th>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="75%" style="text-align: left;border-top: unset;">Compleat Ground Handling:</td>
					<td rowspan="3"  width="25%" style="border-top: unset;"></td>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="75%" style="text-align: left;border-top: unset;">Ground Power Unit:</td>
					<td rowspan="3"  width="25%" style="border-top: unset;"></td>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="75%" style="text-align: left;border-top: unset;">Air Start,Per Start,(No.Of Start)</td>
					<td rowspan="3"  width="25%" style="border-top: unset;"></td>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="75%" style="text-align: left;border-top: unset;">Passanger Stairs:</td>
					<td rowspan="3"  width="25%" style="border-top: unset;"></td>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="75%" style="text-align: left;border-top: unset;">Towing/Jacking/Fuelling:</td>
					<td rowspan="3"  width="25%" style="border-top: unset;"></td>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="75%" style="text-align: left;border-top: unset;">Facilities & Ground Equipment Maint:</td>
					<td rowspan="3"  width="25%" style="border-top: unset;"></td>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="75%" style="text-align: left;border-top: unset;">Other Service/Repair Equired:</td>
					<td rowspan="3"  width="25%" style="border-top: unset;"></td>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="75%" height="35px" style="text-align: left;border-top: unset;"></td>
					<td rowspan="3"  width="25%" style="border-top: unset;"></td>
				</tr>
            </table>
            <table>
                <tbody>
                    <tr>
                        <td colspan="10" height="35px" width="80%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="3" height="35px" rowspan="5" width="20%" style="text-align: left;border-top: unset;"></td>
                    </tr>
                    <tr> 
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;">Manpower</td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;">Rate Per Hour</td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;">Hours Used</td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;">Cost Center</td>
                    </tr>
                    <tr> 
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                    </tr>
                    <tr> 
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                    </tr>
                    <tr> 
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="20%" style="text-align: left;border-top: unset;"></td>
                    </tr>
                </tbody>
            </table>
            <table>
                <tbody>
                    <tr> 
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;">Material Used P/N</td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;">Discription</td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;">Quantity</td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;">Unit</td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;">Unit Price</td>
                        <td colspan="3" height="35px" rowspan="5" width="20%" style="text-align: left;border-top: unset;"></td>
                    </tr>
                    <tr> 
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;"></td>
                    </tr>
                    <tr> 
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;"></td>
                        <td colspan="2" height="35px" width="16%" style="text-align: left;border-top: unset;"></td>
                    </tr>
                </tbody>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="80%" height="35px" style="text-align: left;border-top: unset;"></td>
					<td rowspan="3"  width="20%" style="border-top: unset;"></td>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="80%" height="35px" style="text-align: left;border-top: unset;">Handling Fee:</td>
					<td rowspan="3"  width="25%" style="border-top: unset;"></td>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="80%" height="35px" style="text-align: left;border-top: unset;">Total Charges:</td>
					<td rowspan="3"  width="20%" style="border-top: unset;"></td>
				</tr>
            </table>
            <table>
				<tr>
					<td rowspan="3" width="30%" height="60px" style="text-align: left;border-top: unset;">Auth Npco Rep:</td>
					<td rowspan="3"  width="20%" height="60px" style="border-top: unset;">PRN</td>
                    <td rowspan="3" width="20%" height="60px" style="text-align: left;border-top: unset;">CC:</td>
					<td rowspan="3"  width="30%" height="60px" style="border-top: unset;">Station</td>
				</tr>
            </table>
		</section>

		<section class="end-section">
			<div class="end-section-data">
				<div class="end-data-set">
					<label for="remark">Remark :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</label>
					<div id="remark">Successful</div>
				</div>
	
				<div class="end-data-set">
					<label for="sgpi">SGPI :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</label>
					<div id="sgpi">8.04</div>
				</div>
	
				<div class="end-data-set">
					<label for="cgpi">CGPI :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</label>
					<div id="cgpi"></div>
				</div>
			</div>
	
			<div class="end-data-set">
				<label for="result-date">Result Declared on :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</label>
				<div id="result-date">MARCH 11, 2019</div>
			</div>
			
			<div class="salutation-outer">
				<div class="salutation-inner">
					<div>DIRECTOR</div>
					<div>BOARD OF EXAMINATIONS & EVALUATION</div>
				</div>
			</div>
		</section>
	</body>
</html>