<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?=$title;?></title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600;700&display=swap');

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            list-style: none;
            text-decoration: none;
        }

        html {
            font-size: 60%;
        }

      
    </style>
</head>

<body style="font-family: 'Poppins', sans-serif;">
<?php
$client_id = null;
if ($proposals_info->module == 'client') {
    $client_info = $this->proposal_model->check_by(array('client_id' => $proposals_info->module_id), 'tbl_client');
    $currency = $this->proposal_model->client_currency_symbol($proposals_info->module_id);
    $client_lang = $client_info->language;
    $client_id = $proposals_info->module_id;
} else if ($proposals_info->module == 'leads') {
    $client_info = $this->proposal_model->check_by(array('leads_id' => $proposals_info->module_id), 'tbl_leads');
    if (!empty($client_info)) {
        $client_info->name = $client_info->lead_name;
        $client_info->zipcode = null;
    }
    $client_lang = 'english';
    $currency = $this->proposal_model->check_by(array('code' => config_item('default_currency')), 'tbl_currencies');
} else {
    $client_lang = 'english';
    $currency = $this->proposal_model->check_by(array('code' => config_item('default_currency')), 'tbl_currencies');
}
unset($this->lang->is_loaded[5]);
$language_info = $this->lang->load('sales_lang', $client_lang, TRUE, FALSE, '', TRUE);
$img = ROOTPATH . '/' . config_item('invoice_logo');
$a = file_exists($img);
if (empty($a)) {
    $img = base_url() . config_item('invoice_logo');
}
if (!file_exists($img)) {
    $img = ROOTPATH . '/' . 'uploads/default_logo.png';
}

if(!empty($proposals_info->user_id)):
     $InvoceToemail = $this->db->select('email')->where('user_id', $proposals_info->user_id)->get('tbl_users')->row();
else:
    $InvoceToemail = null;
endif;
?>

   <table style="width:100%;">
		<tr>
			<td style="width: 50%;">
			    <div style="width:180px;">
			        
                    <img style="width: 100%;margin: 0px 50px;" src="https://npcosystem.com/uploads/logo/sss-logo.jpg">
			    </div>
            </td>
		</tr>
	</table>
   <table style="width: 100%;">
			<tr>
				<td >
				    <h2 style="background: #042b64;color: #fff;text-align: center;font-size: 24px;font-weight: 500;border-radius: 50px 50px 0 0;">Quotations</h2>	
				</td>
			</tr>
	</table>


   <table style="width: 100%;">
			<tr>
				<td style="width: 50%">
					<div style="padding-left: 5px">
						<h3 style="margin: 0px">NATIONAL PLEDGES COMMERCIAL COMPANY</h3>
						<div>
							Al Olaya District, Al-Bahrain Tower, 6th Floor Building No. 8953
							<br/>
							Riyadh 12214 - 2393 - King Fahd Road Kingdom of Saudi Arabia
						</div>
						<div>Phone #: +966 11 211 3333</div>
						<div>Fax #: +966 11 463 4000</div>
						<div>0112113333</div>
						<div><a style="text-decoration: none;color: #042b64;" href="www.npco.sa"> Website: www.npco.sa</a></div>
						<div></div>
					</div>
				</td>
				<td style="width: 50%;">
				   <table  style="width: 100%;padding-left:50px;">
					    <tr style="width: 30%;">
							<td style="border: 1px solid black;width: 30%;font-size: 12px;font-weight: 600;"><?= $language_info['proposals'] ?>:</td>
							<td style="border: 1px solid black;font-size: 12px;font-weight: 600;"><?= $proposals_info->reference_no ?></td>
						</tr>
						<tr style="width: 30%;">
							<td style="border: 1px solid black;width: 30%;"><?=lang('date');?>:</td>
							<td style="border: 1px solid black"><?= strftime(config_item('date_format'), strtotime($proposals_info->proposal_date)); ?></td>
						</tr>
						<tr style="width: 30%;">
							<td style="border: 1px solid black;width: 30%;"><?=lang('Due').' '.lang('date');?>:</td>
							<td style="border: 1px solid black"><?= strftime(config_item('date_format'), strtotime($proposals_info->due_date)); ?></td>
						</tr>
						

						
						<tr style="width: 30%;">
							<td style="border: 1px solid black;width: 30%;"><?= lang('proposals').'  '.lang('status') ?>:</td>
							<td style="border: 1px solid black"><?= lang($proposals_info->status) ?></div>
                                <?php $show_custom_fields = custom_form_label(10, $proposals_info->proposals_id);
                                if (!empty($show_custom_fields)) {
                                    foreach ($show_custom_fields as $c_label => $v_fields) {
                                        if (!empty($v_fields)) {
                                            ?>
                                            <div><?= $c_label ?>: <?= $v_fields ?></div>
                                        <?php }
                                    }
                                }
                                ?>
                            </td>
						</tr>
				   </table>
				</td>
			</tr>
		</table>


    <table style="width: 100%;">
			<tbody>
				<tr>
					<th style="width: 50%;text-align: initial;background: #042b64;color: #fff;padding: 5px;margin: 5px;">
						INVOICE TO
					</th>
					<th style="width: 50%;text-align: initial;background: #042b64;color: #fff;padding: 5px;margin: 5px;">
						VENDOR
					</th>
				</tr>
				<tr>
				    <td style="width:50%">
				        <table>
				        <tr>
				            <td style="width:25%">Company:</td>
                            <td style="width:75%"><?= config_item('company_legal_name') ?></td>
				        </tr>
				        <tr>
				            <td style="width:25%">Address:</td>
				            <td style="width:75%"><?= config_item('company_address') ?>  <?= config_item('company_zip_code') ?> , <?= config_item('company_country') ?></td>
				        </tr>
				        <tr>
				            <td style="width:25%">Email:</td>
				            <td style="width:75%"><a style="text-decoration: none;color: #042b64;" href="mailto:<?=(!empty($InvoceToemail))?$InvoceToemail->email:'#';?>"><?=(!empty($InvoceToemail))?$InvoceToemail->email:'#';?></a></td>
				        </tr>
				        <tr>
				            <td style="width:25%">Phone:</td>
				            <td style="width:75%"><?= config_item('company_phone') ?></td>
				        </tr>
				    </table>
				    </td>
				    <td style="width:50%">
				         <table>
				           <?php
                            if (!empty($client_info)) {
                                $client_name = $client_info->name;
                                $address = $client_info->address;
                                $city = $client_info->city;
                                $zipcode = $client_info->zipcode;
                                $country = $client_info->country;
                                $phone = $client_info->phone;
                                $email = $client_info->email;
                            } else {
                                $client_name = '-';
                                $address = '-';
                                $city = '-';
                                $zipcode = '-';
                                $country = '-';
                                $phone = '-';
                                $email = '-';
                            }
                            ?>
    				        <tr>
    				            <td style="width:25%">Company:</td>
    				            <td style="width:75%"><?= $client_name ?></td>
    				        </tr>
    				        <tr>
    				            <td style="width:25%">Address:</td>
    				            <td style="width:75%">
    				                <p><?= $address ?></p>
    				                <p><?php (!empty($city))?$city.', ':'';
    				                    (!empty($zipcode))?$zipcode.', ':'';
    				                    echo $country; 
    				                    ?>
    				                </p>
    				            </td>
    				        </tr>
    				        <tr>
    				            <td style="width:25%">Contact:</td>
    				            <td style="width:75%"><?= (!empty($phone))?$phone:'-';?></td>
    				        </tr>
    				        <tr>
    				            <td style="width:25%">Email:</td>
    				            <td style="width:75%"><a style="text-decoration: none;color: #042b64;font-weight:600" href="mailto:<?= $email ?>"><?= $email ?></a></td>
    				        </tr>
    				        <tr>
    				            <td style="width:25%">Phone:</td>
    				            <td style="width:75%"><?= (!empty($phone))?$phone:'-';?></td>
    				        </tr>
    				        <?php if (!empty($client_info->vat)) : ?>
        				        <tr>
        				            <td style="width:25%"><?= lang('vat_number') ?>:</td>
        				            <td style="width:75%"><?= $client_info->vat ?></td>
        				        </tr>
                            <?php endif; ?>
    				    </table>
				    </td>
				</tr>
				
			</tbody>
		</table>
	

    <table  style="width: 100%;margin-top: 20px;border: none;border-collapse: collapse;" border="1">
            <thead style="background: #042b64;color: #fff;border: none;">
                <tr>
                    <th style="width:4%;">S.No.#</th>
                    <th style="width: 60%;"><?= lang('item').' '.lang('description') ?></th>   
                    <th style="width: 7%;"><?= lang('qty') ?></th>
                    <th style="width: 7%;"><?=lang('price') ?></th>
                    <th style="width: 10%;"><?= lang('tax') ?></th>
                    <th><?= lang('total') ?></th>
                </tr>
            </thead>
            <tbody>
            <?php
                $invoice_items = $this->proposal_model->ordered_items_by_id($proposals_info->proposals_id);
            
                if (!empty($invoice_items)) :
                    $Sn = 1;
                    foreach ($invoice_items as $key => $v_item) :
                        $item_name = $v_item->item_name ? $v_item->item_name : $v_item->item_desc;
                        $item_tax_name = json_decode($v_item->item_tax_name);
                        ?>
                        <tr>
                            <td style="text-align:center"><?=$Sn++;?></td>
                            <td><p style="font-weight: 600;color: #042b64;margin:0"><?= $item_name ?></p><?= nl2br($v_item->item_desc) ?></td>
                            <td><?= $v_item->quantity.' '. $v_item->unit ?></td>
                            <td><?= display_money($v_item->unit_cost) ?></td>
                            <td>
                                <?php
                                    if (!empty($item_tax_name)):
                                        foreach ($item_tax_name as $v_tax_name) :
                                            $i_tax_name = explode('|', $v_tax_name);
                                            echo '<small class="pr-sm">' . $i_tax_name[0] . ' (' . $i_tax_name[1] . ' %)' . '</small>' . display_money($v_item->total_cost / 100 * $i_tax_name[1]) . ' <br>';
                                        endforeach;
                                    endif;
                                ?>
                            </td>
                            <td><?= display_money($v_item->total_cost) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif ?>
          


              
                <tr>
                    <td colspan="4" style="border: none;"></td>
                    <td style="background-color:#21315D ; color: white;"><?= $language_info['sub_total'] ?></td>
                    <td><?= display_money($this->proposal_model->proposal_calculation('proposal_cost', $proposals_info->proposals_id)) ?></td>
                </tr>
                <?php if ($proposals_info->discount_total > 0): ?>
                    <tr>
                        <td colspan="4" style="border: none;"></td>
                        <td style="background-color:#21315D ; color: white;"><?= $language_info['discount'] ?>(<?php echo $proposals_info->discount_percent; ?>%)</td>
                        <td ><?= display_money($this->proposal_model->proposal_calculation('discount', $proposals_info->proposals_id)) ?></td>
                    </tr>
                <?php endif;
                $tax_info = json_decode($proposals_info->total_tax);
                $tax_total = 0;
                if (!empty($tax_info)) {
                    $tax_name = $tax_info->tax_name;
                    $total_tax = $tax_info->total_tax;
                    if (!empty($tax_name)) {
                        foreach ($tax_name as $t_key => $v_tax_info) :
                            $tax = explode('|', $v_tax_info);
                            $tax_total += $total_tax[$t_key];
                            ?>
                            <tr>
                                <td colspan="4" style="border: none;"></td>
                                <td style="background-color:#21315D ; color: white;"><?= $tax[0] . ' (' . $tax[1] . ' %)' ?></td>
                                <td><?= display_money($total_tax[$t_key]); ?></td>
                            </tr>
                        <?php endforeach;
                    }
                } 
                if ($tax_total > 0): ?>
                    <tr >
                        <td colspan="4" style="border: none;"></td>
                        <td style="background-color:#21315D ; color: white;"><?= $language_info['total'] . ' ' . $language_info['tax'] ?></td>
                        <td><?= display_money($tax_total); ?></td>
                    </tr>
                <?php endif; 
                if ($proposals_info->adjustment > 0): ?>
                    <tr>
                        <td colspan="4" style="border: none;"></td>
                        <td style="background-color:#21315D ; color: white;"><?= $language_info['adjustment'] ?></td>
                        <td><?= display_money($proposals_info->adjustment); ?></td>
                    </tr>
                <?php endif ?>
                <tr>
                    <td colspan="4" style="border: none;"></td>
                    <td style="background-color:#21315D ; color: white;">Net <?= $language_info['total'] ?></td>
                    <td>
                        <?php
                            $proposal_total = $this->proposal_model->proposal_calculation('total', $proposals_info->proposals_id);
                            echo display_money($proposal_total, 'SAR'); 
                        ?>
                    </td>
                </tr>
                
               
            </tbody>
        </table>

    <table style="width: 100%;margin-top: 10px;">
        <tr>
            <td>
             <div><?= ($proposals_info->notes) ?></div>
            </td>
            <td style="width:50%;font-weight: 600;">
                <table style="width: 100%;">
                    <tr style="font-size:15px;">
                        <th><p style="text-align: end;padding-left: 100px;">AUTHORIZED SIGNATORY</p</th>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <table style="width: 100%;margin-top: 40px;font-weight: 600;">
        <tr>
            <td style="text-align: center;font-size:11px">
                If you have any questions about this Proposals, please contact
            </td>
        </tr>
        <tr>
            <td style="text-align: center;font-size:11px">
                [<?=(!empty($proposals_info->user_id))?'Name: '.fullname($proposals_info->user_id).', ':''; ?>
                Phone # +966 50 569 2222, E-mail: <a style="text-decoration: none;color: #042b64;" href="mailto:<?=(!empty($InvoceToemail))?$InvoceToemail->email:'#';?>"><?=(!empty($InvoceToemail))?$InvoceToemail->email:'#';?></a> ]
            </td>
	    </tr>
    </table>
   


</body>

</html>