#
# TABLE STRUCTURE FOR: installer
#

DROP TABLE IF EXISTS `installer`;

CREATE TABLE `installer` (
  `id` int(1) NOT NULL,
  `installer_flag` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `installer` (`id`, `installer_flag`) VALUES (1, 1);


#
# TABLE STRUCTURE FOR: tbl_account_details
#

DROP TABLE IF EXISTS `tbl_account_details`;

CREATE TABLE `tbl_account_details` (
  `account_details_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `fullname` varchar(160) COLLATE utf8_unicode_ci DEFAULT NULL,
  `employment_id` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `locale` varchar(100) COLLATE utf8_unicode_ci DEFAULT 'en_US',
  `address` varchar(64) COLLATE utf8_unicode_ci DEFAULT '-',
  `phone` varchar(32) COLLATE utf8_unicode_ci DEFAULT '-',
  `mobile` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `skype` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `language` varchar(40) COLLATE utf8_unicode_ci DEFAULT 'english',
  `designations_id` int(11) DEFAULT 0,
  `avatar` varchar(200) COLLATE utf8_unicode_ci DEFAULT 'uploads/default_avatar.jpg',
  `joining_date` date DEFAULT NULL,
  `present_address` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `gender` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `maratial_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `father_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mother_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `passport` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `direction` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`account_details_id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT;

INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('3', 3, 'NPCO', 'NP439', NULL, NULL, NULL, 'en_US', '-', '-', '', '', 'english', 0, 'uploads/android-icon-192x192.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('6', 6, 'Syed Rameez', 'NP139', '0', NULL, NULL, 'en_IN', '-', '0570367290', '', '', 'english', 5, 'uploads/87261719_10213331474436137_1853834994510725120_n.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('7', 7, 'Abdul Wahab Alamer', 'NP105', '0', NULL, NULL, 'ar_SA', '-', '', '', '', 'english', 6, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('10', 10, 'KKIA', 'NP0001', '0', NULL, NULL, 'en_US', '-', '', '', '', 'english', 24, 'uploads/IMG_20220824_153844.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('17', 17, 'Jabir Ali', 'NP119', '0', NULL, NULL, 'en_US', '-', '', '', '', 'english', 12, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('18', 18, 'Ahmad  Abd Eltawwab ', 'NP111', '0', NULL, NULL, 'ar_EG', '-', '0112113333', '0535292464', '', 'english', 13, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('19', 19, 'Omar  Al-Harbi', 'NP106', '0', NULL, NULL, 'ar_SA', '-', '0112113333', '0544363338', '', 'english', 14, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('20', 20, 'MARK Gil Iriarte', 'NP115', '0', NULL, NULL, 'fil_PH', '-', '', '966545629045 ', '', 'english', 15, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('21', 21, 'JOEL Lumaad', 'NP116', '0', NULL, NULL, 'en_PH', '-', '', '966592551770 ', '', 'english', 15, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('22', 22, 'Wilfredo Del Cruz', 'NP131', '0', NULL, NULL, 'fil_PH', '-', '', '966508180934 ', '', 'english', 16, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('23', 23, 'Jogen  Maginay', 'NP134', '0', NULL, NULL, 'fil_PH', '-', '', '966549665742 ', '', 'english', 17, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('24', 24, 'Samih  Fadul', 'NP135', '0', NULL, NULL, 'ar_SD', '-', '', '966553505839 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('25', 25, 'Samieh  Fadul', 'NP136', '0', NULL, NULL, 'ar_SD', '-', '', '966509696692 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('26', 26, 'Turki Al-Maliki', 'NP143', '0', NULL, NULL, 'ar_SA', '-', '', '966565779766 ', '', 'english', 18, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('27', 27, 'Mohammad Ahsan', 'NP144', '0', NULL, NULL, 'bn_BD', '-', '', '966503122896 ', '', 'english', 19, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('28', 28, 'Mohamed Allal', 'NP147', '0', NULL, NULL, 'bn_BD', '-', '', '966570976911 ', '', 'english', 19, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('29', 29, 'Abdullah Hassan', 'NP148', '0', NULL, NULL, 'en_US', '-', '', '966532696364 ', '', 'english', 20, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('30', 30, 'Fahad Al Muqbis', 'NP151', '0', NULL, NULL, 'en_US', '-', '', '966552757091 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('31', 31, 'Mohammad Al-Suhali', 'NP152', '0', NULL, NULL, 'en_US', '-', '', '966555670456 ', '', 'english', 21, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('32', 32, 'Francis Anthony', 'NP153', '0', NULL, NULL, 'ta_IN', '-', '', '966561518581 ', '', 'english', 22, 'uploads/My_Picture_-_Copy.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('33', 33, 'Fiaz Ahmad', 'NP154', '0', NULL, NULL, 'en_US', '-', '', '966560684815 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('34', 34, 'Francisco Garcia', 'NP155', '0', NULL, NULL, 'en_US', '-', '', '966547358549 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('35', 35, 'Ponciano Centino', 'NP156', '0', NULL, NULL, 'en_PH', '-', '', '966547279149 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('36', 36, 'Saddam Lindit', 'NP157', '0', NULL, NULL, 'en_PH', '-', '050-740-2716', '966507402716 ', '', 'english', 22, 'uploads/IMG_2446.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('37', 37, 'Norman Vivas', 'NP159', '0', NULL, NULL, 'en_PH', '-', '', '966566880988 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('38', 38, 'Jay A. Dajotoy', 'NP162', '0', NULL, NULL, 'fil_PH', '-', '011 214 5444', '966564783246 ', '', 'english', 22, 'uploads/Jay_pics.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('39', 39, 'Faizan noor', 'NP163', '0', NULL, NULL, 'fil_PH', '-', '', '966564703293 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('40', 40, 'Mohammad Asad', 'NP165', '0', NULL, NULL, 'ur_PK', '-', '', '966567497169 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('41', 41, 'Muteb Al-Harbi', 'NP167', '0', NULL, NULL, 'ar_SA', '-', '', '966558686246 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('42', 42, 'Arriel Quirante', 'NP168', '0', NULL, NULL, 'en_US', '-', '', '966541318057 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('43', 43, 'Ireneo Jr Vasquez', 'NP171', '0', NULL, NULL, 'en_PH', '-', '', '966562620732 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('44', 44, 'Samir Madani ', 'NP180', '0', NULL, NULL, 'ar_SA', '-', '', '966505295952 ', '', 'english', 23, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('52', 52, 'Mohamed Zidan', 'NP146', '0', NULL, NULL, 'en_US', '-', '', '966508773916 ', '', 'english', 11, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('57', 57, 'Reem Al-Ghamdi', 'NP158', '0', NULL, NULL, 'en_US', '-', '', '', '', 'english', 26, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('58', 58, 'Talal Al-Kendi ', 'NP170', '0', NULL, NULL, 'en_US', '-', '', '', '', 'english', 27, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('60', 60, 'Mubarak alabdullatif', 'NP169', '0', NULL, NULL, 'en_US', '-', '0112113333', '0532874975', '', 'english', 28, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('61', 61, 'HR TEAM', '', '0', NULL, NULL, 'en_US', '-', '', '', '', 'english', 29, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('63', 63, 'Ghaida Alshubrami', 'NP191', '0', NULL, NULL, 'en_US', '-', '', '', '', 'english', 30, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('64', 64, 'Ehab Hassan', 'NP110', '0', NULL, NULL, 'en_US', '-', '', '966540920276 ', '', 'english', 13, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');


#
# TABLE STRUCTURE FOR: tbl_accounts
#

DROP TABLE IF EXISTS `tbl_accounts`;

CREATE TABLE `tbl_accounts` (
  `account_id` int(11) NOT NULL AUTO_INCREMENT,
  `account_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `balance` decimal(18,2) NOT NULL DEFAULT 0.00,
  `account_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_person` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_phone` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bank_details` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `permission` text COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_activities
#

DROP TABLE IF EXISTS `tbl_activities`;

CREATE TABLE `tbl_activities` (
  `activities_id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `module` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `module_field_id` int(11) DEFAULT NULL,
  `activity` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `activity_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `icon` varchar(32) COLLATE utf8_unicode_ci DEFAULT 'fa-coffee',
  `link` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value1` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `value2` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`activities_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7766 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (46, 3, 'settings', 3, 'activity_update_profile', '2021-08-20 18:14:27', 'fa-coffee', NULL, 'CastleSky', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (47, 3, 'settings', 3, 'activity_save_general_settings', '2021-08-20 18:15:25', 'fa-coffee', NULL, 'Castlesky Soft', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (48, 3, 'settings', 3, 'activity_save_system_settings', '2021-08-20 18:16:28', 'fa-coffee', NULL, 'english', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (49, 3, 'settings', 3, 'activity_save_theme_settings', '2021-08-20 18:16:55', 'fa-coffee', NULL, 'Castlesky Soft', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (50, 3, 'equipment', 4, NULL, '2021-11-11 12:07:19', 'fa-suitcase', 'admin/equipment/view_equipment_details/4', '111', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (51, 3, 'equipment', 5, NULL, '2021-11-11 12:53:33', 'fa-suitcase', 'admin/equipment/view_equipment_details/5', '111', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (52, 3, 'equipment', 5, NULL, '2021-11-11 12:54:52', 'fa-suitcase', 'admin/equipment/view_equipment_details/5', '11132232', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (53, 3, 'equipment', 5, 'activity_delete_equipment', '2021-11-11 12:55:06', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (54, 3, 'equipment', 4, 'activity_delete_equipment', '2021-11-11 12:55:15', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (55, 3, 'equipment', 4, 'activity_delete_equipment', '2021-11-11 12:55:48', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (56, 3, 'equipment', 2, 'activity_delete_equipment', '2021-11-11 12:55:56', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (57, 3, 'equipment', 2, 'activity_delete_equipment', '2021-11-11 12:59:25', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (58, 3, 'equipment', 2, 'activity_delete_equipment', '2021-11-11 12:59:36', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (59, 3, 'equipment', 6, NULL, '2021-11-11 13:01:48', 'fa-suitcase', 'admin/equipment/view_equipment_details/6', '123', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (60, 3, 'equipment', 6, 'activity_delete_equipment', '2021-11-11 13:01:55', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (61, 3, 'equipment', 3, 'activity_delete_equipment', '2021-11-11 13:32:29', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (66, 3, 'jobs', 0, NULL, '2021-11-12 09:32:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/0', 'Sdi No ', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (67, 3, 'jobs', 0, NULL, '2021-11-12 09:38:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/0', '16', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (68, 3, 'jobs', 0, NULL, '2021-11-12 09:49:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/0', '15', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (69, 3, 'jobs', 1, NULL, '2021-11-12 09:57:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/1', '15', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (70, 3, 'jobs', 1, NULL, '2021-11-12 09:59:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/1', 'Sdi No ', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (71, 3, 'jobs', 1, NULL, '2021-11-12 10:47:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/1', 'Sdi No ', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (72, 3, 'jobs', 1, NULL, '2021-11-12 10:48:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/1', 'Sdi No ', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (73, 3, 'jobs', 1, NULL, '2021-11-12 11:16:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/1', 'Sdi No ', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (74, 3, 'jobs', 1, NULL, '2021-11-12 11:17:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/1', 'Sdi No ', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (75, 3, 'jobs', 2, NULL, '2021-11-12 12:41:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/2', 'Sdi No ', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (76, 3, 'jobs', 1, 'activity_delete_jobs', '2021-11-12 12:45:21', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (77, 3, 'jobs', 3, NULL, '2021-11-12 13:49:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/3', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (78, 3, 'equipment', 7, NULL, '2021-11-13 07:59:33', 'fa-suitcase', 'admin/equipment/view_equipment_details/7', 'Test Sdi no', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (79, 3, 'jobs', 3, NULL, '2021-11-13 08:58:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/3', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (80, 3, 'jobs', 3, NULL, '2021-11-13 08:59:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/3', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (81, 3, 'jobs', 3, NULL, '2021-11-13 08:59:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/3', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (82, 3, 'jobs', 3, NULL, '2021-11-13 09:10:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/3', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (83, 3, 'jobs', 2, NULL, '2021-11-13 09:10:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/2', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (84, 3, 'equipment', 8, NULL, '2021-11-13 09:21:20', 'fa-suitcase', 'admin/equipment/view_equipment_details/8', '1', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (85, 3, 'equipment', 1, NULL, '2021-11-13 09:22:19', 'fa-suitcase', 'admin/equipment/view_equipment_details/1', 'NP210009', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (86, 3, 'equipment', 8, NULL, '2021-11-13 09:22:40', 'fa-suitcase', 'admin/equipment/view_equipment_details/8', 'Sdi', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (87, 3, 'equipment', 8, NULL, '2021-11-13 09:22:52', 'fa-suitcase', 'admin/equipment/view_equipment_details/8', 'Sdi', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (88, 3, 'equipment', 8, NULL, '2021-11-13 09:24:10', 'fa-suitcase', 'admin/equipment/view_equipment_details/8', 'Sdi', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (89, 3, 'equipment', 7, NULL, '2021-11-13 09:24:26', 'fa-suitcase', 'admin/equipment/view_equipment_details/7', 'Test Sdi no', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (90, 3, 'equipment', 1, NULL, '2021-11-13 09:24:37', 'fa-suitcase', 'admin/equipment/view_equipment_details/1', 'NP210009', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (91, 3, 'service', 0, NULL, '2021-11-13 13:12:17', 'fa-suitcase', 'admin/service/view_service_details/0', '1', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (92, 3, 'service', 1, NULL, '2021-11-13 13:16:23', 'fa-suitcase', 'admin/service/view_service_details/1', '1', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (93, 3, 'service', 2, NULL, '2021-11-13 13:20:27', 'fa-suitcase', 'admin/service/view_service_details/2', 'NP210001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (94, 3, 'service', 2, NULL, '2021-11-13 13:21:17', 'fa-suitcase', 'admin/service/view_service_details/2', 'NP210001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (95, 3, 'service', 2, NULL, '2021-11-13 13:21:28', 'fa-suitcase', 'admin/service/view_service_details/2', 'NP210001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (96, 3, 'service', 2, NULL, '2021-11-13 13:21:41', 'fa-suitcase', 'admin/service/view_service_details/2', 'NP210001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (97, 3, 'gpu', 0, NULL, '2021-11-13 13:59:56', 'fa-suitcase', 'admin/gpu/view_gpu_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (98, 3, 'gpu', 1, NULL, '2021-11-13 14:01:35', 'fa-suitcase', 'admin/gpu/view_gpu_details/1', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (99, 3, 'equipment_type', 0, NULL, '2021-11-13 14:31:38', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (100, 3, 'equipment_type', 0, NULL, '2021-11-13 14:33:48', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (101, 3, 'equipment_type', 0, NULL, '2021-11-13 14:37:15', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (102, 3, 'equipment_type', 0, NULL, '2021-11-13 14:39:38', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (103, 3, 'equipment_type', 0, NULL, '2021-11-13 14:41:49', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (104, 3, 'equipment_type', 0, NULL, '2021-11-13 14:42:12', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (105, 3, 'equipment_type', 0, NULL, '2021-11-13 14:43:18', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (106, 3, 'equipment_type', 1, NULL, '2021-11-13 14:44:41', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/1', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (107, 3, 'equipment_type', 2, NULL, '2021-11-15 07:43:13', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/2', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (108, 3, 'equipment', 7, NULL, '2021-11-15 08:24:45', 'fa-suitcase', 'admin/equipment/view_equipment_details/7', 'Test Sdi no', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (109, 3, 'equipment', 8, NULL, '2021-11-15 08:24:53', 'fa-suitcase', 'admin/equipment/view_equipment_details/8', 'Sdi', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (110, 3, 'service', 3, NULL, '2021-11-15 08:32:15', 'fa-suitcase', 'admin/service/view_service_details/3', '2', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (111, 3, 'service', 3, NULL, '2021-11-15 08:32:43', 'fa-suitcase', 'admin/service/view_service_details/3', '2', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (112, 3, 'service', 3, 'activity_delete_service', '2021-11-15 08:32:56', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (113, 3, 'jobs', 3, NULL, '2021-11-15 08:50:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/3', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (114, 3, 'jobs', 2, NULL, '2021-11-15 08:50:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/2', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (115, 3, 'jobs', 3, NULL, '2021-11-15 09:07:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/3', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (116, 3, 'jobs', 3, NULL, '2021-11-15 09:15:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/3', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (117, 3, 'jobs', 4, NULL, '2021-11-15 09:17:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/4', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (118, 3, 'jobs', 4, NULL, '2021-11-15 09:17:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/4', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (119, 3, 'jobs', 4, NULL, '2021-11-15 09:20:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/4', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (120, 3, 'jobs', 3, NULL, '2021-11-15 09:58:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/3', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (121, 3, 'jobs', 5, NULL, '2021-11-15 10:15:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/5', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (122, 3, 'training', 1, 'activity_added_training', '2021-11-15 10:27:27', 'fa-suitcase', 'admin/training/view_training_details/1', 'TETSS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (123, 3, 'equipment_type', 2, NULL, '2021-11-15 12:32:13', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/2', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (124, 3, 'equipment_type', 2, NULL, '2021-11-15 12:35:48', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/2', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (125, 3, 'equipment_type', 2, NULL, '2021-11-15 12:36:32', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/2', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (126, 3, 'jobs', 3, NULL, '2021-11-15 12:45:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/3', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (127, 3, 'equipment_type', 3, NULL, '2021-11-15 12:49:04', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/3', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (128, 3, 'equipment_type', 4, NULL, '2021-11-15 12:52:27', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/4', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (129, 3, 'equipment', 8, 'activity_delete_equipment', '2021-11-15 14:00:48', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (130, 3, 'equipment', 7, 'activity_delete_equipment', '2021-11-15 14:00:57', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (131, 3, 'equipment', 1, 'activity_delete_equipment', '2021-11-15 14:01:00', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (132, 3, 'equipment', 9, NULL, '2021-11-15 14:03:09', 'fa-suitcase', 'admin/equipment/view_equipment_details/9', 'NP210009', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (133, 3, 'equipment', 10, NULL, '2021-11-15 14:04:31', 'fa-suitcase', 'admin/equipment/view_equipment_details/10', 'NP210012', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (134, 3, 'jobs', 5, 'activity_delete_jobs', '2021-11-15 14:05:38', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (135, 3, 'jobs', 4, 'activity_delete_jobs', '2021-11-15 14:05:41', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (136, 3, 'jobs', 3, 'activity_delete_jobs', '2021-11-15 14:05:44', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (137, 3, 'jobs', 2, 'activity_delete_jobs', '2021-11-15 14:05:47', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (138, 3, 'service', 2, 'activity_delete_service', '2021-11-15 14:06:04', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (139, 3, 'service', 4, NULL, '2021-11-15 14:08:48', 'fa-suitcase', 'admin/service/view_service_details/4', 'NP210001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (140, 3, 'service', 5, NULL, '2021-11-15 14:08:50', 'fa-suitcase', 'admin/service/view_service_details/5', 'NP210001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (141, 3, 'service', 4, 'activity_delete_service', '2021-11-15 14:17:30', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (142, 3, 'gpu', 1, 'activity_delete_gpu', '2021-11-15 14:18:20', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (143, 3, 'gpu', 2, NULL, '2021-11-15 14:19:41', 'fa-suitcase', 'admin/gpu/view_gpu_details/2', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (144, 3, 'equipment_type', 2, 'activity_delete_equipment_type', '2021-11-15 14:20:26', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (145, 3, 'equipment_type', 5, NULL, '2021-11-15 14:21:53', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/5', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (146, 3, 'equipment_type', 4, 'activity_delete_equipment_type', '2021-11-15 14:22:05', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (147, 3, 'equipment_type', 3, 'activity_delete_equipment_type', '2021-11-15 14:22:16', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (148, 3, 'equipment_type', 6, NULL, '2021-11-15 14:26:10', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/6', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (149, 3, 'equipment_type', 7, NULL, '2021-11-15 14:28:44', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/7', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (150, 3, 'equipment_type', 5, NULL, '2021-11-15 14:29:59', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/5', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (151, 3, 'equipment_type', 5, NULL, '2021-11-15 14:31:09', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/5', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (152, 3, 'service', 5, NULL, '2021-11-15 14:33:30', 'fa-suitcase', 'admin/service/view_service_details/5', 'NP210001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (153, 3, 'equipment_type', 5, NULL, '2021-11-15 14:34:08', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/5', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (154, 3, 'equipment_type', 6, NULL, '2021-11-15 14:34:29', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/6', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (155, 3, 'equipment_type', 7, NULL, '2021-11-15 14:37:47', 'fa-suitcase', 'admin/equipment_type/view_equipment_type_details/7', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (156, 3, 'settings', 3, 'activity_save_general_settings', '2021-11-16 09:04:23', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (157, 3, 'settings', 3, 'activity_save_system_settings', '2021-11-16 09:09:12', 'fa-coffee', NULL, 'english', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (158, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-16 09:10:09', 'fa-coffee', NULL, 'NCPO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (159, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-16 09:30:35', 'fa-coffee', NULL, 'NCPO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (160, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-16 09:31:48', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (161, 3, 'settings', 3, 'activity_save_general_settings', '2021-11-16 20:09:36', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (162, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-16 20:10:16', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (163, 3, 'user', 1, 'activity_added_new_user', '2021-11-16 20:20:03', 'fa-user', NULL, 'admin', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (164, 3, 'user', 5, 'activity_added_new_user', '2021-11-17 10:34:52', 'fa-user', NULL, 'staff', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (165, 3, 'departments', NULL, 'activity_added_a_department', '2021-11-17 10:44:21', 'fa-coffee', NULL, 'Maintence', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (166, 3, 'settings', 3, 'activity_save_general_settings', '2021-11-17 10:53:21', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (167, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-17 11:01:07', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (168, 3, 'jobs', 6, NULL, '2021-11-17 11:12:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/6', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (169, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-17 11:50:39', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (170, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-17 11:51:14', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (171, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-17 11:51:53', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (172, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-17 11:57:31', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (173, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-17 11:59:55', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (174, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-17 12:01:07', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (175, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-17 12:01:26', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (176, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-17 12:01:42', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (177, 3, 'settings', 3, 'activity_save_theme_settings', '2021-11-17 12:02:24', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (178, 3, 'jobs', 6, 'activity_delete_jobs', '2021-11-17 12:04:53', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (179, 3, 'jobs', 6, 'activity_delete_jobs', '2021-11-17 12:05:05', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (180, 3, 'user', 5, 'activity_added_new_user', '2021-11-17 12:07:13', 'fa-user', NULL, 'staff', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (181, 3, 'jobs', 7, NULL, '2021-11-19 03:04:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/7', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (182, 3, 'jobs', 8, NULL, '2021-11-26 15:32:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/8', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (183, 3, 'problems', 0, NULL, '2021-11-26 15:37:12', 'fa-suitcase', 'admin/problems/view_problems_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (184, 3, 'knowledgebase', 1, 'activity_save_kb_category', '2021-11-28 17:26:12', 'fa-circle-o', '#', 'Load bank', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (185, 3, 'knowledgebase', 1, 'activity_delete_kb_category', '2021-11-28 17:26:25', 'fa-circle-o', NULL, 'Load bank', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (186, 3, 'jobs', 9, NULL, '2021-11-28 17:44:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/9', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (187, 3, 'problems', 0, NULL, '2021-11-28 17:46:14', 'fa-suitcase', 'admin/problems/view_problems_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (188, 3, 'jobs', 9, NULL, '2021-11-28 17:46:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/9', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (189, 3, 'jobs', 10, NULL, '2021-11-29 14:42:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/10', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (190, 3, 'jobs', 10, NULL, '2021-11-29 14:43:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/10', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (191, 3, 'problems', 0, 'activity_delete_problems', '2021-11-29 14:44:45', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (192, 3, 'problems', 0, NULL, '2021-11-29 14:45:37', 'fa-suitcase', 'admin/problems/view_problems_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (193, 3, 'user', 4, 'activity_change_status', '2021-12-15 10:02:43', 'fa-user', NULL, 'QBPHGOIQWNQPEMCOQEYTJJHS365 https://apple.com blaw Active', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (194, 3, 'user', 4, 'activity_change_status', '2021-12-15 10:02:51', 'fa-user', NULL, 'QBPHGOIQWNQPEMCOQEYTJJHS365 https://apple.com blaw Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (195, 3, 'departments', NULL, 'activity_added_a_department', '2021-12-15 10:10:04', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (196, 3, 'user', 6, 'activity_added_new_user', '2021-12-15 10:10:32', 'fa-user', NULL, 'Rameez', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (197, 3, 'user', 6, 'activity_added_new_user', '2021-12-15 10:14:23', 'fa-user', NULL, 'Rameez', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (198, 3, 'departments', 2, 'activity_delete_a_department', '2021-12-15 10:14:51', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (199, 3, 'departments', 3, 'activity_added_a_department', '2021-12-15 10:15:28', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (200, 3, 'departments', 3, 'activity_added_a_department', '2021-12-15 10:16:19', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (201, 3, 'announcements', NULL, 'activity_added_announcements', '2021-12-15 10:23:13', 'fa-ticket', NULL, 'ERP', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (202, 3, 'announcements', 1, 'activity_update_announcements', '2021-12-15 10:23:39', 'fa-ticket', NULL, 'ERP', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (203, 3, 'departments', 3, 'activity_added_a_department', '2021-12-15 10:26:05', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (204, 3, 'mailbox', 3, 'Mail Sent', '2021-12-15 10:29:46', 'fa-circle-o', NULL, 'syed.rameez143@gmail.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (205, 3, 'mailbox', 1, 'Delete inbox msg', '2021-12-15 10:30:39', 'fa-circle-o', NULL, 'syed.rameez143@gmail.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (206, 3, 'mailbox', 3, 'Mail Sent', '2021-12-15 10:31:03', 'fa-circle-o', NULL, 'syed.rameez143@gmail.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (207, 3, 'mailbox', 2, 'Delete sent msg', '2021-12-15 10:31:18', 'fa-circle-o', NULL, 'syed.rameez143@gmail.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (208, 3, 'mailbox', 1, 'Delete sent msg', '2021-12-15 10:31:18', 'fa-circle-o', NULL, 'syed.rameez143@gmail.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (209, 3, 'mailbox', 2, 'Delete inbox msg', '2021-12-15 10:31:26', 'fa-circle-o', NULL, 'syed.rameez143@gmail.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (210, 3, 'mailbox', 2, 'Delete inbox msg from trash', '2021-12-15 10:31:45', 'fa-circle-o', NULL, 'syed.rameez143@gmail.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (211, 3, 'mailbox', 1, 'Delete inbox msg from trash', '2021-12-15 10:31:45', 'fa-circle-o', NULL, 'syed.rameez143@gmail.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (212, 3, 'client', 1, 'activity_added_new_company', '2021-12-15 10:40:06', 'fa-user', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (213, 3, 'user', 6, 'activity_added_new_user', '2021-12-15 11:01:11', 'fa-user', NULL, 'Rameez', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (214, 3, 'departments', NULL, 'activity_added_a_department', '2021-12-15 16:49:48', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (215, 3, 'user', 7, 'activity_added_new_user', '2021-12-15 16:50:02', 'fa-user', NULL, 'Abdulwahab', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (216, 7, 'announcements', NULL, 'activity_added_announcements', '2021-12-15 16:52:38', 'fa-ticket', NULL, 'TEST', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (217, 7, 'announcements', 2, 'activity_update_announcements', '2021-12-15 16:53:02', 'fa-ticket', NULL, 'TEST', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (218, 3, 'client', 2, 'activity_update_company', '2021-12-16 11:48:49', 'fa-user', NULL, 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (219, 3, 'jobs', 11, NULL, '2021-12-16 11:52:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/11', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (220, 3, 'jobs', 11, NULL, '2021-12-16 11:53:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/11', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (221, 3, 'jobs', 7, 'activity_delete_jobs', '2021-12-16 12:03:33', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (222, 3, 'jobs', 8, 'activity_delete_jobs', '2021-12-16 12:03:46', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (223, 3, 'jobs', 12, NULL, '2021-12-17 20:56:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/12', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (224, 3, 'jobs', 13, NULL, '2021-12-29 09:20:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/13', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (225, 3, 'jobs', 13, NULL, '2021-12-29 09:20:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/13', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (226, 3, 'jobs', 14, NULL, '2021-12-29 10:22:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/14', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (227, 3, 'jobs', 15, NULL, '2021-12-29 10:22:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/15', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (228, 3, 'jobs', 15, 'activity_delete_jobs', '2021-12-29 10:25:10', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (229, 3, 'jobs', 16, NULL, '2021-12-29 10:27:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/16', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (230, 3, 'jobs', 16, 'activity_delete_jobs', '2021-12-29 11:11:18', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (231, 3, 'jobs', 10, NULL, '2021-12-29 11:13:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/10', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (232, 3, 'jobs', 13, NULL, '2021-12-29 15:50:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/13', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (233, 3, 'jobs', 13, NULL, '2021-12-29 23:15:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/13', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (234, 3, 'jobs', 13, NULL, '2021-12-29 23:15:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/13', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (235, 3, 'jobs', 13, NULL, '2021-12-29 23:15:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/13', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (236, 3, 'jobs', 13, NULL, '2021-12-29 23:15:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/13', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (237, 3, 'jobs', 13, NULL, '2021-12-29 23:15:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/13', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (238, 3, 'jobs', 13, NULL, '2021-12-29 23:16:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/13', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (239, 3, 'jobs', 13, NULL, '2021-12-29 23:16:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/13', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (240, 3, 'jobs', 9, NULL, '2021-12-29 23:17:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/9', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (241, 3, 'settings', 3, 'activity_update_profile', '2021-12-29 23:35:54', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (242, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-29 23:38:00', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (243, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-29 23:38:19', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (244, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-29 23:38:58', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (245, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-29 23:39:57', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (246, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-29 23:42:15', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (247, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-29 23:44:25', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (248, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-29 23:48:28', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (249, 3, 'jobs', 11, NULL, '2021-12-30 08:34:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/11', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (250, 3, 'jobs', 17, NULL, '2021-12-30 11:49:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/17', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (251, 3, 'jobs', 18, NULL, '2021-12-30 12:18:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/18', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (252, 3, 'jobs', 19, NULL, '2021-12-30 12:46:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/19', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (253, 3, 'jobs', 20, NULL, '2021-12-30 12:46:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/20', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (254, 3, 'jobs', 17, NULL, '2021-12-30 12:58:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/17', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (255, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-30 12:59:58', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (256, 3, 'jobs', 21, NULL, '2021-12-30 13:49:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/21', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (257, 3, 'jobs', 22, NULL, '2021-12-30 16:21:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/22', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (258, 3, 'jobs', 11, NULL, '2021-12-30 19:24:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/11', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (259, 6, 'jobs', 23, NULL, '2021-12-30 19:52:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/23', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (260, 6, 'jobs', 24, NULL, '2021-12-30 19:55:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/24', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (261, 6, 'jobs', 25, NULL, '2021-12-30 19:57:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/25', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (262, 6, 'jobs', 26, NULL, '2021-12-30 19:58:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/26', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (263, 6, 'jobs', 27, NULL, '2021-12-30 19:59:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/27', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (264, 6, 'jobs', 28, NULL, '2021-12-30 20:00:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/28', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (265, 3, 'jobs', 28, NULL, '2021-12-31 13:45:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/28', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (266, 3, 'jobs', 28, NULL, '2021-12-31 13:52:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/28', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (267, 3, 'jobs', 29, NULL, '2021-12-31 13:56:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/29', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (268, 3, 'jobs', 30, NULL, '2021-12-31 14:00:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (269, 3, 'jobs', 30, NULL, '2021-12-31 14:03:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (270, 3, 'jobs', 30, NULL, '2021-12-31 14:12:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (271, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-31 14:20:35', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (272, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-31 14:25:15', 'fa-coffee', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (273, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-31 14:28:21', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (274, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-31 14:32:04', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (275, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-31 14:33:05', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (276, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-31 14:33:45', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (277, 3, 'jobs', 30, NULL, '2021-12-31 14:36:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (278, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-31 15:42:58', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (279, 3, 'jobs', 25, NULL, '2021-12-31 15:53:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/25', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (280, 3, 'jobs', 30, NULL, '2021-12-31 15:54:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (281, 3, 'jobs', 30, NULL, '2021-12-31 15:59:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (282, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-31 16:01:11', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (283, 3, 'settings', 3, 'activity_save_theme_settings', '2021-12-31 16:02:10', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (284, 3, 'user', 6, 'activity_change_status', '2021-12-31 16:05:30', 'fa-user', NULL, 'Rameez Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (285, 3, 'user', 6, 'activity_change_status', '2021-12-31 16:05:32', 'fa-user', NULL, 'Rameez Active', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (286, 3, 'departments', NULL, 'activity_added_a_department', '2021-12-31 16:07:25', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (287, 3, 'departments', NULL, 'activity_added_a_department', '2021-12-31 16:07:31', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (288, 3, 'departments', NULL, 'activity_added_a_department', '2021-12-31 16:07:43', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (289, 3, 'departments', NULL, 'activity_added_a_department', '2021-12-31 16:07:58', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (290, 3, 'departments', NULL, 'activity_added_a_department', '2021-12-31 16:09:35', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (291, 3, 'departments', NULL, 'activity_added_a_department', '2021-12-31 16:09:40', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (292, 3, 'jobs', 30, NULL, '2021-12-31 19:43:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (293, 3, 'jobs', 30, NULL, '2021-12-31 19:48:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (294, 3, 'jobs', 30, NULL, '2021-12-31 19:52:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (295, 3, 'jobs', 31, NULL, '2021-12-31 21:27:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (296, 3, 'jobs', 31, NULL, '2021-12-31 21:28:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (297, 3, 'jobs', 31, NULL, '2021-12-31 21:29:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (298, 3, 'jobs', 31, NULL, '2021-12-31 21:39:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (299, 3, 'jobs', 31, NULL, '2022-01-02 12:45:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (300, 3, 'jobs', 31, NULL, '2022-01-02 12:56:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (301, 3, 'jobs', 31, NULL, '2022-01-03 12:56:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (302, 3, 'jobs', 31, NULL, '2022-01-03 12:57:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (303, 3, 'jobs', 31, NULL, '2022-01-03 12:57:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (304, 3, 'jobs', 31, NULL, '2022-01-03 13:01:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (305, 3, 'jobs', 9, NULL, '2022-01-03 13:03:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/9', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (306, 6, 'jobs', 31, NULL, '2022-01-03 13:28:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (307, 6, 'jobs', 31, NULL, '2022-01-03 13:29:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (308, 3, 'jobs', 31, NULL, '2022-01-04 09:05:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (309, 3, 'jobs', 31, NULL, '2022-01-04 09:05:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (310, 3, 'jobs', 30, NULL, '2022-01-04 18:31:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (311, 3, 'jobs', 30, NULL, '2022-01-04 18:31:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (312, 3, 'jobs', 31, NULL, '2022-01-04 19:30:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/31', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (313, 3, 'jobs', 30, NULL, '2022-01-04 19:38:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (314, 3, 'jobs', 30, NULL, '2022-01-04 19:39:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/30', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (315, 3, 'jobs', 32, NULL, '2022-01-04 19:49:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/32', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (316, 3, 'jobs', 33, NULL, '2022-01-05 09:42:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/33', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (317, 3, 'jobs', 33, NULL, '2022-01-05 09:43:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/33', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (318, 3, 'jobs', 34, NULL, '2022-01-05 09:52:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (319, 3, 'jobs', 34, NULL, '2022-01-05 09:53:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (320, 3, 'jobs', 34, NULL, '2022-01-05 11:33:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (321, 3, 'jobs', 34, NULL, '2022-01-05 19:34:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (322, 3, 'jobs', 34, NULL, '2022-01-05 19:36:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (323, 3, 'jobs', 34, NULL, '2022-01-05 19:40:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (324, 3, 'jobs', 34, NULL, '2022-01-05 19:47:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (325, 3, 'settings', 3, 'activity_save_theme_settings', '2022-01-05 20:00:13', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (326, 3, 'settings', 3, 'activity_save_theme_settings', '2022-01-05 20:05:16', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (327, 3, 'settings', 3, 'activity_save_theme_settings', '2022-01-05 20:07:58', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (328, 3, 'settings', 3, 'activity_save_theme_settings', '2022-01-05 20:10:25', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (329, 3, 'jobs', 34, NULL, '2022-01-06 09:55:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (330, 3, 'jobs', 34, NULL, '2022-01-06 09:55:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (331, 3, 'jobs', 34, NULL, '2022-01-06 15:31:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (332, 3, 'jobs', 34, NULL, '2022-01-07 08:49:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (333, 3, 'jobs', 34, NULL, '2022-01-07 08:49:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (334, 3, 'jobs', 34, NULL, '2022-01-07 08:51:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (335, 3, 'jobs', 34, NULL, '2022-01-07 08:56:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (336, 3, 'jobs', 34, NULL, '2022-01-07 09:03:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (337, 3, 'jobs', 35, NULL, '2022-01-07 09:10:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/35', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (338, 3, 'settings', 3, 'activity_save_theme_settings', '2022-01-07 09:23:07', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (339, 3, 'settings', 3, 'activity_save_theme_settings', '2022-01-07 09:23:08', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (340, 3, 'jobs', 34, NULL, '2022-01-07 10:08:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (341, 3, 'jobs', 34, NULL, '2022-01-07 17:51:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (342, 3, 'jobs', 34, NULL, '2022-01-07 17:52:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (343, 3, 'jobs', 34, NULL, '2022-01-07 17:53:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (344, 3, 'jobs', 34, NULL, '2022-01-07 17:58:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (345, 3, 'settings', 3, 'activity_save_theme_settings', '2022-01-07 18:03:41', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (346, 3, 'jobs', 34, NULL, '2022-01-07 18:09:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (347, 3, 'jobs', 34, NULL, '2022-01-07 18:11:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (348, 3, 'jobs', 34, NULL, '2022-01-07 18:15:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/34', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (349, 3, 'settings', 3, 'activity_save_theme_settings', '2022-01-07 18:20:21', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (350, 3, 'jobs', 36, NULL, '2022-01-07 19:43:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (351, 3, 'jobs', 36, NULL, '2022-01-07 19:43:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (352, 3, 'jobs', 36, NULL, '2022-01-07 19:47:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (353, 3, 'jobs', 36, NULL, '2022-01-07 19:52:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (354, 3, 'jobs', 36, NULL, '2022-01-08 19:21:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (355, 3, 'jobs', 36, NULL, '2022-01-08 19:21:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (356, 3, 'jobs', 36, NULL, '2022-01-08 19:22:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (357, 3, 'jobs', 36, NULL, '2022-01-08 19:23:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (358, 3, 'jobs', 36, NULL, '2022-01-08 19:48:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (359, 3, 'jobs', 36, NULL, '2022-01-08 19:48:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (360, 3, 'jobs', 36, NULL, '2022-01-08 19:51:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (361, 3, 'jobs', 36, NULL, '2022-01-08 19:54:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (362, 3, 'jobs', 37, NULL, '2022-01-08 20:05:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/37', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (363, 3, 'settings', 3, 'activity_save_theme_settings', '2022-01-08 20:14:21', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (364, 3, 'jobs', 36, NULL, '2022-01-09 08:19:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (365, 3, 'jobs', 36, NULL, '2022-01-09 08:23:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (366, 3, 'jobs', 38, NULL, '2022-01-09 11:44:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/38', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (367, 3, 'jobs', 38, NULL, '2022-01-09 11:45:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/38', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (368, 3, 'jobs', 38, NULL, '2022-01-09 11:46:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/38', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (369, 3, 'jobs', 38, NULL, '2022-01-09 11:47:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/38', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (370, 3, 'jobs', 39, NULL, '2022-01-09 11:51:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/39', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (371, 3, 'jobs', 40, NULL, '2022-01-09 11:51:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/40', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (372, 3, 'jobs', 41, NULL, '2022-01-09 11:52:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/41', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (373, 3, 'jobs', 41, 'activity_delete_jobs', '2022-01-09 11:52:53', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (374, 3, 'jobs', 41, 'activity_delete_jobs', '2022-01-09 11:52:56', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (375, 3, 'jobs', 40, 'activity_delete_jobs', '2022-01-09 11:53:36', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (376, 3, 'jobs', 39, 'activity_delete_jobs', '2022-01-09 11:53:39', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (377, 3, 'jobs', 38, NULL, '2022-01-09 12:53:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/38', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (378, 3, 'jobs', 37, 'activity_delete_jobs', '2022-01-09 13:40:00', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (379, 3, 'jobs', 38, NULL, '2022-01-09 13:40:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/38', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (380, 3, 'jobs', 38, NULL, '2022-01-09 15:09:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/38', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (381, 3, 'jobs', 36, NULL, '2022-01-09 19:10:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (382, 3, 'jobs', 36, NULL, '2022-01-10 08:26:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (383, 3, 'jobs', 36, NULL, '2022-01-10 08:26:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (384, 3, 'jobs', 36, NULL, '2022-01-10 08:27:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (385, 3, 'jobs', 36, NULL, '2022-01-10 09:34:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (386, 3, 'jobs', 36, NULL, '2022-01-10 09:38:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (387, 3, 'jobs', 36, NULL, '2022-01-10 09:40:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (388, 6, 'departments', NULL, 'activity_added_a_department', '2022-01-10 09:48:44', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (389, 6, 'user', 8, 'activity_added_new_user', '2022-01-10 09:49:05', 'fa-user', NULL, 'Test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (390, 3, 'departments', NULL, 'activity_added_a_department', '2022-01-10 09:52:06', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (391, 3, 'user', 8, 'activity_added_new_user', '2022-01-10 09:54:05', 'fa-user', NULL, 'Test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (392, 3, 'departments', 8, 'activity_delete_a_designation', '2022-01-10 10:14:55', 'fa-coffee', NULL, 'Test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (393, 3, 'departments', 7, 'activity_delete_a_designation', '2022-01-10 10:15:00', 'fa-coffee', NULL, 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (394, 3, 'jobs', 36, NULL, '2022-01-10 15:40:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/36', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (395, 3, 'jobs', 42, NULL, '2022-01-10 18:26:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (396, 3, 'jobs', 42, NULL, '2022-01-10 18:38:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (397, 3, 'jobs', 42, NULL, '2022-01-11 00:07:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (398, 3, 'jobs', 42, NULL, '2022-01-11 14:43:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (399, 3, 'jobs', 42, NULL, '2022-01-11 14:47:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (400, 3, 'jobs', 42, NULL, '2022-01-11 14:51:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (401, 3, 'jobs', 42, NULL, '2022-01-12 12:06:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (402, 3, 'jobs', 43, NULL, '2022-01-12 14:45:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/43', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (403, 3, 'jobs', 42, NULL, '2022-01-12 14:46:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (404, 3, 'jobs', 42, NULL, '2022-01-12 14:47:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (405, 3, 'jobs', 42, NULL, '2022-01-12 14:47:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (406, 3, 'jobs', 42, NULL, '2022-01-12 14:48:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (407, 3, 'jobs', 42, NULL, '2022-01-12 14:50:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/42', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (408, 3, 'equipment', 11, NULL, '2022-01-12 14:54:44', 'fa-suitcase', 'admin/equipment/view_equipment_details/11', 'NP210005', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (409, 3, 'equipment', 11, NULL, '2022-01-12 14:55:18', 'fa-suitcase', 'admin/equipment/view_equipment_details/11', 'NP210005', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (410, 3, 'jobs', 44, NULL, '2022-01-12 14:58:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/44', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (411, 3, 'jobs', 44, NULL, '2022-01-12 14:59:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/44', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (412, 3, 'jobs', 44, NULL, '2022-01-12 16:10:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/44', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (413, 3, 'jobs', 44, NULL, '2022-01-12 16:15:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/44', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (414, 3, 'jobs', 44, NULL, '2022-01-12 16:22:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/44', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (415, 3, 'jobs', 44, NULL, '2022-01-12 18:59:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/44', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (416, 3, 'jobs', 44, NULL, '2022-01-12 19:36:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/44', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (417, 3, 'jobs', 44, NULL, '2022-01-12 23:40:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/44', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (418, 3, 'jobs', 44, NULL, '2022-01-13 08:46:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/44', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (419, 3, 'equipment', 12, NULL, '2022-01-13 10:34:24', 'fa-suitcase', 'admin/equipment/view_equipment_details/12', 'NP210003', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (420, 3, 'jobs', 45, NULL, '2022-01-13 10:46:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/45', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (421, 3, 'jobs', 45, NULL, '2022-01-13 10:55:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/45', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (422, 3, 'jobs', 45, NULL, '2022-01-13 10:57:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/45', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (423, 3, 'equipment', 13, NULL, '2022-01-13 11:17:04', 'fa-suitcase', 'admin/equipment/view_equipment_details/13', 'NP210005', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (424, 3, 'problems', 0, 'activity_delete_problems', '2022-01-13 11:19:47', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (425, 3, 'client', 3, 'activity_update_company', '2022-01-13 11:28:16', 'fa-user', NULL, 'SAEI', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (426, 3, 'jobs', 46, NULL, '2022-01-13 11:32:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/46', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (427, 3, 'jobs', 46, NULL, '2022-01-13 11:36:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/46', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (428, 3, 'jobs', 46, NULL, '2022-01-13 11:40:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/46', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (429, 3, 'jobs', 46, 'activity_delete_jobs', '2022-01-13 11:45:34', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (430, 3, 'jobs', 47, NULL, '2022-01-13 11:50:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (431, 3, 'jobs', 47, NULL, '2022-01-13 11:56:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (432, 3, 'jobs', 47, NULL, '2022-01-13 12:01:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (433, 3, 'jobs', 47, NULL, '2022-01-13 12:11:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (434, 3, 'jobs', 47, NULL, '2022-01-13 12:12:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (435, 3, 'jobs', 47, NULL, '2022-01-13 12:14:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (436, 3, 'jobs', 47, NULL, '2022-01-13 12:14:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (437, 3, 'jobs', 47, NULL, '2022-01-13 12:21:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (438, 3, 'jobs', 47, NULL, '2022-01-13 12:24:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (439, 3, 'jobs', 47, NULL, '2022-01-13 12:26:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (440, 3, 'jobs', 47, NULL, '2022-01-13 12:31:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (441, 3, 'jobs', 47, NULL, '2022-01-13 12:32:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/47', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (442, 3, 'equipment', 14, NULL, '2022-01-13 14:53:15', 'fa-suitcase', 'admin/equipment/view_equipment_details/14', 'FLY0001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (443, 3, 'client', 4, 'activity_update_company', '2022-01-13 14:56:32', 'fa-user', NULL, 'FLYNAS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (444, 3, 'client', 4, 'activity_added_new_company', '2022-01-13 14:57:03', 'fa-user', NULL, 'FLYNAS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (445, 3, 'jobs', 48, NULL, '2022-01-13 15:02:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/48', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (446, 3, 'jobs', 48, NULL, '2022-01-13 15:04:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/48', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (447, 3, 'jobs', 48, NULL, '2022-01-13 15:06:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/48', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (448, 3, 'jobs', 48, NULL, '2022-01-13 15:08:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/48', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (449, 3, 'jobs', 48, NULL, '2022-01-13 15:10:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/48', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (450, 3, 'jobs', 48, NULL, '2022-01-13 15:13:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/48', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (451, 3, 'client', 5, 'activity_update_company', '2022-01-13 15:24:32', 'fa-user', NULL, 'SACC', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (452, 3, 'equipment', 15, NULL, '2022-01-13 15:26:27', 'fa-suitcase', 'admin/equipment/view_equipment_details/15', '12392', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (453, 3, 'jobs', 49, NULL, '2022-01-13 15:30:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (454, 3, 'jobs', 49, NULL, '2022-01-13 15:30:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (455, 3, 'jobs', 49, NULL, '2022-01-13 15:31:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (456, 3, 'jobs', 49, NULL, '2022-01-13 15:32:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (457, 3, 'jobs', 49, NULL, '2022-01-13 15:34:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (458, 3, 'jobs', 49, NULL, '2022-01-13 15:35:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (459, 3, 'jobs', 49, NULL, '2022-01-13 15:36:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (460, 3, 'jobs', 48, NULL, '2022-01-14 21:26:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/48', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (461, 3, 'jobs', 49, NULL, '2022-01-14 21:27:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (462, 3, 'jobs', 49, NULL, '2022-01-14 21:34:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (463, 3, 'jobs', 49, NULL, '2022-01-14 21:35:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (464, 3, 'jobs', 49, NULL, '2022-01-14 21:38:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (465, 3, 'jobs', 48, NULL, '2022-01-14 21:39:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/48', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (466, 3, 'jobs', 49, NULL, '2022-01-14 21:45:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (467, 3, 'settings', 3, 'activity_save_theme_settings', '2022-01-14 22:24:44', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (468, 3, 'jobs', 48, NULL, '2022-01-15 17:30:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/48', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (469, 3, 'jobs', 49, NULL, '2022-01-15 17:32:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (470, 3, 'jobs', 49, NULL, '2022-01-15 17:32:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (471, 3, 'jobs', 49, NULL, '2022-01-15 17:36:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (472, 3, 'user', 8, 'activity_added_new_user', '2022-01-16 10:23:57', 'fa-user', NULL, 'Test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (473, 3, 'departments', 3, 'activity_added_a_department', '2022-01-16 10:25:37', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (474, 3, 'departments', NULL, 'activity_added_a_department', '2022-01-16 10:26:39', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (475, 3, 'departments', 10, 'activity_delete_a_designation', '2022-01-16 10:27:39', 'fa-coffee', NULL, 'Test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (476, 3, 'user', 9, 'activity_added_new_user', '2022-01-16 10:50:26', 'fa-user', NULL, 'Test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (477, 3, 'departments', 3, 'activity_added_a_department', '2022-01-16 10:51:33', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (478, 3, 'departments', 3, 'activity_added_a_department', '2022-01-16 10:56:11', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (479, 3, 'departments', 3, 'activity_added_a_department', '2022-01-16 10:59:34', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (480, 3, 'user', 10, 'activity_added_new_user', '2022-01-17 10:52:30', 'fa-user', NULL, 'KKIA', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (481, 3, 'user', 11, 'activity_added_new_user', '2022-01-17 10:54:59', 'fa-user', NULL, 'MPC', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (482, 10, 'settings', 10, 'activity_save_theme_settings', '2022-01-17 10:56:26', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (488, 10, 'jobs', 50, NULL, '2022-01-17 12:02:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/50', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (494, 10, 'jobs', 51, NULL, '2022-01-17 12:16:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/51', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (502, 10, 'jobs', 51, NULL, '2022-01-17 12:35:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/51', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (503, 10, 'jobs', 51, NULL, '2022-01-17 12:36:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/51', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (506, 10, 'jobs', 51, NULL, '2022-01-17 12:45:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/51', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (507, 10, 'jobs', 51, NULL, '2022-01-17 12:46:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/51', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (508, 10, 'jobs', 51, NULL, '2022-01-17 13:03:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/51', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (509, 10, 'jobs', 50, NULL, '2022-01-17 13:04:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/50', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (510, 10, 'jobs', 51, NULL, '2022-01-17 13:05:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/51', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (513, 10, 'jobs', 49, NULL, '2022-01-17 14:11:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/49', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (514, 10, 'jobs', 52, NULL, '2022-01-17 14:48:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (515, 10, 'jobs', 52, NULL, '2022-01-17 14:51:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (516, 10, 'equipment', 16, NULL, '2022-01-17 16:12:38', 'fa-suitcase', 'admin/equipment/view_equipment_details/16', 'NP210010', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (517, 10, 'equipment', 16, NULL, '2022-01-17 16:13:38', 'fa-suitcase', 'admin/equipment/view_equipment_details/16', 'NP210010', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (518, 10, 'equipment', 17, NULL, '2022-01-17 16:20:15', 'fa-suitcase', 'admin/equipment/view_equipment_details/17', 'NP210011', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (519, 10, 'equipment', 18, NULL, '2022-01-17 16:22:24', 'fa-suitcase', 'admin/equipment/view_equipment_details/18', 'NP210014', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (520, 10, 'equipment', 19, NULL, '2022-01-17 16:23:54', 'fa-suitcase', 'admin/equipment/view_equipment_details/19', 'NP210006', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (521, 10, 'equipment', 20, NULL, '2022-01-17 16:25:28', 'fa-suitcase', 'admin/equipment/view_equipment_details/20', 'NP210008', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (522, 10, 'equipment', 21, NULL, '2022-01-17 16:25:29', 'fa-suitcase', 'admin/equipment/view_equipment_details/21', 'NP210008', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (523, 10, 'equipment', 22, NULL, '2022-01-17 16:27:44', 'fa-suitcase', 'admin/equipment/view_equipment_details/22', 'NP210002', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (524, 10, 'equipment', 23, NULL, '2022-01-17 16:30:06', 'fa-suitcase', 'admin/equipment/view_equipment_details/23', 'NP210004', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (525, 10, 'equipment', 11, NULL, '2022-01-17 16:31:57', 'fa-suitcase', 'admin/equipment/view_equipment_details/11', 'NP210005', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (526, 10, 'equipment', 24, NULL, '2022-01-17 16:35:51', 'fa-suitcase', 'admin/equipment/view_equipment_details/24', 'NP210012', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (527, 10, 'equipment', 20, 'activity_delete_equipment', '2022-01-17 18:33:54', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (528, 10, 'jobs', 53, NULL, '2022-01-17 18:43:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/53', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (529, 10, 'jobs', 53, NULL, '2022-01-17 18:47:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/53', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (530, 10, 'jobs', 53, NULL, '2022-01-17 18:47:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/53', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (531, 10, 'jobs', 53, NULL, '2022-01-17 18:48:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/53', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (532, 10, 'jobs', 53, 'activity_delete_jobs', '2022-01-17 18:49:53', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (533, 10, 'equipment', 25, NULL, '2022-01-17 19:53:30', 'fa-suitcase', 'admin/equipment/view_equipment_details/25', 'NP210007', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (534, 3, 'jobs', 51, NULL, '2022-01-17 20:24:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/51', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (535, 3, 'jobs', 52, NULL, '2022-01-17 20:30:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (546, 3, 'jobs', 51, NULL, '2022-01-18 10:14:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/51', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (547, 3, 'jobs', 52, NULL, '2022-01-18 10:17:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (548, 3, 'user', 3, 'activity_reset_password', '2022-01-18 10:22:50', 'fa-user', NULL, 'admin@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (549, 3, 'user', 1, 'activity_change_status', '2022-01-18 12:45:43', 'fa-user', NULL, 'admin Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (550, 3, 'user', 6, 'activity_change_status', '2022-01-18 12:45:46', 'fa-user', NULL, 'Rameez Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (551, 3, 'user', 7, 'activity_change_status', '2022-01-18 12:45:49', 'fa-user', NULL, 'Abdulwahab Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (552, 3, 'user', 10, 'activity_change_status', '2022-01-18 12:45:52', 'fa-user', NULL, 'KKIA Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (553, 3, 'user', 11, 'activity_change_status', '2022-01-18 12:45:53', 'fa-user', NULL, 'MPC Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (554, 3, 'user', 11, 'activity_change_status', '2022-01-18 23:42:54', 'fa-user', NULL, 'MPC Active', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (555, 3, 'user', 10, 'activity_change_status', '2022-01-18 23:43:01', 'fa-user', NULL, 'KKIA Active', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (556, 3, 'user', 6, 'activity_change_status', '2022-01-18 23:43:12', 'fa-user', NULL, 'Rameez Active', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (568, 3, 'jobs', 52, NULL, '2022-01-19 10:53:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (569, 3, 'user', 7, 'activity_change_status', '2022-01-19 11:09:37', 'fa-user', NULL, 'Abdulwahab Active', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (570, 3, 'user', 7, 'activity_change_status', '2022-01-19 11:10:40', 'fa-user', NULL, 'Abdulwahab Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (571, 10, 'jobs', 52, NULL, '2022-01-20 11:22:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (572, 10, 'equipment', 24, NULL, '2022-01-20 13:43:12', 'fa-suitcase', 'admin/equipment/view_equipment_details/24', 'NP210012', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (573, 10, 'equipment', 27, NULL, '2022-01-20 13:46:52', 'fa-suitcase', 'admin/equipment/view_equipment_details/27', 'NP210001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (574, 10, 'equipment', 11, 'activity_delete_equipment', '2022-01-20 13:52:44', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (575, 6, 'jobs', 52, NULL, '2022-01-22 13:48:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (576, 6, 'jobs', 52, NULL, '2022-01-22 13:51:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (577, 6, 'jobs', 52, NULL, '2022-01-22 14:08:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (578, 6, 'jobs', 52, NULL, '2022-01-22 14:19:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (579, 6, 'problems', 0, 'activity_delete_problems', '2022-01-22 14:26:40', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (580, 6, 'jobs', 52, NULL, '2022-01-22 14:27:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (581, 6, 'jobs', 52, NULL, '2022-01-22 14:28:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (582, 6, 'jobs', 52, NULL, '2022-01-22 14:31:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (583, 6, 'jobs', 52, NULL, '2022-01-22 14:32:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (584, 6, 'jobs', 52, NULL, '2022-01-22 14:45:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (585, 6, 'jobs', 52, NULL, '2022-01-22 14:50:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (586, 6, 'jobs', 52, NULL, '2022-01-22 14:53:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (587, 6, 'jobs', 52, NULL, '2022-01-22 14:57:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (588, 6, 'user', 7, 'activity_change_status', '2022-01-22 15:11:47', 'fa-user', NULL, 'Abdulwahab Active', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (590, 10, 'jobs', 52, NULL, '2022-01-23 13:09:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (591, 3, 'jobs', 54, NULL, '2022-01-29 15:37:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/54', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (593, 6, 'jobs', 52, NULL, '2022-01-31 08:36:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/52', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (594, 6, 'problems', 0, 'activity_delete_problems', '2022-01-31 08:38:51', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (595, 3, 'jobs', 55, NULL, '2022-02-04 23:17:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (596, 3, 'jobs', 55, NULL, '2022-02-04 23:20:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (597, 3, 'jobs', 54, NULL, '2022-02-04 23:21:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/54', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (598, 3, 'jobs', 55, NULL, '2022-02-04 23:23:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (599, 3, 'jobs', 55, NULL, '2022-02-04 23:24:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (600, 3, 'jobs', 56, NULL, '2022-02-04 23:33:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/56', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (601, 3, 'jobs', 20, 'activity_delete_jobs', '2022-02-05 00:19:05', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (602, 3, 'jobs', 20, 'activity_delete_jobs', '2022-02-05 00:19:08', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (603, 3, 'jobs', 19, 'activity_delete_jobs', '2022-02-05 00:19:13', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (604, 3, 'jobs', 57, NULL, '2022-02-05 13:09:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (605, 3, 'jobs', 57, NULL, '2022-02-05 13:11:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (606, 6, 'jobs', 57, NULL, '2022-02-05 13:14:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (607, 6, 'jobs', 57, NULL, '2022-02-05 13:14:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (608, 6, 'jobs', 57, NULL, '2022-02-05 13:33:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (609, 6, 'problems', 0, 'activity_delete_problems', '2022-02-05 13:36:08', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (610, 6, 'jobs', 57, NULL, '2022-02-05 13:42:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (611, 6, 'jobs', 57, NULL, '2022-02-05 13:49:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (612, 6, 'jobs', 57, NULL, '2022-02-05 13:50:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (613, 6, 'departments', NULL, 'activity_added_a_department', '2022-02-05 13:55:49', 'fa-coffee', NULL, 'Workshop', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (614, 6, 'user', 13, 'activity_added_new_user', '2022-02-05 13:55:56', 'fa-user', NULL, 'Gaurav', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (615, 6, 'jobs', 57, NULL, '2022-02-05 13:56:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (616, 3, 'jobs', 57, NULL, '2022-02-05 17:55:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (617, 6, 'jobs', 57, NULL, '2022-02-06 09:41:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (618, 6, 'jobs', 57, NULL, '2022-02-06 09:42:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (619, 6, 'jobs', 57, NULL, '2022-02-06 10:40:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (620, 6, 'jobs', 57, NULL, '2022-02-06 11:03:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/57', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (621, 3, 'jobs', 57, 'activity_delete_jobs', '2022-02-06 16:59:54', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (622, 3, 'jobs', 56, 'activity_delete_jobs', '2022-02-06 17:00:05', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (623, 3, 'jobs', 55, NULL, '2022-02-06 17:00:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (624, 3, 'problems', 10, 'activity_delete_problems', '2022-02-06 17:01:03', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (625, 3, 'jobs', 55, NULL, '2022-02-06 17:03:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (626, 3, 'jobs', 55, NULL, '2022-02-06 19:53:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (627, 3, 'jobs', 54, NULL, '2022-02-06 20:36:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/54', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (628, 3, 'jobs', 55, NULL, '2022-02-06 21:43:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (629, 3, 'departments', 5, 'activity_added_a_department', '2022-02-06 21:49:03', 'fa-coffee', NULL, 'Workshop', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (630, 3, 'departments', 5, 'activity_added_a_department', '2022-02-06 21:49:26', 'fa-coffee', NULL, 'Workshop', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (631, 3, 'departments', 5, 'activity_added_a_department', '2022-02-06 21:49:51', 'fa-coffee', NULL, 'Workshop', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (632, 3, 'departments', 5, 'activity_added_a_department', '2022-02-06 21:50:09', 'fa-coffee', NULL, 'Workshop', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (633, 3, 'departments', 5, 'activity_added_a_department', '2022-02-06 21:51:53', 'fa-coffee', NULL, 'Workshop', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (634, 3, 'problems', 9, 'activity_delete_problems', '2022-02-06 21:56:14', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (635, 3, 'problems', 8, 'activity_delete_problems', '2022-02-06 21:56:33', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (636, 6, 'jobs', 55, NULL, '2022-02-07 09:43:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (637, 6, 'jobs', 55, NULL, '2022-02-08 09:34:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (638, 6, 'jobs', 55, NULL, '2022-02-08 09:35:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (639, 6, 'jobs', 55, NULL, '2022-02-08 09:38:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (640, 6, 'jobs', 55, NULL, '2022-02-08 13:34:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (641, 3, 'equipment', 27, 'activity_delete_equipment', '2022-02-08 22:46:45', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (642, 3, 'problems', 7, 'activity_delete_problems', '2022-02-08 22:47:44', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (643, 3, 'jobs', 58, NULL, '2022-02-08 22:49:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/58', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (644, 3, 'departments', 5, 'activity_added_a_department', '2022-02-08 22:54:46', 'fa-coffee', NULL, 'Workshop', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (645, 6, 'jobs', 55, NULL, '2022-02-09 09:21:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (646, 6, 'problems', 0, 'activity_delete_problems', '2022-02-09 09:44:42', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (647, 6, 'problems', 0, 'activity_delete_problems', '2022-02-09 09:44:48', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (648, 6, 'problems', 0, 'activity_delete_problems', '2022-02-09 09:45:10', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (649, 6, 'problems', 0, 'activity_delete_problems', '2022-02-09 09:45:11', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (650, 6, 'problems', 0, 'activity_delete_problems', '2022-02-09 09:46:43', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (651, 3, 'jobs', 9, NULL, '2022-02-09 20:50:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/9', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (652, 3, 'departments', 5, 'activity_added_a_department', '2022-02-09 20:54:49', 'fa-coffee', NULL, 'Workshop', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (653, 3, 'departments', 5, 'activity_added_a_department', '2022-02-09 20:54:50', 'fa-coffee', NULL, 'Workshop', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (654, 3, 'departments', 5, 'activity_added_a_department', '2022-02-09 20:54:51', 'fa-coffee', NULL, 'Workshop', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (655, 3, 'jobs', 59, NULL, '2022-02-09 20:57:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/59', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (656, 6, 'jobs', 55, NULL, '2022-02-10 10:17:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (657, 6, 'jobs', 55, NULL, '2022-02-13 13:49:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (658, 6, 'jobs', 55, NULL, '2022-02-13 13:52:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (659, 6, 'jobs', 54, NULL, '2022-02-13 13:53:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/54', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (660, 10, 'jobs', 54, NULL, '2022-02-16 13:37:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/54', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (661, 10, 'jobs', 55, NULL, '2022-02-16 13:39:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (662, 10, 'jobs', 54, NULL, '2022-02-16 13:40:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/54', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (663, 10, 'jobs', 60, NULL, '2022-02-16 13:44:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/60', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (664, 10, 'jobs', 60, NULL, '2022-02-16 13:49:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/60', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (665, 10, 'jobs', 61, NULL, '2022-02-16 13:55:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/61', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (666, 10, 'jobs', 61, NULL, '2022-02-16 13:55:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/61', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (667, 10, 'jobs', 62, NULL, '2022-02-16 14:05:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/62', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (668, 10, 'jobs', 62, NULL, '2022-02-16 14:06:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/62', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (669, 10, 'jobs', 62, NULL, '2022-02-16 14:18:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/62', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (670, 10, 'jobs', 62, NULL, '2022-02-16 14:32:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/62', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (671, 10, 'jobs', 63, NULL, '2022-02-16 15:20:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/63', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (672, 10, 'jobs', 63, 'activity_delete_jobs', '2022-02-16 15:25:06', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (673, 10, 'jobs', 64, NULL, '2022-02-16 15:27:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/64', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (674, 10, 'jobs', 64, 'activity_delete_jobs', '2022-02-16 15:39:49', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (675, 10, 'jobs', 65, NULL, '2022-02-16 15:44:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/65', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (676, 10, 'jobs', 65, NULL, '2022-02-16 15:46:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/65', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (677, 10, 'jobs', 65, NULL, '2022-02-16 15:51:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/65', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (678, 10, 'jobs', 65, NULL, '2022-02-16 15:52:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/65', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (679, 10, 'jobs', 65, NULL, '2022-02-16 16:45:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/65', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (680, 6, 'jobs', 61, NULL, '2022-02-17 10:49:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/61', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (681, 6, 'jobs', 55, NULL, '2022-02-17 10:53:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/55', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (682, 6, 'jobs', 54, NULL, '2022-02-17 10:53:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/54', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (683, 6, 'jobs', 65, NULL, '2022-02-17 10:55:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/65', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (684, 6, 'jobs', 65, NULL, '2022-02-17 10:56:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/65', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (685, 6, 'jobs', 65, NULL, '2022-02-17 10:57:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/65', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (686, 6, 'jobs', 65, NULL, '2022-02-17 10:57:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/65', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (687, 6, 'jobs', 62, NULL, '2022-02-17 10:58:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/62', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (688, 10, 'jobs', 65, NULL, '2022-02-17 11:50:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/65', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (689, 10, 'jobs', 65, NULL, '2022-02-17 11:52:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/65', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (690, 10, 'jobs', 66, NULL, '2022-02-17 12:00:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/66', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (691, 10, 'jobs', 66, NULL, '2022-02-17 12:20:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/66', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (692, 10, 'jobs', 66, NULL, '2022-02-17 12:36:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/66', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (693, 3, 'user', 3, 'activity_reset_password', '2022-02-22 10:33:57', 'fa-user', NULL, 'admin@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (694, 6, 'user', 7, 'activity_added_new_user', '2022-02-22 14:23:10', 'fa-user', NULL, 'Abdulwahab', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (695, 10, 'jobs', 67, NULL, '2022-02-23 07:55:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/67', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (696, 10, 'jobs', 67, NULL, '2022-02-23 10:23:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/67', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (697, 10, 'jobs', 67, NULL, '2022-02-23 10:31:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/67', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (698, 10, 'jobs', 67, NULL, '2022-02-23 11:46:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/67', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (699, 10, 'jobs', 67, NULL, '2022-02-23 11:50:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/67', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (700, 6, 'jobs', 67, NULL, '2022-02-23 13:11:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/67', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (701, 10, 'jobs', 68, NULL, '2022-02-23 17:40:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/68', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (702, 10, 'jobs', 69, NULL, '2022-02-23 17:44:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/69', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (703, 10, 'jobs', 69, NULL, '2022-02-23 17:48:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/69', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (704, 10, 'jobs', 69, NULL, '2022-02-23 17:51:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/69', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (705, 10, 'jobs', 69, NULL, '2022-02-23 18:39:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/69', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (706, 10, 'jobs', 69, NULL, '2022-02-23 18:41:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/69', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (707, 10, 'jobs', 69, NULL, '2022-02-23 18:44:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/69', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (708, 10, 'jobs', 68, 'activity_delete_jobs', '2022-02-23 18:45:51', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (709, 10, 'jobs', 69, NULL, '2022-02-23 18:54:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/69', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (710, 10, 'jobs', 69, NULL, '2022-02-23 18:55:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/69', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (711, 10, 'jobs', 69, NULL, '2022-02-23 19:01:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/69', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (712, 10, 'jobs', 69, NULL, '2022-02-23 19:13:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/69', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (713, 10, 'jobs', 69, NULL, '2022-02-23 19:17:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/69', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (714, 10, 'jobs', 70, NULL, '2022-02-24 08:45:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/70', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (715, 10, 'jobs', 70, NULL, '2022-02-24 09:24:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/70', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (716, 10, 'jobs', 67, NULL, '2022-02-24 09:56:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/67', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (717, 10, 'jobs', 67, NULL, '2022-02-24 10:11:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/67', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (718, 10, 'jobs', 71, NULL, '2022-02-24 10:19:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/71', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (719, 10, 'jobs', 72, NULL, '2022-02-24 14:14:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/72', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (720, 10, 'jobs', 71, NULL, '2022-02-24 14:28:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/71', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (721, 10, 'jobs', 70, NULL, '2022-02-24 14:29:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/70', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (722, 10, 'jobs', 70, NULL, '2022-02-24 15:19:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/70', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (723, 10, 'jobs', 70, NULL, '2022-02-24 15:19:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/70', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (724, 10, 'jobs', 70, NULL, '2022-02-24 15:52:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/70', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (725, 10, 'jobs', 72, NULL, '2022-02-24 15:55:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/72', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (726, 10, 'jobs', 72, NULL, '2022-02-24 15:57:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/72', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (727, 10, 'jobs', 59, 'activity_delete_jobs', '2022-02-24 16:04:16', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (728, 10, 'jobs', 59, 'activity_delete_jobs', '2022-02-24 16:04:22', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (729, 10, 'jobs', 59, 'activity_delete_jobs', '2022-02-24 16:04:31', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (730, 10, 'jobs', 51, 'activity_delete_jobs', '2022-02-24 16:05:07', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (731, 10, 'jobs', 50, 'activity_delete_jobs', '2022-02-24 16:05:27', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (732, 10, 'jobs', 49, 'activity_delete_jobs', '2022-02-24 16:05:37', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (733, 10, 'jobs', 13, 'activity_delete_jobs', '2022-02-24 16:05:42', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (734, 10, 'jobs', 12, 'activity_delete_jobs', '2022-02-24 16:05:46', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (735, 10, 'jobs', 11, 'activity_delete_jobs', '2022-02-24 16:05:55', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (736, 10, 'jobs', 10, 'activity_delete_jobs', '2022-02-24 16:05:59', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (737, 10, 'jobs', 9, 'activity_delete_jobs', '2022-02-24 16:06:02', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (738, 10, 'jobs', 27, 'activity_delete_jobs', '2022-02-24 16:06:12', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (739, 10, 'jobs', 26, 'activity_delete_jobs', '2022-02-24 16:06:13', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (740, 10, 'jobs', 22, 'activity_delete_jobs', '2022-02-24 16:06:15', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (741, 10, 'jobs', 21, 'activity_delete_jobs', '2022-02-24 16:06:17', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (742, 10, 'jobs', 25, 'activity_delete_jobs', '2022-02-24 16:06:42', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (743, 10, 'jobs', 24, 'activity_delete_jobs', '2022-02-24 16:06:51', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (744, 10, 'jobs', 23, 'activity_delete_jobs', '2022-02-24 16:06:59', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (745, 10, 'jobs', 18, 'activity_delete_jobs', '2022-02-24 16:07:13', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (746, 10, 'jobs', 17, 'activity_delete_jobs', '2022-02-24 16:07:24', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (747, 10, 'jobs', 14, 'activity_delete_jobs', '2022-02-24 16:07:30', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (748, 10, 'jobs', 35, 'activity_delete_jobs', '2022-02-24 16:07:39', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (749, 10, 'jobs', 38, 'activity_delete_jobs', '2022-02-24 16:07:49', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (750, 10, 'jobs', 36, 'activity_delete_jobs', '2022-02-24 16:07:51', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (751, 10, 'jobs', 35, 'activity_delete_jobs', '2022-02-24 16:07:53', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (752, 10, 'jobs', 34, 'activity_delete_jobs', '2022-02-24 16:08:03', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (753, 10, 'jobs', 33, 'activity_delete_jobs', '2022-02-24 16:08:11', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (754, 10, 'jobs', 32, 'activity_delete_jobs', '2022-02-24 16:08:13', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (755, 10, 'jobs', 29, 'activity_delete_jobs', '2022-02-24 16:08:21', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (756, 10, 'jobs', 31, 'activity_delete_jobs', '2022-02-24 16:08:30', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (757, 10, 'jobs', 30, 'activity_delete_jobs', '2022-02-24 16:08:42', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (758, 10, 'jobs', 29, 'activity_delete_jobs', '2022-02-24 16:08:44', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (759, 10, 'jobs', 28, 'activity_delete_jobs', '2022-02-24 16:08:46', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (760, 10, 'jobs', 42, 'activity_delete_jobs', '2022-02-24 16:09:01', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (761, 10, 'jobs', 43, 'activity_delete_jobs', '2022-02-24 16:09:08', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (762, 10, 'jobs', 44, 'activity_delete_jobs', '2022-02-24 16:09:17', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (763, 10, 'jobs', 45, 'activity_delete_jobs', '2022-02-24 16:09:30', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (764, 10, 'jobs', 47, 'activity_delete_jobs', '2022-02-24 16:09:35', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (765, 10, 'jobs', 54, 'activity_delete_jobs', '2022-02-24 16:10:17', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (766, 10, 'jobs', 55, 'activity_delete_jobs', '2022-02-24 16:10:27', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (767, 10, 'jobs', 58, 'activity_delete_jobs', '2022-02-24 16:10:36', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (768, 10, 'jobs', 60, 'activity_delete_jobs', '2022-02-24 16:11:00', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (769, 10, 'jobs', 61, 'activity_delete_jobs', '2022-02-24 16:11:10', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (770, 10, 'jobs', 65, 'activity_delete_jobs', '2022-02-24 16:12:18', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (771, 10, 'jobs', 65, 'activity_delete_jobs', '2022-02-24 16:12:26', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (772, 10, 'jobs', 48, 'activity_delete_jobs', '2022-02-24 16:13:00', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (773, 10, 'jobs', 52, 'activity_delete_jobs', '2022-02-24 16:13:12', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (774, 10, 'equipment', 28, NULL, '2022-02-24 18:18:45', 'fa-suitcase', 'admin/equipment/view_equipment_details/28', 'NP210001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (775, 10, 'jobs', 67, NULL, '2022-02-24 22:00:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/67', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (776, 10, 'jobs', 72, NULL, '2022-02-24 22:02:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/72', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (777, 6, 'jobs', 72, NULL, '2022-02-25 20:46:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/72', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (778, 6, 'jobs', 72, NULL, '2022-02-25 20:47:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/72', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (779, 6, 'user', 7, 'activity_added_new_user', '2022-02-25 20:57:03', 'fa-user', NULL, 'Abdulwahab', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (780, 10, 'jobs', 73, NULL, '2022-02-27 08:34:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/73', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (781, 10, 'jobs', 74, NULL, '2022-02-27 08:37:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/74', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (782, 10, 'jobs', 75, NULL, '2022-02-27 09:02:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/75', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (783, 10, 'jobs', 75, NULL, '2022-02-27 09:05:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/75', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (784, 10, 'jobs', 76, NULL, '2022-02-27 09:07:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/76', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (785, 10, 'jobs', 75, NULL, '2022-02-27 09:07:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/75', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (786, 10, 'jobs', 74, NULL, '2022-02-27 09:30:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/74', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (787, 10, 'jobs', 74, NULL, '2022-02-27 09:33:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/74', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (788, 10, 'jobs', 74, NULL, '2022-02-27 09:35:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/74', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (789, 10, 'jobs', 73, NULL, '2022-02-27 09:36:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/73', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (790, 10, 'jobs', 72, NULL, '2022-02-27 09:45:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/72', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (791, 10, 'jobs', 67, NULL, '2022-02-27 09:52:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/67', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (792, 10, 'jobs', 76, NULL, '2022-02-27 10:02:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/76', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (793, 10, 'jobs', 76, NULL, '2022-02-27 10:08:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/76', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (794, 10, 'jobs', 75, NULL, '2022-02-27 10:09:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/75', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (795, 10, 'jobs', 76, NULL, '2022-02-27 10:19:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/76', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (796, 10, 'jobs', 75, NULL, '2022-02-27 10:20:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/75', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (797, 10, 'jobs', 77, NULL, '2022-02-27 17:24:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/77', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (798, 10, 'jobs', 77, 'activity_delete_jobs', '2022-02-27 17:28:13', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (799, 10, 'jobs', 78, NULL, '2022-02-28 08:38:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/78', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (800, 10, 'jobs', 79, NULL, '2022-02-28 08:40:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/79', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (801, 10, 'jobs', 79, NULL, '2022-02-28 10:17:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/79', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (802, 10, 'jobs', 78, NULL, '2022-02-28 10:50:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/78', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (803, 10, 'jobs', 80, NULL, '2022-03-01 08:42:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/80', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (804, 10, 'jobs', 81, NULL, '2022-03-01 08:45:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/81', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (805, 10, 'jobs', 81, NULL, '2022-03-01 11:29:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/81', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (806, 10, 'jobs', 80, NULL, '2022-03-01 11:36:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/80', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (807, 10, 'jobs', 76, NULL, '2022-03-01 11:40:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/76', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (808, 10, 'jobs', 76, NULL, '2022-03-01 11:41:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/76', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (809, 10, 'jobs', 75, NULL, '2022-03-01 11:42:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/75', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (822, 10, 'jobs', 82, NULL, '2022-03-03 09:49:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/82', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (823, 10, 'jobs', 82, NULL, '2022-03-03 12:45:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/82', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (824, 10, 'jobs', 82, NULL, '2022-03-03 12:53:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/82', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (825, 10, 'jobs', 82, NULL, '2022-03-03 12:57:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/82', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (826, 10, 'jobs', 82, NULL, '2022-03-03 14:41:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/82', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (875, 10, 'jobs', 83, NULL, '2022-03-07 08:49:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/83', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (876, 10, 'jobs', 84, NULL, '2022-03-07 09:07:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/84', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (877, 10, 'jobs', 84, NULL, '2022-03-07 11:31:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/84', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (878, 10, 'jobs', 81, NULL, '2022-03-07 11:47:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/81', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (879, 10, 'jobs', 83, NULL, '2022-03-07 11:49:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/83', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (880, 10, 'jobs', 84, NULL, '2022-03-07 11:50:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/84', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (881, 10, 'jobs', 75, NULL, '2022-03-07 11:51:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/75', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (882, 10, 'equipment', 29, NULL, '2022-03-07 11:57:01', 'fa-suitcase', 'admin/equipment/view_equipment_details/29', 'NP210001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (883, 10, 'jobs', 85, NULL, '2022-03-07 11:59:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/85', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (884, 10, 'jobs', 83, NULL, '2022-03-07 12:31:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/83', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (885, 6, 'departments', 3, 'activity_added_a_department', '2022-03-08 12:28:43', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (886, 6, 'user', 10, 'activity_added_new_user', '2022-03-08 12:29:21', 'fa-user', NULL, 'KKIA', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (887, 10, 'jobs', 84, NULL, '2022-03-08 13:04:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/84', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (888, 10, 'jobs', 84, NULL, '2022-03-08 13:05:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/84', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (889, 10, 'jobs', 85, NULL, '2022-03-08 13:09:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/85', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (890, 10, 'jobs', 85, NULL, '2022-03-08 13:11:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/85', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (891, 10, 'jobs', 84, NULL, '2022-03-08 13:11:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/84', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (892, 10, 'jobs', 86, NULL, '2022-03-08 17:11:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/86', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (893, 10, 'jobs', 86, NULL, '2022-03-08 17:11:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/86', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (894, 10, 'jobs', 86, 'activity_delete_jobs', '2022-03-08 17:15:27', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (895, 10, 'jobs', 86, 'activity_delete_jobs', '2022-03-08 17:15:29', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (896, 10, 'jobs', 87, NULL, '2022-03-08 17:16:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/87', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (897, 10, 'jobs', 84, NULL, '2022-03-08 17:23:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/84', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (898, 10, 'jobs', 87, 'activity_delete_jobs', '2022-03-08 17:26:02', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (899, 6, 'user', 10, 'activity_added_new_user', '2022-03-09 08:27:25', 'fa-user', NULL, 'KKIA', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (900, 10, 'jobs', 88, NULL, '2022-03-09 09:27:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/88', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (901, 6, 'jobs', 88, NULL, '2022-03-09 11:05:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/88', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (902, 6, 'jobs', 84, NULL, '2022-03-09 11:05:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/84', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (903, 10, 'jobs', 88, NULL, '2022-03-09 11:55:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/88', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (904, 10, 'jobs', 89, NULL, '2022-03-10 08:21:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/89', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (905, 10, 'jobs', 89, NULL, '2022-03-10 09:53:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/89', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (906, 10, 'jobs', 89, NULL, '2022-03-10 09:54:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/89', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (907, 10, 'jobs', 90, NULL, '2022-03-10 16:36:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/90', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (908, 10, 'jobs', 90, 'activity_delete_jobs', '2022-03-10 16:41:00', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (909, 10, 'jobs', 72, NULL, '2022-03-13 11:54:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/72', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (910, 10, 'jobs', 73, NULL, '2022-03-14 11:03:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/73', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (911, 10, 'jobs', 70, NULL, '2022-03-14 11:09:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/70', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (912, 6, 'jobs', 89, NULL, '2022-03-14 13:04:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/89', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (913, 10, 'jobs', 91, NULL, '2022-03-15 12:41:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/91', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (914, 10, 'jobs', 91, NULL, '2022-03-15 12:45:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/91', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (915, 10, 'equipment', 30, NULL, '2022-03-15 12:49:04', 'fa-suitcase', 'admin/equipment/view_equipment_details/30', 'NON REVENUE', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (916, 10, 'jobs', 92, NULL, '2022-03-15 12:52:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/92', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (917, 10, 'jobs', 89, NULL, '2022-03-15 12:55:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/89', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (918, 10, 'jobs', 85, NULL, '2022-03-15 12:56:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/85', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (919, 10, 'jobs', 91, NULL, '2022-03-16 08:54:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/91', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (920, 10, 'jobs', 93, NULL, '2022-03-16 09:07:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/93', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (921, 10, 'jobs', 91, NULL, '2022-03-16 09:19:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/91', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (922, 10, 'jobs', 93, NULL, '2022-03-16 14:49:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/93', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (923, 10, 'jobs', 93, NULL, '2022-03-16 14:51:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/93', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (924, 10, 'jobs', 94, NULL, '2022-03-21 08:56:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/94', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (925, 10, 'jobs', 95, NULL, '2022-03-21 09:25:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/95', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (926, 10, 'jobs', 95, NULL, '2022-03-21 09:29:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/95', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (927, 10, 'jobs', 92, NULL, '2022-03-21 09:46:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/92', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (928, 10, 'jobs', 95, NULL, '2022-03-21 09:54:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/95', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (930, 10, 'jobs', 96, NULL, '2022-03-21 10:32:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/96', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (931, 6, 'departments', 3, 'activity_added_a_department', '2022-03-21 10:34:00', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (932, 6, 'departments', 3, 'activity_added_a_department', '2022-03-21 10:35:40', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (933, 6, 'departments', 3, 'activity_added_a_department', '2022-03-21 10:36:27', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (934, 6, 'departments', 3, 'activity_added_a_department', '2022-03-21 10:36:54', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (935, 6, 'jobs', 96, NULL, '2022-03-21 10:38:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/96', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (936, 6, 'jobs', 89, NULL, '2022-03-21 10:39:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/89', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (937, 6, 'jobs', 89, NULL, '2022-03-21 10:44:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/89', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (938, 10, 'jobs', 96, NULL, '2022-03-21 10:47:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/96', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (939, 6, 'jobs', 88, NULL, '2022-03-21 10:48:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/88', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (940, 6, 'jobs', 88, NULL, '2022-03-21 10:50:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/88', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (941, 10, 'jobs', 97, NULL, '2022-03-21 10:53:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/97', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (942, 10, 'jobs', 97, NULL, '2022-03-21 10:57:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/97', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (943, 10, 'jobs', 95, NULL, '2022-03-21 13:48:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/95', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (944, 10, 'jobs', 95, NULL, '2022-03-21 13:54:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/95', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (945, 10, 'jobs', 98, NULL, '2022-03-22 08:26:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/98', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (946, 10, 'jobs', 98, NULL, '2022-03-22 08:30:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/98', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (947, 10, 'jobs', 99, NULL, '2022-03-22 08:38:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/99', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (948, 10, 'jobs', 99, NULL, '2022-03-22 08:44:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/99', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (949, 10, 'jobs', 100, NULL, '2022-03-22 08:48:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/100', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (950, 10, 'client', 3, 'activity_added_new_company', '2022-03-22 09:00:39', 'fa-user', NULL, 'SAEI', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (951, 10, 'client', 3, 'activity_added_new_company', '2022-03-22 09:08:48', 'fa-user', NULL, 'SAEI', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (952, 10, 'jobs', 101, NULL, '2022-03-22 09:21:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/101', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (953, 10, 'jobs', 102, NULL, '2022-03-22 09:28:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/102', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (954, 10, 'jobs', 103, NULL, '2022-03-22 09:33:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/103', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (955, 10, 'jobs', 104, NULL, '2022-03-22 09:39:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/104', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (956, 10, 'jobs', 105, NULL, '2022-03-22 09:55:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/105', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (957, 10, 'jobs', 105, NULL, '2022-03-22 09:59:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/105', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (958, 10, 'jobs', 106, NULL, '2022-03-22 10:13:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/106', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (959, 10, 'jobs', 106, NULL, '2022-03-22 13:45:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/106', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (960, 10, 'jobs', 106, NULL, '2022-03-22 13:59:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/106', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (961, 6, 'user', 7, 'activity_added_new_user', '2022-03-22 14:48:05', 'fa-user', NULL, 'Abdulwahab', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (962, 10, 'jobs', 107, NULL, '2022-03-23 08:27:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/107', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (963, 10, 'jobs', 108, NULL, '2022-03-23 09:11:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/108', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (964, 10, 'jobs', 108, NULL, '2022-03-23 09:15:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/108', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (965, 10, 'jobs', 109, NULL, '2022-03-23 09:31:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/109', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (966, 10, 'jobs', 109, NULL, '2022-03-23 10:02:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/109', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (967, 10, 'jobs', 110, NULL, '2022-03-23 10:11:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/110', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (968, 10, 'jobs', 110, NULL, '2022-03-23 10:15:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/110', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (969, 10, 'jobs', 110, NULL, '2022-03-23 10:18:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/110', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (970, 10, 'jobs', 111, NULL, '2022-03-23 10:23:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/111', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (971, 10, 'jobs', 111, NULL, '2022-03-23 10:28:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/111', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (972, 10, 'jobs', 110, NULL, '2022-03-23 10:32:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/110', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (973, 10, 'jobs', 110, NULL, '2022-03-23 10:34:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/110', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (981, 10, 'jobs', 112, NULL, '2022-03-24 11:27:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/112', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (995, 6, 'jobs', 112, NULL, '2022-03-31 10:02:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/112', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (996, 6, 'jobs', 112, NULL, '2022-03-31 10:17:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/112', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (997, 6, 'jobs', 111, NULL, '2022-03-31 10:17:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/111', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (998, 6, 'jobs', 111, NULL, '2022-03-31 10:21:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/111', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (999, 6, 'user', 7, 'activity_added_new_user', '2022-03-31 10:25:04', 'fa-user', NULL, 'Abdulwahab', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1000, 6, 'departments', 3, 'activity_added_a_department', '2022-03-31 10:25:55', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1001, 6, 'departments', 3, 'activity_added_a_department', '2022-03-31 10:30:43', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1002, 6, 'user', 10, 'activity_added_new_user', '2022-03-31 10:38:23', 'fa-user', NULL, 'KKIA', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1003, 6, 'departments', 5, 'activity_added_a_department', '2022-03-31 10:39:47', 'fa-coffee', NULL, 'Workshop', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1004, 6, 'departments', 3, 'activity_delete_a_designation', '2022-03-31 10:44:58', 'fa-coffee', NULL, 'STAFFF', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1005, 6, 'departments', 2, 'activity_delete_a_designation', '2022-03-31 10:45:01', 'fa-coffee', NULL, 'STAFFF', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1006, 6, 'user', 14, 'activity_added_new_user', '2022-03-31 10:46:41', 'fa-user', NULL, 'staff', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1007, 6, 'client', 6, 'activity_deleted_client', '2022-03-31 10:47:59', 'fa-user', NULL, 'Ashrith', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1008, 6, 'departments', 3, 'activity_added_a_department', '2022-03-31 10:49:00', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1009, 6, 'departments', 3, 'activity_added_a_department', '2022-03-31 17:36:31', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1010, 6, 'user', 7, 'activity_added_new_user', '2022-04-03 12:53:40', 'fa-user', NULL, 'Abdulwahab', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1017, 6, 'jobs', 112, NULL, '2022-04-05 15:24:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/112', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1018, 6, 'departments', 3, 'activity_added_a_department', '2022-04-05 15:28:31', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1019, 6, 'departments', 3, 'activity_added_a_department', '2022-04-05 15:31:46', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1020, 6, 'departments', 3, 'activity_added_a_department', '2022-04-05 15:33:38', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1021, 10, 'jobs', 113, NULL, '2022-04-06 05:53:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/113', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1022, 10, 'jobs', 113, NULL, '2022-04-06 05:54:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/113', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1023, 10, 'jobs', 113, NULL, '2022-04-06 05:55:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/113', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1024, 10, 'jobs', 113, 'activity_delete_jobs', '2022-04-06 05:57:40', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1025, 10, 'jobs', 114, NULL, '2022-04-06 08:50:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/114', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1026, 10, 'jobs', 115, NULL, '2022-04-06 08:58:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/115', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1027, 10, 'jobs', 115, NULL, '2022-04-06 09:02:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/115', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1028, 10, 'jobs', 116, NULL, '2022-04-06 09:04:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/116', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1029, 10, 'jobs', 117, NULL, '2022-04-06 09:10:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/117', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1030, 10, 'jobs', 118, NULL, '2022-04-06 09:15:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/118', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1031, 10, 'jobs', 119, NULL, '2022-04-07 09:39:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/119', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1032, 10, 'jobs', 119, NULL, '2022-04-07 11:43:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/119', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1038, 10, 'jobs', 119, NULL, '2022-04-10 15:58:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/119', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1039, 10, 'jobs', 120, NULL, '2022-04-11 10:41:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/120', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1040, 10, 'jobs', 121, NULL, '2022-04-11 11:40:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/121', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1041, 10, 'jobs', 120, NULL, '2022-04-11 12:00:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/120', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1042, 10, 'jobs', 122, NULL, '2022-04-11 17:06:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/122', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1043, 10, 'jobs', 122, NULL, '2022-04-11 17:08:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/122', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1044, 10, 'jobs', 122, NULL, '2022-04-11 17:11:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/122', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1045, 10, 'jobs', 122, NULL, '2022-04-11 17:53:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/122', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1047, 10, 'jobs', 122, NULL, '2022-04-11 17:55:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/122', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1049, 10, 'client', 1, 'activity_added_new_company', '2022-04-12 11:31:03', 'fa-user', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1050, 10, 'client', 1, 'activity_added_new_company', '2022-04-12 11:31:04', 'fa-user', NULL, 'NPCO', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1051, 10, 'jobs', 123, NULL, '2022-04-12 11:32:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/123', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1052, 10, 'jobs', 123, 'activity_delete_jobs', '2022-04-12 11:41:04', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1053, 10, 'jobs', 123, 'activity_delete_jobs', '2022-04-12 11:41:17', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1054, 6, 'settings', 6, 'activity_save_invoice_settings', '2022-04-12 14:03:41', 'fa-coffee', NULL, 'SAR', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1055, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:07:42', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1056, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:11:36', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1057, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:11:56', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1058, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:13:20', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1059, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:15:22', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1060, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:16:41', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1061, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:17:54', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1062, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:19:30', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1063, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:19:43', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1064, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:20:15', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1065, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:20:33', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1066, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:21:01', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1067, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:25:05', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1068, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:30:23', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1069, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:31:06', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1070, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:32:36', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1071, 6, 'settings', 6, 'activity_save_theme_settings', '2022-04-12 14:33:28', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1079, 6, 'supplier', 1, 'save_supplier', '2022-04-13 12:48:14', 'fa-circle-o', NULL, 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1080, 6, 'purchase', 1, 'purchase_created', '2022-04-13 12:50:08', 'fa fa-truck', 'admin/purchase/purchase_details/1', '[INV]-2022-Apr-13-0001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1081, 6, 'purchase', 2, 'purchase_created', '2022-04-13 12:50:09', 'fa fa-truck', 'admin/purchase/purchase_details/2', '[INV]-2022-Apr-13-0001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1082, 6, 'purchase', 2, 'activity_delete_purchase', '2022-04-13 12:52:30', 'fa fa-truck', NULL, '[INV]-2022-Apr-13-0001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1083, 7, 'jobs', 122, NULL, '2022-04-13 13:36:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/122', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1084, 7, 'jobs', 120, NULL, '2022-04-13 13:37:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/120', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1085, 7, 'equipment', 31, NULL, '2022-04-13 13:42:13', 'fa-suitcase', 'admin/equipment/view_equipment_details/31', '123', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1086, 7, 'equipment', 31, 'activity_delete_equipment', '2022-04-13 13:43:03', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1087, 7, 'jobs', 120, NULL, '2022-04-13 13:44:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/120', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1088, 7, 'jobs', 62, NULL, '2022-04-13 13:47:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/62', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1089, 7, 'jobs', 118, NULL, '2022-04-13 13:48:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/118', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1114, 10, 'jobs', 119, NULL, '2022-04-14 13:07:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/119', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1115, 6, 'departments', 3, 'activity_added_a_department', '2022-04-14 13:11:44', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1116, 6, 'departments', 3, 'activity_added_a_department', '2022-04-14 13:14:42', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1133, 10, 'jobs', 135, NULL, '2022-04-15 09:39:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/135', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1134, 10, 'jobs', 135, NULL, '2022-04-15 09:42:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/135', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1135, 10, 'jobs', 135, NULL, '2022-04-15 09:45:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/135', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1161, 6, 'jobs', 135, NULL, '2022-04-15 15:00:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/135', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1165, 10, 'equipment', 29, NULL, '2022-04-16 10:31:41', 'fa-suitcase', 'admin/equipment/view_equipment_details/29', 'NP210001', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1168, 10, 'equipment', 22, NULL, '2022-04-16 10:34:05', 'fa-suitcase', 'admin/equipment/view_equipment_details/22', 'NP210002', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1169, 10, 'equipment', 12, NULL, '2022-04-16 10:38:10', 'fa-suitcase', 'admin/equipment/view_equipment_details/12', 'NP210003', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1170, 10, 'equipment', 23, NULL, '2022-04-16 10:39:09', 'fa-suitcase', 'admin/equipment/view_equipment_details/23', 'NP210004', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1171, 10, 'equipment', 13, NULL, '2022-04-16 10:40:39', 'fa-suitcase', 'admin/equipment/view_equipment_details/13', 'NP210005', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1172, 10, 'equipment', 19, NULL, '2022-04-16 10:42:26', 'fa-suitcase', 'admin/equipment/view_equipment_details/19', 'NP210006', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1173, 10, 'equipment', 25, NULL, '2022-04-16 10:42:43', 'fa-suitcase', 'admin/equipment/view_equipment_details/25', 'NP210007', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1174, 10, 'equipment', 21, NULL, '2022-04-16 10:43:03', 'fa-suitcase', 'admin/equipment/view_equipment_details/21', 'NP210008', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1175, 10, 'equipment', 18, NULL, '2022-04-16 10:43:27', 'fa-suitcase', 'admin/equipment/view_equipment_details/18', 'NP210014', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1176, 10, 'equipment', 10, NULL, '2022-04-16 10:43:47', 'fa-suitcase', 'admin/equipment/view_equipment_details/10', 'NP210012', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1177, 10, 'equipment', 24, NULL, '2022-04-16 10:44:01', 'fa-suitcase', 'admin/equipment/view_equipment_details/24', 'NP210012', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1178, 10, 'equipment', 9, NULL, '2022-04-16 10:44:29', 'fa-suitcase', 'admin/equipment/view_equipment_details/9', 'NP210009', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1179, 10, 'equipment', 16, NULL, '2022-04-16 10:44:52', 'fa-suitcase', 'admin/equipment/view_equipment_details/16', 'NP210010', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1180, 10, 'equipment', 17, NULL, '2022-04-16 10:45:09', 'fa-suitcase', 'admin/equipment/view_equipment_details/17', 'NP210011', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1181, 10, 'equipment', 30, NULL, '2022-04-16 10:54:37', 'fa-suitcase', 'admin/equipment/view_equipment_details/30', 'NON REVENUE', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1182, 10, 'equipment', 30, NULL, '2022-04-16 10:54:53', 'fa-suitcase', 'admin/equipment/view_equipment_details/30', 'NON REVENUE', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1183, 10, 'equipment', 30, NULL, '2022-04-16 10:55:22', 'fa-suitcase', 'admin/equipment/view_equipment_details/30', 'NON REVENUE', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1184, 10, 'equipment', 30, NULL, '2022-04-16 10:55:38', 'fa-suitcase', 'admin/equipment/view_equipment_details/30', 'NON REVENUE', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1186, 10, 'jobs', 135, NULL, '2022-04-17 09:32:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/135', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1187, 10, 'jobs', 135, NULL, '2022-04-17 09:33:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/135', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1188, 10, 'jobs', 135, NULL, '2022-04-17 09:36:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/135', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1189, 10, 'jobs', 135, NULL, '2022-04-17 11:54:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/135', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1190, 10, 'jobs', 137, NULL, '2022-04-17 11:55:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/137', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1191, 10, 'jobs', 137, 'activity_delete_jobs', '2022-04-17 11:56:32', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1192, 10, 'jobs', 137, 'activity_delete_jobs', '2022-04-17 11:56:50', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1193, 10, 'client', 7, 'activity_update_company', '2022-04-17 11:57:26', 'fa-user', NULL, 'SWISSPORT', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1194, 10, 'equipment', 32, NULL, '2022-04-17 12:03:40', 'fa-suitcase', 'admin/equipment/view_equipment_details/32', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1195, 10, 'equipment', 33, NULL, '2022-04-17 12:04:20', 'fa-suitcase', 'admin/equipment/view_equipment_details/33', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1196, 10, 'equipment', 34, NULL, '2022-04-17 12:05:08', 'fa-suitcase', 'admin/equipment/view_equipment_details/34', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1197, 10, 'equipment', 35, NULL, '2022-04-17 12:05:35', 'fa-suitcase', 'admin/equipment/view_equipment_details/35', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1198, 10, 'equipment', 36, NULL, '2022-04-17 12:06:01', 'fa-suitcase', 'admin/equipment/view_equipment_details/36', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1199, 10, 'equipment', 37, NULL, '2022-04-17 12:07:12', 'fa-suitcase', 'admin/equipment/view_equipment_details/37', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1200, 10, 'equipment', 38, NULL, '2022-04-17 12:08:08', 'fa-suitcase', 'admin/equipment/view_equipment_details/38', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1201, 10, 'equipment', 39, NULL, '2022-04-17 12:08:37', 'fa-suitcase', 'admin/equipment/view_equipment_details/39', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1202, 10, 'equipment', 40, NULL, '2022-04-17 12:09:06', 'fa-suitcase', 'admin/equipment/view_equipment_details/40', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1203, 10, 'equipment', 41, NULL, '2022-04-17 12:09:32', 'fa-suitcase', 'admin/equipment/view_equipment_details/41', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1204, 10, 'jobs', 135, NULL, '2022-04-17 15:02:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/135', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1205, 10, 'jobs', 135, NULL, '2022-04-17 22:48:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/135', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1208, 10, 'jobs', 138, NULL, '2022-04-19 09:18:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/138', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1209, 10, 'jobs', 139, NULL, '2022-04-19 10:08:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/139', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1210, 10, 'jobs', 140, NULL, '2022-04-19 10:29:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/140', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1211, 10, 'jobs', 141, NULL, '2022-04-19 10:30:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/141', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1212, 10, 'jobs', 142, NULL, '2022-04-19 10:34:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/142', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1213, 10, 'jobs', 143, NULL, '2022-04-19 10:36:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/143', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1214, 10, 'jobs', 143, NULL, '2022-04-20 10:39:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/143', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1215, 10, 'equipment', 42, NULL, '2022-04-22 04:43:55', 'fa-suitcase', 'admin/equipment/view_equipment_details/42', 'SP4002', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1216, 10, 'equipment', 42, 'activity_delete_equipment', '2022-04-22 04:44:26', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1217, 10, 'jobs', 144, NULL, '2022-04-22 04:49:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/144', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1218, 10, 'jobs', 144, NULL, '2022-04-22 04:52:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/144', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1219, 10, 'jobs', 144, NULL, '2022-04-22 05:11:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/144', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1220, 10, 'jobs', 144, 'activity_delete_jobs', '2022-04-22 05:45:05', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1221, 10, 'jobs', 145, NULL, '2022-04-22 06:08:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/145', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1222, 10, 'jobs', 145, NULL, '2022-04-22 06:20:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/145', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1223, 10, 'jobs', 145, NULL, '2022-04-22 06:27:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/145', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1224, 10, 'jobs', 145, NULL, '2022-04-22 06:29:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/145', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1225, 10, 'jobs', 145, NULL, '2022-04-22 06:30:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/145', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1226, 10, 'jobs', 145, NULL, '2022-04-22 06:34:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/145', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1227, 10, 'jobs', 146, NULL, '2022-04-22 06:35:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/146', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1228, 10, 'jobs', 146, 'activity_delete_jobs', '2022-04-22 06:36:52', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1229, 10, 'jobs', 147, NULL, '2022-04-24 09:39:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/147', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1230, 10, 'jobs', 148, NULL, '2022-04-24 09:41:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/148', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1231, 10, 'jobs', 148, NULL, '2022-04-24 11:31:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/148', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1232, 10, 'jobs', 148, NULL, '2022-04-24 11:36:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/148', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1233, 10, 'jobs', 148, NULL, '2022-04-24 11:40:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/148', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1234, 10, 'jobs', 147, NULL, '2022-04-25 11:41:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/147', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1235, 10, 'jobs', 149, NULL, '2022-04-26 08:56:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/149', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1236, 10, 'jobs', 149, NULL, '2022-04-26 10:43:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/149', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1237, 10, 'jobs', 149, NULL, '2022-04-26 10:45:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/149', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1238, 10, 'jobs', 149, NULL, '2022-04-26 15:08:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/149', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1239, 10, 'jobs', 150, NULL, '2022-04-27 09:37:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/150', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1240, 10, 'jobs', 150, NULL, '2022-04-27 11:11:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/150', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1241, 10, 'jobs', 151, NULL, '2022-04-28 09:37:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/151', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1242, 10, 'jobs', 151, NULL, '2022-04-28 09:37:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/151', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1243, 10, 'jobs', 152, NULL, '2022-04-28 09:56:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/152', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1244, 10, 'jobs', 153, NULL, '2022-04-29 07:02:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/153', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1245, 10, 'jobs', 153, 'activity_delete_jobs', '2022-04-29 07:07:15', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1246, 10, 'jobs', 152, NULL, '2022-04-29 07:08:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/152', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1247, 10, 'jobs', 152, NULL, '2022-04-29 07:09:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/152', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1248, 10, 'jobs', 154, NULL, '2022-05-05 16:32:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/154', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1249, 10, 'jobs', 154, NULL, '2022-05-05 16:47:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/154', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1250, 10, 'jobs', 155, NULL, '2022-05-05 21:50:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/155', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1251, 10, 'jobs', 155, NULL, '2022-05-05 21:51:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/155', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1252, 10, 'jobs', 154, NULL, '2022-05-05 21:54:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/154', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1253, 10, 'jobs', 154, NULL, '2022-05-05 21:56:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/154', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1254, 10, 'jobs', 154, NULL, '2022-05-08 22:15:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/154', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1255, 10, 'jobs', 155, NULL, '2022-05-08 22:22:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/155', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1256, 10, 'jobs', 154, NULL, '2022-05-09 16:44:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/154', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1257, 10, 'jobs', 155, NULL, '2022-05-09 16:45:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/155', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1258, 10, 'jobs', 156, NULL, '2022-05-09 18:51:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1259, 10, 'jobs', 156, NULL, '2022-05-09 18:53:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1260, 10, 'jobs', 156, NULL, '2022-05-09 21:05:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1261, 10, 'jobs', 156, NULL, '2022-05-11 20:45:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1262, 10, 'jobs', 156, NULL, '2022-05-11 20:54:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1263, 10, 'jobs', 156, NULL, '2022-05-11 20:57:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1264, 10, 'jobs', 156, NULL, '2022-05-12 09:32:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1265, 10, 'jobs', 156, NULL, '2022-05-12 09:33:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1266, 10, 'jobs', 156, NULL, '2022-05-12 09:34:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1268, 10, 'jobs', 156, NULL, '2022-05-15 14:20:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1269, 10, 'jobs', 156, NULL, '2022-05-15 14:20:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1270, 10, 'jobs', 156, NULL, '2022-05-15 14:22:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1271, 10, 'jobs', 156, NULL, '2022-05-15 14:52:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1272, 10, 'jobs', 156, NULL, '2022-05-15 15:33:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1273, 10, 'jobs', 156, NULL, '2022-05-15 15:38:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1274, 10, 'jobs', 156, NULL, '2022-05-15 17:06:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1275, 10, 'jobs', 156, NULL, '2022-05-15 17:06:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1276, 10, 'jobs', 156, NULL, '2022-05-15 17:06:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1277, 10, 'jobs', 157, NULL, '2022-05-15 22:58:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/157', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1278, 10, 'jobs', 158, NULL, '2022-05-15 23:00:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/158', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1279, 10, 'jobs', 158, 'activity_delete_jobs', '2022-05-15 23:00:30', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1280, 10, 'jobs', 159, NULL, '2022-05-15 23:01:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/159', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1281, 10, 'jobs', 159, 'activity_delete_jobs', '2022-05-15 23:02:05', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1282, 10, 'jobs', 145, NULL, '2022-05-16 14:42:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/145', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1283, 10, 'jobs', 145, NULL, '2022-05-16 15:00:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/145', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1284, 10, 'jobs', 160, NULL, '2022-05-16 15:01:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/160', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1285, 10, 'jobs', 161, NULL, '2022-05-16 15:04:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/161', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1286, 10, 'jobs', 161, 'activity_delete_jobs', '2022-05-16 15:04:39', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1287, 10, 'jobs', 161, 'activity_delete_jobs', '2022-05-16 15:04:43', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1288, 10, 'jobs', 162, NULL, '2022-05-16 15:05:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/162', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1289, 10, 'jobs', 162, 'activity_delete_jobs', '2022-05-16 15:17:28', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1290, 10, 'jobs', 160, 'activity_delete_jobs', '2022-05-16 15:17:39', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1291, 10, 'jobs', 157, 'activity_delete_jobs', '2022-05-16 15:17:54', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1292, 10, 'jobs', 156, NULL, '2022-05-16 17:06:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1293, 6, 'jobs', 156, NULL, '2022-05-16 17:10:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1294, 10, 'jobs', 163, NULL, '2022-05-16 19:19:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1295, 10, 'jobs', 163, NULL, '2022-05-16 19:21:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1296, 10, 'jobs', 163, NULL, '2022-05-16 19:24:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1297, 10, 'jobs', 163, NULL, '2022-05-16 19:46:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1298, 10, 'jobs', 163, NULL, '2022-05-16 19:47:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1299, 10, 'jobs', 163, NULL, '2022-05-16 19:48:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1300, 10, 'jobs', 163, NULL, '2022-05-17 17:34:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1301, 10, 'jobs', 156, NULL, '2022-05-17 17:38:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1302, 10, 'jobs', 155, NULL, '2022-05-17 17:39:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/155', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1303, 10, 'jobs', 154, NULL, '2022-05-17 17:39:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/154', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1304, 6, 'departments', NULL, 'activity_added_a_department', '2022-05-19 16:00:19', 'fa-coffee', NULL, 'Procurement Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1305, 6, 'departments', 6, 'activity_added_a_department', '2022-05-19 16:00:48', 'fa-coffee', NULL, 'Procurement Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1306, 6, 'departments', 6, 'activity_added_a_department', '2022-05-19 16:01:14', 'fa-coffee', NULL, 'Procurement Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1307, 6, 'user', 17, 'activity_added_new_user', '2022-05-19 16:02:43', 'fa-user', NULL, 'Jabir', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1308, 10, 'jobs', 163, NULL, '2022-05-19 16:29:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1309, 10, 'jobs', 109, NULL, '2022-05-22 09:55:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/109', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1310, 10, 'jobs', 163, NULL, '2022-05-22 15:55:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1311, 10, 'jobs', 164, NULL, '2022-05-22 15:59:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/164', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1312, 10, 'jobs', 163, NULL, '2022-05-22 15:59:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1313, 10, 'jobs', 163, NULL, '2022-05-22 16:01:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1314, 10, 'jobs', 164, NULL, '2022-05-22 22:42:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/164', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1315, 10, 'jobs', 163, NULL, '2022-05-22 22:49:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1316, 10, 'jobs', 164, NULL, '2022-05-23 07:57:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/164', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1317, 10, 'jobs', 165, NULL, '2022-05-23 09:04:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/165', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1318, 10, 'jobs', 165, NULL, '2022-05-23 09:48:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/165', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1319, 10, 'jobs', 165, NULL, '2022-05-23 16:06:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/165', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1320, 10, 'jobs', 164, NULL, '2022-05-23 16:08:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/164', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1321, 10, 'jobs', 164, NULL, '2022-05-23 16:08:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/164', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1322, 10, 'jobs', 165, NULL, '2022-05-23 16:09:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/165', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1324, 10, 'jobs', 165, NULL, '2022-05-23 21:53:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/165', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1325, 10, 'jobs', 166, NULL, '2022-05-24 08:45:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/166', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1326, 10, 'jobs', 167, NULL, '2022-05-24 08:48:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/167', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1327, 10, 'jobs', 166, 'activity_delete_jobs', '2022-05-24 08:49:42', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1328, 10, 'jobs', 166, 'activity_delete_jobs', '2022-05-24 08:52:00', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1329, 10, 'jobs', 166, 'activity_delete_jobs', '2022-05-24 08:52:40', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1330, 10, 'jobs', 138, NULL, '2022-05-24 12:27:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/138', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1331, 10, 'jobs', 138, NULL, '2022-05-24 12:32:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/138', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1332, 10, 'jobs', 167, NULL, '2022-05-24 12:40:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/167', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1333, 10, 'jobs', 167, NULL, '2022-05-24 14:35:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/167', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1334, 10, 'jobs', 167, NULL, '2022-05-24 14:39:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/167', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1335, 10, 'jobs', 165, NULL, '2022-05-24 14:41:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/165', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1336, 10, 'jobs', 167, NULL, '2022-05-24 16:39:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/167', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1337, 10, 'jobs', 167, NULL, '2022-05-24 16:42:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/167', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1338, 10, 'jobs', 168, NULL, '2022-05-24 16:49:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/168', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1339, 10, 'jobs', 168, NULL, '2022-05-24 16:57:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/168', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1340, 10, 'jobs', 168, 'activity_delete_jobs', '2022-05-24 16:59:05', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1341, 10, 'jobs', 163, NULL, '2022-05-24 18:07:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1342, 10, 'jobs', 163, NULL, '2022-05-24 18:08:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/163', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1343, 10, 'jobs', 156, NULL, '2022-05-24 18:09:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/156', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1344, 10, 'jobs', 169, NULL, '2022-05-25 07:36:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/169', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1345, 10, 'jobs', 169, NULL, '2022-05-25 07:42:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/169', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1346, 10, 'jobs', 170, NULL, '2022-05-25 08:28:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/170', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1347, 10, 'jobs', 171, NULL, '2022-05-25 08:28:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/171', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1348, 10, 'jobs', 171, 'activity_delete_jobs', '2022-05-25 08:29:38', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1349, 10, 'jobs', 170, NULL, '2022-05-25 08:29:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/170', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1350, 10, 'jobs', 170, 'activity_delete_jobs', '2022-05-25 08:31:34', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1351, 10, 'jobs', 170, 'activity_delete_jobs', '2022-05-25 08:32:04', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1352, 10, 'jobs', 167, NULL, '2022-05-25 10:17:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/167', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1353, 10, 'jobs', 165, NULL, '2022-05-25 10:17:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/165', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1354, 10, 'jobs', 167, NULL, '2022-05-25 19:32:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/167', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1355, 10, 'jobs', 167, NULL, '2022-05-25 19:33:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/167', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1356, 10, 'jobs', 167, NULL, '2022-05-25 19:34:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/167', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1357, 10, 'jobs', 167, NULL, '2022-05-25 19:38:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/167', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1358, 10, 'jobs', 172, NULL, '2022-05-26 08:12:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/172', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1359, 10, 'jobs', 173, NULL, '2022-05-26 17:28:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/173', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1360, 10, 'jobs', 174, NULL, '2022-05-26 17:39:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/174', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1361, 10, 'jobs', 172, NULL, '2022-05-26 18:11:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/172', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1362, 10, 'jobs', 172, NULL, '2022-05-26 18:41:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/172', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1363, 10, 'jobs', 172, NULL, '2022-05-26 19:01:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/172', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1364, 10, 'jobs', 172, NULL, '2022-05-26 19:03:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/172', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1365, 10, 'jobs', 175, NULL, '2022-05-29 10:45:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/175', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1366, 10, 'jobs', 176, NULL, '2022-05-29 10:48:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/176', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1367, 10, 'jobs', 177, NULL, '2022-05-29 10:52:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/177', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1368, 10, 'jobs', 174, NULL, '2022-05-29 22:27:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/174', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1369, 10, 'jobs', 173, NULL, '2022-05-29 22:33:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/173', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1370, 10, 'jobs', 177, NULL, '2022-05-30 11:14:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/177', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1372, 10, 'jobs', 177, NULL, '2022-05-30 12:12:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/177', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1373, 10, 'jobs', 178, NULL, '2022-05-30 13:19:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/178', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1374, 10, 'jobs', 178, NULL, '2022-05-30 13:19:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/178', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1375, 10, 'jobs', 178, NULL, '2022-05-30 13:21:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/178', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1376, 10, 'jobs', 179, NULL, '2022-05-31 10:07:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/179', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1377, 10, 'jobs', 178, NULL, '2022-05-31 19:19:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/178', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1378, 10, 'jobs', 179, NULL, '2022-05-31 19:35:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/179', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1379, 10, 'jobs', 179, NULL, '2022-05-31 20:05:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/179', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1380, 10, 'jobs', 180, NULL, '2022-05-31 20:41:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/180', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1381, 10, 'jobs', 181, NULL, '2022-05-31 20:41:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/181', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1382, 10, 'jobs', 181, NULL, '2022-05-31 20:43:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/181', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1383, 10, 'jobs', 181, NULL, '2022-05-31 20:43:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/181', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1384, 10, 'jobs', 181, NULL, '2022-05-31 20:43:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/181', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1385, 10, 'jobs', 181, NULL, '2022-05-31 20:54:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/181', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1386, 10, 'jobs', 182, NULL, '2022-05-31 22:02:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/182', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1387, 10, 'jobs', 183, NULL, '2022-05-31 22:09:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/183', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1388, 10, 'jobs', 183, NULL, '2022-05-31 22:12:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/183', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1389, 10, 'jobs', 184, NULL, '2022-05-31 22:15:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/184', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1390, 10, 'jobs', 184, NULL, '2022-05-31 22:15:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/184', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1391, 10, 'jobs', 183, NULL, '2022-05-31 22:15:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/183', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1392, 10, 'jobs', 184, 'activity_delete_jobs', '2022-05-31 22:25:20', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1393, 10, 'jobs', 183, 'activity_delete_jobs', '2022-05-31 22:25:26', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1394, 10, 'jobs', 182, 'activity_delete_jobs', '2022-05-31 22:25:27', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1395, 10, 'jobs', 181, 'activity_delete_jobs', '2022-05-31 22:25:29', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1396, 10, 'jobs', 180, 'activity_delete_jobs', '2022-05-31 22:25:38', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1397, 10, 'jobs', 185, NULL, '2022-06-01 08:48:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/185', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1398, 10, 'jobs', 186, NULL, '2022-06-01 10:01:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/186', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1399, 10, 'jobs', 187, NULL, '2022-06-01 16:04:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/187', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1400, 10, 'jobs', 187, NULL, '2022-06-01 16:05:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/187', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1401, 10, 'jobs', 187, NULL, '2022-06-01 16:06:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/187', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1402, 10, 'jobs', 187, NULL, '2022-06-01 16:07:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/187', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1403, 10, 'jobs', 187, 'activity_delete_jobs', '2022-06-01 17:32:16', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1404, 10, 'jobs', 175, NULL, '2022-06-01 22:02:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/175', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1405, 10, 'jobs', 176, NULL, '2022-06-01 22:06:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/176', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1406, 10, 'jobs', 175, NULL, '2022-06-01 22:09:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/175', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1407, 10, 'jobs', 177, NULL, '2022-06-01 22:12:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/177', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1408, 10, 'jobs', 177, NULL, '2022-06-01 22:16:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/177', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1409, 10, 'jobs', 185, NULL, '2022-06-01 22:18:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/185', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1410, 10, 'jobs', 185, NULL, '2022-06-01 22:21:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/185', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1411, 10, 'jobs', 173, NULL, '2022-06-02 09:55:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/173', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1412, 10, 'jobs', 188, NULL, '2022-06-02 12:31:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/188', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1413, 10, 'jobs', 189, NULL, '2022-06-05 09:04:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/189', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1414, 10, 'jobs', 190, NULL, '2022-06-05 09:08:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/190', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1415, 10, 'jobs', 191, NULL, '2022-06-05 09:13:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/191', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1416, 10, 'jobs', 186, NULL, '2022-06-05 09:21:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/186', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1417, 10, 'jobs', 191, NULL, '2022-06-05 09:35:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/191', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1418, 10, 'jobs', 192, NULL, '2022-06-06 09:42:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/192', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1419, 10, 'jobs', 186, NULL, '2022-06-06 16:58:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/186', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1420, 10, 'jobs', 193, NULL, '2022-06-07 07:50:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/193', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1421, 10, 'jobs', 191, NULL, '2022-06-07 13:34:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/191', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1422, 10, 'jobs', 188, NULL, '2022-06-07 17:45:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/188', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1423, 10, 'jobs', 189, NULL, '2022-06-07 17:53:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/189', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1424, 10, 'jobs', 190, NULL, '2022-06-07 17:56:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/190', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1425, 7, 'jobs', 193, NULL, '2022-06-09 14:00:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/193', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1426, 7, 'jobs', 193, NULL, '2022-06-09 14:00:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/193', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1427, 7, 'jobs', 193, NULL, '2022-06-09 14:03:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/193', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1428, 6, 'departments', 6, 'activity_added_a_department', '2022-06-09 15:31:42', 'fa-coffee', NULL, 'Procurement Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1429, 6, 'items', 1, 'supplier_deleted', '2022-06-09 15:34:18', 'fa-circle-o', NULL, 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1430, 10, 'jobs', 191, NULL, '2022-06-09 18:11:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/191', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1431, 10, 'jobs', 191, NULL, '2022-06-09 18:15:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/191', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1432, 10, 'jobs', 193, NULL, '2022-06-09 18:27:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/193', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1433, 6, 'jobs', 193, NULL, '2022-06-09 22:06:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/193', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1434, 10, 'jobs', 194, NULL, '2022-06-12 08:59:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/194', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1435, 10, 'jobs', 194, NULL, '2022-06-12 18:57:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/194', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1436, 10, 'jobs', 192, NULL, '2022-06-12 19:13:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/192', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1437, 6, 'settings', 2, 'customer_group_added', '2022-06-13 14:16:18', 'fa-coffee', NULL, 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1438, 6, 'settings', 0, 'customer_group_added', '2022-06-13 14:18:14', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1439, 6, 'tasks', 2, 'activity_tasks_timer_on', '2022-06-13 14:19:16', 'fa-tasks', 'admin/tasks/view_task_details/2/5', 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1440, 6, 'tasks', 2, 'activity_tasks_timer_off', '2022-06-13 14:19:23', 'fa-tasks', 'admin/tasks/view_task_details/2/5', 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1441, 6, 'tasks', 2, 'activity_tasks_timer_off', '2022-06-13 14:19:25', 'fa-tasks', 'admin/tasks/view_task_details/2/5', 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1442, 6, 'tasks', 2, 'activity_tasks_timer_off', '2022-06-13 14:19:26', 'fa-tasks', 'admin/tasks/view_task_details/2/5', 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1443, 6, 'tasks', 1, 'activity_update_task', '2022-06-13 14:19:46', 'fa-tasks', 'admin/tasks/view_task_details/1', '100', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1444, 6, 'tasks', 1, 'activity_task_deleted', '2022-06-13 14:20:00', 'fa-tasks', NULL, 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1445, 6, 'settings', 3, 'customer_group_added', '2022-06-13 14:41:55', 'fa-coffee', NULL, 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1446, 6, 'tasks', 2, 'activity_update_task', '2022-06-13 15:03:42', 'fa-tasks', 'admin/tasks/view_task_details/2', '100', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1447, 6, 'tasks', 2, 'activity_task_deleted', '2022-06-13 15:03:49', 'fa-tasks', NULL, 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1448, 6, 'tasks', 3, 'activity_tasks_timer_on', '2022-06-13 15:10:35', 'fa-tasks', 'admin/tasks/view_task_details/3/5', 'Naif', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1449, 6, 'tasks', 3, 'activity_tasks_timer_off', '2022-06-13 15:11:17', 'fa-tasks', 'admin/tasks/view_task_details/3/5', 'Naif', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1450, 6, 'tasks', 3, 'activity_tasks_timer_off', '2022-06-13 15:11:25', 'fa-tasks', 'admin/tasks/view_task_details/3/5', 'Naif', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1451, 6, 'tasks', 3, 'activity_update_task', '2022-06-13 15:11:25', 'fa-tasks', 'admin/tasks/view_task_details/3', 'Naif', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1452, 6, 'tasks', 3, 'activity_update_task', '2022-06-13 15:13:33', 'fa-tasks', 'admin/tasks/view_task_details/3', 'Naif', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1453, 6, 'projects', 1, 'activity_project_deleted', '2022-06-13 15:14:33', 'fa-folder-open-o', NULL, 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1454, 17, 'tasks', 3, 'activity_update_task', '2022-06-13 15:18:26', 'fa-tasks', 'admin/tasks/view_task_details/3', 'Naif', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1455, 17, 'tasks', 3, 'activity_update_task', '2022-06-13 15:18:37', 'fa-tasks', 'admin/tasks/view_task_details/3', 'Naif', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1456, 6, 'settings', 0, 'customer_group_added', '2022-06-13 15:19:10', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1457, 6, 'settings', 0, 'customer_group_added', '2022-06-13 15:19:10', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1458, 6, 'settings', 0, 'customer_group_added', '2022-06-13 15:19:17', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1459, 6, 'departments', 6, 'activity_added_a_department', '2022-06-13 15:38:19', 'fa-coffee', NULL, 'Procurement Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1460, 10, 'jobs', 195, NULL, '2022-06-14 07:16:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/195', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1461, 10, 'jobs', 195, NULL, '2022-06-14 12:18:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/195', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1462, 10, 'jobs', 195, NULL, '2022-06-16 16:35:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/195', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1463, 3, 'user', 13, 'activity_change_status', '2022-06-27 14:52:39', 'fa-user', NULL, 'Gaurav Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1464, 6, 'jobs', 196, NULL, '2022-06-27 15:04:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/196', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1465, 6, 'jobs', 195, NULL, '2022-06-27 15:18:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/195', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1466, 3, 'jobs', 196, NULL, '2022-06-27 21:17:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/196', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1467, 3, 'jobs', 196, NULL, '2022-06-28 06:48:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/196', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1468, 3, 'jobs', 0, NULL, '2022-06-29 04:51:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1469, 3, 'jobs', 198, NULL, '2022-06-29 05:10:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/198', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1470, 3, 'jobs', 199, NULL, '2022-06-29 05:15:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/199', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1471, 3, 'jobs', 200, NULL, '2022-06-29 05:28:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/200', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1472, 3, 'jobs', 201, NULL, '2022-06-30 08:45:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/201', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1473, 3, 'jobs', 202, NULL, '2022-06-30 08:45:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/202', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1474, 3, 'jobs', 203, NULL, '2022-06-30 08:45:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/203', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1475, 3, 'jobs', 204, NULL, '2022-06-30 10:24:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/204', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1476, 3, 'jobs', 205, NULL, '2022-06-30 10:25:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/205', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1477, 3, 'jobs', 206, NULL, '2022-06-30 10:25:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/206', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1478, 3, 'settings', 3, 'activity_database_backup', '2022-06-30 12:20:30', 'fa-coffee', NULL, 'BD-backup_2022-06-30_12-20', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1479, 3, 'jobs', 207, NULL, '2022-06-30 12:48:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/207', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1480, 3, 'jobs', 208, NULL, '2022-06-30 12:48:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/208', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1481, 3, 'jobs', 209, NULL, '2022-06-30 12:52:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/209', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1482, 3, 'jobs', 210, NULL, '2022-06-30 12:55:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/210', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1483, 3, 'jobs', 211, NULL, '2022-06-30 13:13:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/211', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1484, 10, 'jobs', 212, NULL, '2022-06-30 15:04:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/212', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1485, 10, 'jobs', 213, NULL, '2022-06-30 16:09:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1486, 10, 'jobs', 211, 'activity_delete_jobs', '2022-06-30 16:09:57', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1487, 10, 'jobs', 213, NULL, '2022-06-30 16:10:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1488, 10, 'jobs', 213, NULL, '2022-06-30 16:36:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1489, 10, 'jobs', 213, NULL, '2022-06-30 16:37:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1490, 10, 'jobs', 213, NULL, '2022-06-30 16:38:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1491, 10, 'jobs', 213, NULL, '2022-06-30 16:40:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1492, 10, 'jobs', 213, NULL, '2022-06-30 16:40:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1493, 10, 'jobs', 213, NULL, '2022-06-30 16:42:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1494, 10, 'jobs', 213, NULL, '2022-06-30 16:55:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1495, 10, 'jobs', 213, NULL, '2022-06-30 16:57:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1496, 3, 'jobs', 213, NULL, '2022-06-30 17:20:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1497, 3, 'jobs', 213, NULL, '2022-06-30 17:22:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1498, 3, 'jobs', 213, NULL, '2022-06-30 17:25:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1499, 10, 'jobs', 214, NULL, '2022-06-30 19:06:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/214', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1500, 10, 'jobs', 214, 'activity_delete_jobs', '2022-06-30 19:08:18', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1501, 10, 'jobs', 214, 'activity_delete_jobs', '2022-06-30 20:43:44', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1502, 10, 'jobs', 213, NULL, '2022-06-30 22:54:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1503, 10, 'jobs', 213, NULL, '2022-07-01 01:49:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1504, 10, 'jobs', 213, NULL, '2022-07-01 04:16:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1505, 3, 'jobs', 213, NULL, '2022-07-01 10:37:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1506, 3, 'jobs', 213, NULL, '2022-07-01 10:37:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1507, 10, 'jobs', 213, NULL, '2022-07-01 21:24:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1508, 3, 'jobs', 213, NULL, '2022-07-01 21:28:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1509, 3, 'jobs', 213, NULL, '2022-07-01 21:29:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1510, 10, 'jobs', 215, NULL, '2022-07-01 21:32:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/215', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1511, 10, 'jobs', 215, 'activity_delete_jobs', '2022-07-01 21:34:36', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1512, 10, 'jobs', 216, NULL, '2022-07-01 21:38:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/216', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1513, 3, 'settings', 3, 'activity_backup_delete_success', '2022-07-01 21:50:49', 'fa-coffee', NULL, 'BD-backup_2022-06-30_12-20.zip', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1514, 6, 'settings', 6, 'activity_save_theme_settings', '2022-07-01 21:52:59', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1515, 3, 'settings', 3, 'activity_save_theme_settings', '2022-07-01 21:55:22', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1516, 3, 'jobs', 216, NULL, '2022-07-02 09:39:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/216', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1517, 3, 'jobs', 216, NULL, '2022-07-02 09:41:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/216', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1518, 3, 'jobs', 217, NULL, '2022-07-02 09:42:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/217', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1519, 3, 'jobs', 218, NULL, '2022-07-02 09:56:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/218', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1520, 10, 'jobs', 218, 'activity_delete_jobs', '2022-07-03 02:51:45', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1521, 10, 'jobs', 219, NULL, '2022-07-03 02:54:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/219', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1522, 10, 'jobs', 219, NULL, '2022-07-03 02:55:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/219', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1523, 10, 'jobs', 219, NULL, '2022-07-03 02:55:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/219', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1524, 6, 'settings', 6, 'activity_save_email_settings', '2022-07-03 10:22:38', 'fa-coffee', NULL, 'npco.saudiarabia@outlook.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1525, 6, 'settings', 6, 'activity_password_update', '2022-07-03 10:25:46', 'fa-coffee', NULL, 'Rameez', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1526, 6, 'settings', 6, 'activity_password_update', '2022-07-03 10:26:45', 'fa-coffee', NULL, 'Rameez', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1527, 6, 'settings', 6, 'activity_save_email_settings', '2022-07-03 10:30:21', 'fa-coffee', NULL, 'npco.saudiarabia@outlook.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1528, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-03 10:42:56', 'fa-coffee', NULL, 'Accounting', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1529, 3, 'jobs', 219, NULL, '2022-07-03 10:44:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/219', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1530, 6, 'user', 18, 'activity_added_new_user', '2022-07-03 10:48:54', 'fa-user', NULL, 'Ahmed@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1531, 6, 'user', 18, 'activity_added_new_user', '2022-07-03 10:51:32', 'fa-user', NULL, 'Ahmed@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1532, 6, 'departments', 7, 'activity_added_a_department', '2022-07-03 10:53:09', 'fa-coffee', NULL, 'Accounting', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1533, 6, 'projects', 2, 'activity_project_deleted', '2022-07-03 10:58:23', 'fa-folder-open-o', NULL, 'mudeb sir', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1534, 6, 'tasks', 3, 'activity_task_deleted', '2022-07-03 10:59:15', 'fa-tasks', NULL, 'Naif', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1535, 3, 'jobs', 213, NULL, '2022-07-03 11:02:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/213', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1536, 6, 'settings', 6, 'Changed email', '2022-07-03 11:03:14', 'fa-coffee', NULL, 'rameez@gmail.com', 'rameez@npco.sa', 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1537, 6, 'departments', 5, 'activity_update_a_department', '2022-07-03 11:05:16', 'fa-coffee', NULL, 'KKIA Operations', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1538, 6, 'departments', 5, 'activity_added_a_department', '2022-07-03 11:05:39', 'fa-coffee', NULL, 'KKIA Operations', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1539, 6, 'departments', 5, 'activity_update_a_department', '2022-07-03 11:06:22', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1540, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-03 11:10:10', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1541, 6, 'user', 19, 'activity_added_new_user', '2022-07-03 11:10:59', 'fa-user', NULL, 'Omar.alharbi@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1542, 3, 'jobs', 220, NULL, '2022-07-03 12:33:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/220', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1543, 3, 'jobs', 221, NULL, '2022-07-03 12:46:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1544, 3, 'jobs', 221, NULL, '2022-07-03 13:22:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1545, 3, 'jobs', 221, NULL, '2022-07-03 13:28:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1546, 3, 'jobs', 221, NULL, '2022-07-03 13:43:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1547, 6, 'jobs', 221, NULL, '2022-07-03 14:03:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1548, 6, 'jobs', 221, NULL, '2022-07-03 14:06:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1549, 6, 'jobs', 221, NULL, '2022-07-03 14:07:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1550, 6, 'jobs', 221, NULL, '2022-07-03 14:08:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1551, 6, 'jobs', 221, NULL, '2022-07-03 14:09:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1552, 3, 'jobs', 221, NULL, '2022-07-03 14:26:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1553, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-03 15:05:45', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1554, 6, 'user', 20, 'activity_added_new_user', '2022-07-03 15:07:11', 'fa-user', NULL, 'Mark@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1555, 6, 'user', 21, 'activity_added_new_user', '2022-07-03 15:09:04', 'fa-user', NULL, 'Joel@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1556, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-03 15:28:55', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1557, 6, 'user', 22, 'activity_added_new_user', '2022-07-03 15:28:59', 'fa-user', NULL, 'Wilfredo.c@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1558, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-03 15:31:45', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1559, 6, 'user', 23, 'activity_added_new_user', '2022-07-03 15:31:49', 'fa-user', NULL, 'Jogen@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1560, 6, 'user', 24, 'activity_added_new_user', '2022-07-03 16:26:20', 'fa-user', NULL, 'Samih@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1561, 6, 'user', 25, 'activity_added_new_user', '2022-07-03 16:28:01', 'fa-user', NULL, 'Samieh@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1562, 6, 'user', 25, 'activity_added_new_user', '2022-07-03 16:28:22', 'fa-user', NULL, 'Samieh@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1563, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-03 16:30:04', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1564, 6, 'user', 26, 'activity_added_new_user', '2022-07-03 16:30:09', 'fa-user', NULL, 'turki@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1565, 6, 'user', 27, 'activity_added_new_user', '2022-07-03 16:33:07', 'fa-user', NULL, 'Ahsan@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1566, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-03 16:57:29', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1567, 6, 'user', 28, 'activity_added_new_user', '2022-07-03 16:58:01', 'fa-user', NULL, 'Allal@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1568, 6, 'user', 27, 'activity_added_new_user', '2022-07-03 16:59:48', 'fa-user', NULL, 'Ahsan@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1569, 6, 'user', 27, 'activity_added_new_user', '2022-07-03 17:04:02', 'fa-user', NULL, 'Ahsan@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1570, 6, 'jobs', 221, NULL, '2022-07-03 17:07:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1571, 3, 'jobs', 217, NULL, '2022-07-03 21:16:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/217', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1572, 3, 'jobs', 221, NULL, '2022-07-04 09:05:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1573, 3, 'jobs', 221, NULL, '2022-07-04 09:05:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1574, 3, 'jobs', 221, NULL, '2022-07-04 09:06:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1575, 3, 'jobs', 221, NULL, '2022-07-04 09:07:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1576, 3, 'jobs', 221, NULL, '2022-07-04 09:13:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1577, 3, 'jobs', 221, NULL, '2022-07-04 09:17:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1578, 3, 'jobs', 221, NULL, '2022-07-04 09:37:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1579, 10, 'jobs', 221, NULL, '2022-07-04 09:45:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1580, 6, 'jobs', 221, NULL, '2022-07-04 10:21:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1581, 6, 'jobs', 221, NULL, '2022-07-04 10:23:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1582, 6, 'jobs', 221, NULL, '2022-07-04 15:21:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1583, 6, 'jobs', 222, NULL, '2022-07-04 15:30:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/222', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1584, 6, 'jobs', 223, NULL, '2022-07-04 15:41:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/223', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1585, 6, 'jobs', 224, NULL, '2022-07-04 17:41:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/224', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1586, 6, 'jobs', 225, NULL, '2022-07-04 17:42:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/225', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1587, 10, 'jobs', 226, NULL, '2022-07-04 19:56:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/226', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1588, 10, 'jobs', 227, NULL, '2022-07-04 20:16:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/227', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1589, 10, 'jobs', 226, NULL, '2022-07-04 20:21:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/226', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1590, 10, 'jobs', 228, NULL, '2022-07-04 20:27:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/228', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1591, 6, 'jobs', 227, NULL, '2022-07-05 11:11:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/227', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1592, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-05 16:02:04', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1593, 6, 'user', 29, 'activity_added_new_user', '2022-07-05 16:02:17', 'fa-user', NULL, 'Abdullah@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1594, 6, 'user', 30, 'activity_added_new_user', '2022-07-05 16:12:57', 'fa-user', NULL, 'Fahad@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1595, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-05 16:14:21', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1596, 6, 'user', 31, 'activity_added_new_user', '2022-07-05 16:14:23', 'fa-user', NULL, 'M.alsahli@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1597, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-05 16:16:58', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1598, 6, 'user', 32, 'activity_added_new_user', '2022-07-05 16:17:02', 'fa-user', NULL, 'Francis@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1599, 6, 'user', 33, 'activity_added_new_user', '2022-07-05 16:19:32', 'fa-user', NULL, 'Faiz@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1600, 6, 'user', 34, 'activity_added_new_user', '2022-07-05 16:21:05', 'fa-user', NULL, 'Francisco@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1601, 6, 'departments', 5, 'activity_added_a_department', '2022-07-05 16:27:19', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1602, 6, 'departments', 3, 'activity_added_a_department', '2022-07-05 16:28:17', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1603, 10, 'jobs', 229, NULL, '2022-07-06 13:27:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/229', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1604, 10, 'jobs', 229, NULL, '2022-07-06 13:33:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/229', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1605, 10, 'jobs', 221, NULL, '2022-07-06 15:58:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1606, 10, 'jobs', 229, NULL, '2022-07-06 16:03:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/229', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1607, 3, 'jobs', 230, NULL, '2022-07-06 20:35:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1608, 10, 'jobs', 230, NULL, '2022-07-07 08:55:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1609, 3, 'jobs', 230, NULL, '2022-07-07 08:55:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1610, 10, 'jobs', 230, NULL, '2022-07-07 08:55:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1611, 3, 'jobs', 230, NULL, '2022-07-07 09:17:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1612, 3, 'jobs', 230, NULL, '2022-07-08 12:44:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1613, 3, 'jobs', 230, NULL, '2022-07-09 14:55:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1614, 3, 'jobs', 230, NULL, '2022-07-10 20:23:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1615, 3, 'jobs', 230, NULL, '2022-07-11 09:36:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1616, 3, 'jobs', 230, NULL, '2022-07-11 13:49:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1617, 3, 'jobs', 230, NULL, '2022-07-11 13:50:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1618, 3, 'jobs', 230, NULL, '2022-07-11 13:51:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1619, 3, 'jobs', 230, NULL, '2022-07-11 13:53:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1620, 3, 'jobs', 230, NULL, '2022-07-11 13:54:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1621, 3, 'jobs', 230, NULL, '2022-07-11 14:10:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1622, 3, 'jobs', 230, NULL, '2022-07-11 16:16:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1623, 3, 'jobs', 230, NULL, '2022-07-11 16:16:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1624, 3, 'jobs', 230, NULL, '2022-07-11 16:19:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1625, 3, 'jobs', 230, NULL, '2022-07-11 16:21:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1626, 3, 'jobs', 221, NULL, '2022-07-11 16:58:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1627, 3, 'jobs', 229, NULL, '2022-07-11 17:00:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/229', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1628, 3, 'jobs', 230, NULL, '2022-07-11 17:00:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1629, 3, 'jobs', 230, NULL, '2022-07-11 17:00:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1630, 3, 'jobs', 230, NULL, '2022-07-11 17:07:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/230', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1631, 3, 'jobs', 221, NULL, '2022-07-11 17:27:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/221', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1632, 3, 'jobs', 231, NULL, '2022-07-11 17:28:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/231', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1633, 3, 'jobs', 232, NULL, '2022-07-11 17:29:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/232', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1634, 3, 'jobs', 233, NULL, '2022-07-11 17:30:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/233', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1635, 3, 'jobs', 233, NULL, '2022-07-11 17:31:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/233', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1636, 3, 'jobs', 234, NULL, '2022-07-11 19:34:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1637, 3, 'jobs', 234, NULL, '2022-07-11 19:35:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1638, 3, 'jobs', 234, NULL, '2022-07-11 19:36:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1639, 3, 'jobs', 234, NULL, '2022-07-11 19:39:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1640, 3, 'jobs', 234, NULL, '2022-07-12 08:04:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1641, 3, 'jobs', 234, NULL, '2022-07-12 08:05:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1642, 3, 'jobs', 234, NULL, '2022-07-12 08:07:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1643, 3, 'jobs', 234, NULL, '2022-07-12 19:22:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1644, 3, 'settings', 3, 'activity_password_update', '2022-07-12 19:40:19', 'fa-coffee', NULL, 'admin@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1645, 3, 'settings', 3, 'activity_password_update', '2022-07-12 19:46:10', 'fa-coffee', NULL, 'admin@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1646, 3, 'jobs', 233, NULL, '2022-07-12 19:47:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/233', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1647, 3, 'jobs', 234, NULL, '2022-07-12 19:48:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1648, 3, 'jobs', 234, NULL, '2022-07-12 19:49:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1649, 3, 'jobs', 234, NULL, '2022-07-12 19:51:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1650, 3, 'jobs', 234, NULL, '2022-07-13 06:06:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1651, 3, 'jobs', 234, NULL, '2022-07-13 07:48:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1652, 3, 'jobs', 234, NULL, '2022-07-14 12:13:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1653, 3, 'jobs', 234, NULL, '2022-07-15 20:49:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1654, 3, 'jobs', 234, NULL, '2022-07-15 20:59:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1655, 3, 'jobs', 234, NULL, '2022-07-17 09:20:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1656, 6, 'user', 34, 'activity_added_new_user', '2022-07-17 09:40:22', 'fa-user', NULL, 'Francisco@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1657, 6, 'user', 35, 'activity_added_new_user', '2022-07-17 09:44:50', 'fa-user', NULL, 'Ponciano@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1658, 6, 'user', 36, 'activity_added_new_user', '2022-07-17 09:47:56', 'fa-user', NULL, 'Saddam@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1659, 6, 'user', 37, 'activity_added_new_user', '2022-07-17 09:50:11', 'fa-user', NULL, 'Norman@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1660, 6, 'user', 38, 'activity_added_new_user', '2022-07-17 10:00:24', 'fa-user', NULL, 'Jay@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1661, 6, 'user', 39, 'activity_added_new_user', '2022-07-17 10:02:10', 'fa-user', NULL, 'Faizan@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1662, 6, 'user', 40, 'activity_added_new_user', '2022-07-17 10:04:17', 'fa-user', NULL, 'Asad@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1663, 6, 'user', 41, 'activity_added_new_user', '2022-07-17 10:06:15', 'fa-user', NULL, 'Muteb@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1664, 6, 'user', 42, 'activity_added_new_user', '2022-07-17 10:07:48', 'fa-user', NULL, 'Arriel@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1665, 6, 'user', 43, 'activity_added_new_user', '2022-07-17 10:09:24', 'fa-user', NULL, 'Ireneo@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1666, 6, 'user', 43, 'activity_added_new_user', '2022-07-17 10:09:58', 'fa-user', NULL, 'Ireneo@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1667, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-17 10:11:56', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1668, 6, 'user', 44, 'activity_added_new_user', '2022-07-17 10:12:13', 'fa-user', NULL, 'Samir.madani@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1669, 6, 'departments', 1, 'activity_delete_a_department', '2022-07-17 10:12:30', 'fa-coffee', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1670, 6, 'departments', NULL, 'activity_added_a_department', '2022-07-17 10:16:08', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1671, 6, 'user', 10, 'activity_added_new_user', '2022-07-17 10:16:12', 'fa-user', NULL, 'KKIA', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1672, 6, 'departments', 9, 'activity_delete_a_designation', '2022-07-17 10:16:30', 'fa-coffee', NULL, 'Test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1673, 3, 'jobs', 234, NULL, '2022-07-17 10:30:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1674, 6, 'departments', 7, 'activity_added_a_department', '2022-07-17 10:52:00', 'fa-coffee', NULL, 'Accounting', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1675, 6, 'jobs', 233, NULL, '2022-07-17 13:07:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/233', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1676, 6, 'jobs', 233, NULL, '2022-07-17 13:08:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/233', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1677, 6, 'jobs', 233, NULL, '2022-07-17 13:09:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/233', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1678, 17, 'client', 9, 'activity_update_company', '2022-07-17 15:10:27', 'fa-user', NULL, 'AIRBUS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1679, 17, 'projects', 3, 'activity_save_project', '2022-07-17 15:12:44', 'fa-folder-open-o', 'admin/projects/project_details/3', 'AIRBUS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1680, 17, 'projects', 3, 'activity_tasks_timer_on', '2022-07-17 15:13:29', 'fa-folder-open-o', 'admin/projects/project_details/3/7', 'AIRBUS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1681, 17, 'projects', 3, 'activity_tasks_timer_off', '2022-07-17 16:52:37', 'fa-folder-open-o', 'admin/projects/project_details/3/7', 'AIRBUS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1682, 17, 'tasks', 14, 'activity_update_task', '2022-07-18 08:41:36', 'fa-tasks', 'admin/tasks/view_task_details/14', 'RFQ 0000123', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1683, 17, 'tasks', 15, 'activity_update_task', '2022-07-18 08:41:57', 'fa-tasks', 'admin/tasks/view_task_details/15', 'RFQ 0000123', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1684, 17, 'projects', 3, 'activity_project_deleted', '2022-07-18 08:58:06', 'fa-folder-open-o', NULL, 'AIRBUS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1685, 17, 'projects', 4, 'activity_save_project', '2022-07-18 09:13:55', 'fa-folder-open-o', 'admin/projects/project_details/4', 'AIRBUS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1686, 17, 'tasks', NULL, 'activity_new_task', '2022-07-18 09:33:27', 'fa-tasks', 'admin/tasks/view_task_details/', 'Import Tasks', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1687, 17, 'tasks', 16, 'activity_tasks_timer_on', '2022-07-18 09:33:51', 'fa-tasks', 'admin/tasks/view_task_details/16/5', '1', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1688, 17, 'tasks', 16, 'activity_tasks_timer_off', '2022-07-18 09:33:59', 'fa-tasks', 'admin/tasks/view_task_details/16/5', '1', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1689, 17, 'settings', 4, 'customer_group_added', '2022-07-18 10:34:18', 'fa-coffee', NULL, 'GSE SPARE PARTS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1690, 17, 'supplier', 2, 'save_supplier', '2022-07-18 11:10:18', 'fa-circle-o', NULL, 'WRIGHT AERO COMPONENTS FZE', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1691, 17, 'projects', 4, 'activity_tasks_timer_on', '2022-07-18 13:39:26', 'fa-folder-open-o', 'admin/projects/project_details/4/7', 'AIRBUS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1692, 17, 'projects', 4, 'activity_tasks_timer_off', '2022-07-18 13:40:18', 'fa-folder-open-o', 'admin/projects/project_details/4/7', 'AIRBUS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1693, 17, 'projects', 5, 'activity_save_project', '2022-07-18 13:42:03', 'fa-folder-open-o', 'admin/projects/project_details/5', 'aircraft parts', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1694, 3, 'jobs', 234, NULL, '2022-07-18 18:11:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/234', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1695, 6, 'departments', 5, 'activity_added_a_department', '2022-07-20 12:26:20', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1696, 38, 'settings', 38, 'activity_password_update', '2022-07-20 12:28:02', 'fa-coffee', NULL, 'Jay@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1697, 38, 'equipment', 43, NULL, '2022-07-20 12:32:09', 'fa-suitcase', 'admin/equipment/view_equipment_details/43', 'NP210006', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1698, 38, 'jobs', 235, NULL, '2022-07-20 12:34:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/235', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1699, 38, 'jobs', 235, NULL, '2022-07-20 12:35:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/235', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1700, 38, 'jobs', 235, NULL, '2022-07-20 12:46:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/235', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1701, 36, 'settings', 36, 'activity_password_update', '2022-07-20 15:25:14', 'fa-coffee', NULL, 'Saddam@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1702, 36, 'jobs', 236, NULL, '2022-07-20 15:29:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/236', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1703, 36, 'jobs', 236, NULL, '2022-07-20 15:30:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/236', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1704, 36, 'jobs', 236, NULL, '2022-07-20 15:39:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/236', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1705, 36, 'jobs', 237, NULL, '2022-07-20 16:42:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/237', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1706, 3, 'jobs', 237, NULL, '2022-07-20 22:05:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/237', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1707, 3, 'jobs', 238, NULL, '2022-07-20 22:05:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/238', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1708, 3, 'jobs', 238, 'activity_delete_jobs', '2022-07-20 22:08:27', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1709, 3, 'jobs', 237, NULL, '2022-07-20 22:12:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/237', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1710, 3, 'jobs', 239, NULL, '2022-07-20 22:17:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/239', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1711, 32, 'jobs', 240, NULL, '2022-07-21 00:01:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/240', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1712, 32, 'jobs', 240, 'activity_delete_jobs', '2022-07-21 00:56:05', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1713, 32, 'jobs', 241, NULL, '2022-07-21 01:03:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/241', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1714, 6, 'jobs', 239, NULL, '2022-07-21 10:03:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/239', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1715, 6, 'jobs', 239, NULL, '2022-07-21 10:03:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/239', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1716, 6, 'settings', 6, 'activity_save_email_settings', '2022-07-21 10:37:56', 'fa-coffee', NULL, 'npco.saudiarabia@outlook.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1717, 6, 'announcements', 2, 'activity_delete_announcements', '2022-07-21 11:13:27', 'fa-ticket', NULL, 'TEST', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1718, 6, 'announcements', 1, 'activity_delete_announcements', '2022-07-21 11:13:35', 'fa-ticket', NULL, 'ERP', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1719, 38, 'jobs', 242, NULL, '2022-07-21 11:24:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/242', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1720, 38, 'jobs', 243, NULL, '2022-07-21 11:38:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/243', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1721, 38, 'equipment', 44, NULL, '2022-07-21 12:03:00', 'fa-suitcase', 'admin/equipment/view_equipment_details/44', 'NP210007', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1722, 38, 'jobs', 244, NULL, '2022-07-21 12:06:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/244', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1723, 38, 'jobs', 243, NULL, '2022-07-21 12:11:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/243', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1724, 38, 'jobs', 242, NULL, '2022-07-21 12:13:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/242', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1725, 38, 'jobs', 244, NULL, '2022-07-21 13:11:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/244', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1726, 38, 'jobs', 244, NULL, '2022-07-21 13:12:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/244', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1727, 38, 'jobs', 243, NULL, '2022-07-21 13:14:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/243', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1728, 32, 'jobs', 245, NULL, '2022-07-22 00:23:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1729, 32, 'jobs', 244, NULL, '2022-07-22 00:24:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/244', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1730, 32, 'jobs', 245, NULL, '2022-07-22 00:30:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1731, 32, 'jobs', 245, NULL, '2022-07-22 00:45:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1732, 3, 'jobs', 245, NULL, '2022-07-23 08:17:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1733, 3, 'jobs', 245, NULL, '2022-07-23 08:20:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1734, 3, 'jobs', 245, NULL, '2022-07-23 08:25:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1735, 38, 'jobs', 246, NULL, '2022-07-24 07:31:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/246', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1736, 38, 'jobs', 246, NULL, '2022-07-24 07:32:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/246', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1737, 38, 'jobs', 247, NULL, '2022-07-24 07:43:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/247', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1738, 38, 'jobs', 248, NULL, '2022-07-24 07:47:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/248', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1739, 38, 'jobs', 232, 'activity_delete_jobs', '2022-07-24 11:57:52', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1740, 38, 'jobs', 232, 'activity_delete_jobs', '2022-07-24 11:57:59', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1741, 38, 'jobs', 249, NULL, '2022-07-24 12:02:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/249', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1742, 38, 'jobs', 231, 'activity_delete_jobs', '2022-07-24 12:06:00', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1743, 38, 'jobs', 225, 'activity_delete_jobs', '2022-07-24 12:06:24', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1744, 38, 'jobs', 224, 'activity_delete_jobs', '2022-07-24 12:06:25', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1745, 38, 'jobs', 223, 'activity_delete_jobs', '2022-07-24 12:06:28', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1746, 38, 'jobs', 220, 'activity_delete_jobs', '2022-07-24 12:06:32', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1747, 38, 'jobs', 225, 'activity_delete_jobs', '2022-07-24 12:06:39', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1748, 38, 'jobs', 212, 'activity_delete_jobs', '2022-07-24 12:06:47', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1749, 38, 'jobs', 210, 'activity_delete_jobs', '2022-07-24 12:06:49', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1750, 38, 'jobs', 209, 'activity_delete_jobs', '2022-07-24 12:06:50', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1751, 38, 'jobs', 208, 'activity_delete_jobs', '2022-07-24 12:06:52', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1752, 38, 'jobs', 207, 'activity_delete_jobs', '2022-07-24 12:07:06', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1753, 38, 'jobs', 206, 'activity_delete_jobs', '2022-07-24 12:07:09', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1754, 38, 'jobs', 205, 'activity_delete_jobs', '2022-07-24 12:07:10', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1755, 38, 'jobs', 204, 'activity_delete_jobs', '2022-07-24 12:07:12', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1756, 38, 'jobs', 228, 'activity_delete_jobs', '2022-07-24 12:07:41', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1757, 38, 'jobs', 227, 'activity_delete_jobs', '2022-07-24 12:07:42', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1758, 38, 'jobs', 226, 'activity_delete_jobs', '2022-07-24 12:07:45', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1759, 38, 'jobs', 203, 'activity_delete_jobs', '2022-07-24 12:07:53', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1760, 38, 'jobs', 202, 'activity_delete_jobs', '2022-07-24 12:07:55', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1761, 38, 'jobs', 201, 'activity_delete_jobs', '2022-07-24 12:07:57', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1762, 38, 'jobs', 213, 'activity_delete_jobs', '2022-07-24 12:08:09', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1763, 38, 'jobs', 200, 'activity_delete_jobs', '2022-07-24 12:08:26', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1764, 38, 'jobs', 199, 'activity_delete_jobs', '2022-07-24 12:08:28', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1765, 38, 'jobs', 198, 'activity_delete_jobs', '2022-07-24 12:08:30', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1766, 38, 'jobs', 198, 'activity_delete_jobs', '2022-07-24 12:08:33', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1767, 38, 'jobs', 197, 'activity_delete_jobs', '2022-07-24 12:08:35', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1768, 38, 'jobs', 196, 'activity_delete_jobs', '2022-07-24 12:08:36', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1769, 38, 'jobs', 195, 'activity_delete_jobs', '2022-07-24 12:08:38', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1770, 38, 'jobs', 194, 'activity_delete_jobs', '2022-07-24 12:08:40', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1771, 38, 'equipment', 45, NULL, '2022-07-24 12:11:26', 'fa-suitcase', 'admin/equipment/view_equipment_details/45', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1772, 38, 'equipment', 45, NULL, '2022-07-24 12:12:36', 'fa-suitcase', 'admin/equipment/view_equipment_details/45', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1773, 38, 'equipment', 45, 'activity_delete_equipment', '2022-07-24 12:15:08', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1774, 38, 'jobs', 250, NULL, '2022-07-24 12:30:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/250', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1775, 38, 'jobs', 250, NULL, '2022-07-24 12:31:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/250', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1776, 10, 'jobs', 62, 'activity_delete_jobs', '2022-07-24 12:35:27', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1777, 10, 'jobs', 66, 'activity_delete_jobs', '2022-07-24 12:35:30', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1778, 10, 'jobs', 67, 'activity_delete_jobs', '2022-07-24 12:35:32', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1779, 10, 'jobs', 69, 'activity_delete_jobs', '2022-07-24 12:35:40', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1780, 10, 'jobs', 70, 'activity_delete_jobs', '2022-07-24 12:35:42', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1781, 10, 'jobs', 71, 'activity_delete_jobs', '2022-07-24 12:35:45', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1782, 10, 'jobs', 72, 'activity_delete_jobs', '2022-07-24 12:35:47', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1783, 10, 'jobs', 73, 'activity_delete_jobs', '2022-07-24 12:35:49', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1784, 10, 'jobs', 74, 'activity_delete_jobs', '2022-07-24 12:35:51', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1785, 10, 'jobs', 75, 'activity_delete_jobs', '2022-07-24 12:35:53', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1786, 10, 'jobs', 76, 'activity_delete_jobs', '2022-07-24 12:35:58', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1787, 10, 'jobs', 78, 'activity_delete_jobs', '2022-07-24 12:36:00', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1788, 10, 'jobs', 79, 'activity_delete_jobs', '2022-07-24 12:36:02', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1789, 10, 'jobs', 80, 'activity_delete_jobs', '2022-07-24 12:36:17', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1790, 10, 'jobs', 81, 'activity_delete_jobs', '2022-07-24 12:36:19', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1791, 10, 'jobs', 83, 'activity_delete_jobs', '2022-07-24 12:36:51', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1792, 10, 'jobs', 84, 'activity_delete_jobs', '2022-07-24 12:36:53', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1793, 10, 'jobs', 85, 'activity_delete_jobs', '2022-07-24 12:36:55', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1794, 10, 'jobs', 88, 'activity_delete_jobs', '2022-07-24 12:36:58', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1795, 10, 'jobs', 89, 'activity_delete_jobs', '2022-07-24 12:37:00', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1796, 10, 'jobs', 91, 'activity_delete_jobs', '2022-07-24 12:37:02', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1797, 10, 'jobs', 92, 'activity_delete_jobs', '2022-07-24 12:37:05', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1798, 10, 'jobs', 93, 'activity_delete_jobs', '2022-07-24 12:37:07', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1799, 6, 'user', 46, 'activity_change_status', '2022-07-24 12:47:15', 'fa-user', NULL, 'test Active', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1800, 6, 'user', 45, 'activity_change_status', '2022-07-24 12:49:29', 'fa-user', NULL, 'Mohammed salih  Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1801, 6, 'user', 46, 'activity_change_status', '2022-07-24 12:49:29', 'fa-user', NULL, 'test Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1802, 6, 'settings', 6, 'trying_update_email', '2022-07-24 13:04:56', 'fa-coffee', NULL, 'rameez@gmail.com', 'rameez@npco.sa', 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1803, 3, 'user', 6, 'activity_added_new_user', '2022-07-24 13:09:07', 'fa-user', NULL, 'Rameez', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1804, 3, 'user', 49, 'activity_change_status', '2022-07-24 13:34:45', 'fa-user', NULL, 'JABIR ALI Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1805, 3, 'user', 47, 'activity_change_status', '2022-07-24 13:34:48', 'fa-user', NULL, 'npcosystem Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1806, 3, 'user', 50, 'activity_added_new_user', '2022-07-24 15:00:23', 'fa-user', NULL, 'SAMI', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1807, 3, 'user', 50, 'activity_change_status', '2022-07-24 15:01:48', 'fa-user', NULL, 'SAMI Deactive', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1808, 36, 'jobs', 239, 'activity_delete_jobs', '2022-07-24 15:57:48', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1809, 36, 'jobs', 237, 'activity_delete_jobs', '2022-07-24 15:57:58', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1810, 36, 'jobs', 236, 'activity_delete_jobs', '2022-07-24 15:58:14', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1811, 36, 'jobs', 251, NULL, '2022-07-24 16:23:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/251', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1812, 36, 'jobs', 251, NULL, '2022-07-24 16:45:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/251', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1813, 36, 'jobs', 229, 'activity_delete_jobs', '2022-07-24 16:50:23', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1814, 36, 'jobs', 221, 'activity_delete_jobs', '2022-07-24 16:50:39', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1815, 36, 'jobs', 219, 'activity_delete_jobs', '2022-07-24 16:50:49', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1816, 36, 'jobs', 241, 'activity_delete_jobs', '2022-07-24 16:52:12', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1817, 36, 'jobs', 230, 'activity_delete_jobs', '2022-07-24 16:52:53', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1818, 36, 'jobs', 222, 'activity_delete_jobs', '2022-07-24 16:53:00', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1819, 36, 'jobs', 217, 'activity_delete_jobs', '2022-07-24 16:53:14', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1820, 36, 'jobs', 216, 'activity_delete_jobs', '2022-07-24 16:53:21', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1821, 36, 'jobs', 252, NULL, '2022-07-24 17:17:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/252', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1822, 36, 'jobs', 251, NULL, '2022-07-24 17:29:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/251', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1823, 36, 'jobs', 251, NULL, '2022-07-24 21:13:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/251', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1824, 38, 'client', 16, 'activity_update_company', '2022-07-25 11:29:09', 'fa-user', NULL, 'SAAS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1825, 38, 'equipment', 46, NULL, '2022-07-25 11:32:30', 'fa-suitcase', 'admin/equipment/view_equipment_details/46', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1826, 38, 'jobs', 253, NULL, '2022-07-25 11:36:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/253', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1827, 38, 'jobs', 254, NULL, '2022-07-25 12:56:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/254', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1828, 38, 'jobs', 254, NULL, '2022-07-25 13:30:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/254', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1829, 38, 'jobs', 255, NULL, '2022-07-25 14:17:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/255', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1830, 38, 'jobs', 255, NULL, '2022-07-25 14:18:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/255', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1831, 38, 'jobs', 255, NULL, '2022-07-25 14:55:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/255', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1832, 38, 'jobs', 254, NULL, '2022-07-25 14:55:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/254', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1833, 38, 'jobs', 255, NULL, '2022-07-25 15:00:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/255', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1834, 38, 'jobs', 255, NULL, '2022-07-25 15:02:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/255', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1835, 36, 'jobs', 251, NULL, '2022-07-25 15:47:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/251', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1836, 36, 'jobs', 251, NULL, '2022-07-25 15:51:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/251', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1837, 36, 'jobs', 251, NULL, '2022-07-25 15:51:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/251', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1838, 36, 'jobs', 252, NULL, '2022-07-25 15:53:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/252', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1839, 36, 'jobs', 255, NULL, '2022-07-25 16:05:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/255', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1840, 36, 'jobs', 255, NULL, '2022-07-25 16:11:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/255', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1841, 36, 'jobs', 256, NULL, '2022-07-25 16:25:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/256', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1842, 36, 'jobs', 257, NULL, '2022-07-25 16:26:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/257', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1843, 36, 'jobs', 257, NULL, '2022-07-25 16:27:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/257', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1844, 36, 'problems', 10, NULL, '2022-07-25 16:33:49', 'fa-suitcase', 'admin/problems/view_problems_details/10', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1845, 36, 'problems', 8, NULL, '2022-07-25 16:34:14', 'fa-suitcase', 'admin/problems/view_problems_details/8', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1846, 36, 'jobs', 257, NULL, '2022-07-25 16:37:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/257', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1847, 34, 'settings', 34, 'activity_password_update', '2022-07-25 18:06:30', 'fa-coffee', NULL, 'Francisco@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1848, 36, 'jobs', 254, NULL, '2022-07-25 18:43:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/254', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1849, 36, 'jobs', 257, NULL, '2022-07-25 19:12:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/257', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1850, 36, 'jobs', 254, NULL, '2022-07-25 19:24:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/254', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1851, 6, 'jobs', 257, NULL, '2022-07-25 19:37:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/257', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1852, 6, 'jobs', 255, NULL, '2022-07-25 19:57:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/255', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1853, 6, 'jobs', 255, NULL, '2022-07-25 19:57:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/255', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1854, 3, 'jobs', 257, NULL, '2022-07-25 20:18:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/257', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1855, 3, 'jobs', 257, NULL, '2022-07-25 20:19:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/257', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1856, 36, 'jobs', 257, NULL, '2022-07-25 20:39:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/257', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1857, 36, 'jobs', 252, NULL, '2022-07-25 20:47:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/252', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1858, 36, 'jobs', 258, NULL, '2022-07-25 21:40:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/258', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1859, 36, 'jobs', 256, 'activity_delete_jobs', '2022-07-25 21:42:36', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1860, 36, 'jobs', 259, NULL, '2022-07-25 21:44:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/259', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1861, 36, 'problems', 8, NULL, '2022-07-25 21:57:38', 'fa-suitcase', 'admin/problems/view_problems_details/8', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1862, 36, 'jobs', 258, NULL, '2022-07-25 21:58:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/258', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1863, 36, 'jobs', 258, NULL, '2022-07-25 22:57:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/258', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1864, 36, 'jobs', 259, NULL, '2022-07-25 22:59:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/259', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1865, 36, 'jobs', 259, NULL, '2022-07-25 23:06:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/259', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1866, 36, 'jobs', 259, NULL, '2022-07-25 23:07:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/259', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1867, 36, 'jobs', 259, NULL, '2022-07-25 23:07:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/259', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1868, 36, 'jobs', 259, NULL, '2022-07-25 23:07:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/259', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1869, 36, 'jobs', 259, NULL, '2022-07-25 23:07:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/259', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1870, 36, 'jobs', 259, NULL, '2022-07-25 23:08:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/259', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1871, 36, 'jobs', 259, NULL, '2022-07-25 23:08:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/259', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1872, 36, 'jobs', 259, NULL, '2022-07-25 23:09:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/259', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1873, 36, 'jobs', 259, NULL, '2022-07-25 23:09:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/259', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1874, 36, 'jobs', 260, NULL, '2022-07-25 23:22:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/260', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1875, 32, 'settings', 32, 'activity_password_update', '2022-07-26 00:06:56', 'fa-coffee', NULL, 'Francis@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1876, 3, 'jobs', 258, NULL, '2022-07-26 06:06:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/258', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1877, 38, 'jobs', 245, NULL, '2022-07-26 08:18:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1878, 38, 'jobs', 245, NULL, '2022-07-26 08:20:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1879, 38, 'jobs', 245, NULL, '2022-07-26 08:23:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1880, 38, 'jobs', 245, NULL, '2022-07-26 08:25:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1881, 38, 'jobs', 261, NULL, '2022-07-26 08:37:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/261', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1882, 38, 'jobs', 261, NULL, '2022-07-26 08:39:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/261', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1883, 38, 'jobs', 261, NULL, '2022-07-26 08:52:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/261', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1884, 38, 'jobs', 245, NULL, '2022-07-26 08:56:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1885, 38, 'jobs', 245, NULL, '2022-07-26 09:11:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1886, 38, 'jobs', 245, NULL, '2022-07-26 09:17:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1887, 38, 'jobs', 262, NULL, '2022-07-26 09:55:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/262', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1888, 38, 'jobs', 263, NULL, '2022-07-26 10:00:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1889, 10, 'jobs', 261, NULL, '2022-07-26 10:08:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/261', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1890, 10, 'jobs', 263, NULL, '2022-07-26 10:32:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1891, 10, 'jobs', 261, NULL, '2022-07-26 10:33:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/261', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1892, 10, 'jobs', 263, NULL, '2022-07-26 10:39:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1893, 10, 'jobs', 263, NULL, '2022-07-26 10:39:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1894, 6, 'jobs', 259, 'activity_delete_jobs', '2022-07-26 10:55:44', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1895, 6, 'jobs', 260, 'activity_delete_jobs', '2022-07-26 10:55:49', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1896, 38, 'jobs', 263, NULL, '2022-07-26 11:03:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1897, 38, 'jobs', 262, NULL, '2022-07-26 11:03:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/262', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1898, 38, 'jobs', 261, NULL, '2022-07-26 11:04:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/261', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1899, 38, 'jobs', 263, NULL, '2022-07-26 11:05:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1900, 38, 'jobs', 263, NULL, '2022-07-26 11:07:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1901, 6, 'jobs', 94, 'activity_delete_jobs', '2022-07-26 11:17:03', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1902, 6, 'jobs', 95, 'activity_delete_jobs', '2022-07-26 11:17:06', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1903, 6, 'jobs', 96, 'activity_delete_jobs', '2022-07-26 11:17:08', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1904, 6, 'jobs', 97, 'activity_delete_jobs', '2022-07-26 11:17:10', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1905, 6, 'jobs', 98, 'activity_delete_jobs', '2022-07-26 11:17:12', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1906, 6, 'jobs', 99, 'activity_delete_jobs', '2022-07-26 11:17:14', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1907, 6, 'jobs', 100, 'activity_delete_jobs', '2022-07-26 11:17:16', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1908, 6, 'jobs', 101, 'activity_delete_jobs', '2022-07-26 11:17:18', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1909, 6, 'jobs', 102, 'activity_delete_jobs', '2022-07-26 11:17:20', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1910, 6, 'jobs', 103, 'activity_delete_jobs', '2022-07-26 11:17:22', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1911, 6, 'jobs', 104, 'activity_delete_jobs', '2022-07-26 11:17:24', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1912, 6, 'jobs', 105, 'activity_delete_jobs', '2022-07-26 11:17:26', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1913, 6, 'jobs', 106, 'activity_delete_jobs', '2022-07-26 11:17:29', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1914, 6, 'jobs', 107, 'activity_delete_jobs', '2022-07-26 11:17:32', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1915, 6, 'jobs', 108, 'activity_delete_jobs', '2022-07-26 11:17:34', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1916, 6, 'jobs', 109, 'activity_delete_jobs', '2022-07-26 11:17:37', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1917, 10, 'jobs', 262, NULL, '2022-07-26 11:17:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/262', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1918, 6, 'jobs', 110, 'activity_delete_jobs', '2022-07-26 11:17:40', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1919, 6, 'jobs', 111, 'activity_delete_jobs', '2022-07-26 11:17:42', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1920, 6, 'jobs', 112, 'activity_delete_jobs', '2022-07-26 11:17:46', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1921, 6, 'jobs', 114, 'activity_delete_jobs', '2022-07-26 11:17:48', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1922, 10, 'jobs', 262, NULL, '2022-07-26 11:18:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/262', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1923, 10, 'jobs', 262, NULL, '2022-07-26 11:19:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/262', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1924, 6, 'jobs', 115, 'activity_delete_jobs', '2022-07-26 11:24:23', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1925, 6, 'jobs', 116, 'activity_delete_jobs', '2022-07-26 11:24:25', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1926, 6, 'jobs', 117, 'activity_delete_jobs', '2022-07-26 11:24:27', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1927, 6, 'jobs', 118, 'activity_delete_jobs', '2022-07-26 11:24:29', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1928, 6, 'jobs', 119, 'activity_delete_jobs', '2022-07-26 11:24:32', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1929, 6, 'jobs', 120, 'activity_delete_jobs', '2022-07-26 11:24:34', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1930, 6, 'jobs', 121, 'activity_delete_jobs', '2022-07-26 11:24:36', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1931, 6, 'jobs', 122, 'activity_delete_jobs', '2022-07-26 11:24:39', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1932, 6, 'jobs', 124, 'activity_delete_jobs', '2022-07-26 11:24:42', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1933, 6, 'jobs', 135, 'activity_delete_jobs', '2022-07-26 11:24:45', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1934, 6, 'jobs', 138, 'activity_delete_jobs', '2022-07-26 11:24:47', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1935, 6, 'jobs', 139, 'activity_delete_jobs', '2022-07-26 11:24:50', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1936, 6, 'jobs', 140, 'activity_delete_jobs', '2022-07-26 11:24:52', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1937, 6, 'jobs', 141, 'activity_delete_jobs', '2022-07-26 11:24:56', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1938, 6, 'jobs', 142, 'activity_delete_jobs', '2022-07-26 11:24:58', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1939, 6, 'jobs', 143, 'activity_delete_jobs', '2022-07-26 11:25:00', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1940, 6, 'jobs', 145, 'activity_delete_jobs', '2022-07-26 11:25:02', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1941, 6, 'jobs', 147, 'activity_delete_jobs', '2022-07-26 11:25:04', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1942, 6, 'jobs', 148, 'activity_delete_jobs', '2022-07-26 11:25:07', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1943, 6, 'jobs', 149, 'activity_delete_jobs', '2022-07-26 11:25:09', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1944, 6, 'jobs', 150, 'activity_delete_jobs', '2022-07-26 11:25:11', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1945, 6, 'jobs', 151, 'activity_delete_jobs', '2022-07-26 11:25:15', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1946, 6, 'jobs', 152, 'activity_delete_jobs', '2022-07-26 11:25:18', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1947, 6, 'jobs', 154, 'activity_delete_jobs', '2022-07-26 11:25:20', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1948, 6, 'jobs', 155, 'activity_delete_jobs', '2022-07-26 11:25:23', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1949, 6, 'jobs', 156, 'activity_delete_jobs', '2022-07-26 11:25:25', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1950, 6, 'jobs', 163, 'activity_delete_jobs', '2022-07-26 11:25:27', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1951, 6, 'jobs', 164, 'activity_delete_jobs', '2022-07-26 11:25:30', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1952, 6, 'jobs', 165, 'activity_delete_jobs', '2022-07-26 11:25:33', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1953, 6, 'jobs', 167, 'activity_delete_jobs', '2022-07-26 11:25:35', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1954, 6, 'jobs', 167, 'activity_delete_jobs', '2022-07-26 11:25:37', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1955, 6, 'jobs', 169, 'activity_delete_jobs', '2022-07-26 11:25:42', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1956, 6, 'jobs', 172, 'activity_delete_jobs', '2022-07-26 11:25:44', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1957, 6, 'jobs', 173, 'activity_delete_jobs', '2022-07-26 11:25:47', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1958, 6, 'jobs', 174, 'activity_delete_jobs', '2022-07-26 11:26:02', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1959, 6, 'jobs', 175, 'activity_delete_jobs', '2022-07-26 11:26:03', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1960, 6, 'jobs', 176, 'activity_delete_jobs', '2022-07-26 11:26:05', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1961, 6, 'jobs', 177, 'activity_delete_jobs', '2022-07-26 11:26:08', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1962, 6, 'jobs', 178, 'activity_delete_jobs', '2022-07-26 11:26:13', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1963, 6, 'jobs', 179, 'activity_delete_jobs', '2022-07-26 11:26:15', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1964, 6, 'jobs', 185, 'activity_delete_jobs', '2022-07-26 11:26:16', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1965, 6, 'jobs', 186, 'activity_delete_jobs', '2022-07-26 11:26:18', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1966, 6, 'jobs', 188, 'activity_delete_jobs', '2022-07-26 11:26:20', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1967, 6, 'jobs', 189, 'activity_delete_jobs', '2022-07-26 11:26:23', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1968, 6, 'jobs', 190, 'activity_delete_jobs', '2022-07-26 11:26:25', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1969, 6, 'jobs', 191, 'activity_delete_jobs', '2022-07-26 11:26:27', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1970, 6, 'jobs', 192, 'activity_delete_jobs', '2022-07-26 11:26:29', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1971, 6, 'jobs', 193, 'activity_delete_jobs', '2022-07-26 11:26:32', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1972, 6, 'jobs', 193, 'activity_delete_jobs', '2022-07-26 11:26:35', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1973, 6, 'jobs', 262, 'activity_delete_jobs', '2022-07-26 11:29:47', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1974, 38, 'jobs', 264, NULL, '2022-07-26 11:35:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/264', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1975, 38, 'jobs', 264, NULL, '2022-07-26 11:38:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/264', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1976, 10, 'jobs', 263, NULL, '2022-07-26 11:47:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1977, 10, 'jobs', 263, NULL, '2022-07-26 11:50:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1978, 38, 'jobs', 261, NULL, '2022-07-26 12:06:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/261', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1979, 38, 'jobs', 264, NULL, '2022-07-26 12:07:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/264', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1980, 10, 'jobs', 263, NULL, '2022-07-26 12:12:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1981, 38, 'jobs', 261, NULL, '2022-07-26 12:26:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/261', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1982, 38, 'jobs', 245, NULL, '2022-07-26 12:33:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1983, 6, 'settings', 6, 'activity_save_theme_settings', '2022-07-26 12:36:27', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1984, 38, 'jobs', 245, NULL, '2022-07-26 12:36:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1985, 10, 'jobs', 264, NULL, '2022-07-26 12:43:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/264', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1986, 10, 'jobs', 264, NULL, '2022-07-26 12:45:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/264', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1987, 10, 'jobs', 261, NULL, '2022-07-26 12:51:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/261', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1988, 10, 'jobs', 264, NULL, '2022-07-26 12:57:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/264', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1989, 10, 'jobs', 264, NULL, '2022-07-26 12:58:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/264', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1990, 10, 'jobs', 264, NULL, '2022-07-26 12:58:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/264', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1991, 10, 'jobs', 264, NULL, '2022-07-26 12:59:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/264', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1992, 6, 'settings', 6, 'activity_update_profile', '2022-07-26 13:00:05', 'fa-coffee', NULL, 'Syed Rameez', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1993, 6, 'settings', 6, 'activity_update_profile', '2022-07-26 13:00:53', 'fa-coffee', NULL, 'Syed Rameez', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1994, 38, 'jobs', 264, 'activity_delete_jobs', '2022-07-26 13:20:21', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1995, 38, 'jobs', 261, 'activity_delete_jobs', '2022-07-26 13:20:26', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1996, 38, 'jobs', 265, NULL, '2022-07-26 13:23:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/265', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1997, 38, 'jobs', 266, NULL, '2022-07-26 13:27:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/266', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1998, 38, 'jobs', 265, NULL, '2022-07-26 14:22:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/265', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (1999, 38, 'jobs', 266, NULL, '2022-07-26 14:25:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/266', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2000, 10, 'jobs', 265, NULL, '2022-07-26 14:36:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/265', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2001, 38, 'jobs', 266, NULL, '2022-07-26 14:45:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/266', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2002, 38, 'jobs', 266, NULL, '2022-07-26 14:47:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/266', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2003, 38, 'jobs', 263, NULL, '2022-07-26 14:48:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2004, 38, 'jobs', 266, NULL, '2022-07-26 14:49:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/266', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2005, 10, 'jobs', 265, NULL, '2022-07-26 14:59:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/265', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2006, 10, 'jobs', 266, NULL, '2022-07-26 15:01:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/266', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2007, 36, 'jobs', 266, NULL, '2022-07-26 16:34:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/266', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2008, 6, 'settings', 6, 'activity_save_general_settings', '2022-07-26 16:35:24', 'fa-coffee', NULL, 'National Commercial Pledges Company', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2009, 6, 'settings', 6, 'activity_save_theme_settings', '2022-07-26 16:37:00', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2010, 6, 'settings', 6, 'activity_save_theme_settings', '2022-07-26 16:38:59', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2011, 6, 'settings', 6, 'activity_save_theme_settings', '2022-07-26 16:41:15', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2012, 6, 'settings', 6, 'activity_save_theme_settings', '2022-07-26 16:43:18', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2013, 6, 'settings', 6, 'activity_save_theme_settings', '2022-07-26 16:46:40', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2014, 6, 'settings', 6, 'activity_save_theme_settings', '2022-07-26 16:52:40', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2015, 6, 'settings', 6, 'activity_save_theme_settings', '2022-07-26 16:54:39', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2016, 6, 'settings', 6, 'activity_save_theme_settings', '2022-07-26 16:56:14', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2017, 10, 'jobs', 266, NULL, '2022-07-26 17:32:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/266', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2018, 10, 'jobs', 267, NULL, '2022-07-26 17:34:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/267', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2019, 36, 'jobs', 268, NULL, '2022-07-26 17:44:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/268', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2020, 3, 'jobs', 268, NULL, '2022-07-26 17:53:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/268', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2021, 3, 'jobs', 268, NULL, '2022-07-26 18:03:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/268', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2022, 36, 'jobs', 258, NULL, '2022-07-26 18:08:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/258', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2023, 36, 'jobs', 265, NULL, '2022-07-26 18:14:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/265', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2024, 3, 'jobs', 268, NULL, '2022-07-26 18:16:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/268', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2025, 36, 'jobs', 266, NULL, '2022-07-26 18:20:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/266', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2026, 10, 'jobs', 268, NULL, '2022-07-26 19:01:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/268', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2027, 10, 'jobs', 268, NULL, '2022-07-26 19:01:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/268', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2028, 10, 'jobs', 268, NULL, '2022-07-26 19:01:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/268', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2029, 10, 'jobs', 268, NULL, '2022-07-26 19:02:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/268', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2030, 3, 'jobs', 268, 'activity_delete_jobs', '2022-07-26 21:39:33', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2031, 3, 'jobs', 268, 'activity_delete_jobs', '2022-07-26 21:39:40', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2032, 3, 'jobs', 267, 'activity_delete_jobs', '2022-07-26 21:41:08', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2033, 3, 'jobs', 269, NULL, '2022-07-26 21:42:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/269', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2034, 3, 'jobs', 269, 'activity_delete_jobs', '2022-07-26 21:43:16', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2035, 3, 'jobs', 261, 'activity_delete_jobs', '2022-07-26 21:44:48', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2036, 3, 'jobs', 264, 'activity_delete_jobs', '2022-07-26 21:44:54', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2037, 6, 'jobs', 270, NULL, '2022-07-26 22:06:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/270', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2038, 6, 'jobs', 270, 'activity_delete_jobs', '2022-07-26 22:08:48', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2039, 36, 'jobs', 263, NULL, '2022-07-26 22:44:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2040, 36, 'jobs', 263, NULL, '2022-07-26 22:45:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/263', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2041, 32, 'jobs', 266, NULL, '2022-07-26 23:28:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/266', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2042, 32, 'jobs', 245, NULL, '2022-07-26 23:51:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/245', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2043, 38, 'jobs', 271, NULL, '2022-07-27 07:27:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2044, 38, 'jobs', 271, NULL, '2022-07-27 07:28:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2045, 38, 'jobs', 272, NULL, '2022-07-27 07:47:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/272', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2046, 38, 'jobs', 272, NULL, '2022-07-27 07:49:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/272', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2047, 38, 'jobs', 271, NULL, '2022-07-27 07:49:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2048, 38, 'jobs', 271, NULL, '2022-07-27 07:49:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2049, 38, 'jobs', 273, NULL, '2022-07-27 08:17:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/273', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2050, 38, 'jobs', 273, NULL, '2022-07-27 09:37:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/273', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2051, 6, 'departments', 5, 'activity_added_a_department', '2022-07-27 09:59:18', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2052, 38, 'settings', 38, 'activity_update_profile', '2022-07-27 10:21:09', 'fa-coffee', NULL, 'Jay A. Dajotoy', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2053, 38, 'settings', 38, 'activity_update_profile', '2022-07-27 10:28:47', 'fa-coffee', NULL, 'Jay A. Dajotoy', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2054, 6, 'tasks', 16, 'activity_task_deleted', '2022-07-27 11:12:21', 'fa-tasks', NULL, '1', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2055, 6, 'user', 51, 'activity_added_new_user', '2022-07-27 11:16:34', 'fa-user', NULL, 'Zidan', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2056, 6, 'user', 52, 'activity_added_new_user', '2022-07-27 11:22:10', 'fa-user', NULL, 'Zidan@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2057, 38, 'jobs', 274, NULL, '2022-07-27 12:38:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/274', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2058, 38, 'jobs', 274, NULL, '2022-07-27 12:39:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/274', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2059, 38, 'jobs', 274, NULL, '2022-07-27 12:48:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/274', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2060, 3, 'jobs', 274, NULL, '2022-07-27 13:10:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/274', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2061, 38, 'jobs', 274, NULL, '2022-07-27 13:18:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/274', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2062, 38, 'jobs', 274, NULL, '2022-07-27 13:20:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/274', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2063, 3, 'jobs', 275, NULL, '2022-07-27 16:11:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/275', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2064, 3, 'jobs', 275, 'activity_delete_jobs', '2022-07-27 16:11:43', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2065, 10, 'jobs', 273, NULL, '2022-07-27 17:22:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/273', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2066, 36, 'jobs', 273, NULL, '2022-07-27 18:02:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/273', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2067, 3, 'jobs', 274, NULL, '2022-07-27 18:45:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/274', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2068, 3, 'jobs', 274, NULL, '2022-07-27 18:58:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/274', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2069, 36, 'jobs', 274, NULL, '2022-07-27 22:05:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/274', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2070, 32, 'jobs', 274, NULL, '2022-07-28 00:41:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/274', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2071, 32, 'jobs', 276, NULL, '2022-07-28 00:51:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/276', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2072, 32, 'jobs', 277, NULL, '2022-07-28 00:59:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/277', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2073, 32, 'jobs', 278, NULL, '2022-07-28 01:01:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/278', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2074, 32, 'jobs', 276, NULL, '2022-07-28 03:06:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/276', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2075, 32, 'jobs', 279, NULL, '2022-07-28 03:08:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/279', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2076, 32, 'jobs', 278, NULL, '2022-07-28 04:46:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/278', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2077, 10, 'jobs', 279, NULL, '2022-07-28 05:10:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/279', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2078, 10, 'jobs', 278, NULL, '2022-07-28 05:11:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/278', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2079, 10, 'jobs', 277, NULL, '2022-07-28 05:13:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/277', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2080, 10, 'jobs', 276, NULL, '2022-07-28 05:13:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/276', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2081, 32, 'jobs', 279, NULL, '2022-07-28 05:22:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/279', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2082, 32, 'jobs', 278, NULL, '2022-07-28 05:25:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/278', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2083, 32, 'jobs', 276, NULL, '2022-07-28 05:37:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/276', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2084, 32, 'jobs', 279, NULL, '2022-07-28 06:23:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/279', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2085, 32, 'jobs', 279, NULL, '2022-07-28 06:24:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/279', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2086, 32, 'jobs', 277, NULL, '2022-07-28 06:43:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/277', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2087, 38, 'jobs', 280, NULL, '2022-07-28 07:20:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/280', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2088, 38, 'jobs', 281, NULL, '2022-07-28 07:23:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2089, 38, 'jobs', 280, NULL, '2022-07-28 07:24:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/280', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2090, 38, 'jobs', 281, NULL, '2022-07-28 07:25:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2091, 38, 'jobs', 282, NULL, '2022-07-28 08:17:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/282', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2092, 38, 'jobs', 282, NULL, '2022-07-28 08:17:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/282', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2093, 10, 'jobs', 282, NULL, '2022-07-28 09:01:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/282', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2094, 10, 'jobs', 282, NULL, '2022-07-28 09:08:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/282', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2095, 38, 'jobs', 272, NULL, '2022-07-28 09:43:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/272', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2096, 38, 'jobs', 272, NULL, '2022-07-28 09:46:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/272', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2097, 38, 'jobs', 282, NULL, '2022-07-28 09:59:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/282', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2098, 38, 'jobs', 283, NULL, '2022-07-28 11:08:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/283', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2099, 38, 'jobs', 282, NULL, '2022-07-28 11:33:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/282', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2100, 38, 'jobs', 282, NULL, '2022-07-28 11:35:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/282', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2101, 38, 'jobs', 282, NULL, '2022-07-28 11:36:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/282', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2102, 38, 'jobs', 282, NULL, '2022-07-28 12:52:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/282', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2103, 38, 'jobs', 283, NULL, '2022-07-28 12:52:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/283', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2104, 6, 'client', 6, 'activity_deleted_client', '2022-07-28 14:51:28', 'fa-user', NULL, 'digitaldeloitte.com ugrfeiohofidsksmvnjdbvsijf94t9u5t0i4r94ijgrjght9y84r49t64rkowf0ereiuguejdkwdiweofuehdskodjjdgofjsoddggfsidj', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2105, 6, 'client', 6, 'activity_deleted_client', '2022-07-28 14:52:59', 'fa-user', NULL, 'test', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2106, 6, 'client', 6, 'activity_deleted_client', '2022-07-28 14:53:38', 'fa-user', NULL, 'JABIR ALI', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2107, 6, 'client', 6, 'activity_deleted_client', '2022-07-28 14:53:38', 'fa-user', NULL, 'JABIR ALI', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2108, 6, 'client', 6, 'activity_deleted_client', '2022-07-28 14:53:38', 'fa-user', NULL, 'npcosystem', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2109, 6, 'client', 6, 'activity_deleted_client', '2022-07-28 14:54:08', 'fa-user', NULL, 'مصنع الرياض للقطع المعدنية ', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2110, 6, 'client', 6, 'activity_deleted_client', '2022-07-28 14:54:44', 'fa-user', NULL, 'SAMI', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2111, 36, 'jobs', 283, NULL, '2022-07-28 16:46:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/283', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2112, 7, 'settings', 7, 'activity_password_update', '2022-07-28 16:53:04', 'fa-coffee', NULL, 'Abdulwahab', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2113, 3, 'jobs', 284, NULL, '2022-07-28 20:15:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/284', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2114, 32, 'jobs', 285, NULL, '2022-07-29 02:07:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/285', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2115, 32, 'jobs', 286, NULL, '2022-07-29 02:09:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/286', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2116, 32, 'jobs', 287, NULL, '2022-07-29 02:11:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/287', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2117, 32, 'jobs', 288, NULL, '2022-07-29 02:12:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/288', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2118, 32, 'jobs', 285, NULL, '2022-07-29 03:39:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/285', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2119, 32, 'jobs', 286, NULL, '2022-07-29 03:44:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/286', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2120, 32, 'jobs', 287, NULL, '2022-07-29 03:47:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/287', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2121, 32, 'jobs', 288, NULL, '2022-07-29 03:51:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/288', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2122, 32, 'jobs', 289, NULL, '2022-07-29 03:57:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/289', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2123, 32, 'jobs', 290, NULL, '2022-07-29 03:59:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/290', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2124, 32, 'jobs', 291, NULL, '2022-07-29 04:01:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/291', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2125, 32, 'jobs', 292, NULL, '2022-07-29 05:30:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/292', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2126, 32, 'jobs', 292, NULL, '2022-07-29 05:44:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/292', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2127, 32, 'jobs', 285, NULL, '2022-07-29 05:59:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/285', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2128, 32, 'jobs', 289, NULL, '2022-07-29 05:59:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/289', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2129, 32, 'jobs', 289, NULL, '2022-07-29 06:39:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/289', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2130, 32, 'jobs', 290, NULL, '2022-07-29 06:43:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/290', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2131, 32, 'jobs', 291, NULL, '2022-07-29 06:48:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/291', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2132, 32, 'jobs', 292, NULL, '2022-07-29 06:51:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/292', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2133, 6, 'jobs', 293, NULL, '2022-07-29 13:02:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2134, 3, 'jobs', 294, NULL, '2022-07-29 13:03:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/294', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2135, 6, 'jobs', 293, 'activity_delete_jobs', '2022-07-29 13:04:48', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2136, 6, 'jobs', 294, 'activity_delete_jobs', '2022-07-29 13:05:11', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2137, 6, 'jobs', 295, NULL, '2022-07-29 13:05:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/295', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2138, 6, 'jobs', 295, 'activity_delete_jobs', '2022-07-29 13:07:13', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2139, 6, 'jobs', 296, NULL, '2022-07-29 13:14:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/296', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2140, 6, 'jobs', 296, 'activity_delete_jobs', '2022-07-29 13:14:46', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2141, 38, 'jobs', 293, NULL, '2022-07-31 10:34:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2142, 38, 'jobs', 293, NULL, '2022-07-31 10:46:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2143, 38, 'jobs', 293, NULL, '2022-07-31 10:51:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2144, 10, 'jobs', 293, NULL, '2022-07-31 11:31:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2145, 10, 'jobs', 293, NULL, '2022-07-31 12:02:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2146, 38, 'jobs', 293, NULL, '2022-07-31 12:35:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2147, 38, 'jobs', 293, NULL, '2022-07-31 12:50:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2148, 3, 'jobs', 294, NULL, '2022-07-31 13:51:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/294', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2149, 3, 'jobs', 297, NULL, '2022-07-31 14:14:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/297', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2150, 3, 'jobs', 298, NULL, '2022-07-31 14:16:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/298', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2151, 36, 'jobs', 299, NULL, '2022-07-31 16:21:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/299', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2152, 6, 'jobs', 295, 'activity_delete_jobs', '2022-07-31 16:30:09', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2153, 6, 'jobs', 296, 'activity_delete_jobs', '2022-07-31 16:30:15', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2154, 6, 'jobs', 297, 'activity_delete_jobs', '2022-07-31 16:30:17', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2155, 6, 'jobs', 298, 'activity_delete_jobs', '2022-07-31 16:30:20', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2156, 6, 'jobs', 294, NULL, '2022-07-31 16:39:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/294', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2157, 6, 'jobs', 294, NULL, '2022-07-31 16:40:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/294', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2158, 6, 'jobs', 294, 'activity_delete_jobs', '2022-07-31 16:41:04', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2159, 10, 'jobs', 299, NULL, '2022-07-31 16:54:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/299', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2160, 10, 'jobs', 299, NULL, '2022-07-31 17:38:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/299', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2161, 36, 'jobs', 299, NULL, '2022-07-31 22:02:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/299', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2162, 32, 'jobs', 300, NULL, '2022-08-01 02:36:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/300', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2163, 32, 'jobs', 301, NULL, '2022-08-01 05:14:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/301', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2164, 32, 'jobs', 300, NULL, '2022-08-01 06:01:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/300', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2165, 32, 'jobs', 301, NULL, '2022-08-01 06:11:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/301', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2166, 32, 'jobs', 302, NULL, '2022-08-01 06:54:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/302', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2167, 32, 'jobs', 303, NULL, '2022-08-01 07:00:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/303', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2168, 32, 'jobs', 301, NULL, '2022-08-01 07:27:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/301', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2169, 32, 'jobs', 301, NULL, '2022-08-01 07:30:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/301', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2170, 32, 'jobs', 303, NULL, '2022-08-01 07:35:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/303', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2171, 32, 'jobs', 302, NULL, '2022-08-01 07:35:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/302', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2172, 38, 'jobs', 302, NULL, '2022-08-01 07:49:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/302', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2173, 38, 'jobs', 303, NULL, '2022-08-01 07:50:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/303', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2174, 38, 'jobs', 304, NULL, '2022-08-01 08:38:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/304', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2175, 38, 'jobs', 304, NULL, '2022-08-01 08:44:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/304', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2176, 38, 'jobs', 304, NULL, '2022-08-01 08:48:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/304', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2177, 38, 'jobs', 304, NULL, '2022-08-01 08:54:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/304', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2178, 3, 'settings', 3, 'activity_save_theme_settings', '2022-08-01 10:48:39', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2179, 3, 'settings', 3, 'activity_save_theme_settings', '2022-08-01 10:49:05', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2180, 3, 'settings', 3, 'activity_save_theme_settings', '2022-08-01 10:49:38', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2181, 3, 'settings', 3, 'activity_save_theme_settings', '2022-08-01 10:52:41', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2182, 38, 'jobs', 281, NULL, '2022-08-01 10:53:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2183, 38, 'jobs', 281, NULL, '2022-08-01 10:54:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2184, 38, 'jobs', 281, NULL, '2022-08-01 10:55:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2185, 38, 'jobs', 281, NULL, '2022-08-01 10:59:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2186, 38, 'jobs', 281, NULL, '2022-08-01 11:04:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2187, 38, 'jobs', 280, NULL, '2022-08-01 11:05:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/280', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2188, 38, 'jobs', 280, NULL, '2022-08-01 11:08:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/280', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2189, 38, 'jobs', 280, NULL, '2022-08-01 11:09:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/280', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2190, 38, 'jobs', 281, NULL, '2022-08-01 11:10:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2191, 10, 'jobs', 248, NULL, '2022-08-01 11:37:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/248', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2192, 10, 'jobs', 248, NULL, '2022-08-01 11:40:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/248', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2193, 38, 'jobs', 271, NULL, '2022-08-01 11:45:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2194, 38, 'jobs', 293, NULL, '2022-08-01 11:47:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2195, 6, 'settings', 6, 'activity_save_theme_settings', '2022-08-01 11:59:06', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2196, 6, 'departments', 5, 'activity_added_a_department', '2022-08-01 14:17:45', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2197, 10, 'jobs', 293, NULL, '2022-08-01 18:54:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2198, 10, 'jobs', 293, NULL, '2022-08-01 18:57:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2199, 10, 'jobs', 293, NULL, '2022-08-01 18:57:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2200, 10, 'jobs', 293, NULL, '2022-08-01 18:57:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2201, 10, 'jobs', 293, NULL, '2022-08-01 18:57:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2202, 10, 'jobs', 293, NULL, '2022-08-01 18:57:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2203, 10, 'jobs', 293, NULL, '2022-08-01 18:57:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2204, 10, 'jobs', 293, NULL, '2022-08-01 18:57:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/293', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2205, 6, 'jobs', 305, NULL, '2022-08-01 20:36:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/305', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2206, 6, 'jobs', 305, 'activity_delete_jobs', '2022-08-01 20:37:46', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2207, 36, 'jobs', 306, NULL, '2022-08-01 21:06:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/306', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2208, 10, 'jobs', 306, NULL, '2022-08-01 21:14:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/306', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2209, 36, 'jobs', 302, NULL, '2022-08-01 21:42:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/302', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2210, 36, 'jobs', 303, NULL, '2022-08-01 21:48:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/303', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2211, 32, 'jobs', 306, NULL, '2022-08-02 00:48:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/306', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2212, 32, 'jobs', 302, NULL, '2022-08-02 00:53:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/302', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2213, 32, 'jobs', 302, NULL, '2022-08-02 00:56:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/302', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2214, 32, 'jobs', 303, NULL, '2022-08-02 00:56:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/303', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2215, 32, 'jobs', 306, NULL, '2022-08-02 00:57:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/306', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2216, 32, 'jobs', 306, NULL, '2022-08-02 00:59:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/306', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2217, 32, 'jobs', 307, NULL, '2022-08-02 03:26:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/307', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2218, 32, 'jobs', 308, NULL, '2022-08-02 03:31:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/308', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2219, 32, 'jobs', 309, NULL, '2022-08-02 03:35:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/309', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2220, 32, 'jobs', 308, NULL, '2022-08-02 04:59:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/308', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2221, 32, 'jobs', 309, NULL, '2022-08-02 04:59:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/309', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2222, 32, 'jobs', 307, NULL, '2022-08-02 05:26:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/307', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2223, 32, 'jobs', 308, NULL, '2022-08-02 05:28:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/308', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2224, 32, 'jobs', 309, NULL, '2022-08-02 05:32:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/309', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2225, 32, 'jobs', 309, NULL, '2022-08-02 05:34:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/309', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2226, 38, 'jobs', 310, NULL, '2022-08-02 07:44:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/310', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2227, 38, 'jobs', 310, NULL, '2022-08-02 07:45:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/310', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2228, 38, 'jobs', 310, NULL, '2022-08-02 07:46:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/310', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2229, 38, 'jobs', 310, NULL, '2022-08-02 07:47:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/310', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2230, 3, 'jobs', 293, 'activity_delete_jobs', '2022-08-02 07:50:03', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2231, 38, 'jobs', 281, NULL, '2022-08-02 08:59:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2232, 38, 'jobs', 281, NULL, '2022-08-02 09:00:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2233, 38, 'jobs', 281, NULL, '2022-08-02 09:02:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2234, 38, 'jobs', 281, NULL, '2022-08-02 09:02:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2235, 38, 'jobs', 281, NULL, '2022-08-02 09:03:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2236, 38, 'jobs', 280, NULL, '2022-08-02 09:03:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/280', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2237, 38, 'jobs', 271, NULL, '2022-08-02 09:04:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2238, 38, 'jobs', 271, NULL, '2022-08-02 09:06:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2239, 38, 'jobs', 271, NULL, '2022-08-02 09:07:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2240, 38, 'jobs', 281, NULL, '2022-08-02 09:08:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2241, 38, 'jobs', 281, NULL, '2022-08-02 09:08:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2242, 38, 'jobs', 280, NULL, '2022-08-02 09:08:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/280', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2243, 38, 'jobs', 281, NULL, '2022-08-02 09:09:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2244, 38, 'jobs', 281, NULL, '2022-08-02 09:09:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/281', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2245, 38, 'jobs', 271, NULL, '2022-08-02 09:10:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2246, 38, 'jobs', 271, NULL, '2022-08-02 09:10:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2247, 38, 'jobs', 271, NULL, '2022-08-02 09:11:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2248, 38, 'jobs', 271, NULL, '2022-08-02 09:12:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2249, 38, 'jobs', 311, NULL, '2022-08-02 10:55:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/311', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2250, 38, 'jobs', 312, NULL, '2022-08-02 11:00:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/312', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2251, 38, 'jobs', 312, NULL, '2022-08-02 11:02:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/312', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2252, 38, 'jobs', 312, NULL, '2022-08-02 11:02:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/312', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2253, 6, 'jobs', 248, 'activity_delete_jobs', '2022-08-02 11:20:47', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2254, 10, 'jobs', 311, NULL, '2022-08-02 11:40:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/311', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2255, 10, 'jobs', 311, NULL, '2022-08-02 11:40:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/311', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2256, 38, 'jobs', 312, NULL, '2022-08-02 11:48:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/312', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2257, 38, 'jobs', 311, NULL, '2022-08-02 11:50:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/311', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2258, 38, 'jobs', 311, NULL, '2022-08-02 11:52:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/311', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2259, 38, 'jobs', 313, NULL, '2022-08-02 12:19:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/313', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2260, 38, 'jobs', 313, NULL, '2022-08-02 12:23:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/313', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2261, 38, 'jobs', 313, NULL, '2022-08-02 13:35:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/313', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2262, 36, 'jobs', 312, NULL, '2022-08-02 15:58:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/312', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2263, 10, 'jobs', 314, NULL, '2022-08-02 16:25:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/314', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2264, 36, 'jobs', 312, NULL, '2022-08-02 16:28:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/312', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2265, 36, 'jobs', 311, NULL, '2022-08-02 16:29:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/311', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2266, 10, 'jobs', 315, NULL, '2022-08-02 18:12:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/315', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2267, 10, 'jobs', 315, NULL, '2022-08-02 18:59:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/315', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2268, 36, 'jobs', 304, NULL, '2022-08-02 20:35:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/304', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2269, 36, 'jobs', 310, NULL, '2022-08-02 20:41:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/310', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2270, 36, 'jobs', 313, NULL, '2022-08-02 22:45:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/313', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2271, 36, 'jobs', 313, NULL, '2022-08-02 22:48:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/313', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2272, 36, 'jobs', 313, NULL, '2022-08-02 22:49:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/313', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2273, 36, 'jobs', 314, NULL, '2022-08-02 22:56:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/314', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2274, 32, 'jobs', 315, NULL, '2022-08-02 23:55:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/315', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2275, 32, 'jobs', 315, NULL, '2022-08-03 00:03:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/315', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2276, 32, 'jobs', 315, NULL, '2022-08-03 00:03:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/315', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2277, 32, 'jobs', 315, NULL, '2022-08-03 00:03:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/315', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2278, 32, 'jobs', 316, NULL, '2022-08-03 01:25:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/316', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2279, 32, 'jobs', 317, NULL, '2022-08-03 01:36:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/317', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2280, 32, 'jobs', 318, NULL, '2022-08-03 01:47:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/318', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2281, 32, 'jobs', 318, NULL, '2022-08-03 04:17:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/318', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2282, 32, 'jobs', 317, NULL, '2022-08-03 06:17:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/317', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2283, 32, 'jobs', 316, NULL, '2022-08-03 06:18:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/316', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2284, 32, 'jobs', 318, NULL, '2022-08-03 06:20:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/318', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2285, 38, 'jobs', 314, NULL, '2022-08-03 09:29:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/314', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2286, 38, 'jobs', 271, NULL, '2022-08-03 09:55:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/271', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2287, 38, 'jobs', 319, NULL, '2022-08-03 10:10:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/319', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2288, 38, 'jobs', 320, NULL, '2022-08-03 10:54:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/320', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2289, 6, 'departments', 5, 'activity_added_a_department', '2022-08-03 12:13:24', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2290, 6, 'user', 22, 'activity_added_new_user', '2022-08-03 12:15:55', 'fa-user', NULL, 'Wilfredo.c@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2291, 6, 'user', 22, 'activity_added_new_user', '2022-08-03 12:27:39', 'fa-user', NULL, 'Wilfredo.c@npco.sa', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2292, 38, 'jobs', 320, NULL, '2022-08-03 12:42:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/320', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2293, 38, 'jobs', 320, NULL, '2022-08-03 12:43:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/320', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2294, 6, 'jobs', 299, NULL, '2022-08-03 12:50:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/299', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2295, 38, 'jobs', 320, NULL, '2022-08-03 13:26:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/320', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2296, 38, 'jobs', 320, NULL, '2022-08-03 13:27:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/320', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2297, 38, 'jobs', 320, NULL, '2022-08-03 13:59:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/320', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2298, 38, 'jobs', 320, NULL, '2022-08-03 13:59:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/320', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2299, 38, 'jobs', 320, NULL, '2022-08-03 14:03:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/320', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2300, 38, 'jobs', 320, NULL, '2022-08-03 14:04:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/320', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2301, 38, 'jobs', 320, NULL, '2022-08-03 14:05:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/320', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2302, 36, 'jobs', 316, NULL, '2022-08-03 19:42:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/316', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2303, 36, 'jobs', 317, NULL, '2022-08-03 19:48:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/317', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2304, 36, 'jobs', 319, NULL, '2022-08-03 19:56:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/319', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2305, 36, 'settings', 36, 'activity_update_profile', '2022-08-03 20:16:34', 'fa-coffee', NULL, 'Saddam Lindit', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2306, 36, 'settings', 36, 'activity_update_profile', '2022-08-03 20:17:53', 'fa-coffee', NULL, 'Saddam Lindit', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2307, 32, 'jobs', 321, NULL, '2022-08-04 01:31:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/321', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2308, 32, 'jobs', 321, NULL, '2022-08-04 05:09:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/321', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2309, 38, 'jobs', 322, NULL, '2022-08-04 08:08:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/322', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2310, 38, 'jobs', 322, NULL, '2022-08-04 08:08:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/322', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2311, 38, 'jobs', 323, NULL, '2022-08-04 09:00:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/323', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2312, 38, 'jobs', 323, NULL, '2022-08-04 10:49:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/323', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2313, 38, 'jobs', 324, NULL, '2022-08-04 10:52:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/324', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2314, 38, 'jobs', 322, NULL, '2022-08-04 11:04:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/322', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2315, 38, 'jobs', 324, NULL, '2022-08-04 11:04:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/324', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2316, 36, 'jobs', 321, NULL, '2022-08-04 21:03:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/321', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2317, 36, 'jobs', 323, NULL, '2022-08-04 21:08:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/323', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2318, 32, 'jobs', 325, NULL, '2022-08-05 03:57:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/325', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2319, 32, 'jobs', 326, NULL, '2022-08-05 04:07:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/326', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2320, 32, 'jobs', 325, NULL, '2022-08-05 04:07:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/325', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2321, 32, 'jobs', 327, NULL, '2022-08-05 04:12:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/327', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2322, 32, 'jobs', 325, NULL, '2022-08-05 04:15:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/325', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2323, 32, 'jobs', 327, NULL, '2022-08-05 04:18:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/327', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2324, 32, 'jobs', 327, NULL, '2022-08-05 04:21:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/327', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2325, 32, 'jobs', 327, NULL, '2022-08-05 04:22:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/327', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2326, 32, 'jobs', 327, NULL, '2022-08-05 04:23:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/327', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2327, 32, 'jobs', 327, NULL, '2022-08-05 04:23:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/327', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2328, 10, 'jobs', 327, NULL, '2022-08-05 04:25:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/327', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2329, 10, 'jobs', 327, NULL, '2022-08-05 04:29:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/327', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2330, 10, 'jobs', 327, NULL, '2022-08-05 04:30:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/327', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2331, 32, 'jobs', 328, NULL, '2022-08-05 05:22:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/328', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2332, 32, 'jobs', 326, NULL, '2022-08-05 05:41:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/326', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2333, 32, 'jobs', 328, NULL, '2022-08-05 05:47:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/328', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2334, 32, 'jobs', 327, NULL, '2022-08-05 05:48:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/327', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2335, 32, 'jobs', 326, NULL, '2022-08-05 05:49:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/326', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2336, 32, 'jobs', 325, NULL, '2022-08-05 05:49:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/325', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2337, 32, 'jobs', 328, NULL, '2022-08-05 05:50:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/328', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2338, 32, 'jobs', 328, NULL, '2022-08-05 06:25:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/328', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2339, 32, 'jobs', 324, NULL, '2022-08-05 06:39:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/324', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2340, 32, 'jobs', 324, NULL, '2022-08-05 06:40:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/324', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2341, 10, 'jobs', 329, NULL, '2022-08-05 12:42:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/329', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2342, 10, 'jobs', 329, NULL, '2022-08-05 12:50:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/329', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2343, 10, 'jobs', 329, NULL, '2022-08-05 12:53:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/329', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2344, 10, 'jobs', 329, NULL, '2022-08-05 13:00:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/329', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2345, 10, 'jobs', 329, NULL, '2022-08-05 13:01:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/329', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2346, 10, 'jobs', 329, NULL, '2022-08-05 13:37:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/329', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2347, 10, 'jobs', 329, NULL, '2022-08-05 13:54:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/329', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2348, 10, 'jobs', 330, NULL, '2022-08-05 16:12:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/330', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2349, 10, 'jobs', 330, NULL, '2022-08-05 18:16:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/330', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2350, 10, 'jobs', 330, NULL, '2022-08-05 20:34:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/330', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2351, 10, 'jobs', 330, NULL, '2022-08-05 22:00:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/330', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2352, 10, 'jobs', 330, NULL, '2022-08-05 22:01:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/330', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2353, 10, 'jobs', 331, NULL, '2022-08-06 04:21:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/331', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2354, 10, 'jobs', 331, NULL, '2022-08-06 05:12:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/331', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2355, 10, 'jobs', 331, NULL, '2022-08-06 05:43:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/331', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2356, 10, 'jobs', 332, NULL, '2022-08-06 08:02:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/332', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2357, 10, 'jobs', 332, NULL, '2022-08-06 08:03:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/332', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2358, 10, 'jobs', 332, NULL, '2022-08-06 08:06:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/332', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2359, 10, 'jobs', 332, NULL, '2022-08-06 08:07:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/332', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2360, 10, 'jobs', 333, NULL, '2022-08-06 10:30:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/333', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2361, 10, 'jobs', 332, NULL, '2022-08-06 10:35:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/332', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2362, 10, 'jobs', 334, NULL, '2022-08-06 11:45:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/334', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2363, 10, 'jobs', 332, NULL, '2022-08-06 12:33:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/332', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2364, 10, 'jobs', 335, NULL, '2022-08-06 17:28:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/335', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2365, 10, 'jobs', 336, NULL, '2022-08-06 17:32:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/336', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2366, 10, 'jobs', 337, NULL, '2022-08-06 17:33:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/337', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2367, 10, 'jobs', 338, NULL, '2022-08-06 17:33:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/338', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2368, 10, 'jobs', 339, NULL, '2022-08-06 17:33:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/339', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2369, 10, 'jobs', 340, NULL, '2022-08-06 17:34:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/340', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2370, 10, 'jobs', 341, NULL, '2022-08-06 17:34:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/341', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2371, 10, 'jobs', 342, NULL, '2022-08-06 17:34:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/342', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2372, 10, 'jobs', 336, 'activity_delete_jobs', '2022-08-06 17:42:48', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2373, 10, 'jobs', 336, 'activity_delete_jobs', '2022-08-06 17:42:51', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2374, 10, 'jobs', 338, 'activity_delete_jobs', '2022-08-06 17:42:53', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2375, 10, 'jobs', 339, 'activity_delete_jobs', '2022-08-06 17:42:55', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2376, 10, 'jobs', 340, 'activity_delete_jobs', '2022-08-06 17:43:01', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2377, 10, 'jobs', 341, 'activity_delete_jobs', '2022-08-06 17:43:06', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2378, 10, 'jobs', 342, 'activity_delete_jobs', '2022-08-06 17:43:08', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2379, 10, 'jobs', 337, 'activity_delete_jobs', '2022-08-06 17:43:56', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2380, 10, 'jobs', 335, NULL, '2022-08-06 17:55:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/335', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2381, 10, 'jobs', 335, NULL, '2022-08-06 18:15:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/335', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2382, 10, 'jobs', 333, NULL, '2022-08-06 18:22:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/333', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2383, 10, 'jobs', 334, NULL, '2022-08-06 18:24:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/334', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2384, 10, 'jobs', 335, NULL, '2022-08-06 21:04:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/335', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2385, 10, 'jobs', 343, NULL, '2022-08-06 21:27:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/343', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2386, 10, 'jobs', 344, NULL, '2022-08-06 21:33:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/344', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2387, 10, 'jobs', 344, NULL, '2022-08-06 22:41:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/344', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2388, 10, 'jobs', 343, NULL, '2022-08-06 22:48:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/343', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2389, 10, 'jobs', 343, NULL, '2022-08-06 22:53:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/343', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2390, 10, 'jobs', 344, NULL, '2022-08-06 23:00:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/344', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2391, 10, 'jobs', 343, NULL, '2022-08-06 23:01:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/343', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2392, 10, 'jobs', 345, NULL, '2022-08-07 04:14:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/345', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2393, 10, 'jobs', 346, NULL, '2022-08-07 04:30:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/346', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2394, 10, 'jobs', 346, NULL, '2022-08-07 05:11:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/346', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2395, 10, 'jobs', 345, NULL, '2022-08-07 05:12:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/345', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2396, 10, 'jobs', 346, NULL, '2022-08-07 06:40:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/346', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2397, 38, 'jobs', 347, NULL, '2022-08-07 08:13:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2398, 38, 'jobs', 347, NULL, '2022-08-07 08:27:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2399, 38, 'jobs', 347, NULL, '2022-08-07 08:28:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2400, 38, 'jobs', 348, NULL, '2022-08-07 08:39:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/348', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2401, 38, 'jobs', 349, NULL, '2022-08-07 08:40:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/349', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2402, 38, 'jobs', 350, NULL, '2022-08-07 08:40:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/350', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2403, 38, 'jobs', 350, 'activity_delete_jobs', '2022-08-07 08:40:29', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2404, 10, 'jobs', 334, NULL, '2022-08-07 10:21:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/334', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2405, 38, 'jobs', 351, NULL, '2022-08-07 10:27:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/351', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2406, 38, 'jobs', 351, NULL, '2022-08-07 10:28:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/351', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2407, 10, 'jobs', 334, NULL, '2022-08-07 10:48:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/334', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2408, 38, 'jobs', 347, NULL, '2022-08-07 11:34:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2409, 38, 'jobs', 347, NULL, '2022-08-07 11:34:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2410, 38, 'jobs', 347, NULL, '2022-08-07 11:39:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2411, 38, 'jobs', 347, NULL, '2022-08-07 11:41:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2412, 38, 'jobs', 347, NULL, '2022-08-07 11:43:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2413, 38, 'jobs', 347, NULL, '2022-08-07 11:43:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2414, 38, 'jobs', 335, NULL, '2022-08-07 12:48:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/335', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2415, 38, 'jobs', 347, NULL, '2022-08-07 12:50:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2416, 38, 'jobs', 347, NULL, '2022-08-07 12:51:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2417, 38, 'jobs', 347, NULL, '2022-08-07 12:51:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2418, 38, 'jobs', 347, NULL, '2022-08-07 12:52:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/347', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2419, 10, 'jobs', 352, NULL, '2022-08-07 13:15:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/352', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2420, 10, 'jobs', 352, NULL, '2022-08-07 14:10:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/352', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2421, 10, 'jobs', 352, NULL, '2022-08-07 14:11:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/352', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2422, 10, 'jobs', 334, NULL, '2022-08-07 14:22:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/334', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2423, 10, 'jobs', 334, NULL, '2022-08-07 14:31:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/334', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2424, 10, 'jobs', 334, NULL, '2022-08-07 14:36:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/334', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2425, 10, 'jobs', 348, 'activity_delete_jobs', '2022-08-07 16:43:04', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2426, 10, 'jobs', 349, 'activity_delete_jobs', '2022-08-07 16:43:08', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2427, 10, 'jobs', 344, NULL, '2022-08-07 18:23:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/344', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2428, 10, 'jobs', 343, NULL, '2022-08-07 18:27:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/343', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2429, 36, 'jobs', 343, NULL, '2022-08-07 18:32:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/343', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2430, 36, 'jobs', 329, NULL, '2022-08-07 18:52:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/329', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2431, 36, 'jobs', 330, NULL, '2022-08-07 19:01:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/330', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2432, 36, 'jobs', 331, NULL, '2022-08-07 19:06:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/331', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2433, 36, 'jobs', 332, NULL, '2022-08-07 19:12:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/332', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2434, 36, 'jobs', 333, NULL, '2022-08-07 19:16:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/333', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2435, 36, 'jobs', 334, NULL, '2022-08-07 19:20:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/334', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2436, 36, 'jobs', 335, NULL, '2022-08-07 19:26:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/335', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2437, 36, 'jobs', 343, NULL, '2022-08-07 19:30:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/343', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2438, 36, 'jobs', 344, NULL, '2022-08-07 19:34:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/344', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2439, 36, 'jobs', 345, NULL, '2022-08-07 19:39:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/345', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2440, 36, 'jobs', 346, NULL, '2022-08-07 19:43:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/346', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2441, 10, 'jobs', 353, NULL, '2022-08-07 19:54:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/353', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2442, 10, 'jobs', 354, NULL, '2022-08-07 20:03:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/354', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2443, 10, 'jobs', 354, NULL, '2022-08-07 20:12:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/354', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2444, 10, 'jobs', 354, NULL, '2022-08-07 20:21:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/354', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2445, 10, 'jobs', 353, NULL, '2022-08-07 20:24:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/353', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2446, 10, 'jobs', 353, NULL, '2022-08-07 20:24:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/353', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2447, 10, 'jobs', 353, NULL, '2022-08-07 20:24:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/353', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2448, 10, 'jobs', 353, NULL, '2022-08-07 20:24:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/353', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2449, 10, 'jobs', 353, NULL, '2022-08-07 20:25:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/353', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2450, 10, 'jobs', 353, NULL, '2022-08-07 20:25:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/353', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2451, 10, 'jobs', 353, NULL, '2022-08-07 20:25:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/353', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2452, 10, 'jobs', 353, NULL, '2022-08-07 20:25:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/353', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2453, 10, 'jobs', 353, NULL, '2022-08-07 20:25:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/353', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2454, 10, 'jobs', 353, NULL, '2022-08-07 20:25:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/353', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2455, 10, 'jobs', 355, NULL, '2022-08-07 20:28:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/355', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2456, 10, 'jobs', 355, 'activity_delete_jobs', '2022-08-07 20:38:51', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2457, 10, 'jobs', 356, NULL, '2022-08-07 21:18:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/356', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2458, 10, 'jobs', 356, NULL, '2022-08-07 21:26:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/356', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2459, 10, 'jobs', 356, NULL, '2022-08-07 21:35:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/356', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2460, 10, 'jobs', 354, NULL, '2022-08-07 21:36:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/354', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2461, 10, 'jobs', 353, 'activity_delete_jobs', '2022-08-07 21:43:41', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2462, 36, 'jobs', 354, NULL, '2022-08-07 21:55:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/354', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2463, 36, 'jobs', 356, NULL, '2022-08-07 22:01:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/356', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2464, 32, 'jobs', 345, NULL, '2022-08-08 01:02:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/345', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2465, 32, 'jobs', 357, NULL, '2022-08-08 01:06:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/357', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2466, 32, 'jobs', 358, NULL, '2022-08-08 01:10:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/358', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2467, 32, 'jobs', 352, NULL, '2022-08-08 02:16:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/352', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2468, 32, 'jobs', 352, NULL, '2022-08-08 02:20:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/352', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2469, 32, 'jobs', 352, NULL, '2022-08-08 02:25:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/352', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2470, 32, 'jobs', 352, NULL, '2022-08-08 02:29:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/352', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2471, 32, 'jobs', 359, NULL, '2022-08-08 02:36:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/359', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2472, 32, 'jobs', 360, NULL, '2022-08-08 05:47:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/360', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2473, 32, 'jobs', 359, NULL, '2022-08-08 05:59:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/359', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2474, 32, 'jobs', 359, NULL, '2022-08-08 06:03:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/359', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2475, 32, 'jobs', 360, NULL, '2022-08-08 06:18:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/360', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2476, 10, 'jobs', 360, NULL, '2022-08-08 09:01:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/360', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2477, 36, 'jobs', 360, NULL, '2022-08-08 15:24:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/360', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2478, 36, 'equipment', 47, NULL, '2022-08-08 16:49:59', 'fa-suitcase', 'admin/equipment/view_equipment_details/47', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2479, 36, 'jobs', 361, NULL, '2022-08-08 16:52:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/361', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2480, 36, 'problems', 11, NULL, '2022-08-08 17:02:07', 'fa-suitcase', 'admin/problems/view_problems_details/11', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2481, 36, 'jobs', 361, NULL, '2022-08-08 17:02:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/361', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2482, 36, 'jobs', 361, NULL, '2022-08-08 17:03:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/361', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2483, 36, 'problems', 11, 'activity_delete_problems', '2022-08-08 17:04:04', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2484, 10, 'jobs', 357, NULL, '2022-08-08 18:03:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/357', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2485, 10, 'jobs', 358, NULL, '2022-08-08 18:06:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/358', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2486, 36, 'jobs', 361, NULL, '2022-08-08 18:12:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/361', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2487, 36, 'jobs', 361, NULL, '2022-08-08 18:12:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/361', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2488, 36, 'jobs', 357, NULL, '2022-08-08 18:16:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/357', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2489, 36, 'jobs', 358, NULL, '2022-08-08 18:21:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/358', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2490, 36, 'jobs', 362, NULL, '2022-08-08 22:04:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/362', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2491, 36, 'jobs', 363, NULL, '2022-08-08 22:33:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/363', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2492, 36, 'jobs', 362, NULL, '2022-08-08 22:39:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/362', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2493, 10, 'jobs', 363, NULL, '2022-08-08 22:40:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/363', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2494, 36, 'jobs', 362, NULL, '2022-08-08 22:40:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/362', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2495, 32, 'jobs', 363, NULL, '2022-08-09 02:33:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/363', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2496, 32, 'jobs', 363, NULL, '2022-08-09 02:36:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/363', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2497, 32, 'jobs', 364, NULL, '2022-08-09 02:41:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/364', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2498, 32, 'jobs', 365, NULL, '2022-08-09 02:45:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/365', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2499, 32, 'jobs', 366, NULL, '2022-08-09 03:35:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/366', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2500, 32, 'jobs', 367, NULL, '2022-08-09 04:37:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/367', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2501, 32, 'jobs', 365, NULL, '2022-08-09 05:30:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/365', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2502, 32, 'jobs', 366, NULL, '2022-08-09 05:34:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/366', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2503, 32, 'jobs', 366, NULL, '2022-08-09 05:37:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/366', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2504, 32, 'jobs', 367, NULL, '2022-08-09 05:42:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/367', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2505, 38, 'jobs', 362, NULL, '2022-08-09 08:05:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/362', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2506, 38, 'jobs', 368, NULL, '2022-08-09 08:30:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/368', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2507, 38, 'jobs', 368, NULL, '2022-08-09 08:31:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/368', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2508, 38, 'jobs', 369, NULL, '2022-08-09 09:36:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/369', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2509, 38, 'jobs', 369, NULL, '2022-08-09 09:44:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/369', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2510, 38, 'jobs', 368, NULL, '2022-08-09 09:51:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/368', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2511, 10, 'jobs', 369, NULL, '2022-08-09 09:58:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/369', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2512, 38, 'jobs', 368, NULL, '2022-08-09 10:02:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/368', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2513, 38, 'jobs', 368, NULL, '2022-08-09 10:05:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/368', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2514, 38, 'jobs', 368, NULL, '2022-08-09 10:08:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/368', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2515, 38, 'jobs', 369, NULL, '2022-08-09 10:09:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/369', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2516, 38, 'jobs', 368, NULL, '2022-08-09 10:10:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/368', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2517, 38, 'jobs', 368, NULL, '2022-08-09 10:11:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/368', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2518, 38, 'jobs', 368, NULL, '2022-08-09 10:11:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/368', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2519, 38, 'jobs', 368, NULL, '2022-08-09 10:12:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/368', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2520, 10, 'jobs', 364, NULL, '2022-08-09 10:18:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/364', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2521, 38, 'jobs', 369, NULL, '2022-08-09 11:04:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/369', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2522, 10, 'jobs', 367, NULL, '2022-08-09 13:48:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/367', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2523, 3, 'jobs', 370, NULL, '2022-08-09 17:26:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/370', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2524, 3, 'jobs', 371, NULL, '2022-08-09 17:27:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/371', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2525, 3, 'jobs', 371, NULL, '2022-08-09 17:30:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/371', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2526, 3, 'jobs', 372, NULL, '2022-08-09 17:33:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/372', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2527, 3, 'jobs', 373, NULL, '2022-08-09 17:46:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/373', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2528, 10, 'jobs', 374, NULL, '2022-08-09 17:46:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/374', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2529, 3, 'jobs', 375, NULL, '2022-08-09 17:59:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/375', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2530, 3, 'jobs', 375, 'activity_delete_jobs', '2022-08-09 17:59:20', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2531, 10, 'jobs', 376, NULL, '2022-08-09 18:02:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/376', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2532, 3, 'jobs', 377, NULL, '2022-08-09 18:06:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/377', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2533, 3, 'jobs', 377, 'activity_delete_jobs', '2022-08-09 18:07:06', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2534, 3, 'jobs', 377, 'activity_delete_jobs', '2022-08-09 18:07:15', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2535, 3, 'jobs', 377, 'activity_delete_jobs', '2022-08-09 18:07:20', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2536, 10, 'jobs', 376, NULL, '2022-08-09 18:12:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/376', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2537, 3, 'jobs', 378, NULL, '2022-08-09 18:14:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/378', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2538, 3, 'jobs', 378, 'activity_delete_jobs', '2022-08-09 18:14:33', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2539, 36, 'jobs', 364, NULL, '2022-08-09 18:43:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/364', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2540, 36, 'jobs', 367, NULL, '2022-08-09 18:47:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/367', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2541, 36, 'equipment', 48, NULL, '2022-08-09 19:30:34', 'fa-suitcase', 'admin/equipment/view_equipment_details/48', 'NIL', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2542, 36, 'jobs', 379, NULL, '2022-08-09 19:42:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/379', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2543, 10, 'jobs', 380, NULL, '2022-08-09 20:55:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/380', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2544, 10, 'jobs', 380, NULL, '2022-08-09 21:05:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/380', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2545, 10, 'jobs', 380, NULL, '2022-08-09 21:06:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/380', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2546, 10, 'jobs', 380, NULL, '2022-08-09 21:06:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/380', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2547, 10, 'jobs', 380, NULL, '2022-08-09 21:07:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/380', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2548, 10, 'jobs', 380, NULL, '2022-08-09 21:07:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/380', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2549, 10, 'jobs', 380, NULL, '2022-08-09 21:07:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/380', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2550, 10, 'jobs', 376, NULL, '2022-08-09 21:57:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/376', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2551, 36, 'jobs', 369, NULL, '2022-08-09 22:01:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/369', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2552, 36, 'jobs', 376, NULL, '2022-08-09 22:05:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/376', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2553, 3, 'jobs', 380, 'activity_delete_jobs', '2022-08-09 22:07:50', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2554, 36, 'jobs', 381, NULL, '2022-08-09 22:14:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/381', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2555, 10, 'jobs', 381, NULL, '2022-08-09 22:26:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/381', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2556, 36, 'jobs', 381, NULL, '2022-08-09 22:39:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/381', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2557, 36, 'jobs', 381, NULL, '2022-08-09 22:46:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/381', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2558, 32, 'jobs', 382, NULL, '2022-08-10 02:43:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/382', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2559, 32, 'jobs', 383, NULL, '2022-08-10 02:48:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/383', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2560, 32, 'jobs', 384, NULL, '2022-08-10 02:52:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/384', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2561, 32, 'jobs', 385, NULL, '2022-08-10 04:33:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/385', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2562, 32, 'jobs', 386, NULL, '2022-08-10 04:38:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/386', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2563, 32, 'jobs', 384, NULL, '2022-08-10 04:42:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/384', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2564, 32, 'jobs', 384, NULL, '2022-08-10 04:46:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/384', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2565, 32, 'jobs', 387, NULL, '2022-08-10 05:41:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/387', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2566, 32, 'jobs', 387, NULL, '2022-08-10 05:57:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/387', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2567, 32, 'jobs', 387, NULL, '2022-08-10 05:58:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/387', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2568, 32, 'jobs', 384, NULL, '2022-08-10 06:01:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/384', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2569, 32, 'jobs', 385, NULL, '2022-08-10 06:04:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/385', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2570, 32, 'jobs', 386, NULL, '2022-08-10 06:08:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/386', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2571, 32, 'jobs', 387, NULL, '2022-08-10 06:25:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/387', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2572, 38, 'jobs', 388, NULL, '2022-08-10 08:02:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/388', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2573, 38, 'jobs', 388, NULL, '2022-08-10 08:03:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/388', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2574, 38, 'jobs', 351, NULL, '2022-08-10 08:10:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/351', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2575, 38, 'equipment', 49, NULL, '2022-08-10 09:23:49', 'fa-suitcase', 'admin/equipment/view_equipment_details/49', 'GP03', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2576, 38, 'jobs', 389, NULL, '2022-08-10 09:27:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/389', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2577, 38, 'jobs', 389, NULL, '2022-08-10 09:28:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/389', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2578, 38, 'jobs', 389, NULL, '2022-08-10 09:29:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/389', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2579, 38, 'client', 17, 'activity_update_company', '2022-08-10 10:32:05', 'fa-user', NULL, 'SAUDI SKILLS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2580, 38, 'jobs', 389, NULL, '2022-08-10 10:33:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/389', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2581, 38, 'jobs', 389, NULL, '2022-08-10 10:37:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/389', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2582, 38, 'jobs', 390, NULL, '2022-08-10 11:25:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/390', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2583, 38, 'jobs', 390, NULL, '2022-08-10 11:27:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/390', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2584, 38, 'jobs', 391, NULL, '2022-08-10 11:32:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/391', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2585, 38, 'jobs', 391, NULL, '2022-08-10 11:34:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/391', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2586, 38, 'jobs', 389, NULL, '2022-08-10 11:37:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/389', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2587, 38, 'jobs', 392, NULL, '2022-08-10 12:10:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/392', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2588, 38, 'jobs', 392, NULL, '2022-08-10 12:15:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/392', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2589, 3, 'departments', 5, 'activity_added_a_department', '2022-08-10 12:26:18', 'fa-coffee', NULL, 'Maintenance & Operation Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2590, 38, 'jobs', 392, NULL, '2022-08-10 12:30:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/392', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2591, 38, 'jobs', 391, NULL, '2022-08-10 12:34:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/391', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2592, 38, 'client', 17, 'activity_added_new_company', '2022-08-10 12:40:14', 'fa-user', NULL, 'SAUDI SCALES AND EQUIPMENTS CO. LTD.', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2593, 38, 'client', 17, 'activity_added_new_company', '2022-08-10 12:41:39', 'fa-user', NULL, 'SAUDI SCALES AND EQUIPMENTS CO. LTD.', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2594, 38, 'client', 17, 'activity_added_new_company', '2022-08-10 12:43:39', 'fa-user', NULL, 'SAUDI SCALES AND EQUIPMENTS CO. LTD.', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2595, 38, 'client', 18, 'activity_update_company', '2022-08-10 12:51:05', 'fa-user', NULL, 'ALNAKKHLAH NATIONAL', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2596, 38, 'client', 18, 'activity_added_new_company', '2022-08-10 12:51:20', 'fa-user', NULL, 'ALNAKHLAH NATIONAL', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2597, 38, 'equipment', 50, NULL, '2022-08-10 12:52:59', 'fa-suitcase', 'admin/equipment/view_equipment_details/50', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2598, 38, 'jobs', 393, NULL, '2022-08-10 12:54:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/393', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2599, 38, 'jobs', 392, NULL, '2022-08-10 13:12:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/392', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2600, 38, 'jobs', 393, NULL, '2022-08-10 13:50:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/393', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2601, 38, 'jobs', 393, NULL, '2022-08-10 13:50:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/393', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2602, 38, 'jobs', 393, NULL, '2022-08-10 13:51:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/393', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2603, 38, 'jobs', 393, NULL, '2022-08-10 13:53:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/393', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2604, 38, 'jobs', 393, NULL, '2022-08-10 13:54:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/393', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2605, 38, 'jobs', 390, NULL, '2022-08-10 13:55:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/390', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2606, 38, 'jobs', 390, NULL, '2022-08-10 13:57:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/390', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2607, 36, 'jobs', 382, NULL, '2022-08-10 16:03:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/382', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2608, 36, 'jobs', 392, NULL, '2022-08-10 16:07:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/392', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2609, 36, 'jobs', 394, NULL, '2022-08-10 19:25:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/394', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2610, 36, 'jobs', 368, NULL, '2022-08-10 19:34:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/368', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2611, 36, 'jobs', 322, NULL, '2022-08-10 19:36:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/322', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2612, 36, 'jobs', 324, NULL, '2022-08-10 19:42:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/324', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2613, 36, 'jobs', 390, NULL, '2022-08-10 19:47:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/390', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2614, 36, 'jobs', 351, NULL, '2022-08-10 19:48:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/351', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2615, 36, 'jobs', 394, NULL, '2022-08-10 20:00:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/394', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2616, 36, 'jobs', 391, NULL, '2022-08-10 21:47:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/391', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2617, 36, 'jobs', 394, NULL, '2022-08-10 21:52:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/394', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2618, 36, 'jobs', 383, NULL, '2022-08-10 22:10:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/383', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2619, 32, 'jobs', 395, NULL, '2022-08-11 02:45:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/395', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2620, 32, 'jobs', 396, NULL, '2022-08-11 02:48:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/396', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2621, 32, 'jobs', 397, NULL, '2022-08-11 04:38:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/397', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2622, 32, 'jobs', 398, NULL, '2022-08-11 04:41:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/398', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2623, 32, 'jobs', 399, NULL, '2022-08-11 05:12:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/399', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2624, 32, 'jobs', 400, NULL, '2022-08-11 05:14:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/400', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2625, 32, 'jobs', 399, NULL, '2022-08-11 05:15:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/399', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2626, 32, 'jobs', 400, NULL, '2022-08-11 05:59:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/400', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2627, 32, 'jobs', 399, NULL, '2022-08-11 06:04:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/399', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2628, 32, 'jobs', 398, NULL, '2022-08-11 06:07:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/398', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2629, 32, 'jobs', 398, NULL, '2022-08-11 06:07:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/398', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2630, 32, 'jobs', 398, NULL, '2022-08-11 06:08:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/398', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2631, 32, 'jobs', 397, NULL, '2022-08-11 06:11:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/397', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2632, 32, 'jobs', 396, NULL, '2022-08-11 06:13:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/396', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2633, 32, 'jobs', 395, NULL, '2022-08-11 06:15:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/395', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2634, 32, 'jobs', 398, NULL, '2022-08-11 06:22:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/398', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2635, 32, 'jobs', 397, NULL, '2022-08-11 06:23:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/397', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2636, 32, 'jobs', 396, NULL, '2022-08-11 06:25:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/396', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2637, 32, 'jobs', 395, NULL, '2022-08-11 06:26:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/395', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2638, 32, 'jobs', 399, NULL, '2022-08-11 06:32:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/399', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2639, 38, 'jobs', 401, NULL, '2022-08-11 07:36:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/401', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2640, 3, 'jobs', 401, NULL, '2022-08-11 07:38:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/401', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2641, 38, 'client', 19, 'activity_update_company', '2022-08-11 08:32:29', 'fa-user', NULL, 'SUMMIT HELICOPTERS - KSA', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2642, 38, 'jobs', 379, NULL, '2022-08-11 08:33:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/379', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2643, 38, 'jobs', 401, NULL, '2022-08-11 09:28:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/401', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2644, 38, 'jobs', 401, NULL, '2022-08-11 09:56:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/401', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2645, 10, 'jobs', 401, NULL, '2022-08-12 19:42:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/401', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2646, 10, 'jobs', 402, NULL, '2022-08-12 19:52:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/402', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2647, 10, 'jobs', 403, NULL, '2022-08-12 20:12:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/403', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2648, 3, 'jobs', 402, 'activity_delete_jobs', '2022-08-13 13:39:57', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2649, 3, 'jobs', 403, 'activity_delete_jobs', '2022-08-13 15:00:37', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2650, 3, 'jobs', 404, NULL, '2022-08-13 15:04:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/404', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2651, 3, 'jobs', 405, NULL, '2022-08-13 15:11:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/405', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2652, 3, 'jobs', 405, NULL, '2022-08-13 15:13:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/405', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2653, 10, 'jobs', 404, NULL, '2022-08-13 15:17:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/404', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2654, 10, 'jobs', 406, NULL, '2022-08-13 15:38:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/406', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2655, 10, 'jobs', 406, NULL, '2022-08-13 15:40:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/406', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2656, 10, 'jobs', 407, NULL, '2022-08-13 15:51:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/407', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2657, 10, 'jobs', 407, NULL, '2022-08-13 15:58:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/407', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2658, 10, 'jobs', 408, NULL, '2022-08-13 16:06:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/408', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2659, 10, 'jobs', 409, NULL, '2022-08-13 16:17:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/409', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2660, 10, 'jobs', 410, NULL, '2022-08-13 17:11:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/410', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2661, 10, 'jobs', 411, NULL, '2022-08-13 17:23:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/411', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2662, 10, 'jobs', 412, NULL, '2022-08-13 17:33:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/412', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2663, 10, 'jobs', 413, NULL, '2022-08-13 17:44:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/413', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2664, 10, 'jobs', 414, NULL, '2022-08-13 17:55:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/414', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2665, 10, 'jobs', 415, NULL, '2022-08-13 18:04:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/415', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2666, 10, 'jobs', 416, NULL, '2022-08-13 18:12:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/416', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2667, 10, 'jobs', 417, NULL, '2022-08-13 19:09:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/417', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2668, 10, 'jobs', 418, NULL, '2022-08-13 19:16:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/418', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2669, 10, 'jobs', 419, NULL, '2022-08-13 19:25:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/419', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2670, 10, 'jobs', 418, NULL, '2022-08-13 20:27:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/418', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2671, 10, 'jobs', 419, NULL, '2022-08-13 20:59:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/419', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2672, 10, 'jobs', 405, NULL, '2022-08-13 21:06:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/405', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2673, 10, 'jobs', 405, NULL, '2022-08-13 21:07:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/405', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2674, 10, 'jobs', 405, NULL, '2022-08-13 21:07:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/405', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2675, 10, 'jobs', 405, NULL, '2022-08-13 21:08:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/405', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2676, 6, 'jobs', 405, 'activity_delete_jobs', '2022-08-13 22:03:12', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2677, 10, 'jobs', 420, NULL, '2022-08-13 22:05:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/420', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2678, 10, 'jobs', 420, NULL, '2022-08-13 22:26:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/420', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2679, 10, 'jobs', 404, NULL, '2022-08-13 22:33:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/404', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2680, 10, 'jobs', 421, NULL, '2022-08-14 04:45:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/421', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2681, 10, 'jobs', 421, NULL, '2022-08-14 04:57:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/421', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2682, 10, 'jobs', 422, NULL, '2022-08-14 05:03:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/422', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2683, 10, 'jobs', 423, NULL, '2022-08-14 05:20:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/423', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2684, 10, 'jobs', 423, NULL, '2022-08-14 05:35:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/423', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2685, 38, 'jobs', 401, NULL, '2022-08-14 08:44:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/401', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2686, 38, 'jobs', 401, NULL, '2022-08-14 08:46:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/401', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2687, 38, 'jobs', 401, NULL, '2022-08-14 08:51:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/401', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2688, 38, 'jobs', 420, NULL, '2022-08-14 09:34:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/420', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2689, 10, 'jobs', 424, NULL, '2022-08-14 09:35:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/424', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2690, 10, 'jobs', 424, NULL, '2022-08-14 09:38:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/424', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2691, 38, 'jobs', 418, NULL, '2022-08-14 09:39:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/418', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2692, 10, 'jobs', 422, NULL, '2022-08-14 10:08:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/422', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2693, 10, 'jobs', 411, NULL, '2022-08-14 10:13:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/411', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2694, 10, 'jobs', 412, NULL, '2022-08-14 10:15:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/412', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2695, 38, 'jobs', 425, NULL, '2022-08-14 10:31:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2696, 38, 'jobs', 425, NULL, '2022-08-14 10:33:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2697, 10, 'jobs', 417, NULL, '2022-08-14 10:33:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/417', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2698, 38, 'jobs', 425, NULL, '2022-08-14 10:33:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2699, 38, 'jobs', 425, NULL, '2022-08-14 10:38:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2700, 38, 'jobs', 425, NULL, '2022-08-14 10:40:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2701, 38, 'jobs', 425, NULL, '2022-08-14 11:24:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2702, 38, 'jobs', 416, NULL, '2022-08-14 12:11:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/416', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2703, 10, 'jobs', 417, NULL, '2022-08-14 13:40:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/417', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2704, 10, 'jobs', 412, NULL, '2022-08-14 13:41:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/412', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2705, 10, 'jobs', 411, NULL, '2022-08-14 13:42:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/411', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2706, 38, 'jobs', 417, NULL, '2022-08-14 13:54:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/417', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2707, 38, 'jobs', 412, NULL, '2022-08-14 13:56:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/412', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2708, 38, 'jobs', 412, NULL, '2022-08-14 13:57:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/412', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2709, 38, 'jobs', 411, NULL, '2022-08-14 13:58:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/411', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2710, 3, 'jobs', 425, NULL, '2022-08-14 16:03:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2711, 3, 'jobs', 393, NULL, '2022-08-14 16:04:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/393', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2712, 10, 'jobs', 426, NULL, '2022-08-14 16:20:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2713, 10, 'jobs', 427, NULL, '2022-08-14 16:35:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/427', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2714, 36, 'jobs', 428, NULL, '2022-08-14 16:42:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/428', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2715, 36, 'jobs', 428, NULL, '2022-08-14 16:44:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/428', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2716, 10, 'jobs', 427, NULL, '2022-08-14 16:46:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/427', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2717, 10, 'jobs', 426, NULL, '2022-08-14 16:49:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2718, 10, 'jobs', 426, NULL, '2022-08-14 16:49:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2719, 10, 'jobs', 426, NULL, '2022-08-14 16:49:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2720, 10, 'jobs', 426, NULL, '2022-08-14 16:50:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2721, 10, 'jobs', 426, NULL, '2022-08-14 16:50:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2722, 10, 'jobs', 426, NULL, '2022-08-14 16:50:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2723, 10, 'jobs', 426, NULL, '2022-08-14 16:50:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2724, 10, 'jobs', 426, NULL, '2022-08-14 16:50:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2725, 10, 'jobs', 426, NULL, '2022-08-14 16:50:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2726, 10, 'jobs', 426, NULL, '2022-08-14 16:50:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2727, 10, 'jobs', 426, NULL, '2022-08-14 16:50:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2728, 10, 'jobs', 426, NULL, '2022-08-14 16:50:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2729, 10, 'jobs', 426, NULL, '2022-08-14 16:50:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2730, 10, 'jobs', 426, NULL, '2022-08-14 16:51:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/426', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2731, 10, 'jobs', 429, NULL, '2022-08-14 17:00:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/429', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2732, 10, 'jobs', 429, NULL, '2022-08-14 17:08:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/429', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2733, 36, 'jobs', 426, 'activity_delete_jobs', '2022-08-14 17:21:18', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2734, 36, 'jobs', 424, NULL, '2022-08-14 18:05:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/424', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2735, 36, 'jobs', 424, NULL, '2022-08-14 18:08:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/424', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2736, 36, 'jobs', 427, NULL, '2022-08-14 19:45:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/427', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2737, 36, 'jobs', 429, NULL, '2022-08-14 19:51:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/429', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2738, 36, 'jobs', 404, NULL, '2022-08-14 20:02:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/404', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2739, 36, 'jobs', 404, NULL, '2022-08-14 20:04:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/404', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2740, 36, 'jobs', 419, NULL, '2022-08-14 20:07:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/419', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2741, 10, 'jobs', 429, NULL, '2022-08-14 22:11:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/429', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2742, 32, 'jobs', 406, NULL, '2022-08-15 01:50:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/406', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2743, 32, 'jobs', 406, NULL, '2022-08-15 01:52:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/406', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2744, 32, 'jobs', 407, NULL, '2022-08-15 02:00:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/407', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2745, 32, 'jobs', 409, NULL, '2022-08-15 02:07:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/409', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2746, 32, 'jobs', 410, NULL, '2022-08-15 02:13:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/410', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2747, 32, 'jobs', 414, NULL, '2022-08-15 02:19:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/414', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2748, 32, 'jobs', 414, NULL, '2022-08-15 02:21:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/414', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2749, 32, 'jobs', 414, NULL, '2022-08-15 02:21:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/414', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2750, 32, 'jobs', 414, NULL, '2022-08-15 02:22:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/414', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2751, 32, 'jobs', 415, NULL, '2022-08-15 02:27:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/415', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2752, 32, 'jobs', 421, NULL, '2022-08-15 02:31:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/421', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2753, 32, 'jobs', 423, NULL, '2022-08-15 02:35:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/423', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2754, 32, 'jobs', 408, NULL, '2022-08-15 02:41:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/408', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2755, 32, 'jobs', 408, NULL, '2022-08-15 02:44:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/408', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2756, 32, 'jobs', 416, NULL, '2022-08-15 02:48:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/416', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2757, 32, 'jobs', 406, NULL, '2022-08-15 02:54:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/406', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2758, 32, 'jobs', 407, NULL, '2022-08-15 02:55:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/407', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2759, 32, 'jobs', 409, NULL, '2022-08-15 02:56:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/409', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2760, 32, 'jobs', 410, NULL, '2022-08-15 02:57:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/410', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2761, 32, 'jobs', 430, NULL, '2022-08-15 03:04:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/430', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2762, 32, 'jobs', 430, NULL, '2022-08-15 03:05:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/430', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2763, 32, 'jobs', 431, NULL, '2022-08-15 03:08:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/431', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2764, 32, 'jobs', 432, NULL, '2022-08-15 03:11:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/432', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2765, 10, 'jobs', 432, NULL, '2022-08-15 05:28:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/432', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2766, 32, 'jobs', 413, NULL, '2022-08-15 05:54:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/413', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2767, 32, 'jobs', 422, NULL, '2022-08-15 06:01:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/422', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2768, 32, 'jobs', 432, NULL, '2022-08-15 06:05:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/432', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2769, 10, 'jobs', 433, NULL, '2022-08-15 08:18:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/433', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2770, 10, 'jobs', 433, NULL, '2022-08-15 08:23:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/433', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2771, 10, 'jobs', 430, NULL, '2022-08-15 08:36:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/430', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2772, 38, 'jobs', 433, NULL, '2022-08-15 09:36:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/433', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2773, 38, 'jobs', 433, NULL, '2022-08-15 09:39:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/433', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2774, 38, 'jobs', 433, NULL, '2022-08-15 10:00:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/433', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2775, 10, 'jobs', 433, NULL, '2022-08-15 10:00:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/433', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2776, 10, 'jobs', 433, NULL, '2022-08-15 10:01:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/433', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2777, 38, 'jobs', 430, NULL, '2022-08-15 10:37:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/430', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2778, 38, 'jobs', 430, NULL, '2022-08-15 10:41:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/430', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2779, 3, 'jobs', 370, 'activity_delete_jobs', '2022-08-15 17:03:20', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2780, 36, 'jobs', 431, NULL, '2022-08-15 18:05:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/431', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2781, 36, 'jobs', 433, NULL, '2022-08-15 18:10:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/433', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2782, 36, 'jobs', 434, NULL, '2022-08-15 21:21:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/434', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2783, 36, 'jobs', 435, NULL, '2022-08-15 21:59:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/435', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2784, 10, 'jobs', 435, NULL, '2022-08-15 22:12:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/435', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2785, 10, 'jobs', 435, NULL, '2022-08-15 22:14:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/435', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2786, 10, 'jobs', 434, NULL, '2022-08-15 22:15:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/434', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2787, 36, 'jobs', 435, NULL, '2022-08-15 22:23:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/435', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2788, 32, 'jobs', 435, NULL, '2022-08-16 03:45:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/435', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2789, 32, 'jobs', 435, NULL, '2022-08-16 03:47:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/435', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2790, 32, 'jobs', 434, NULL, '2022-08-16 03:50:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/434', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2791, 32, 'jobs', 436, NULL, '2022-08-16 04:00:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/436', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2792, 32, 'jobs', 436, NULL, '2022-08-16 05:40:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/436', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2793, 10, 'jobs', 437, NULL, '2022-08-16 09:40:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2794, 10, 'jobs', 437, NULL, '2022-08-16 09:48:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2795, 10, 'jobs', 437, NULL, '2022-08-16 09:48:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2796, 10, 'jobs', 437, NULL, '2022-08-16 09:55:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2797, 38, 'jobs', 437, NULL, '2022-08-16 09:56:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2798, 10, 'jobs', 438, NULL, '2022-08-16 10:29:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2799, 10, 'jobs', 438, NULL, '2022-08-16 10:46:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2800, 10, 'jobs', 438, NULL, '2022-08-16 10:50:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2801, 38, 'jobs', 438, NULL, '2022-08-16 11:14:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2802, 38, 'jobs', 437, NULL, '2022-08-16 11:16:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2803, 10, 'jobs', 438, NULL, '2022-08-16 12:10:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2804, 10, 'jobs', 438, NULL, '2022-08-16 12:23:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2805, 10, 'jobs', 437, NULL, '2022-08-16 12:24:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2806, 10, 'jobs', 437, NULL, '2022-08-16 12:30:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2807, 38, 'jobs', 437, NULL, '2022-08-16 12:32:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2808, 38, 'jobs', 437, NULL, '2022-08-16 12:35:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2809, 38, 'jobs', 437, NULL, '2022-08-16 12:36:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2810, 38, 'jobs', 438, NULL, '2022-08-16 12:38:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2811, 38, 'jobs', 438, NULL, '2022-08-16 13:44:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2812, 38, 'jobs', 436, NULL, '2022-08-16 13:45:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/436', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2813, 38, 'jobs', 437, NULL, '2022-08-16 13:46:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2814, 38, 'jobs', 437, NULL, '2022-08-16 13:46:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2815, 38, 'jobs', 436, NULL, '2022-08-16 13:47:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/436', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2816, 38, 'jobs', 437, NULL, '2022-08-16 13:47:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2817, 38, 'jobs', 437, NULL, '2022-08-16 13:50:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2818, 38, 'jobs', 438, NULL, '2022-08-16 13:51:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2819, 38, 'jobs', 438, NULL, '2022-08-16 13:53:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2820, 38, 'jobs', 436, NULL, '2022-08-16 13:54:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/436', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2821, 38, 'jobs', 437, NULL, '2022-08-16 13:55:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/437', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2822, 38, 'jobs', 438, NULL, '2022-08-16 13:56:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2823, 38, 'jobs', 436, NULL, '2022-08-16 13:57:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/436', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2824, 38, 'jobs', 438, NULL, '2022-08-16 14:01:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2825, 10, 'jobs', 439, NULL, '2022-08-16 21:08:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/439', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2826, 10, 'jobs', 440, NULL, '2022-08-16 21:12:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/440', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2827, 10, 'jobs', 440, NULL, '2022-08-16 22:37:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/440', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2828, 10, 'jobs', 439, NULL, '2022-08-16 22:39:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/439', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2829, 32, 'jobs', 441, NULL, '2022-08-17 03:07:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/441', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2830, 32, 'jobs', 442, NULL, '2022-08-17 06:02:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/442', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2831, 32, 'jobs', 439, NULL, '2022-08-17 06:26:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/439', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2832, 32, 'jobs', 441, NULL, '2022-08-17 06:31:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/441', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2833, 32, 'jobs', 441, NULL, '2022-08-17 06:33:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/441', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2834, 38, 'jobs', 443, NULL, '2022-08-17 08:57:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/443', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2835, 38, 'jobs', 443, NULL, '2022-08-17 09:06:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/443', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2836, 38, 'jobs', 443, NULL, '2022-08-17 09:07:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/443', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2837, 38, 'jobs', 393, NULL, '2022-08-17 10:28:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/393', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2838, 38, 'jobs', 425, NULL, '2022-08-17 10:28:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2839, 38, 'jobs', 425, NULL, '2022-08-17 10:32:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2840, 38, 'jobs', 425, NULL, '2022-08-17 10:35:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2841, 38, 'jobs', 425, NULL, '2022-08-17 10:35:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2842, 38, 'jobs', 425, NULL, '2022-08-17 10:37:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2843, 38, 'jobs', 438, NULL, '2022-08-17 10:39:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/438', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2844, 38, 'jobs', 444, NULL, '2022-08-17 11:29:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/444', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2845, 38, 'jobs', 444, NULL, '2022-08-17 11:31:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/444', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2846, 38, 'jobs', 443, NULL, '2022-08-17 11:37:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/443', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2847, 38, 'jobs', 443, NULL, '2022-08-17 11:39:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/443', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2848, 38, 'jobs', 444, NULL, '2022-08-17 11:39:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/444', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2849, 38, 'jobs', 443, NULL, '2022-08-17 12:36:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/443', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2850, 38, 'jobs', 443, NULL, '2022-08-17 12:37:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/443', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2851, 38, 'jobs', 444, NULL, '2022-08-17 12:48:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/444', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2852, 38, 'jobs', 443, NULL, '2022-08-17 13:04:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/443', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2853, 38, 'jobs', 443, NULL, '2022-08-17 13:09:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/443', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2854, 38, 'jobs', 444, NULL, '2022-08-17 13:10:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/444', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2855, 38, 'jobs', 442, NULL, '2022-08-17 13:33:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/442', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2856, 38, 'jobs', 445, NULL, '2022-08-17 13:39:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/445', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2857, 38, 'jobs', 445, NULL, '2022-08-17 13:42:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/445', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2858, 38, 'jobs', 442, NULL, '2022-08-17 13:51:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/442', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2859, 38, 'jobs', 442, NULL, '2022-08-17 13:58:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/442', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2860, 38, 'jobs', 442, NULL, '2022-08-17 13:59:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/442', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2861, 38, 'jobs', 446, NULL, '2022-08-17 14:46:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/446', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2862, 38, 'jobs', 446, NULL, '2022-08-17 14:47:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/446', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2863, 38, 'jobs', 446, NULL, '2022-08-17 14:48:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/446', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2864, 36, 'jobs', 440, NULL, '2022-08-17 19:28:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/440', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2865, 36, 'jobs', 445, NULL, '2022-08-17 19:35:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/445', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2866, 32, 'settings', 32, 'activity_update_profile', '2022-08-17 23:46:35', 'fa-coffee', NULL, 'Francis Anthony', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2867, 32, 'jobs', 404, NULL, '2022-08-18 03:54:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/404', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2868, 38, 'jobs', 447, NULL, '2022-08-18 08:34:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/447', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2869, 38, 'jobs', 448, NULL, '2022-08-18 08:40:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/448', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2870, 38, 'jobs', 449, NULL, '2022-08-18 08:50:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/449', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2871, 38, 'jobs', 449, NULL, '2022-08-18 08:52:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/449', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2872, 38, 'jobs', 449, NULL, '2022-08-18 08:53:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/449', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2873, 38, 'jobs', 447, NULL, '2022-08-18 11:10:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/447', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2874, 38, 'jobs', 449, NULL, '2022-08-18 11:12:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/449', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2875, 38, 'jobs', 449, NULL, '2022-08-18 11:13:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/449', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2876, 38, 'jobs', 447, NULL, '2022-08-18 11:17:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/447', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2877, 38, 'jobs', 447, NULL, '2022-08-18 11:18:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/447', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2878, 38, 'jobs', 446, NULL, '2022-08-18 11:21:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/446', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2879, 38, 'jobs', 446, NULL, '2022-08-18 11:22:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/446', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2880, 38, 'jobs', 446, NULL, '2022-08-18 11:26:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/446', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2881, 38, 'jobs', 446, NULL, '2022-08-18 11:27:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/446', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2882, 38, 'jobs', 428, NULL, '2022-08-18 11:30:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/428', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2883, 38, 'jobs', 428, NULL, '2022-08-18 11:33:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/428', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2884, 38, 'jobs', 428, NULL, '2022-08-18 11:34:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/428', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2885, 38, 'jobs', 449, NULL, '2022-08-18 12:20:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/449', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2886, 38, 'jobs', 449, NULL, '2022-08-18 12:25:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/449', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2887, 38, 'jobs', 449, NULL, '2022-08-18 12:28:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/449', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2888, 38, 'jobs', 449, NULL, '2022-08-18 12:29:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/449', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2889, 38, 'jobs', 448, NULL, '2022-08-18 12:33:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/448', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2890, 38, 'jobs', 448, NULL, '2022-08-18 12:35:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/448', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2891, 38, 'jobs', 448, NULL, '2022-08-18 12:46:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/448', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2892, 38, 'jobs', 447, NULL, '2022-08-18 14:32:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/447', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2893, 38, 'jobs', 447, NULL, '2022-08-18 14:35:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/447', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2894, 38, 'jobs', 447, NULL, '2022-08-18 14:35:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/447', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2895, 38, 'jobs', 447, NULL, '2022-08-18 14:36:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/447', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2896, 38, 'jobs', 447, NULL, '2022-08-18 14:36:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/447', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2897, 36, 'jobs', 450, NULL, '2022-08-18 16:26:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/450', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2898, 36, 'jobs', 451, NULL, '2022-08-18 16:28:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/451', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2899, 10, 'jobs', 451, NULL, '2022-08-18 17:05:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/451', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2900, 36, 'jobs', 450, NULL, '2022-08-18 17:14:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/450', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2901, 36, 'jobs', 450, NULL, '2022-08-18 19:23:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/450', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2902, 36, 'jobs', 451, NULL, '2022-08-18 21:48:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/451', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2903, 36, 'jobs', 450, NULL, '2022-08-18 21:50:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/450', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2904, 36, 'jobs', 451, NULL, '2022-08-18 21:55:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/451', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2905, 32, 'jobs', 452, NULL, '2022-08-19 03:51:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/452', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2906, 32, 'jobs', 453, NULL, '2022-08-19 03:54:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/453', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2907, 32, 'jobs', 454, NULL, '2022-08-19 03:59:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/454', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2908, 32, 'jobs', 455, NULL, '2022-08-19 04:02:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/455', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2909, 32, 'jobs', 452, NULL, '2022-08-19 04:04:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/452', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2910, 32, 'jobs', 452, NULL, '2022-08-19 04:18:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/452', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2911, 32, 'jobs', 453, NULL, '2022-08-19 05:29:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/453', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2912, 32, 'jobs', 455, NULL, '2022-08-19 05:32:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/455', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2913, 32, 'jobs', 453, NULL, '2022-08-19 06:06:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/453', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2914, 32, 'jobs', 454, NULL, '2022-08-19 06:08:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/454', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2915, 32, 'jobs', 455, NULL, '2022-08-19 06:11:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/455', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2916, 10, 'jobs', 456, NULL, '2022-08-19 09:01:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/456', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2917, 10, 'jobs', 456, NULL, '2022-08-19 12:09:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/456', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2918, 10, 'jobs', 457, NULL, '2022-08-19 17:47:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/457', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2919, 10, 'jobs', 457, NULL, '2022-08-19 17:52:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/457', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2920, 10, 'jobs', 457, NULL, '2022-08-19 18:00:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/457', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2921, 10, 'jobs', 457, NULL, '2022-08-19 18:00:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/457', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2922, 10, 'jobs', 457, NULL, '2022-08-19 18:00:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/457', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2923, 10, 'jobs', 457, NULL, '2022-08-19 18:00:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/457', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2924, 10, 'jobs', 457, NULL, '2022-08-19 18:00:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/457', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2925, 36, 'jobs', 457, 'activity_delete_jobs', '2022-08-19 18:14:27', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2926, 36, 'jobs', 458, NULL, '2022-08-19 18:21:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/458', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2927, 10, 'jobs', 458, NULL, '2022-08-19 19:34:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/458', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2928, 10, 'jobs', 458, NULL, '2022-08-19 19:37:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/458', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2929, 10, 'jobs', 459, NULL, '2022-08-19 19:47:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/459', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2930, 10, 'jobs', 459, NULL, '2022-08-19 20:23:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/459', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2931, 10, 'jobs', 460, NULL, '2022-08-19 20:42:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/460', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2932, 10, 'jobs', 461, NULL, '2022-08-19 20:48:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/461', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2933, 10, 'jobs', 461, NULL, '2022-08-19 20:54:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/461', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2934, 10, 'jobs', 460, NULL, '2022-08-19 21:03:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/460', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2935, 10, 'jobs', 461, NULL, '2022-08-19 22:00:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/461', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2936, 10, 'jobs', 460, NULL, '2022-08-19 22:02:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/460', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2937, 10, 'jobs', 459, NULL, '2022-08-19 22:04:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/459', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2938, 10, 'jobs', 462, NULL, '2022-08-20 02:50:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/462', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2939, 10, 'jobs', 463, NULL, '2022-08-20 02:58:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/463', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2940, 10, 'jobs', 464, NULL, '2022-08-20 03:04:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/464', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2941, 10, 'jobs', 465, NULL, '2022-08-20 03:10:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/465', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2942, 10, 'jobs', 466, NULL, '2022-08-20 05:29:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/466', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2943, 10, 'jobs', 467, NULL, '2022-08-20 05:36:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/467', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2944, 10, 'jobs', 468, NULL, '2022-08-20 05:42:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/468', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2945, 10, 'jobs', 464, NULL, '2022-08-20 06:04:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/464', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2946, 10, 'jobs', 468, NULL, '2022-08-20 06:05:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/468', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2947, 10, 'jobs', 467, NULL, '2022-08-20 06:06:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/467', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2948, 10, 'jobs', 465, NULL, '2022-08-20 06:07:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/465', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2949, 10, 'jobs', 463, NULL, '2022-08-20 06:08:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/463', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2950, 10, 'jobs', 462, NULL, '2022-08-20 06:09:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/462', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2951, 10, 'jobs', 468, NULL, '2022-08-20 06:14:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/468', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2952, 10, 'jobs', 467, NULL, '2022-08-20 06:14:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/467', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2953, 10, 'jobs', 465, NULL, '2022-08-20 06:15:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/465', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2954, 10, 'jobs', 464, NULL, '2022-08-20 06:16:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/464', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2955, 10, 'jobs', 463, NULL, '2022-08-20 06:16:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/463', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2956, 10, 'jobs', 462, NULL, '2022-08-20 06:17:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/462', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2957, 10, 'jobs', 468, NULL, '2022-08-20 06:47:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/468', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2958, 10, 'jobs', 467, NULL, '2022-08-20 06:49:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/467', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2959, 10, 'jobs', 465, NULL, '2022-08-20 06:51:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/465', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2960, 10, 'jobs', 462, NULL, '2022-08-20 06:53:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/462', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2961, 10, 'jobs', 469, NULL, '2022-08-20 11:08:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/469', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2962, 10, 'jobs', 469, NULL, '2022-08-20 11:13:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/469', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2963, 10, 'jobs', 469, NULL, '2022-08-20 11:43:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/469', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2964, 10, 'jobs', 469, NULL, '2022-08-20 11:47:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/469', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2965, 10, 'jobs', 469, NULL, '2022-08-20 15:42:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/469', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2966, 10, 'jobs', 470, NULL, '2022-08-20 17:56:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/470', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2967, 10, 'jobs', 471, NULL, '2022-08-20 18:02:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/471', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2968, 10, 'jobs', 471, NULL, '2022-08-20 18:09:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/471', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2969, 10, 'jobs', 470, NULL, '2022-08-20 18:20:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/470', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2970, 10, 'jobs', 471, NULL, '2022-08-20 19:46:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/471', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2971, 10, 'jobs', 470, NULL, '2022-08-20 19:47:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/470', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2972, 10, 'jobs', 471, NULL, '2022-08-20 21:42:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/471', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2973, 10, 'jobs', 470, NULL, '2022-08-20 21:43:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/470', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2974, 10, 'jobs', 472, NULL, '2022-08-21 02:08:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/472', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2975, 10, 'jobs', 473, NULL, '2022-08-21 02:15:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/473', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2976, 10, 'jobs', 473, NULL, '2022-08-21 09:34:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/473', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2977, 10, 'jobs', 472, NULL, '2022-08-21 09:38:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/472', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2978, 10, 'jobs', 466, NULL, '2022-08-21 09:48:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/466', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2979, 10, 'jobs', 474, NULL, '2022-08-21 11:09:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/474', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2980, 10, 'jobs', 474, NULL, '2022-08-21 11:28:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/474', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2981, 10, 'jobs', 474, NULL, '2022-08-21 11:30:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/474', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2982, 38, 'jobs', 475, NULL, '2022-08-21 12:40:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/475', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2983, 38, 'jobs', 475, NULL, '2022-08-21 12:41:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/475', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2984, 38, 'jobs', 458, NULL, '2022-08-21 12:52:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/458', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2985, 38, 'jobs', 458, NULL, '2022-08-21 12:55:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/458', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2986, 38, 'jobs', 459, NULL, '2022-08-21 12:58:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/459', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2987, 38, 'jobs', 459, NULL, '2022-08-21 13:00:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/459', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2988, 38, 'jobs', 460, NULL, '2022-08-21 13:35:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/460', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2989, 38, 'jobs', 460, NULL, '2022-08-21 13:37:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/460', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2990, 38, 'jobs', 460, NULL, '2022-08-21 13:38:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/460', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2991, 38, 'jobs', 461, NULL, '2022-08-21 13:41:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/461', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2992, 38, 'jobs', 462, NULL, '2022-08-21 13:45:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/462', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2993, 38, 'jobs', 463, NULL, '2022-08-21 13:48:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/463', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2994, 38, 'jobs', 464, NULL, '2022-08-21 13:51:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/464', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2995, 38, 'jobs', 465, NULL, '2022-08-21 13:53:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/465', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2996, 38, 'jobs', 467, NULL, '2022-08-21 13:56:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/467', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2997, 38, 'jobs', 468, NULL, '2022-08-21 13:58:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/468', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2998, 38, 'jobs', 469, NULL, '2022-08-21 14:00:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/469', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (2999, 38, 'jobs', 469, NULL, '2022-08-21 14:01:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/469', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3000, 38, 'jobs', 470, NULL, '2022-08-21 14:04:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/470', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3001, 38, 'jobs', 471, NULL, '2022-08-21 14:07:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/471', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3002, 38, 'jobs', 472, NULL, '2022-08-21 14:09:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/472', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3003, 38, 'jobs', 473, NULL, '2022-08-21 14:14:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/473', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3004, 38, 'jobs', 446, NULL, '2022-08-21 14:43:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/446', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3005, 38, 'jobs', 466, NULL, '2022-08-21 14:46:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/466', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3006, 38, 'jobs', 475, NULL, '2022-08-21 14:48:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/475', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3007, 6, 'departments', 6, 'activity_added_a_department', '2022-08-21 15:48:25', 'fa-coffee', NULL, 'Procurement Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3008, 17, 'items', 1, 'activity_save_items', '2022-08-21 17:14:40', 'fa-circle-o', NULL, '11223344', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3009, 17, 'purchase', 2, 'purchase_created', '2022-08-21 17:23:00', 'fa fa-truck', 'admin/purchase/purchase_details/2', '[INV]-2022-Aug-21-0002', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3010, 36, 'jobs', 456, NULL, '2022-08-21 19:55:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/456', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3011, 10, 'jobs', 474, NULL, '2022-08-21 20:51:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/474', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3012, 36, 'jobs', 474, NULL, '2022-08-21 21:19:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/474', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3013, 32, 'jobs', 466, NULL, '2022-08-22 01:41:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/466', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3014, 32, 'jobs', 476, NULL, '2022-08-22 01:50:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/476', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3015, 32, 'jobs', 477, NULL, '2022-08-22 01:53:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/477', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3016, 32, 'jobs', 478, NULL, '2022-08-22 04:05:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/478', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3017, 32, 'jobs', 479, NULL, '2022-08-22 04:07:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/479', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3018, 32, 'jobs', 480, NULL, '2022-08-22 04:10:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/480', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3019, 32, 'jobs', 476, NULL, '2022-08-22 04:13:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/476', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3020, 32, 'jobs', 476, NULL, '2022-08-22 04:15:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/476', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3021, 32, 'jobs', 480, NULL, '2022-08-22 04:15:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/480', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3022, 32, 'jobs', 481, NULL, '2022-08-22 04:52:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/481', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3023, 32, 'jobs', 482, NULL, '2022-08-22 05:43:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/482', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3024, 32, 'jobs', 482, NULL, '2022-08-22 06:12:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/482', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3025, 32, 'jobs', 476, NULL, '2022-08-22 06:15:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/476', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3026, 32, 'jobs', 478, NULL, '2022-08-22 06:16:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/478', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3027, 32, 'jobs', 479, NULL, '2022-08-22 06:21:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/479', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3028, 32, 'jobs', 476, NULL, '2022-08-22 06:34:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/476', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3029, 32, 'jobs', 480, NULL, '2022-08-22 06:36:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/480', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3030, 32, 'jobs', 481, NULL, '2022-08-22 06:37:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/481', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3031, 32, 'jobs', 481, NULL, '2022-08-22 06:38:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/481', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3032, 38, 'jobs', 469, NULL, '2022-08-22 08:42:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/469', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3033, 38, 'jobs', 474, NULL, '2022-08-22 08:43:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/474', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3034, 38, 'jobs', 467, NULL, '2022-08-22 08:43:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/467', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3035, 38, 'jobs', 479, NULL, '2022-08-22 08:44:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/479', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3036, 38, 'jobs', 479, NULL, '2022-08-22 08:45:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/479', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3037, 38, 'jobs', 458, NULL, '2022-08-22 08:47:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/458', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3038, 17, 'purchase', 2, 'purchase_updated', '2022-08-22 09:55:14', 'fa fa-truck', 'admin/purchase/purchase_details/2', '[INV]-2022-Aug-21-0002', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3039, 38, 'equipment', 51, NULL, '2022-08-22 10:57:32', 'fa-suitcase', 'admin/equipment/view_equipment_details/51', 'NIL', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3040, 38, 'equipment', 51, NULL, '2022-08-22 10:57:54', 'fa-suitcase', 'admin/equipment/view_equipment_details/51', 'NIL', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3041, 38, 'jobs', 483, NULL, '2022-08-22 11:01:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/483', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3042, 38, 'jobs', 484, NULL, '2022-08-22 11:06:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/484', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3043, 38, 'jobs', 484, NULL, '2022-08-22 11:09:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/484', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3044, 38, 'jobs', 483, NULL, '2022-08-22 11:10:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/483', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3045, 38, 'jobs', 484, NULL, '2022-08-22 11:11:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/484', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3046, 38, 'jobs', 483, NULL, '2022-08-22 11:19:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/483', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3047, 38, 'jobs', 484, NULL, '2022-08-22 11:19:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/484', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3048, 38, 'equipment', 51, NULL, '2022-08-22 11:24:27', 'fa-suitcase', 'admin/equipment/view_equipment_details/51', 'NIL', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3049, 38, 'jobs', 484, NULL, '2022-08-22 11:26:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/484', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3050, 38, 'jobs', 483, NULL, '2022-08-22 11:26:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/483', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3051, 38, 'jobs', 484, NULL, '2022-08-22 11:26:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/484', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3052, 38, 'jobs', 475, NULL, '2022-08-22 11:27:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/475', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3053, 10, 'jobs', 485, NULL, '2022-08-22 11:35:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/485', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3054, 10, 'jobs', 485, NULL, '2022-08-22 11:38:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/485', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3055, 10, 'jobs', 486, NULL, '2022-08-22 11:45:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/486', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3056, 10, 'jobs', 486, NULL, '2022-08-22 11:56:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/486', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3057, 10, 'jobs', 486, NULL, '2022-08-22 11:56:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/486', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3058, 10, 'jobs', 485, NULL, '2022-08-22 11:56:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/485', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3059, 38, 'jobs', 486, NULL, '2022-08-22 12:04:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/486', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3060, 38, 'jobs', 486, NULL, '2022-08-22 12:07:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/486', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3061, 38, 'jobs', 485, NULL, '2022-08-22 12:07:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/485', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3062, 10, 'jobs', 486, NULL, '2022-08-22 12:50:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/486', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3063, 10, 'jobs', 485, NULL, '2022-08-22 12:50:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/485', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3064, 38, 'jobs', 485, NULL, '2022-08-22 12:52:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/485', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3065, 38, 'jobs', 485, NULL, '2022-08-22 12:53:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/485', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3066, 38, 'jobs', 485, NULL, '2022-08-22 12:53:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/485', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3067, 38, 'jobs', 486, NULL, '2022-08-22 12:56:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/486', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3068, 38, 'jobs', 486, NULL, '2022-08-22 12:59:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/486', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3069, 38, 'jobs', 486, NULL, '2022-08-22 13:00:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/486', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3070, 38, 'jobs', 486, NULL, '2022-08-22 13:03:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/486', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3071, 38, 'jobs', 485, NULL, '2022-08-22 13:03:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/485', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3072, 38, 'jobs', 485, NULL, '2022-08-22 13:05:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/485', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3073, 38, 'jobs', 486, NULL, '2022-08-22 13:06:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/486', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3074, 38, 'jobs', 485, NULL, '2022-08-22 13:19:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/485', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3075, 10, 'jobs', 482, NULL, '2022-08-22 19:22:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/482', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3076, 36, 'jobs', 482, NULL, '2022-08-22 21:40:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/482', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3077, 32, 'jobs', 481, NULL, '2022-08-23 00:44:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/481', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3078, 32, 'jobs', 480, NULL, '2022-08-23 00:44:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/480', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3079, 32, 'jobs', 477, NULL, '2022-08-23 00:45:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/477', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3080, 32, 'jobs', 476, NULL, '2022-08-23 00:47:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/476', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3081, 32, 'jobs', 477, NULL, '2022-08-23 00:50:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/477', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3082, 32, 'jobs', 477, NULL, '2022-08-23 00:50:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/477', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3083, 32, 'jobs', 477, NULL, '2022-08-23 00:51:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/477', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3084, 32, 'jobs', 487, NULL, '2022-08-23 02:02:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/487', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3085, 32, 'jobs', 487, NULL, '2022-08-23 04:03:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/487', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3086, 32, 'jobs', 488, NULL, '2022-08-23 04:11:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/488', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3087, 32, 'jobs', 487, NULL, '2022-08-23 04:14:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/487', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3088, 32, 'jobs', 489, NULL, '2022-08-23 04:20:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/489', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3089, 32, 'jobs', 490, NULL, '2022-08-23 04:23:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/490', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3090, 32, 'jobs', 491, NULL, '2022-08-23 04:25:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/491', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3091, 32, 'jobs', 488, NULL, '2022-08-23 04:37:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/488', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3092, 32, 'jobs', 487, NULL, '2022-08-23 04:38:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/487', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3093, 32, 'jobs', 491, NULL, '2022-08-23 05:39:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/491', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3094, 32, 'jobs', 490, NULL, '2022-08-23 05:40:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/490', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3095, 32, 'jobs', 489, NULL, '2022-08-23 06:20:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/489', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3096, 38, 'jobs', 492, NULL, '2022-08-23 08:36:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/492', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3097, 38, 'jobs', 493, NULL, '2022-08-23 08:39:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/493', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3098, 38, 'jobs', 493, 'activity_delete_jobs', '2022-08-23 08:40:01', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3099, 38, 'jobs', 492, 'activity_delete_jobs', '2022-08-23 08:40:39', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3100, 38, 'equipment', 52, NULL, '2022-08-23 08:41:43', 'fa-suitcase', 'admin/equipment/view_equipment_details/52', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3101, 38, 'equipment', 52, NULL, '2022-08-23 08:45:24', 'fa-suitcase', 'admin/equipment/view_equipment_details/52', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3102, 38, 'jobs', 494, NULL, '2022-08-23 08:51:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3103, 38, 'jobs', 494, NULL, '2022-08-23 09:02:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3104, 38, 'jobs', 494, NULL, '2022-08-23 09:02:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3105, 38, 'jobs', 494, NULL, '2022-08-23 09:04:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3106, 38, 'jobs', 494, NULL, '2022-08-23 09:08:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3107, 38, 'jobs', 494, NULL, '2022-08-23 09:14:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3108, 38, 'jobs', 494, NULL, '2022-08-23 09:23:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3109, 38, 'jobs', 494, NULL, '2022-08-23 09:24:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3110, 38, 'jobs', 494, NULL, '2022-08-23 09:25:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3111, 38, 'equipment', 52, NULL, '2022-08-23 09:26:03', 'fa-suitcase', 'admin/equipment/view_equipment_details/52', 'N/A', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3112, 38, 'jobs', 494, NULL, '2022-08-23 09:26:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3113, 38, 'jobs', 494, NULL, '2022-08-23 09:27:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3114, 10, 'jobs', 495, NULL, '2022-08-23 10:02:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/495', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3115, 10, 'jobs', 496, NULL, '2022-08-23 10:09:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3116, 38, 'jobs', 495, NULL, '2022-08-23 10:23:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/495', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3117, 38, 'jobs', 496, NULL, '2022-08-23 10:24:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3118, 38, 'jobs', 495, NULL, '2022-08-23 10:24:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/495', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3119, 38, 'jobs', 496, NULL, '2022-08-23 10:27:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3120, 38, 'jobs', 495, NULL, '2022-08-23 10:27:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/495', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3121, 38, 'jobs', 475, NULL, '2022-08-23 10:45:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/475', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3122, 38, 'jobs', 475, NULL, '2022-08-23 10:48:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/475', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3123, 38, 'jobs', 475, NULL, '2022-08-23 12:18:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/475', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3124, 38, 'jobs', 483, NULL, '2022-08-23 12:23:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/483', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3125, 38, 'jobs', 483, NULL, '2022-08-23 12:29:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/483', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3126, 38, 'jobs', 483, NULL, '2022-08-23 12:30:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/483', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3127, 38, 'jobs', 484, NULL, '2022-08-23 12:33:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/484', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3128, 10, 'jobs', 496, NULL, '2022-08-23 12:35:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3129, 10, 'jobs', 496, NULL, '2022-08-23 12:49:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3130, 10, 'jobs', 495, NULL, '2022-08-23 12:50:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/495', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3131, 38, 'jobs', 458, NULL, '2022-08-23 14:00:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/458', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3132, 38, 'jobs', 496, NULL, '2022-08-23 14:35:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3133, 10, 'jobs', 490, NULL, '2022-08-23 17:51:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/490', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3134, 10, 'jobs', 491, NULL, '2022-08-23 17:51:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/491', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3135, 36, 'jobs', 490, NULL, '2022-08-23 19:03:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/490', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3136, 36, 'jobs', 490, NULL, '2022-08-23 19:06:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/490', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3137, 36, 'jobs', 491, NULL, '2022-08-23 19:09:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/491', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3138, 32, 'jobs', 497, NULL, '2022-08-23 23:27:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/497', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3139, 32, 'jobs', 498, NULL, '2022-08-23 23:30:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/498', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3140, 38, 'jobs', 495, NULL, '2022-08-24 07:12:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/495', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3141, 38, 'jobs', 496, NULL, '2022-08-24 07:13:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3142, 38, 'jobs', 495, NULL, '2022-08-24 07:15:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/495', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3143, 38, 'jobs', 495, NULL, '2022-08-24 07:16:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/495', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3144, 38, 'jobs', 499, NULL, '2022-08-24 09:03:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/499', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3145, 38, 'jobs', 500, NULL, '2022-08-24 09:05:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/500', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3146, 38, 'jobs', 501, NULL, '2022-08-24 09:08:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/501', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3147, 38, 'jobs', 500, NULL, '2022-08-24 09:09:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/500', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3148, 38, 'jobs', 500, NULL, '2022-08-24 09:10:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/500', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3149, 38, 'jobs', 499, NULL, '2022-08-24 09:10:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/499', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3150, 38, 'jobs', 499, NULL, '2022-08-24 09:19:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/499', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3151, 38, 'jobs', 499, NULL, '2022-08-24 09:20:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/499', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3152, 38, 'jobs', 500, NULL, '2022-08-24 09:21:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/500', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3153, 38, 'jobs', 500, NULL, '2022-08-24 09:21:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/500', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3154, 38, 'jobs', 501, NULL, '2022-08-24 09:22:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/501', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3155, 38, 'jobs', 501, NULL, '2022-08-24 09:22:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/501', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3156, 38, 'jobs', 501, NULL, '2022-08-24 09:23:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/501', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3157, 38, 'jobs', 501, NULL, '2022-08-24 09:24:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/501', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3158, 38, 'jobs', 501, NULL, '2022-08-24 09:24:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/501', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3159, 38, 'jobs', 484, NULL, '2022-08-24 09:30:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/484', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3160, 38, 'jobs', 484, NULL, '2022-08-24 09:32:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/484', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3161, 38, 'jobs', 501, NULL, '2022-08-24 09:33:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/501', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3162, 38, 'jobs', 500, NULL, '2022-08-24 09:33:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/500', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3163, 38, 'jobs', 499, NULL, '2022-08-24 09:33:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/499', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3164, 6, 'purchase', 2, 'activity_purchase_sent', '2022-08-24 09:44:25', 'fa-shopping-cart', 'admin/purchase/purchase_details/2', '[INV]-2022-Aug-21-0002', 'ر.س 80,00', 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3165, 38, 'client', 20, 'activity_update_company', '2022-08-24 12:33:13', 'fa-user', NULL, 'NAGS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3166, 38, 'jobs', 502, NULL, '2022-08-24 12:38:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/502', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3167, 38, 'jobs', 502, NULL, '2022-08-24 12:44:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/502', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3168, 38, 'jobs', 502, NULL, '2022-08-24 12:45:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/502', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3169, 38, 'jobs', 502, NULL, '2022-08-24 12:47:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/502', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3170, 38, 'client', 20, 'activity_added_new_company', '2022-08-24 12:53:17', 'fa-user', NULL, 'NAGS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3171, 38, 'client', 20, 'activity_added_new_company', '2022-08-24 12:53:34', 'fa-user', NULL, 'NAGS', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3172, 38, 'jobs', 502, NULL, '2022-08-24 13:23:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/502', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3173, 38, 'jobs', 502, NULL, '2022-08-24 13:24:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/502', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3174, 38, 'jobs', 502, NULL, '2022-08-24 13:25:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/502', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3175, 38, 'jobs', 502, NULL, '2022-08-24 13:27:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/502', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3176, 38, 'jobs', 502, NULL, '2022-08-24 13:28:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/502', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3177, 6, 'settings', 6, 'activity_database_backup', '2022-08-24 15:04:00', 'fa-coffee', NULL, 'BD-backup_2022-08-24_15-03', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3178, 10, 'settings', 10, 'activity_update_profile', '2022-08-24 15:39:51', 'fa-coffee', NULL, 'KKIA', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3179, 10, 'settings', 10, 'activity_update_profile', '2022-08-24 15:40:31', 'fa-coffee', NULL, 'KKIA', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3180, 36, 'jobs', 497, NULL, '2022-08-24 19:23:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/497', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3181, 36, 'jobs', 498, NULL, '2022-08-24 19:29:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/498', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3182, 32, 'jobs', 503, NULL, '2022-08-25 02:15:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/503', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3183, 32, 'jobs', 504, NULL, '2022-08-25 02:17:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/504', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3184, 32, 'jobs', 505, NULL, '2022-08-25 05:00:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/505', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3185, 32, 'jobs', 503, NULL, '2022-08-25 05:18:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/503', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3186, 32, 'jobs', 504, NULL, '2022-08-25 05:22:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/504', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3187, 32, 'jobs', 505, NULL, '2022-08-25 06:49:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/505', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3188, 32, 'jobs', 505, NULL, '2022-08-25 06:50:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/505', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3189, 38, 'jobs', 506, NULL, '2022-08-25 08:13:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/506', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3190, 38, 'jobs', 503, NULL, '2022-08-25 10:47:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/503', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3191, 38, 'jobs', 506, NULL, '2022-08-25 12:02:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/506', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3192, 38, 'jobs', 507, NULL, '2022-08-25 12:53:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/507', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3193, 38, 'jobs', 507, NULL, '2022-08-25 13:06:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/507', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3194, 38, 'jobs', 496, NULL, '2022-08-25 13:28:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3195, 38, 'jobs', 496, NULL, '2022-08-25 13:35:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3196, 38, 'jobs', 388, NULL, '2022-08-25 13:39:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/388', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3197, 38, 'jobs', 388, NULL, '2022-08-25 13:43:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/388', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3198, 38, 'jobs', 484, NULL, '2022-08-25 13:44:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/484', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3199, 38, 'jobs', 484, NULL, '2022-08-25 13:47:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/484', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3200, 38, 'jobs', 483, NULL, '2022-08-25 13:48:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/483', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3201, 38, 'jobs', 475, NULL, '2022-08-25 13:49:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/475', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3202, 38, 'jobs', 393, NULL, '2022-08-25 13:59:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/393', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3203, 38, 'jobs', 425, NULL, '2022-08-25 14:00:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/425', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3204, 3, 'jobs', 508, NULL, '2022-08-25 15:06:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/508', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3205, 3, 'jobs', 508, NULL, '2022-08-25 15:07:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/508', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3206, 36, 'jobs', 496, NULL, '2022-08-25 16:18:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3207, 36, 'jobs', 506, NULL, '2022-08-25 16:32:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/506', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3208, 36, 'jobs', 507, NULL, '2022-08-25 20:13:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/507', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3209, 36, 'jobs', 499, NULL, '2022-08-25 20:53:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/499', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3210, 36, 'jobs', 494, NULL, '2022-08-25 21:05:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3211, 36, 'jobs', 494, NULL, '2022-08-25 21:07:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3212, 36, 'jobs', 494, NULL, '2022-08-25 21:13:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3213, 36, 'jobs', 494, NULL, '2022-08-25 21:20:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3214, 36, 'jobs', 494, NULL, '2022-08-25 21:22:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3215, 36, 'jobs', 494, NULL, '2022-08-25 21:25:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3216, 36, 'jobs', 494, NULL, '2022-08-25 21:34:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3217, 36, 'jobs', 507, NULL, '2022-08-25 21:53:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/507', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3218, 36, 'jobs', 507, NULL, '2022-08-25 22:03:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/507', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3219, 36, 'jobs', 507, NULL, '2022-08-25 22:14:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/507', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3220, 36, 'jobs', 504, NULL, '2022-08-25 22:32:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/504', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3221, 36, 'jobs', 504, NULL, '2022-08-25 22:33:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/504', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3222, 32, 'jobs', 496, NULL, '2022-08-26 01:03:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3223, 32, 'jobs', 496, NULL, '2022-08-26 01:20:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/496', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3224, 32, 'jobs', 509, NULL, '2022-08-26 01:42:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/509', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3225, 32, 'jobs', 510, NULL, '2022-08-26 01:46:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/510', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3226, 32, 'jobs', 511, NULL, '2022-08-26 02:26:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/511', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3227, 32, 'jobs', 511, NULL, '2022-08-26 02:48:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/511', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3228, 32, 'jobs', 512, NULL, '2022-08-26 02:51:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/512', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3229, 32, 'jobs', 512, NULL, '2022-08-26 03:17:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/512', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3230, 32, 'jobs', 512, NULL, '2022-08-26 03:33:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/512', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3231, 32, 'jobs', 513, NULL, '2022-08-26 03:36:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/513', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3232, 32, 'jobs', 511, NULL, '2022-08-26 04:30:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/511', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3233, 32, 'jobs', 513, NULL, '2022-08-26 05:01:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/513', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3234, 32, 'jobs', 507, NULL, '2022-08-26 05:08:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/507', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3235, 32, 'jobs', 511, NULL, '2022-08-26 05:13:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/511', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3236, 32, 'jobs', 513, NULL, '2022-08-26 05:14:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/513', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3237, 32, 'jobs', 507, NULL, '2022-08-26 05:30:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/507', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3238, 32, 'jobs', 494, NULL, '2022-08-26 05:32:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3239, 32, 'jobs', 510, NULL, '2022-08-26 06:31:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/510', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3240, 32, 'jobs', 509, NULL, '2022-08-26 06:33:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/509', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3241, 32, 'jobs', 510, NULL, '2022-08-26 06:36:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/510', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3242, 32, 'jobs', 510, NULL, '2022-08-26 06:54:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/510', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3243, 10, 'jobs', 514, NULL, '2022-08-26 09:17:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/514', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3244, 10, 'jobs', 514, NULL, '2022-08-26 09:30:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/514', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3245, 3, 'settings', 3, 'activity_database_backup', '2022-08-26 10:32:22', 'fa-coffee', NULL, 'BD-backup_2022-08-26_10-32', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3246, 10, 'jobs', 514, NULL, '2022-08-26 11:46:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/514', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3247, 10, 'jobs', 515, NULL, '2022-08-26 18:46:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/515', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3248, 10, 'jobs', 515, NULL, '2022-08-26 18:56:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/515', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3249, 10, 'jobs', 515, NULL, '2022-08-26 21:34:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/515', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3250, 3, 'settings', 3, 'activity_database_backup', '2022-08-27 08:27:11', 'fa-coffee', NULL, 'BD-backup_2022-08-27_08-27', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3251, 3, 'user', 53, 'activity_added_new_user', '2022-08-27 13:21:13', 'fa-user', NULL, 'prashantyadav.py218@gmail.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3252, 10, 'jobs', 516, NULL, '2022-08-27 15:52:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/516', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3253, 10, 'jobs', 516, NULL, '2022-08-27 16:04:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/516', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3254, 10, 'jobs', 517, NULL, '2022-08-27 19:46:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/517', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3255, 10, 'jobs', 517, NULL, '2022-08-27 20:09:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/517', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3256, 10, 'jobs', 516, NULL, '2022-08-27 20:12:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/516', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3257, 10, 'jobs', 517, NULL, '2022-08-27 21:34:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/517', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3258, 10, 'jobs', 518, NULL, '2022-08-27 23:37:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/518', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3259, 10, 'jobs', 519, NULL, '2022-08-27 23:42:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/519', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3260, 10, 'jobs', 520, NULL, '2022-08-27 23:51:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/520', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3261, 10, 'jobs', 521, NULL, '2022-08-27 23:57:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/521', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3262, 10, 'jobs', 522, NULL, '2022-08-28 00:05:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/522', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3263, 10, 'jobs', 523, NULL, '2022-08-28 00:11:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/523', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3264, 10, 'jobs', 524, NULL, '2022-08-28 00:19:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/524', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3265, 10, 'jobs', 525, NULL, '2022-08-28 00:26:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/525', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3266, 10, 'jobs', 525, NULL, '2022-08-28 00:29:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/525', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3267, 10, 'jobs', 525, NULL, '2022-08-28 02:48:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/525', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3268, 10, 'jobs', 526, NULL, '2022-08-28 02:50:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/526', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3269, 10, 'jobs', 527, NULL, '2022-08-28 02:58:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/527', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3270, 10, 'jobs', 528, NULL, '2022-08-28 03:43:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/528', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3271, 10, 'jobs', 529, NULL, '2022-08-28 03:49:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/529', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3272, 10, 'jobs', 530, NULL, '2022-08-28 03:54:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/530', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3273, 10, 'jobs', 531, NULL, '2022-08-28 05:01:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/531', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3274, 10, 'jobs', 532, NULL, '2022-08-28 05:07:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/532', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3275, 10, 'jobs', 532, NULL, '2022-08-28 05:57:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/532', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3276, 10, 'jobs', 531, NULL, '2022-08-28 05:58:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/531', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3277, 10, 'jobs', 530, NULL, '2022-08-28 05:59:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/530', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3278, 10, 'jobs', 529, NULL, '2022-08-28 06:01:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/529', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3279, 38, 'jobs', 515, NULL, '2022-08-28 07:12:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/515', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3280, 38, 'jobs', 516, NULL, '2022-08-28 07:14:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/516', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3281, 38, 'jobs', 517, NULL, '2022-08-28 07:15:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/517', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3282, 38, 'jobs', 518, NULL, '2022-08-28 07:16:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/518', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3283, 38, 'jobs', 519, NULL, '2022-08-28 07:17:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/519', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3284, 38, 'jobs', 520, NULL, '2022-08-28 07:18:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/520', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3285, 38, 'jobs', 521, NULL, '2022-08-28 07:19:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/521', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3286, 38, 'jobs', 522, NULL, '2022-08-28 07:20:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/522', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3287, 38, 'jobs', 523, NULL, '2022-08-28 07:20:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/523', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3288, 38, 'jobs', 524, NULL, '2022-08-28 07:21:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/524', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3289, 38, 'jobs', 525, NULL, '2022-08-28 07:21:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/525', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3290, 38, 'jobs', 528, NULL, '2022-08-28 07:23:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/528', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3291, 38, 'jobs', 529, NULL, '2022-08-28 07:24:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/529', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3292, 38, 'jobs', 530, NULL, '2022-08-28 07:24:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/530', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3293, 38, 'jobs', 531, NULL, '2022-08-28 07:25:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/531', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3294, 38, 'jobs', 532, NULL, '2022-08-28 07:25:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/532', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3295, 38, 'jobs', 533, NULL, '2022-08-28 07:46:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/533', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3296, 38, 'jobs', 533, NULL, '2022-08-28 07:47:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/533', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3297, 38, 'jobs', 533, NULL, '2022-08-28 07:48:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/533', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3298, 38, 'jobs', 534, NULL, '2022-08-28 07:51:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/534', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3299, 38, 'jobs', 535, NULL, '2022-08-28 07:53:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/535', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3300, 38, 'jobs', 536, NULL, '2022-08-28 07:56:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/536', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3301, 38, 'jobs', 534, NULL, '2022-08-28 07:58:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/534', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3302, 38, 'jobs', 535, NULL, '2022-08-28 07:58:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/535', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3303, 38, 'jobs', 533, NULL, '2022-08-28 08:00:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/533', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3304, 38, 'jobs', 533, NULL, '2022-08-28 08:20:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/533', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3305, 38, 'jobs', 533, NULL, '2022-08-28 08:21:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/533', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3306, 38, 'jobs', 534, NULL, '2022-08-28 08:22:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/534', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3307, 38, 'jobs', 535, NULL, '2022-08-28 08:22:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/535', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3308, 38, 'jobs', 535, NULL, '2022-08-28 08:23:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/535', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3309, 38, 'jobs', 536, NULL, '2022-08-28 08:25:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/536', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3310, 38, 'jobs', 536, NULL, '2022-08-28 08:25:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/536', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3311, 10, 'jobs', 537, NULL, '2022-08-28 09:35:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/537', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3312, 38, 'jobs', 0, NULL, '2022-08-28 09:36:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/0', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3313, 38, 'jobs', 539, NULL, '2022-08-28 09:38:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/539', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3314, 38, 'equipment', 53, NULL, '2022-08-28 09:41:45', 'fa-suitcase', 'admin/equipment/view_equipment_details/53', 'NIL', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3315, 38, 'jobs', 539, NULL, '2022-08-28 09:42:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/539', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3316, 38, 'jobs', 539, NULL, '2022-08-28 09:43:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/539', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3317, 10, 'jobs', 540, NULL, '2022-08-28 09:45:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/540', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3318, 38, 'jobs', 540, NULL, '2022-08-28 09:53:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/540', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3319, 38, 'jobs', 539, NULL, '2022-08-28 09:53:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/539', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3320, 10, 'jobs', 540, NULL, '2022-08-28 10:06:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/540', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3321, 3, 'settings', 3, 'activity_database_backup', '2022-08-28 10:28:02', 'fa-coffee', NULL, 'BD-backup_2022-08-28_10-28', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3322, 10, 'jobs', 541, NULL, '2022-08-28 10:56:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/541', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3323, 10, 'jobs', 541, NULL, '2022-08-28 11:32:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/541', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3324, 10, 'jobs', 526, NULL, '2022-08-28 12:55:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/526', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3325, 3, 'settings', 3, 'activity_database_backup', '2022-08-28 14:08:06', 'fa-coffee', NULL, 'BD-backup_2022-08-28_14-08', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3326, 38, 'jobs', 539, NULL, '2022-08-28 14:59:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/539', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3327, 10, 'jobs', 541, NULL, '2022-08-28 19:58:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/541', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3328, 10, 'jobs', 540, NULL, '2022-08-28 19:59:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/540', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3329, 36, 'jobs', 540, NULL, '2022-08-28 20:25:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/540', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3330, 36, 'jobs', 541, NULL, '2022-08-28 20:29:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/541', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3331, 36, 'jobs', 540, NULL, '2022-08-28 20:31:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/540', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3332, 36, 'jobs', 514, NULL, '2022-08-28 20:57:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/514', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3333, 36, 'jobs', 514, NULL, '2022-08-28 21:00:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/514', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3334, 36, 'jobs', 514, NULL, '2022-08-28 21:01:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/514', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3335, 36, 'jobs', 541, NULL, '2022-08-28 22:11:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/541', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3336, 36, 'jobs', 527, NULL, '2022-08-28 22:24:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/527', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3337, 10, 'jobs', 541, NULL, '2022-08-28 22:34:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/541', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3338, 32, 'jobs', 542, NULL, '2022-08-29 01:13:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/542', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3339, 32, 'jobs', 543, NULL, '2022-08-29 01:19:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/543', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3340, 32, 'jobs', 544, NULL, '2022-08-29 01:23:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/544', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3341, 32, 'jobs', 545, NULL, '2022-08-29 02:47:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/545', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3342, 32, 'jobs', 542, NULL, '2022-08-29 02:50:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/542', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3343, 32, 'jobs', 542, NULL, '2022-08-29 02:50:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/542', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3344, 32, 'jobs', 543, NULL, '2022-08-29 02:57:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/543', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3345, 32, 'jobs', 544, NULL, '2022-08-29 03:01:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/544', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3346, 32, 'jobs', 541, NULL, '2022-08-29 03:06:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/541', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3347, 32, 'jobs', 541, NULL, '2022-08-29 03:09:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/541', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3348, 32, 'jobs', 495, NULL, '2022-08-29 03:15:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/495', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3349, 32, 'jobs', 546, NULL, '2022-08-29 04:31:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/546', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3350, 32, 'jobs', 545, NULL, '2022-08-29 04:32:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/545', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3351, 32, 'jobs', 542, NULL, '2022-08-29 05:05:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/542', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3352, 32, 'jobs', 542, NULL, '2022-08-29 05:05:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/542', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3353, 32, 'jobs', 542, NULL, '2022-08-29 05:07:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/542', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3354, 32, 'jobs', 542, NULL, '2022-08-29 05:08:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/542', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3355, 32, 'jobs', 542, NULL, '2022-08-29 05:08:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/542', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3356, 32, 'jobs', 542, NULL, '2022-08-29 05:10:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/542', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3357, 32, 'jobs', 543, NULL, '2022-08-29 05:11:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/543', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3358, 32, 'jobs', 545, NULL, '2022-08-29 05:13:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/545', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3359, 32, 'jobs', 546, NULL, '2022-08-29 05:14:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/546', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3360, 32, 'jobs', 518, NULL, '2022-08-29 05:34:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/518', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3361, 32, 'jobs', 518, NULL, '2022-08-29 05:37:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/518', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3362, 32, 'jobs', 519, NULL, '2022-08-29 05:38:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/519', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3363, 32, 'jobs', 520, NULL, '2022-08-29 05:40:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/520', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3364, 32, 'jobs', 521, NULL, '2022-08-29 05:41:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/521', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3365, 32, 'jobs', 522, NULL, '2022-08-29 05:42:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/522', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3366, 32, 'jobs', 523, NULL, '2022-08-29 05:43:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/523', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3367, 32, 'jobs', 524, NULL, '2022-08-29 05:44:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/524', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3368, 32, 'jobs', 525, NULL, '2022-08-29 05:44:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/525', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3369, 32, 'jobs', 527, NULL, '2022-08-29 05:46:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/527', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3370, 32, 'jobs', 529, NULL, '2022-08-29 05:48:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/529', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3371, 32, 'jobs', 530, NULL, '2022-08-29 05:49:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/530', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3372, 32, 'jobs', 547, NULL, '2022-08-29 05:58:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/547', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3373, 32, 'jobs', 548, NULL, '2022-08-29 06:00:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/548', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3374, 32, 'jobs', 546, NULL, '2022-08-29 06:17:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/546', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3375, 32, 'jobs', 546, NULL, '2022-08-29 06:17:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/546', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3376, 32, 'jobs', 548, NULL, '2022-08-29 06:39:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/548', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3377, 32, 'jobs', 547, NULL, '2022-08-29 06:39:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/547', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3378, 38, 'equipment', 53, NULL, '2022-08-29 08:33:17', 'fa-suitcase', 'admin/equipment/view_equipment_details/53', 'NIL', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3379, 38, 'equipment', 53, NULL, '2022-08-29 08:33:48', 'fa-suitcase', 'admin/equipment/view_equipment_details/53', 'NIL', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3380, 38, 'jobs', 539, NULL, '2022-08-29 08:35:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/539', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3381, 38, 'jobs', 539, NULL, '2022-08-29 08:38:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/539', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3382, 38, 'jobs', 533, NULL, '2022-08-29 08:49:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/533', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3383, 38, 'jobs', 533, NULL, '2022-08-29 08:50:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/533', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3384, 38, 'jobs', 533, NULL, '2022-08-29 08:52:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/533', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3385, 38, 'jobs', 535, NULL, '2022-08-29 08:54:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/535', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3386, 38, 'jobs', 535, NULL, '2022-08-29 08:56:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/535', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3387, 38, 'jobs', 535, NULL, '2022-08-29 08:57:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/535', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3388, 38, 'jobs', 535, NULL, '2022-08-29 08:58:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/535', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3389, 38, 'jobs', 535, NULL, '2022-08-29 08:59:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/535', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3390, 38, 'jobs', 535, NULL, '2022-08-29 08:59:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/535', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3391, 38, 'jobs', 500, NULL, '2022-08-29 09:02:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/500', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3392, 38, 'jobs', 500, NULL, '2022-08-29 09:23:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/500', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3393, 38, 'jobs', 500, NULL, '2022-08-29 09:27:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/500', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3394, 10, 'jobs', 549, NULL, '2022-08-29 10:27:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/549', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3395, 10, 'jobs', 549, NULL, '2022-08-29 10:36:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/549', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3396, 3, 'jobs', 537, 'activity_delete_jobs', '2022-08-29 10:47:06', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3397, 38, 'jobs', 549, NULL, '2022-08-29 12:46:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/549', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3398, 3, 'settings', 3, 'activity_database_backup', '2022-08-29 12:57:12', 'fa-coffee', NULL, 'BD-backup_2022-08-29_12-57', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3399, 38, 'jobs', 549, NULL, '2022-08-29 12:58:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/549', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3400, 38, 'jobs', 547, NULL, '2022-08-29 12:59:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/547', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3401, 38, 'jobs', 499, NULL, '2022-08-29 13:00:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/499', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3402, 38, 'jobs', 539, NULL, '2022-08-29 13:04:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/539', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3403, 10, 'jobs', 549, NULL, '2022-08-29 13:12:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/549', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3404, 38, 'jobs', 536, NULL, '2022-08-29 13:37:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/536', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3405, 38, 'jobs', 536, NULL, '2022-08-29 13:39:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/536', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3406, 38, 'jobs', 536, NULL, '2022-08-29 13:41:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/536', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3407, 38, 'jobs', 536, NULL, '2022-08-29 13:43:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/536', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3408, 38, 'jobs', 536, NULL, '2022-08-29 13:44:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/536', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3409, 38, 'jobs', 536, NULL, '2022-08-29 13:46:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/536', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3410, 38, 'jobs', 534, NULL, '2022-08-29 13:47:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/534', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3411, 3, 'settings', 3, 'activity_database_backup', '2022-08-29 13:59:51', 'fa-coffee', NULL, 'BD-backup_2022-08-29_13-59', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3412, 38, 'jobs', 549, NULL, '2022-08-29 14:34:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/549', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3413, 38, 'jobs', 549, NULL, '2022-08-29 14:36:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/549', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3414, 38, 'jobs', 549, NULL, '2022-08-29 14:37:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/549', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3415, 38, 'jobs', 534, NULL, '2022-08-29 14:48:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/534', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3416, 38, 'jobs', 534, NULL, '2022-08-29 14:50:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/534', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3417, 3, 'items', 2, 'activity_save_items', '2022-08-29 16:21:35', 'fa-circle-o', NULL, '1112233344', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3418, 3, 'settings', 3, 'activity_database_backup', '2022-08-29 17:08:48', 'fa-coffee', NULL, 'BD-backup_2022-08-29_17-08', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3419, 36, 'jobs', 550, NULL, '2022-08-29 17:18:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/550', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3420, 10, 'jobs', 550, NULL, '2022-08-29 17:33:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/550', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3421, 10, 'jobs', 548, NULL, '2022-08-29 18:33:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/548', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3422, 10, 'jobs', 547, NULL, '2022-08-29 18:34:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/547', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3423, 36, 'jobs', 547, NULL, '2022-08-29 20:30:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/547', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3424, 36, 'jobs', 548, NULL, '2022-08-29 20:34:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/548', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3425, 36, 'jobs', 526, NULL, '2022-08-29 20:41:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/526', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3426, 36, 'jobs', 526, NULL, '2022-08-29 20:44:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/526', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3427, 36, 'jobs', 526, NULL, '2022-08-29 20:45:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/526', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3428, 36, 'jobs', 526, NULL, '2022-08-29 20:45:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/526', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3429, 10, 'jobs', 550, NULL, '2022-08-29 22:45:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/550', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3430, 36, 'jobs', 550, NULL, '2022-08-29 22:45:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/550', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3431, 32, 'jobs', 551, NULL, '2022-08-30 00:28:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/551', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3432, 32, 'jobs', 552, NULL, '2022-08-30 00:29:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/552', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3433, 32, 'jobs', 551, NULL, '2022-08-30 00:49:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/551', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3434, 32, 'jobs', 552, NULL, '2022-08-30 00:50:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/552', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3435, 32, 'jobs', 551, NULL, '2022-08-30 00:51:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/551', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3436, 32, 'jobs', 526, NULL, '2022-08-30 01:00:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/526', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3437, 32, 'jobs', 527, NULL, '2022-08-30 01:01:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/527', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3438, 32, 'jobs', 553, NULL, '2022-08-30 02:53:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/553', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3439, 32, 'jobs', 553, NULL, '2022-08-30 04:46:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/553', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3440, 32, 'jobs', 554, NULL, '2022-08-30 04:51:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/554', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3441, 32, 'jobs', 554, NULL, '2022-08-30 04:55:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/554', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3442, 32, 'jobs', 553, NULL, '2022-08-30 04:56:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/553', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3443, 32, 'jobs', 555, NULL, '2022-08-30 04:58:52', 'fa-suitcase', 'admin/jobs/view_jobs_details/555', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3444, 32, 'jobs', 555, NULL, '2022-08-30 05:29:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/555', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3445, 32, 'jobs', 554, NULL, '2022-08-30 05:31:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/554', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3446, 32, 'jobs', 554, NULL, '2022-08-30 06:34:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/554', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3447, 32, 'jobs', 555, NULL, '2022-08-30 06:36:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/555', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3448, 3, 'settings', 3, 'activity_database_backup', '2022-08-30 09:41:18', 'fa-coffee', NULL, 'BD-backup_2022-08-30_09-41', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3449, 10, 'jobs', 556, NULL, '2022-08-30 10:04:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/556', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3450, 10, 'jobs', 556, NULL, '2022-08-30 10:33:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/556', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3451, 7, 'jobs', 458, NULL, '2022-08-30 11:28:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/458', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3452, 7, 'jobs', 494, NULL, '2022-08-30 11:30:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3453, 7, 'jobs', 507, NULL, '2022-08-30 11:31:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/507', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3454, 10, 'jobs', 551, NULL, '2022-08-30 11:36:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/551', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3455, 10, 'jobs', 551, NULL, '2022-08-30 11:36:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/551', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3456, 10, 'jobs', 557, NULL, '2022-08-30 11:40:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/557', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3457, 10, 'jobs', 558, NULL, '2022-08-30 11:45:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/558', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3458, 10, 'jobs', 557, NULL, '2022-08-30 11:59:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/557', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3459, 10, 'jobs', 557, NULL, '2022-08-30 12:00:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/557', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3460, 10, 'jobs', 558, NULL, '2022-08-30 12:04:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/558', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3461, 10, 'jobs', 557, NULL, '2022-08-30 12:05:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/557', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3462, 10, 'jobs', 558, NULL, '2022-08-30 12:05:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/558', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3463, 38, 'jobs', 494, NULL, '2022-08-30 13:31:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3464, 38, 'jobs', 494, NULL, '2022-08-30 13:36:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3465, 38, 'jobs', 494, NULL, '2022-08-30 13:37:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3466, 38, 'jobs', 494, NULL, '2022-08-30 13:38:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3467, 38, 'jobs', 494, NULL, '2022-08-30 13:43:58', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3468, 38, 'jobs', 494, NULL, '2022-08-30 13:44:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3469, 38, 'jobs', 494, NULL, '2022-08-30 13:45:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3470, 36, 'jobs', 551, NULL, '2022-08-30 15:56:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/551', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3471, 3, 'jobs', 555, NULL, '2022-08-30 16:55:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/555', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3472, 3, 'jobs', 553, NULL, '2022-08-30 16:56:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/553', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3473, 3, 'jobs', 553, NULL, '2022-08-30 16:56:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/553', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3474, 10, 'jobs', 558, NULL, '2022-08-30 18:06:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/558', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3475, 10, 'jobs', 557, NULL, '2022-08-30 18:08:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/557', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3476, 36, 'jobs', 557, NULL, '2022-08-30 19:42:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/557', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3477, 36, 'jobs', 558, NULL, '2022-08-30 19:45:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/558', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3478, 36, 'jobs', 559, NULL, '2022-08-30 20:38:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/559', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3479, 10, 'jobs', 559, NULL, '2022-08-30 20:40:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/559', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3480, 36, 'jobs', 559, NULL, '2022-08-30 20:42:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/559', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3481, 36, 'jobs', 560, NULL, '2022-08-30 20:53:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/560', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3482, 36, 'jobs', 559, NULL, '2022-08-30 20:54:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/559', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3483, 36, 'jobs', 561, NULL, '2022-08-30 20:59:24', 'fa-suitcase', 'admin/jobs/view_jobs_details/561', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3484, 10, 'jobs', 561, NULL, '2022-08-30 22:06:01', 'fa-suitcase', 'admin/jobs/view_jobs_details/561', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3485, 10, 'jobs', 561, NULL, '2022-08-30 22:12:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/561', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3486, 10, 'jobs', 560, NULL, '2022-08-30 22:13:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/560', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3487, 36, 'jobs', 552, NULL, '2022-08-30 22:27:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/552', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3488, 36, 'jobs', 559, NULL, '2022-08-30 22:31:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/559', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3489, 36, 'jobs', 559, NULL, '2022-08-30 22:34:54', 'fa-suitcase', 'admin/jobs/view_jobs_details/559', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3490, 36, 'jobs', 560, NULL, '2022-08-30 22:35:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/560', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3491, 36, 'jobs', 562, NULL, '2022-08-30 22:42:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/562', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3492, 36, 'jobs', 563, NULL, '2022-08-30 22:43:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/563', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3493, 36, 'jobs', 556, NULL, '2022-08-30 22:46:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/556', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3494, 10, 'jobs', 563, NULL, '2022-08-30 22:50:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/563', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3495, 10, 'jobs', 562, NULL, '2022-08-30 23:06:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/562', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3496, 32, 'jobs', 528, NULL, '2022-08-30 23:43:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/528', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3497, 32, 'jobs', 528, NULL, '2022-08-30 23:46:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/528', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3498, 32, 'jobs', 530, NULL, '2022-08-30 23:50:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/530', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3499, 32, 'jobs', 531, NULL, '2022-08-30 23:55:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/531', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3500, 32, 'jobs', 532, NULL, '2022-08-31 00:01:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/532', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3501, 32, 'jobs', 532, NULL, '2022-08-31 00:04:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/532', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3502, 32, 'jobs', 561, NULL, '2022-08-31 00:52:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/561', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3503, 32, 'jobs', 561, NULL, '2022-08-31 00:53:59', 'fa-suitcase', 'admin/jobs/view_jobs_details/561', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3504, 32, 'jobs', 561, NULL, '2022-08-31 00:56:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/561', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3505, 32, 'jobs', 561, NULL, '2022-08-31 01:11:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/561', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3506, 32, 'jobs', 564, NULL, '2022-08-31 01:16:23', 'fa-suitcase', 'admin/jobs/view_jobs_details/564', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3507, 32, 'jobs', 565, NULL, '2022-08-31 01:19:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/565', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3508, 32, 'jobs', 561, NULL, '2022-08-31 03:13:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/561', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3509, 32, 'jobs', 564, NULL, '2022-08-31 03:15:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/564', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3510, 32, 'jobs', 565, NULL, '2022-08-31 03:18:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/565', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3511, 32, 'jobs', 566, NULL, '2022-08-31 03:23:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/566', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3512, 32, 'jobs', 567, NULL, '2022-08-31 03:25:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/567', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3513, 32, 'jobs', 565, NULL, '2022-08-31 05:19:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/565', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3514, 32, 'jobs', 564, NULL, '2022-08-31 05:19:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/564', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3515, 32, 'jobs', 567, NULL, '2022-08-31 06:12:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/567', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3516, 32, 'jobs', 566, NULL, '2022-08-31 06:16:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/566', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3517, 32, 'jobs', 566, NULL, '2022-08-31 06:19:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/566', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3518, 32, 'jobs', 568, NULL, '2022-08-31 06:21:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/568', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3519, 32, 'jobs', 562, NULL, '2022-08-31 06:23:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/562', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3520, 32, 'jobs', 568, NULL, '2022-08-31 06:24:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/568', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3521, 10, 'jobs', 568, NULL, '2022-08-31 06:30:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/568', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3522, 10, 'jobs', 568, NULL, '2022-08-31 06:41:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/568', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3523, 10, 'jobs', 568, NULL, '2022-08-31 06:47:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/568', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3524, 32, 'jobs', 562, NULL, '2022-08-31 06:48:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/562', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3525, 32, 'jobs', 562, NULL, '2022-08-31 06:57:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/562', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3526, 38, 'jobs', 494, NULL, '2022-08-31 07:25:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3527, 38, 'jobs', 494, NULL, '2022-08-31 07:29:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/494', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3528, 38, 'jobs', 501, NULL, '2022-08-31 07:34:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/501', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3529, 38, 'jobs', 501, NULL, '2022-08-31 07:36:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/501', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3530, 38, 'jobs', 501, NULL, '2022-08-31 07:41:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/501', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3531, 38, 'jobs', 569, NULL, '2022-08-31 08:04:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/569', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3532, 38, 'jobs', 570, NULL, '2022-08-31 08:40:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/570', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3533, 3, 'settings', 3, 'activity_database_backup', '2022-08-31 09:19:35', 'fa-coffee', NULL, 'BD-backup_2022-08-31_09-19', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3534, 38, 'jobs', 569, NULL, '2022-08-31 09:22:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/569', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3535, 38, 'jobs', 569, NULL, '2022-08-31 09:25:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/569', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3536, 38, 'jobs', 571, NULL, '2022-08-31 09:56:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/571', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3537, 38, 'jobs', 571, 'activity_delete_jobs', '2022-08-31 10:05:47', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3538, 38, 'jobs', 569, NULL, '2022-08-31 10:18:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/569', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3539, 38, 'jobs', 569, NULL, '2022-08-31 10:20:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/569', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3540, 38, 'jobs', 569, NULL, '2022-08-31 10:24:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/569', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3541, 38, 'jobs', 569, NULL, '2022-08-31 10:25:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/569', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3542, 38, 'jobs', 569, NULL, '2022-08-31 10:26:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/569', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3543, 38, 'jobs', 570, NULL, '2022-08-31 11:12:35', 'fa-suitcase', 'admin/jobs/view_jobs_details/570', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3544, 38, 'jobs', 570, NULL, '2022-08-31 11:15:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/570', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3545, 38, 'jobs', 570, NULL, '2022-08-31 11:16:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/570', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3546, 38, 'jobs', 570, NULL, '2022-08-31 11:26:32', 'fa-suitcase', 'admin/jobs/view_jobs_details/570', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3547, 38, 'jobs', 570, NULL, '2022-08-31 11:27:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/570', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3548, 38, 'jobs', 570, NULL, '2022-08-31 11:27:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/570', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3549, 3, 'user', 54, 'activity_added_new_user', '2022-08-31 13:12:53', 'fa-user', NULL, 'prashantyadav.py218@gmail.com', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3550, 3, 'departments', 3, 'activity_added_a_department', '2022-08-31 13:15:27', 'fa-coffee', NULL, 'IT Department', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3552, 3, 'purchase', 2, 'activity_purchase_sent', '2022-08-31 13:58:50', 'fa-shopping-cart', 'admin/purchase/purchase_details/2', '[INV]-2022-Aug-21-0002', 'ر.س 80,00', 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3553, 36, 'jobs', 572, NULL, '2022-08-31 19:53:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/572', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3554, 36, 'jobs', 573, NULL, '2022-08-31 20:24:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/573', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3555, 36, 'jobs', 563, NULL, '2022-08-31 21:19:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/563', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3556, 36, 'jobs', 572, NULL, '2022-08-31 21:27:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/572', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3557, 36, 'jobs', 573, NULL, '2022-08-31 21:28:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/573', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3558, 36, 'jobs', 568, NULL, '2022-08-31 21:31:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/568', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3559, 36, 'jobs', 572, NULL, '2022-08-31 22:26:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/572', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3560, 36, 'jobs', 573, NULL, '2022-08-31 22:29:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/573', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3561, 32, 'jobs', 574, NULL, '2022-09-01 01:04:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/574', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3562, 32, 'jobs', 575, NULL, '2022-09-01 01:06:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/575', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3563, 32, 'jobs', 576, NULL, '2022-09-01 01:10:07', 'fa-suitcase', 'admin/jobs/view_jobs_details/576', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3564, 32, 'jobs', 577, NULL, '2022-09-01 02:20:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/577', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3565, 32, 'jobs', 574, NULL, '2022-09-01 02:22:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/574', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3566, 32, 'jobs', 575, NULL, '2022-09-01 02:22:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/575', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3567, 32, 'jobs', 575, NULL, '2022-09-01 02:48:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/575', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3568, 32, 'jobs', 575, NULL, '2022-09-01 02:48:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/575', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3569, 32, 'jobs', 575, NULL, '2022-09-01 02:49:37', 'fa-suitcase', 'admin/jobs/view_jobs_details/575', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3570, 32, 'jobs', 574, NULL, '2022-09-01 02:51:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/574', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3571, 32, 'jobs', 574, NULL, '2022-09-01 03:37:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/574', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3572, 32, 'jobs', 575, NULL, '2022-09-01 03:38:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/575', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3573, 32, 'jobs', 575, NULL, '2022-09-01 03:38:38', 'fa-suitcase', 'admin/jobs/view_jobs_details/575', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3574, 32, 'jobs', 577, NULL, '2022-09-01 03:41:06', 'fa-suitcase', 'admin/jobs/view_jobs_details/577', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3575, 32, 'jobs', 578, NULL, '2022-09-01 03:48:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/578', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3576, 32, 'jobs', 579, NULL, '2022-09-01 03:50:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/579', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3577, 32, 'jobs', 579, NULL, '2022-09-01 03:50:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/579', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3578, 32, 'jobs', 578, NULL, '2022-09-01 03:51:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/578', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3579, 32, 'jobs', 579, NULL, '2022-09-01 04:11:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/579', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3580, 32, 'jobs', 578, NULL, '2022-09-01 04:13:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/578', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3581, 32, 'jobs', 580, NULL, '2022-09-01 04:28:34', 'fa-suitcase', 'admin/jobs/view_jobs_details/580', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3582, 32, 'jobs', 581, NULL, '2022-09-01 04:29:36', 'fa-suitcase', 'admin/jobs/view_jobs_details/581', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3583, 32, 'jobs', 580, NULL, '2022-09-01 05:55:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/580', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3584, 32, 'jobs', 581, NULL, '2022-09-01 05:56:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/581', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3585, 32, 'jobs', 580, NULL, '2022-09-01 05:56:18', 'fa-suitcase', 'admin/jobs/view_jobs_details/580', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3586, 32, 'jobs', 581, NULL, '2022-09-01 05:57:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/581', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3587, 32, 'jobs', 580, NULL, '2022-09-01 05:58:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/580', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3588, 32, 'jobs', 576, NULL, '2022-09-01 05:59:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/576', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3589, 32, 'jobs', 577, NULL, '2022-09-01 06:03:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/577', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3590, 32, 'jobs', 578, NULL, '2022-09-01 06:06:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/578', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3591, 32, 'jobs', 579, NULL, '2022-09-01 06:08:56', 'fa-suitcase', 'admin/jobs/view_jobs_details/579', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3592, 38, 'jobs', 582, NULL, '2022-09-01 08:37:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/582', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3593, 38, 'jobs', 583, NULL, '2022-09-01 08:41:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/583', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3594, 38, 'jobs', 583, NULL, '2022-09-01 08:44:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/583', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3595, 38, 'jobs', 583, NULL, '2022-09-01 08:58:29', 'fa-suitcase', 'admin/jobs/view_jobs_details/583', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3596, 3, 'settings', 3, 'activity_database_backup', '2022-09-01 09:43:15', 'fa-coffee', NULL, 'BD-backup_2022-09-01_09-43', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3597, 38, 'jobs', 582, NULL, '2022-09-01 12:06:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/582', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3598, 38, 'jobs', 583, NULL, '2022-09-01 12:06:45', 'fa-suitcase', 'admin/jobs/view_jobs_details/583', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3599, 38, 'jobs', 582, NULL, '2022-09-01 12:07:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/582', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3600, 38, 'jobs', 583, NULL, '2022-09-01 12:08:22', 'fa-suitcase', 'admin/jobs/view_jobs_details/583', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3601, 38, 'jobs', 582, NULL, '2022-09-01 12:08:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/582', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3602, 38, 'jobs', 583, NULL, '2022-09-01 12:09:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/583', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3603, 38, 'jobs', 582, NULL, '2022-09-01 12:09:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/582', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3604, 38, 'jobs', 584, NULL, '2022-09-01 13:36:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/584', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3605, 38, 'jobs', 584, 'activity_delete_jobs', '2022-09-01 13:52:12', 'fa-suitcase', NULL, NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3606, 38, 'jobs', 585, NULL, '2022-09-01 14:14:27', 'fa-suitcase', 'admin/jobs/view_jobs_details/585', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3607, 38, 'jobs', 585, NULL, '2022-09-01 14:17:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/585', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3608, 38, 'jobs', 585, NULL, '2022-09-01 14:27:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/585', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3609, 38, 'jobs', 585, NULL, '2022-09-01 14:39:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/585', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3610, 36, 'jobs', 361, NULL, '2022-09-01 15:37:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/361', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3611, 3, 'departments', 7, 'activity_added_a_department', '2022-09-01 16:08:04', 'fa-coffee', NULL, 'Accounting', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3612, 36, 'jobs', 586, NULL, '2022-09-01 16:45:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/586', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3613, 36, 'jobs', 585, NULL, '2022-09-01 16:46:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/585', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3614, 36, 'jobs', 587, NULL, '2022-09-01 16:52:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/587', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3615, 36, 'jobs', 580, NULL, '2022-09-01 19:46:41', 'fa-suitcase', 'admin/jobs/view_jobs_details/580', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3616, 36, 'jobs', 586, NULL, '2022-09-01 19:52:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/586', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3617, 36, 'jobs', 587, NULL, '2022-09-01 19:56:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/587', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3618, 36, 'jobs', 581, NULL, '2022-09-01 20:00:46', 'fa-suitcase', 'admin/jobs/view_jobs_details/581', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3619, 36, 'jobs', 581, NULL, '2022-09-01 20:03:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/581', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3620, 32, 'jobs', 588, NULL, '2022-09-01 23:57:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/588', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3621, 32, 'jobs', 588, NULL, '2022-09-02 00:36:44', 'fa-suitcase', 'admin/jobs/view_jobs_details/588', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3622, 32, 'jobs', 589, NULL, '2022-09-02 00:38:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/589', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3623, 32, 'jobs', 588, NULL, '2022-09-02 02:41:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/588', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3624, 32, 'jobs', 590, NULL, '2022-09-02 05:20:28', 'fa-suitcase', 'admin/jobs/view_jobs_details/590', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3625, 32, 'jobs', 589, NULL, '2022-09-02 05:35:12', 'fa-suitcase', 'admin/jobs/view_jobs_details/589', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3626, 32, 'jobs', 589, NULL, '2022-09-02 05:35:50', 'fa-suitcase', 'admin/jobs/view_jobs_details/589', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3627, 32, 'jobs', 590, NULL, '2022-09-02 05:39:09', 'fa-suitcase', 'admin/jobs/view_jobs_details/590', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3628, 32, 'jobs', 591, NULL, '2022-09-02 05:55:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/591', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3629, 32, 'jobs', 592, NULL, '2022-09-02 05:57:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/592', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3630, 32, 'jobs', 589, NULL, '2022-09-02 06:09:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/589', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3631, 32, 'jobs', 589, NULL, '2022-09-02 06:10:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/589', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3632, 32, 'jobs', 590, NULL, '2022-09-02 06:11:30', 'fa-suitcase', 'admin/jobs/view_jobs_details/590', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3633, 32, 'jobs', 590, NULL, '2022-09-02 06:12:03', 'fa-suitcase', 'admin/jobs/view_jobs_details/590', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3634, 32, 'jobs', 591, NULL, '2022-09-02 06:14:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/591', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3635, 32, 'jobs', 592, NULL, '2022-09-02 06:17:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/592', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3636, 32, 'jobs', 591, NULL, '2022-09-02 06:47:21', 'fa-suitcase', 'admin/jobs/view_jobs_details/591', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3637, 32, 'jobs', 592, NULL, '2022-09-02 06:48:13', 'fa-suitcase', 'admin/jobs/view_jobs_details/592', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3638, 10, 'jobs', 582, NULL, '2022-09-02 08:45:51', 'fa-suitcase', 'admin/jobs/view_jobs_details/582', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3639, 10, 'jobs', 583, NULL, '2022-09-02 08:47:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/583', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3640, 10, 'jobs', 593, NULL, '2022-09-02 11:26:25', 'fa-suitcase', 'admin/jobs/view_jobs_details/593', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3641, 10, 'jobs', 594, NULL, '2022-09-02 11:30:49', 'fa-suitcase', 'admin/jobs/view_jobs_details/594', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3642, 10, 'jobs', 594, NULL, '2022-09-02 11:43:26', 'fa-suitcase', 'admin/jobs/view_jobs_details/594', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3643, 10, 'jobs', 593, NULL, '2022-09-02 11:44:53', 'fa-suitcase', 'admin/jobs/view_jobs_details/593', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3644, 10, 'jobs', 594, NULL, '2022-09-02 13:22:48', 'fa-suitcase', 'admin/jobs/view_jobs_details/594', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3645, 10, 'jobs', 593, NULL, '2022-09-02 13:23:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/593', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3646, 10, 'jobs', 594, NULL, '2022-09-02 14:16:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/594', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3647, 10, 'jobs', 593, NULL, '2022-09-02 14:17:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/593', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3648, 10, 'jobs', 595, NULL, '2022-09-03 00:34:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/595', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3649, 10, 'jobs', 596, NULL, '2022-09-03 00:38:55', 'fa-suitcase', 'admin/jobs/view_jobs_details/596', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3650, 10, 'jobs', 595, NULL, '2022-09-03 01:50:11', 'fa-suitcase', 'admin/jobs/view_jobs_details/595', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3651, 10, 'jobs', 597, NULL, '2022-09-03 01:52:39', 'fa-suitcase', 'admin/jobs/view_jobs_details/597', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3652, 10, 'jobs', 598, NULL, '2022-09-03 01:56:33', 'fa-suitcase', 'admin/jobs/view_jobs_details/598', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3653, 10, 'jobs', 596, NULL, '2022-09-03 02:40:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/596', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3654, 10, 'jobs', 599, NULL, '2022-09-03 04:08:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/599', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3655, 10, 'jobs', 600, NULL, '2022-09-03 04:13:16', 'fa-suitcase', 'admin/jobs/view_jobs_details/600', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3656, 10, 'jobs', 598, NULL, '2022-09-03 04:17:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/598', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3657, 10, 'jobs', 597, NULL, '2022-09-03 04:17:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/597', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3658, 10, 'jobs', 600, NULL, '2022-09-03 06:23:10', 'fa-suitcase', 'admin/jobs/view_jobs_details/600', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3659, 10, 'jobs', 599, NULL, '2022-09-03 06:24:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/599', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3660, 10, 'jobs', 601, NULL, '2022-09-03 08:38:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/601', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3661, 10, 'jobs', 601, NULL, '2022-09-03 08:54:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/601', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3662, 10, 'jobs', 602, NULL, '2022-09-03 09:29:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/602', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3663, 10, 'jobs', 602, NULL, '2022-09-03 09:33:04', 'fa-suitcase', 'admin/jobs/view_jobs_details/602', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3664, 10, 'jobs', 602, NULL, '2022-09-03 09:33:17', 'fa-suitcase', 'admin/jobs/view_jobs_details/602', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3665, 10, 'jobs', 602, NULL, '2022-09-03 10:10:00', 'fa-suitcase', 'admin/jobs/view_jobs_details/602', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3666, 10, 'jobs', 602, NULL, '2022-09-03 11:33:19', 'fa-suitcase', 'admin/jobs/view_jobs_details/602', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3667, 10, 'jobs', 602, NULL, '2022-09-03 11:48:31', 'fa-suitcase', 'admin/jobs/view_jobs_details/602', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3668, 10, 'jobs', 602, NULL, '2022-09-03 11:50:47', 'fa-suitcase', 'admin/jobs/view_jobs_details/602', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3669, 10, 'jobs', 601, NULL, '2022-09-03 11:52:14', 'fa-suitcase', 'admin/jobs/view_jobs_details/601', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3670, 10, 'jobs', 601, NULL, '2022-09-03 14:07:42', 'fa-suitcase', 'admin/jobs/view_jobs_details/601', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3671, 10, 'jobs', 601, NULL, '2022-09-03 14:28:20', 'fa-suitcase', 'admin/jobs/view_jobs_details/601', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3672, 10, 'jobs', 602, NULL, '2022-09-03 15:56:40', 'fa-suitcase', 'admin/jobs/view_jobs_details/602', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3673, 10, 'jobs', 603, NULL, '2022-09-04 01:51:43', 'fa-suitcase', 'admin/jobs/view_jobs_details/603', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3674, 10, 'jobs', 604, NULL, '2022-09-04 01:55:57', 'fa-suitcase', 'admin/jobs/view_jobs_details/604', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3675, 10, 'jobs', 605, NULL, '2022-09-04 02:03:08', 'fa-suitcase', 'admin/jobs/view_jobs_details/605', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3676, 10, 'jobs', 606, NULL, '2022-09-04 02:08:02', 'fa-suitcase', 'admin/jobs/view_jobs_details/606', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3677, 10, 'jobs', 607, NULL, '2022-09-04 03:43:05', 'fa-suitcase', 'admin/jobs/view_jobs_details/607', NULL, NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (3678, 10, 'jobs', 608, NULL, '2022-09-04 03:47:15', 'fa-suitcase', 'admin/jobs/view_jobs_details/608', NULL, NULL, 